
#include <stdlib.h>
#include <conio.h>
#include <math.h>
#include "bitmaps.h"
#include "blitter.h"
#include "globals.h"
#include "obj3d.h"
#include "scenes.h"
#include "cameras.h"
#include "lightsrc.h"
#include "triangle.h"
#include "primitiv.h"
#include "phongpal.h"
#include "plasmafx.h"
#include "midas.h"
#include "part2.h"

#include "p12.h"
#include "p12b.h"
#include "tex1.h"
#include "us9.h"
#include "geo720.h"


#define FX2radius 12.0
#define FX2depth 4.0

byte p2_table1[256], p2_table2[256];

void FX2(TObject3D *srcobj, TObject3D *obj, TBitmap8bpp *source) {
	byte *src = source->datos + source->ancho + 1;
	int total = obj->NumVertex;
	for (int i = 0; i < total; i++) {
		obj->Vertex[i]->SetP(srcobj->Vertex[i]->x, srcobj->Vertex[i]->y, srcobj->Vertex[i]->z);
		*(obj->Vertex[i]) += srcobj->Vertex[i]->normal * 
                        (Sin256[*src++] * FX2depth);
//                obj->Vertex[i]->u = srcobj->Vertex[i]->u;
//                obj->Vertex[i]->v = srcobj->Vertex[i]->v;
	}
	total = obj->NumPolygons;
	for (i = 0; i < total; i++) obj->Poly[i]->CalcNormal();
}


void Part2_Setup() {
        GeneratePlasmaTable(p2_table1, 0, 0, 0);
        GeneratePlasmaTable(p2_table1, 1, 64, 2);
        GeneratePlasmaTable(p2_table1, 5, 16, 4);
        GeneratePlasmaTable(p2_table2, 0, 0, 0);
        GeneratePlasmaTable(p2_table2, 2, 64, 1);
        GeneratePlasmaTable(p2_table2, 6, 16, 2);
}


void luchador_Part2() {
        TBitmap8bpp *texture = new TBitmap8bpp(TEX1_ANCHO, TEX1_ALTO, TEX1, TEX1_PAL);
        TBitmap8bpp *mono = new TBitmap8bpp(US9_ANCHO, US9_ALTO, US9, US9_PAL);
        TBitmap8bpp *fondo = new TBitmap8bpp(P12_ANCHO, P12_ALTO, P12, P12_PAL);
        TBitmap8bpp *abajo = new TBitmap8bpp(P12B_ANCHO, P12B_ALTO, P12B, P12B_PAL);
	TBitmap8bpp *plasma;

	TObject3D *srcobj = new TObject3D();
        Read3DObject(GEO720, srcobj);
	srcobj->Centre();
        srcobj->FitSphere(FX2radius);
        srcobj->MapEnviroment();

	TObject3D *obj = new TObject3D();
        Read3DObject(GEO720, obj);
	obj->Centre();
        obj->FitSphere(FX2radius);
	obj->SetStyle(c_texturemapped);
//        obj->SetColor(RGB(255, 255, 255), 127, (int *)colortable);
	obj->SetTexture(texture);
	obj->MapEnviroment();

        if (srcobj->NumVertex & 1) plasma = new TBitmap8bpp(srcobj->NumVertex + 3, 4);
        else plasma = new TBitmap8bpp(srcobj->NumVertex + 2, 4);
	
//        for (i = 0; i < 256; i++) plasma->paleta[i] = RGB(i, i, i);

        camera->location.SetP(0, 0, -FX2radius * 1.8);
        
        double a;
        m_timer = 0;
        while (m_position < 6) {
                fondo->BlitTo(vscr, 0, 0);

                a = m_timer / 180.0;

                GeneratePlasma(plasma, p2_table1, p2_table2, 128 + 127 * sin(a), 
			128 + 127 * cos(a * 0.5), 255 * cos(a) * cos(a),
			128 - 127 * sin(a * 0.5));

                FX2(srcobj, obj, plasma);
		obj->Draw(vscr);

                if (m_timer < 240) mono->TransBlitTo(vscr, 0, 240 - m_timer, 255);
                else if (m_timer < 700) mono->TransBlitTo(vscr, 0, 0, 255);
                else mono->TransBlitTo(vscr, 0, m_timer - 700, 255);

                abajo->TransBlitTo(vscr, 0, 186, 102);

//                srcobj->Rotate(0, 1, 0);
		camera->az--;

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                GetMusicStatus();
                if (kbhit()) if (getch() == 27) Finalize();
	}
        
        delete texture;
        free(plasma->datos); delete plasma;
        delete mono;
        delete fondo;
        delete abajo;
        delete srcobj;
        delete obj;
}


