
#include <math.h>
#include <stdlib.h>
#include <conio.h>
#include "bitmaps.h"
#include "blitter.h"
#include "circles.h"
#include "plasmafx.h"
#include "obj3d.h"
#include "cameras.h"
#include "triangle.h"
#include "primitiv.h"
#include "globals.h"
#include "midas.h"
#include "part17.h"

#include "p6.h"
#include "mono5.h"
#include "banner5.h"


#define FX17sides 10
#define FX17sections 40
#define FX17freq1 2
#define FX17freq2 5

double p17_ainc1, p17_ainc2;

void EFX17_1(TObject3D *o, double t, double p) {
	int v = 0;
	double dist;
        for (int j = 0; j < FX17sections; j++) {
		dist = sin(t) * p;
                for (int i = 0; i < FX17sides; i++) {
			o->Vertex[v]->x += dist * o->Vertex[v]->normal.x;
			o->Vertex[v]->y += dist * o->Vertex[v]->normal.y;
			o->Vertex[v]->z += dist * o->Vertex[v]->normal.z;
			v++;
		}
                t += p17_ainc1;
	}
}

void EFX17_2(TObject3D *o, double t, double p) {
	int v = 0;
	double dist;
        for (int j = 0; j < FX17sections; j++) {
		dist = cos(t) * p;
                for (int i = 0; i < FX17sides; i++) {
			o->Vertex[v]->x += dist * o->Vertex[v]->normal.x;
			o->Vertex[v]->y += dist * o->Vertex[v]->normal.y;
			o->Vertex[v]->z += dist * o->Vertex[v]->normal.z;
			v++;
		}
                t += p17_ainc2;
	}
	for (int i = 0; i < o->NumPolygons; i++) o->Poly[i]->CalcNormal();
}


void luchador_Part17() {
        TBitmap8bpp *fondo = new TBitmap8bpp(P6_ANCHO, P6_ALTO, P6, P6_PAL);
        TBitmap8bpp *mono = new TBitmap8bpp(MONO5_ANCHO, MONO5_ALTO, MONO5, MONO5_PAL);
        TBitmap8bpp *logo = new TBitmap8bpp(BANNER5_ANCHO, BANNER5_ALTO, BANNER5, BANNER5_PAL);

        TVector *c = new TVector(0.12, 0.01, -2.0);

        p17_ainc1 = FX17freq1 * 2.0 * 3.14159265 / FX17sections;
        p17_ainc2 = FX17freq2 * 2.0 * 3.14159265 / FX17sections;

	TObject3D *obj = new TObject3D();
        MakeTorus(obj, 1.2, 0.65, FX17sides, FX17sections, 0);
        obj->SetStyle(c_wireframe);
        obj->SetColor(RGB(255, 255, 255), 0, NULL);
	obj->Rotate(360, 0, 0);

        TObject3D *sombra = new TObject3D();
        MakeTorus(sombra, 1.2, 0.65, FX17sides, FX17sections, 0);
        sombra->SetStyle(c_wireframe);
        sombra->SetColor(RGB(0, 0, 0), 0, NULL);
        sombra->Rotate(360, 0, 0);
        sombra->origin.SetP(c->x, c->y, 0);

        camera->location.SetP(c->x, c->y, c->z);
        camera->ax = -dtoi(NumDegrees * atan2(c->y, -c->z));
        camera->ay = -dtoi(NumDegrees * atan2(c->x, -c->z));
        camera->az = 0;

        double a, b;

        m_timer = 0;
        while (m_position < 49) {
                fondo->BlitTo(vscr, 0, 0);

                a = m_timer / 250.0;
                b = -m_timer / 31.0;

                EFX17_1(obj, a * 15.0, 0.024);
                EFX17_2(obj, b, 0.015);

                EFX17_1(sombra, (a - 0.5) * 15.0, 0.024);
                EFX17_2(sombra, (b - 0.5), 0.015);

                obj->Rotate(0, 0, dtoi(8.0 * sin(a * 1.7)));
                sombra->Rotate(0, 0, dtoi(8.0 * sin((a - 0.5) * 1.7)));

                sombra->Draw(vscr);
                obj->Draw(vscr);

                if (m_timer < 216)
                        mono->TransBlitTo(vscr, 74, 240 - m_timer, 128);
                else mono->TransBlitTo(vscr, 74, 24, 128);

                if (m_timer < 246)
                        logo->TransBlitTo(vscr, m_timer - 246, 0, 255);
                else logo->TransBlitTo(vscr, 0, 0, 255);

                if (blurflag) vscr->Blur();
                Blit((unsigned)vscr->datos);
                frames++;
                GetMusicStatus();
                if (kbhit()) if (getch() == 27) Finalize();
        }

        delete fondo;
        delete mono;
        delete logo;
        delete obj;
        delete sombra;
        delete c;
}

