
program Inna;

uses XMS, Mode13, FVektor2, INNAdraw, Crt,
     Midas, MConfig, MFile, MPlayer, S3M, MGlobals, Errors;


{ CONSTANTES Y VARIABLES GLOBALES }
const Npal = 16 - 1;    { Nmero de paletas usadas }
      Nstatic = 8 - 1;  { Nmero de pantallas estticas }

var module : PmpModule;  { apuntador al mdulo (cancin) actual }
    moduleInfo : PPmpInformation; { apuntador a la informacin del mdulo }
    MP : ^ModulePlayer;  { apuntador al reproductor del mdulo }

{ Medicin de velocidad }
var CPUvel : integer;

{ Handles para paletas }
var HPalette : array[0..Npal] of XMSHandle;

{ Handles y variables para tneles }
var HAngTab, HRadTab : array[0..2] of XMSHandle;
    HTunnel : array[0..2] of XMSHandle;
    RadTab, AngTab, TunnelMap : PTTexture;
    RadSeg, AngSeg, TunnelSeg : word;

{ Handles para rotozooms }
var HRotoPic : array[0..4] of XMSHandle;

{ Handles para imgenes estticas }
var HStaticPic : array[0..Nstatic] of XMSHandle;
    HGreetPic : array[0..1] of XMSHandle;
    HWordPic : array[0..3] of XMSHandle;
{    HBig : XMSHandle; }  { HBig definido en INNAdraw.pas }

{ Tablas y variables para el plasma }
var PlasmaTable1, PlasmaTable2 : array[0..255] of byte;
    pos1, pos2, pos3, pos4 : byte;

{ Handles para texturas y entornos }
var HMap : array[0..2] of XMSHandle;


{ PROCEDIMIENTOS Y FUNCIONES GLOBALES }
procedure dot;
begin
     write('!');
end;

function toASCIIZ(dest : PChar; str : string) : PChar;
var
    spos, slen : integer;
    i : integer;

begin
    spos := 0;                          { string position = 0 }
    slen := ord(str[0]);                { string length }

    { copy string to ASCIIZ conversion buffer: }
    while spos < slen do
    begin
        dest[spos] := str[spos+1];
        spos := spos + 1;
    end;

    dest[spos] := chr(0);               { put terminating 0 to end of string }

    toASCIIZ := dest;
end;


{ Pide al usuario la informacin de configuracin de la tarjeta de sonido }
procedure ConfigMidas;
var done : integer;
begin
    midasSetDefaults; { inicializa la informacin de configuracin }
    done := midasConfig; { pide la nueva configuracin }
    if done = 1 then { si todo est correcto... }
    begin
         midasSaveConfig('sound.cfg'); { guarda la configuracin }
         textmode(CO80);
         writeln;
         WriteLn('Configuration saved. Press any key to continue...');
         readkey;
    end
    else
    begin { Si no, detiene el programa }
         WriteLn('Configuration couldn''t be saved.');
         halt(1);
    end;
end;

{ Inicializa el sistema MIDAS para reproducir la msica }
procedure InitMidas;
var error, isConfig : integer;
    asciiz : array[0..256] of char;
begin
     { Comprueba que exista el archivo de configuracin }
     error := fileExists('sound.cfg', @isConfig);
     if error <> OK then MidasError(error);

     { Si no existe, entonces llama al procedimiento de configuracin }
     if isConfig <> 1 then ConfigMidas;
     error := fileExists('sound.cfg', @isConfig);
     if error <> OK then MidasError(error);

     MidasSetDefaults; { Reinicializa el sistema MIDAS }
     useVDS := 0;
     MidasLoadConfig('sound.cfg'); { Carga el archivo de configuracin }
     MidasInit; { Inicia el sonido }
     toAsciiZ(asciiz, 'innadat.002');
     module := midasLoadModule(asciiz, @mpS3M, nil); { Carga el mdulo }
     SetTextMode;
end;


{ Esta funcin ayuda a sincronizar el demo con la msica.
  Devuelve true hasta que la msica llegue al patrn y rengln especificados }
function Sync(p, r : word) : boolean;
begin
     MP^.GetInformation(moduleInfo);
     if (moduleInfo^)^.pos < p then
     begin
          Sync := true;
          exit;
     end;
     if (moduleInfo^)^.pos > p then
     begin
          Sync := false;
          exit;
     end;
     if (moduleInfo^)^.row < r then Sync := true
                               else Sync := false;
end;


Function IntSqrt(Const L : LongInt) : Word; Assembler;
(* This routine was "borrowed" from Demostu3.zip ;) *)
Asm
	Db $66; mov ax,WORD PTR [l]
	Db $66; mov bx,ax
	Db $66; mov cx, $0000; DW $4000;
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over1
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over1:	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over2
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over2: Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over3
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over3:	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over4
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over4:	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over5
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over5:	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over6
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over6:	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over7
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over7:	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over8
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over8:	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over9
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over9:	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over10
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over10:
	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over11
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over11:
	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over12
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over12:
	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over13
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over13:
	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over14
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over14:
	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over15
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over15:
	Db $66; shr cx,2
	Db $66; mov dx,cx
	Db $66; add dx,ax
	Db $66; shr ax,1
	Db $66; cmp dx,bx
	ja @over16
	Db $66; sub bx,dx
	Db $66; or ax,cx
@over16:
End;

function pow(base, exponente : single) : single;
begin
     pow := exp(ln(base) * exponente);
end;


procedure LoadBigPic;
var buffer : PTTexture;
    n : word;
    cs : XMSstruct;
    ff : file;
    temp : pointer;
    pal : ^TPalette;

begin
     assign(ff, 'innadat.000');
     reset(ff, 1);
     seek(ff, 589505);
     buffer := new(PTTexture);
     getmem(pal, 768);

     cs.size := 60 * 968;
     cs.srchandle := 0;
     cs.srcoffset := buffer;
     cs.dsthandle := HBig;
     cs.dstoffset := nil;

     for n := 0 to 19 do
     begin
          blockread(ff, buffer^, 60 * 968);
          XMSCopy(cs);
          temp := cs.dstoffset;
          asm
             db long; mov ax, word ptr [temp]
             db long; add ax, 58080; dw 0
             db long; mov word ptr [temp], ax
          end;
          cs.dstoffset := temp;
          dot;
     end;

     blockread(ff, pal^, 768);
     base2xms(pal, HPalette[13], 768);

     dispose(buffer);
     freemem(pal, 768);
     close(ff);
end;


procedure InitAll;
var buffer, buffer2, buffer3 : PTTexture;
    vscr : PTVirtual;
    vseg, i, j, off : word;
    pal : ^TPalette;
    x, y, ang : single;
    intang, i1, i2, j1, j2, rad, rad1 : longint;

    TotalXMS, TotalBase : longint;

begin
     { Checa memoria }
     if memavail < (430 * 1024) then
     begin
          writeln('You need at least 570 Kb base memory and 2.8 Mb XMS memory.');
          halt(1);
     end;
     if XMSFree < (2800 * 1024) then
     begin
          writeln('You need at least 570 Kb base memory and 2.8 Mb XMS memory.');
          halt(1);
     end;

     clrscr;
     writeln;
     writeln;
     writeln('This demo uses a lot of XMS handles, so you must have a line');
     writeln('like this in you CONFIG.SYS:');
     writeln;
     writeln('     device=c:\windows\himem.sys /numhandles=128');
     writeln;
     writeln;
     writeln('If you don''t have it, some pictures will not look good.');
     writeln;
     writeln('Press [ESC] to exit the demo and change your CONFIG.SYS');
     writeln('or press ANY other key to continue and watch the demo...');

     while keypressed do readkey;
     if readkey = #27 then halt(0);

     writeln;
     writeln;
     writeln('Is your CPU a Pentium 120 or faster (Y/N)?');
     case readkey of
          'y', 'Y', 's', 'S', 'j', 'J', 'o', 'O' : CPUvel := 2;
          else CPUvel := 3;
     end;
     InitMidas;
     clrscr;
     writeln;
     writeln('Please wait while I load some pictures and calculate some stuff...');
     writeln('(it''s gonna take A LOT of time... sorry! I know it''s a pain in the * )');
     randomize;
     TotalBase := memavail;
     writeln;
     writeln(' * Allocated ', TotalBase, ' bytes of base memory...');
     getmem(pal, 768);
     TotalXMS := 0;
     for i := 0 to Npal do XMSAlloc(HPalette[i], 768);
     inc(TotalXMS, 1);
     buffer := new(PTTexture);
     buffer2 := new(PTTexture);
     buffer3 := new(PTTexture);
     SetupVirtual(vscr, vseg);
     for i := 0 to 2 do XMSAlloc(HRadTab[i], 65536); inc(TotalXMS, 195);
     for i := 0 to 2 do XMSAlloc(HAngTab[i], 65536); inc(TotalXMS, 195);
     for i := 0 to 2 do XMSAlloc(HTunnel[i], 65536); inc(TotalXMS, 195);
     for i := 0 to 4 do XMSAlloc(HRotoPic[i], 65536); inc(TotalXMS, 260);
     for i := 0 to 2 do XMSAlloc(HMap[i], 65536); inc(TotalXMS, 195);
     XMSAlloc(HStaticPic[0], 186 * 152); inc(TotalXMS, 28);
     XMSAlloc(HStaticPic[1], 222 * 146); inc(TotalXMS, 32);
     for i := 2 to 7 do XMSAlloc(HStaticPic[i], 64000); inc(TotalXMS, 320);
     for i := 0 to 1 do XMSAlloc(HGreetPic[i], 25600); inc(TotalXMS, 50);
     for i := 0 to 3 do XMSAlloc(HWordPic[i], 2560); inc(TotalXMS, 12);
     XMSAlloc(HBig, 968 * 1200); inc(TotalXMS, 1135);

     writeln(' * Allocated ', TotalXMS * 1024, ' bytes of XMS memory...');

     writeln(' * Generating plasma tables...');

     for i := 0 to 255 do
     begin
          PlasmaTable1[i] := round(cos(Pi * i / 128) * 31 + exp(i/128)) + 32;
          PlasmaTable2[i] := round(sin(i / 80) * 2.5 * exp(i / 192) * i);
     end;

     write(' * Generating tunnel tables...');

     for j1 := -128 to 127 do
     begin
         for i1 := -128 to 127 do
         begin
              if i1 <> 0 then i2 := i1 else i2 := 1;
              if j1 <> 0 then j2 := j1 else j2 := 1;
              rad1 := IntSqrt(i2 * i2 + j2 * j2);
              rad := trunc(8 * 32 * pow(256 * 1024 * rad1, 0.1));
              rad := rad + trunc((32 * sin(rad * 1.284 / 64.0)));
              buffer^[(j1 + 128) shl 8 + i1 + 128] := rad and $FF;
              rad := rad - abs(abs(j1) - 128) - i1 - j1;
              buffer2^[(j1 + 128) shl 8 + i1 + 128] := rad and $FF;
              rad1 := trunc(8 * 32 * pow(256 * 1024 * rad1, 0.08));
              rad1 := rad1 + trunc((48 * sin(rad1 * 6.284 / 64.0)));
              buffer3^[(j1 + 128) shl 8 + i1 + 128] := rad1 and $FF;
         end;
         if (j1 mod 16) = 0 then dot;
     end;
     base2xms(buffer, HRadTab[0], 65536);
     base2xms(buffer2, HRadTab[1], 65536);
     base2xms(buffer3, HRadTab[2], 65536);

     for j1 := -128 to 127 do
     begin
         for i1 := -128 to 127 do
         begin
              if i1 <> 0 then x := i1 else x := 0.0001;
              if j1 <> 0 then y := j1 else y := 0.0001;
              ang := arctan(y / x) * (256 / 6.284);
              intang := trunc(ang);
              buffer^[(j1 + 128) shl 8 + i1 + 128] := intang and $FF;
              intang := intang + intsqrt(i1*i1 + j1*j1);
              buffer2^[(j1 + 128) shl 8 + i1 + 128] := intang and $FF;
              if intsqrt(i1*i1 + j1*j1) >= 64 then
                 intang := intang - (intsqrt(i1*i1 + j1*j1) - 64) * 2;
              buffer3^[(j1 + 128) shl 8 + i1 + 128] := intang and $FF;
         end;
         if (j1 mod 16) = 0 then dot;
     end;
     writeln;
     base2xms(buffer, HAngTab[0], 65536);
     base2xms(buffer2, HAngTab[1], 65536);
     base2xms(buffer3, HAngTab[2], 65536);

     write(' * Loading tunnel textures...');

     LoadTexture('innadat.000', buffer, pal^, 63293, 80909);
     base2xms(buffer, HTunnel[0], 65536);
     base2xms(pal, HPalette[0], 768);
     dot;

     LoadTexture('innadat.000', buffer, pal^, 80909, 98301);
     base2xms(buffer, HTunnel[1], 65536);
     base2xms(pal, HPalette[1], 768);
     dot;

     LoadTexture('innadat.000', buffer, pal^, 98301, 179732);
     base2xms(buffer, HTunnel[2], 65536);
     base2xms(pal, HPalette[2], 768);
     dot;

     writeln;
     write(' * Loading rotozoom pictures...');

     LoadTexture('innadat.000', buffer, pal^, 179732, 229999);
     base2xms(buffer, HRotoPic[0], 65536);
     base2xms(pal, HPalette[3], 768);
     dot;

     LoadTexture('innadat.000', buffer, pal^, 229999, 242807);
     base2xms(buffer, HRotoPic[1], 65536);
     base2xms(pal, HPalette[4], 768);
     dot;

     LoadTexture('innadat.000', buffer, pal^, 242807, 273474);
     base2xms(buffer, HRotoPic[2], 65536);
     base2xms(pal, HPalette[5], 768);
     dot;

     LoadTexture('innadat.000', buffer, pal^, 273474, 287479);
     base2xms(buffer, HRotoPic[3], 65536);
     base2xms(pal, HPalette[6], 768);
     dot;

     LoadTexture('innadat.000', buffer, pal^, 287479, 340877);
     base2xms(buffer, HRotoPic[4], 65536);
     base2xms(pal, HPalette[15], 768);
     dot;

     writeln;
     write(' * Loading static images...');

     LoadPCX('innadat.000', vseg, 80, 32, 0, 0, pal^, 354839, 357221);
     off := 0;
     for j := 0 to 31 do
         for i := 0 to 79 do
         begin
              buffer^[off] := GetPixel(i, j, vseg);
              inc(off);
         end;
     base2xms(buffer, HWordPic[0], 2560);
     dot;

     LoadPCX('innadat.000', vseg, 80, 32, 0, 0, pal^, 357221, 359541);
     off := 0;
     for j := 0 to 31 do
         for i := 0 to 79 do
         begin
              buffer^[off] := GetPixel(i, j, vseg);
              inc(off);
         end;
     base2xms(buffer, HWordPic[1], 2560);
     dot;

     LoadPCX('innadat.000', vseg, 80, 32, 0, 0, pal^, 359541, 361480);
     off := 0;
     for j := 0 to 31 do
         for i := 0 to 79 do
         begin
              buffer^[off] := GetPixel(i, j, vseg);
              inc(off);
         end;
     base2xms(buffer, HWordPic[2], 2560);
     dot;

     LoadPCX('innadat.000', vseg, 80, 32, 0, 0, pal^, 361480, 363842);
     off := 0;
     for j := 0 to 31 do
         for i := 0 to 79 do
         begin
              buffer^[off] := GetPixel(i, j, vseg);
              inc(off);
         end;
     base2xms(buffer, HWordPic[3], 2560);
     dot;

     LoadPCX('innadat.000', vseg, 186, 152, 0, 0, pal^, 363842, 373652);
     off := 0;
     for j := 0 to 151 do
         for i := 0 to 185 do
         begin
              buffer^[off] := GetPixel(i, j, vseg);
              inc(off);
         end;
     base2xms(buffer, HStaticPic[0], 186 * 152);
     dot;

     LoadPCX('innadat.000', vseg, 222, 146, 0, 0, pal^, 373652, 383935);
     off := 0;
     for j := 0 to 145 do
         for i := 0 to 221 do
         begin
              buffer^[off] := GetPixel(i, j, vseg);
              inc(off);
         end;
     base2xms(buffer, HStaticPic[1], 222 * 146);
     dot;

     LoadPCX('innadat.000', vseg, 320, 200, 0, 0, pal^, 383935, 424228);
     base2xms(vscr, HStaticPic[2], 64000);
     base2xms(pal, HPalette[7], 768);
     dot;

     LoadPCX('innadat.000', vseg, 320, 200, 0, 0, pal^, 424228, 484605);
     base2xms(vscr, HStaticPic[3], 64000);
     base2xms(pal, HPalette[8], 768);
     dot;

     LoadPCX('innadat.000', vseg, 320, 200, 0, 0, pal^, 484605, 509197);
     base2xms(vscr, HStaticPic[4], 64000);
     base2xms(pal, HPalette[9], 768);
     dot;

     LoadPCX('innadat.000', vseg, 320, 200, 0, 0, pal^, 509197, 513874);
     base2xms(vscr, HStaticPic[5], 64000);
     dot;

     LoadPCX('innadat.000', vseg, 320, 200, 0, 0, pal^, 513874, 573608);
     base2xms(vscr, HStaticPic[6], 64000);
     base2xms(pal, HPalette[14], 768);
     dot;

     LoadPCX('innadat.000', vseg, 320, 200, 0, 0, pal^, 573608, 589505);
     base2xms(vscr, HStaticPic[7], 64000);
     dot;

     LoadPCX('innadat.000', vseg, 128, 200, 0, 0, pal^, 340877, 347829);
     off := 0;
     for j := 0 to 199 do
         for i := 0 to 127 do
         begin
              buffer^[off] := GetPixel(i, j, vseg);
              inc(off);
         end;
     base2xms(buffer, HGreetPic[0], 25600);
     dot;

     LoadPCX('innadat.000', vseg, 128, 200, 0, 0, pal^, 347829, 354839);
     off := 0;
     for j := 0 to 199 do
         for i := 0 to 127 do
         begin
              buffer^[off] := GetPixel(i, j, vseg);
              inc(off);
         end;
     base2xms(buffer, HGreetPic[1], 25600);
     dot;

     writeln;
     write(' * Loading textures and enviroments...');

     LoadTexture('innadat.000', buffer, pal^, 0, 24367);
     base2xms(buffer, HMap[0], 65536);
     base2xms(pal, HPalette[10], 768);
     dot;

     LoadTexture('innadat.000', buffer, pal^, 24367, 39044);
     base2xms(buffer, HMap[1], 65536);
     base2xms(pal, HPalette[11], 768);
     dot;

     LoadTexture('innadat.000', buffer, pal^, 39044, 63293);
     base2xms(buffer, HMap[2], 65536);
     base2xms(pal, HPalette[12], 768);
     dot;

     writeln;
     write(' * Loading the BIG picture...');
     LoadBigPic;

     writeln;
     writeln(' * DONE!');
     dispose(buffer);
     dispose(buffer2);
     dispose(buffer3);
     ShutDownVirtual(vscr);
     freemem(pal, 768);
     writeln;
     writeln;
     writeln;
     writeln(' Thanks for waiting. Press any key to continue...');
     while keypressed do readkey;
     readkey;
     SetMode13;
     midasPlayModule(module, 0);
     MP := midasMP;
end;


procedure FreeAll;
var i : word;
    k : boolean;
begin
     k := false;
     if keypressed then
     begin
          readkey;
          k := true;
     end;
     midasStopModule(module);
     midasFreeModule(module);
     midasClose;
     for i := 0 to Npal do XMSDispose(HPalette[i]);
     for i := 0 to 2 do XMSDispose(HAngTab[i]);
     for i := 0 to 2 do XMSDispose(HRadTab[i]);
     for i := 0 to 2 do XMSDispose(HTunnel[i]);
     for i := 0 to 4 do XMSDispose(HRotoPic[i]);
     for i := 0 to Nstatic do XMSDispose(HStaticPic[i]);
     for i := 0 to 2 do XMSDispose(HMap[i]);
     for i := 0 to 1 do XMSDispose(HGreetPic[i]);
     for i := 0 to 3 do XMSDispose(HWordPic[i]);
     XMSDispose(HBig);
     SetTextMode;
     writeln;
     writeln(' INNA  --  a vampire tribute by FAC');
     writeln;
     writeln(' get in contact:  shadowfac@hotmail.com (preferred)');
     writeln('                  ganzo@galia.fc.uaslp.mx');
     writeln;
     writeln;
     halt(0);
end;


{ DIBUJO DE TUNELES }
procedure DrawTunnelFull(radoff, angoff : integer; where : word); assembler;
asm
   push ds
   mov bx, 256 * 28
   mov di, 32
   mov es, RadSeg
   mov dx, AngSeg
   mov ax, TunnelSeg
   db $8E, $E8  { mov gs, ax }
   mov ax, where
   db $8E, $E0  { mov fs, ax }
   mov ds, dx
   mov dh, 200
   @loopy:  mov cx, 256
   @loopx:  mov al, es:[bx]
            add ax, radoff
            shl ax, 8
            add ax, angoff
            mov si, ax
            xor ax, ax
            mov al, [bx]
            shl ax, 1
            add si, ax
            db $65; mov dl, [si]   { mov dl, gs:[si] }
            db $64; mov [di], dl   { mov fs:[di], dl }
            inc di
            inc bx
            dec cx
            jnz @loopx
            add di, 64
            dec dh
            jnz @loopy
            pop ds
end;

procedure DrawTunnel(radoff, angoff : integer; where : word); assembler;
asm
   push ds
   mov bx, 256 * 28
   mov di, 32
   mov es, RadSeg
   mov dx, AngSeg
   mov ax, TunnelSeg
   db $8E, $E8  { mov gs, ax }
   mov ax, where
   db $8E, $E0  { mov fs, ax }
   mov ds, dx
   mov dh, 100
   @loopy:  mov cx, 256
   @loopx:  mov al, es:[bx]
            add ax, radoff
            shl ax, 8
            add ax, angoff
            mov si, ax
            xor ax, ax
            mov al, [bx]
            shl ax, 1
            add si, ax
            db $65; mov dl, [si]   { mov dl, gs:[si] }
            db $64; mov [di], dl   { mov fs:[di], dl }
            inc di
            inc bx
            dec cx
            jnz @loopx
            add di, 384
            add bx, 256
            dec dh
            jnz @loopy
            pop ds
end;


{ DIBUJO DE PLASMA }
procedure DrawPlasma256(where : word);
var p3 : byte;
begin
     asm
        mov es, where
        mov ah, pos4
        mov si, 100
        mov di, 352  { 320 + 32 }
        @loopy:   mov dl, pos1
                  mov dh, pos2
                  mov cx, 256
        @loopx:   xor bh, bh
                  mov bl, dl
                  mov al, [offset PlasmaTable1 + bx]
                  mov bl, dh
                  add al, [offset PlasmaTable1 + bx]
                  mov bl, p3
                  add al, [offset PlasmaTable1 + bx]
                  mov bl, ah
                  add al, [offset PlasmaTable1 + bx]
                  mov bx, si
                  shl bx, 1
                  add al, [offset PlasmaTable2 + bx]
                  mov bx, cx
                  add al, [offset PlasmaTable2 + bx]
                  shr al, 1
                  or al, $80
                  mov es:[di], al
                  inc di
                  add dl, 3
                  add dh, 2
                  dec cx
                  jne @loopx
                  add di, 384
                  add p3, 3
                  add ah, 2
                  dec si
                  jne @loopy
     end;
end;


procedure GetPaletteXMS(p : byte; var pal : TPalette);
var temp : ^TPalette;
begin
     getmem(temp, 768);
     xms2base(HPalette[p], temp, 768);
     pal := temp^;
     freemem(temp, 768);
end;



{ PRIMERA PARTE: PLASMA + TUNEL + IMAGENES }
procedure Part1;
var VirScr : PTVirtual;
    VirSeg : word;
    pal1, pal2 : TPalette;
    i, j, k : byte;
    fade : integer;
    pic : pointer;
    rz : PTRotoZoom;
    solid : PTSolid;
begin
     SetupVirtual(VirScr, VirSeg);
     ClearScreen(0, VirSeg);
     RadTab := new(PTTexture);
     AngTab := new(PTTexture);
     TunnelMap := new(PTTexture);
     xms2base(HRadTab[0], RadTab, 65536);
     xms2base(HAngTab[0], AngTab, 65536);
     xms2base(HTunnel[1], TunnelMap, 65536);
     GetPaletteXMS(1, pal1);
     RadSeg := seg(RadTab^);
     AngSeg := seg(AngTab^);
     TunnelSeg := seg(TunnelMap^);
     GetPaletteXMS(4, pal2);
     rz := new(PTRotoZoom, Init(TunnelMap, pal2));
     rz^.ScaleUV(0.7, 1);
     rz^.Scale(39322);

     for i := 0 to 31 do
     begin
          pal1[i][0] := i shl 1;
          pal1[i][1] := i shl 1;
          pal1[i][2] := i shl 1;
          pal1[i + 32] := pal1[i];
     end;
     for i := 0 to 63 do
     begin
          pal1[i+128][0] := (63 - i) div 16;
          pal1[i+128][1] := 0;
          pal1[i+128][2] := 0;
     end;
     for i := 64 to 95 do
     begin
          pal1[i+128][0] := i - 64;
          pal1[i+128][1] := 0;
          pal1[i+128][2] := 0;
     end;
     for i := 96 to 127 do
     begin
          pal1[i+128][0] := 127 - i;
          pal1[i+128][1] := 0;
          pal1[i+128][2] := 0;
     end;
     fillchar(pal2, 768, 0);

     { Sh*t starts here }
     setpalette(pal2);
     xms2base(HStaticPic[7], VirScr, 64000);

     { Iluminar tunel }
     fade := 0;
     while Sync(1, 0) do
     begin
          DrawTunnel(-i, i, VirSeg);
          DrawPlasma256(VirSeg);
          CopyScreen(VirSeg, VGA);
          SetPalette(pal2);
          inc(i);

          { mueve plasma }
          dec(pos1, 3);
          inc(pos3, 3);
          inc(pos1, random(3) - 1);
          dec(pos2, random(3) - 1);
          inc(pos3, random(3));
          dec(pos4, random(3));

          { fade up tunel }
          inc(fade);
          if (fade mod 6) = 0 then
             for j := 97 to 127 do
                 if pal2[j][0] < pal1[j][0] then inc(pal2[j][0]);
          if keypressed then FreeAll;
     end;

     { Iluminar plasma }
     fade := 0;
     while Sync(1, 16) do
     begin
          DrawTunnel(-i, i, VirSeg);
          DrawPlasma256(VirSeg);
          CopyScreen(VirSeg, VGA);
          SetPalette(pal2);
          inc(i);

          { mueve plasma }
          dec(pos1, 3);
          inc(pos3, 3);
          inc(pos1, random(3) - 1);
          dec(pos2, random(3) - 1);
          inc(pos3, random(3));
          dec(pos4, random(3));

          { fade up plasma }
          inc(fade);
          if (fade mod 6) = 0 then
             for j := 128 to 255 do
                 if pal2[j][0] < pal1[j][0] then inc(pal2[j][0]);
          if keypressed then FreeAll;
     end;

     { Iluminar plasma }
     fade := 0;
     while Sync(1, 32) do
     begin
          DrawTunnel(-i, i, VirSeg);
          DrawPlasma256(VirSeg);
          CopyScreen(VirSeg, VGA);
          SetPalette(pal2);
          inc(i);

          { mueve plasma }
          dec(pos1, 3);
          inc(pos3, 3);
          inc(pos1, random(3) - 1);
          dec(pos2, random(3) - 1);
          inc(pos3, random(3));
          dec(pos4, random(3));

          { fade up plasma }
          inc(fade);
          if (fade mod 6) = 0 then
             for j := 128 to 255 do
                 if pal2[j][0] > 0 then dec(pal2[j][0]);
          if keypressed then FreeAll;
     end;

     { Iluminar plasma }
     fade := 0;
     while Sync(1, 56) do
     begin
          DrawTunnel(-i, i, VirSeg);
          DrawPlasma256(VirSeg);
          CopyScreen(VirSeg, VGA);
          SetPalette(pal2);
          inc(i);

          { mueve plasma }
          dec(pos1, 3);
          inc(pos3, 3);
          inc(pos1, random(3) - 1);
          dec(pos2, random(3) - 1);
          inc(pos3, random(3));
          dec(pos4, random(3));

          { fade up plasma }
          inc(fade);
          if (fade mod 4) = 0 then
             for j := 128 to 255 do
                 if pal2[j][0] < pal1[j][0] then inc(pal2[j][0]);
          if keypressed then FreeAll;
     end;


     { Iluminar texto }
     GetMem(pic, 186*152);
     fade := 0;
     xms2base(HStaticPic[0], pic, 186*152);
     xms2base(HStaticPic[7], VirScr, 64000);
     while Sync(2, 48) do
     begin
          DrawTunnel(-i, i, VirSeg);
          DrawPlasma256(VirSeg);
          DrawPicture(pic, 186, 152, 7747, 134, VirSeg);
          CopyScreen(VirSeg, VGA);
          SetPalette(pal2);
          inc(i);

          { mueve plasma }
          dec(pos1, 3);
          inc(pos3, 3);
          inc(pos1, random(3) - 1);
          dec(pos2, random(3) - 1);
          inc(pos3, random(3));
          dec(pos4, random(3));

          { fade up text }
          inc(fade);
          if (fade mod 4) = 0 then
             for j := 1 to 63 do
                 if pal2[j][0] < pal1[j][0] then
                 begin
                      inc(pal2[j][0]);
                      inc(pal2[j][1]);
                      inc(pal2[j][2]);
                 end;
          if keypressed then FreeAll;
     end;

     { oscurecer texto }
     xms2base(HAngTab[2], AngTab, 65536);
     for k := 1 to 64 do
     begin
          DrawTunnel(0, i, VirSeg);
          DrawPlasma256(VirSeg);
          DrawPicture(pic, 186, 152, 7747, 134, VirSeg);
          CopyScreen(VirSeg, VGA);
          SetPalette(pal2);
          inc(i);

          { mueve plasma }
          dec(pos1, 3);
          inc(pos3, 3);
          inc(pos1, random(3) - 1);
          dec(pos2, random(3) - 1);
          inc(pos3, random(3));
          dec(pos4, random(3));

          { fade out text }
          for j := 1 to 63 do
               if pal2[j][0] > 0 then
               begin
                    dec(pal2[j][0]);
                    dec(pal2[j][1]);
                    dec(pal2[j][2]);
               end;
          if keypressed then FreeAll;
     end;

     FreeMem(pic, 186*152);

     { continan tnel y plasma }
     while Sync(3, 0) do
     begin
          DrawTunnel(0, i, VirSeg);
          DrawPlasma256(VirSeg);
          CopyScreen(VirSeg, VGA);
          SetPalette(pal2);
          inc(i);

          { mueve plasma }
          dec(pos1, 3);
          inc(pos3, 3);
          inc(pos1, random(3) - 1);
          dec(pos2, random(3) - 1);
          inc(pos3, random(3));
          dec(pos4, random(3));
          if keypressed then FreeAll;
      end;

     { iluminar texto 2 }
     GetMem(pic, 222*146);
     xms2base(HStaticPic[1], pic, 222*146);
     for j := 0 to 24 do
     begin
          pal1[j+32][0] := trunc(j * 2.56);
          pal1[j+32][1] := 0;
          pal1[j+32][2] := 0;
     end;
     while Sync(4, 0) do
     begin
          DrawTunnel(-i, i, VirSeg);
          DrawPlasma256(VirSeg);
          DrawPicture(pic, 222, 146, 8689, 98, VirSeg);
          CopyScreen(VirSeg, VGA);
          SetPalette(pal2);
          inc(i);

          { mueve plasma }
          dec(pos1, 3);
          inc(pos3, 3);
          inc(pos1, random(3) - 1);
          dec(pos2, random(3) - 1);
          inc(pos3, random(3));
          dec(pos4, random(3));

          { fade up text }
          for j := 1 to 56 do
          begin
               if pal2[j][0] < pal1[j][0] then inc(pal2[j][0]);
               if pal2[j][1] < pal1[j][1] then inc(pal2[j][1]);
               if pal2[j][2] < pal1[j][2] then inc(pal2[j][2]);
          end;
          if keypressed then FreeAll;
     end;

     { oscurecer texto 2 }
     for k := 1 to 64 do
     begin
          DrawTunnel(-i, i, VirSeg);
          DrawPlasma256(VirSeg);
          DrawPicture(pic, 222, 146, 8689, 98, VirSeg);
          CopyScreen(VirSeg, VGA);
          SetPalette(pal2);
          inc(i);

          { mueve plasma }
          dec(pos1, 3);
          inc(pos3, 3);
          inc(pos1, random(3) - 1);
          dec(pos2, random(3) - 1);
          inc(pos3, random(3));
          dec(pos4, random(3));

          { fade out text }
          for j := 1 to 56 do
          begin
               if pal2[j][0] > 0 then dec(pal2[j][0]);
               if pal2[j][1] > 0 then dec(pal2[j][1]);
               if pal2[j][2] > 0 then dec(pal2[j][2]);
          end;
          if keypressed then FreeAll;
     end;

     FreeMem(pic, 222*146);

     { continan tnel y plasma }
     while Sync(4, 16) do
     begin
          DrawTunnel(-i, i, VirSeg);
          DrawPlasma256(VirSeg);
          CopyScreen(VirSeg, VGA);
          SetPalette(pal2);
          inc(i);

          { mueve plasma }
          dec(pos1, 3);
          inc(pos3, 3);
          inc(pos1, random(3) - 1);
          dec(pos2, random(3) - 1);
          inc(pos3, random(3));
          dec(pos4, random(3));
          if keypressed then FreeAll;
     end;

     { oscurecer plasma }
     fade := 0;
     while Sync(4, 32) do
     begin
          DrawTunnel(-i, i, VirSeg);
          DrawPlasma256(VirSeg);
          CopyScreen(VirSeg, VGA);
          SetPalette(pal2);
          inc(i);

          { mueve plasma }
          dec(pos1, 3);
          inc(pos3, 3);
          inc(pos1, random(3) - 1);
          dec(pos2, random(3) - 1);
          inc(pos3, random(3));
          dec(pos4, random(3));

          { fade out plasma }
          inc(fade);
          if (fade mod 4) = 0 then
             for j := 128 to 255 do
                 if pal2[j][0] > 0 then dec(pal2[j][0]);
          if keypressed then FreeAll;
     end;

     { oscurecer tunel }
     fade := 0;
     while Sync(4, 56) do
     begin
          DrawTunnel(-i, i, VirSeg);
          DrawPlasma256(VirSeg);
          CopyScreen(VirSeg, VGA);
          SetPalette(pal2);
          inc(i);

          { mueve plasma }
          dec(pos1, 3);
          inc(pos3, 3);
          inc(pos1, random(3) - 1);
          dec(pos2, random(3) - 1);
          inc(pos3, random(3));
          dec(pos4, random(3));

          { fade out tunel }
          inc(fade);
          if (fade mod 3) = 0 then
             for j := 97 to 127 do
                 if pal2[j][0] > 0 then dec(pal2[j][0]);
          if keypressed then FreeAll;
     end;

     { titulo + rotozoom }
     ClearScreen(0, VGA);
     ClearScreen(0, VirSeg);
     solid := new(PTSolid);
     solid^.Load('innadat.001', 0);
     solid^.Rotate(0, 0, 180);
     solid^.SetStyle(EnviromentMap);
     xms2base(HMap[0], RadTab, 65536);
     solid^.SetTexture(RadTab, 0);
     xms2base(HRotoPic[1], TunnelMap, 65536);
     GetPaletteXMS(10, pal2);
     for i := 128 to 255 do rz^.palette[i] := pal2[i];
     SetPalette(rz^.palette);
     i := 159;  { * }
     j := 0;
     frame.SetCenter(160, 100);
     rz^.move(220, 80);
     while Sync(5, 32) do
     begin
          asm
             mov es, VirSeg
             mov di, 0
             mov cx, 4000
             db long; xor ax, ax
             db $F3, $66, $AB  { rep stosd }
             mov di, 48000
             mov cx, 4000
             db $F3, $66, $AB  { rep stodsd }
          end;
          frame.SetFrame(159 - i, 99 - j, 160 + i, 100 + j);
          rz^.rotate(1);
          rz^.drawfull(VirSeg, 15996, 100);
          solid^.Draw(VirSeg);
          copyscreen(VirSeg, VGA);

          Solid^.SetOrigin(0, 0, i * 3);
          Solid^.rotate(-2, -2, 4);
          if i < 159 then inc(i);
          if j < 99 then inc(j);
          if keypressed then FreeAll;
     end;

     pal1 := rz^.palette;
     while Sync(5, 60) do
     begin
          asm
             mov es, VirSeg
             mov di, 0
             mov cx, 4000
             db long; xor ax, ax
             db $F3, $66, $AB  { rep stosd }
             mov di, 48000
             mov cx, 4000
             db $F3, $66, $AB  { rep stodsd }
          end;
          frame.SetFrame(159 - i, 99 - j, 160 + i, 100 + j);
          rz^.rotate(1);
          rz^.drawfull(VirSeg, 15996, 100);
          solid^.Draw(VirSeg);
          copyscreen(VirSeg, VGA);
          setpalette(pal1);

          Solid^.SetOrigin(0, 0, i * 3);
          Solid^.rotate(-2, -2, 4);
          if i < 159 then inc(i);
          if j < 99 then inc(j);
          for k := 0 to 255 do
          begin
               if pal1[k][0] < 63 then inc(pal1[k][0]);
               if pal1[k][1] < 63 then inc(pal1[k][1]);
               if pal1[k][2] < 63 then inc(pal1[k][2]);
          end;
          if keypressed then FreeAll;
     end;

     { Sh*t ends here }
     ShutDownVirtual(VirScr);
     dispose(Solid, Done);
     dispose(RadTab);
     dispose(AngTab);
     dispose(TunnelMap);
end;


{ SEGUNDA PARTE: HELICE + Rotozooms + Imgenes estticas }
procedure Part2;
var VScr1, VScr2 : PTVirtual;
    VSeg1, VSeg2 : word;
    Solid : PTSolid;
    rz : PTRotoZoom;
    texture, rpic : PTTexture;
    i, j, k, l : integer;
    pal1, pal2 : TPalette;
    x : integer;
begin
     ClearScreen(0, VGA);
     Frame.Reset;
     SetupVirtual(VScr1, vseg1);
     SetupVirtual(vscr2, vseg2);
     xms2base(HStaticPic[4], vscr2, 64000);
     GetPaletteXMS(9, pal1);
     Solid := new(PTSolid, Init);
     Solid^.Load('innadat.001', 51504);
     texture := new(PTTexture);
     xms2base(HMap[2], texture, 65536);
     Solid^.SetStyle(EnviromentMap);
     Solid^.Settexture(texture, 0);
     rpic := new(PTTexture);
     xms2base(HRotoPic[2], rpic, 65536);
     rz := new(PTRotoZoom, Init(rpic, pal1));
     rz^.ScaleUV(0.76, 1);
     i := 0;
     ClearScreen(255, VSeg1);
     fillchar(pal2, 768, 0);
     for j := 128 to 255 do pal2[j] := pal1[j];

     setpalette(pal2);
     j := 0;
     k := 1;
     x := -400;
     while Sync(6, 32) do
     begin
          rz^.move(160 + cost[i] div 1024, 100 + sint[i] div 1024);
          solid^.setorigin(x, 0, 300);
          fadeblurto128(k, vseg1);
          rz^.Draw(vseg1, 316);
          solid^.draw(vseg1);
          copyscreen(vseg1, vga);

          inc(j);
          if (j mod 16) = 0 then if k < 64 then inc(k);
          if i < 359 then inc(i) else i := 0;
          rz^.rotate(-1);
          rz^.scale(65210);
          solid^.rotate(1, 1, 1);
          inc(x, 2);
          if keypressed then FreeAll;
     end;

     while Sync(7, 0) do
     begin
          rz^.move(160 + cost[i] div 1024, 100 + sint[i] div 1024);
          solid^.setorigin(x, 0, 300);
          copyscreen(Vseg2, Vseg1);
          rz^.Draw(vseg1, 316);
          solid^.draw(vseg1);
          copyscreen(vseg1, vga);
          setpalette(pal2);

          inc(j);
          if i < 359 then inc(i) else i := 0;
          rz^.rotate(-1);
          rz^.scale(65210);
          solid^.rotate(1, 1, 1);
          inc(x, 2);

          if (j and 1) = 0 then
          begin
               { fade up imagen }
               for l := 0 to 127 do
               begin
                    if pal2[l][0] < pal1[l][0] then inc(pal2[l][0]);
                    if pal2[l][1] < pal1[l][1] then inc(pal2[l][1]);
                    if pal2[l][2] < pal1[l][2] then inc(pal2[l][2]);
               end;
               { fade out rotozoom }
               for l := 192 to 255 do
               begin
                    if pal2[l][0] > 0 then dec(pal2[l][0]);
                    if pal2[l][1] > 0 then dec(pal2[l][1]);
                    if pal2[l][2] > 0 then dec(pal2[l][2]);
               end;
          end;
          if keypressed then FreeAll;
     end;

     xms2base(HRotoPic[0], rpic, 65536);
     GetPaletteXMS(3, pal2);
     for l := 0 to 191 do pal2[l] := pal1[l];
     pal1 := pal2;
     rz^.Init(rpic, pal1);
     rz^.ScaleUV(2.7, 1);
     rz^.Scale(13110);
     fillchar(pal2, 768, 63);
     while Sync(7, 32) do
     begin
          rz^.move(160 + cost[i] div 1024, 175 + sint[i] div 2048);
          solid^.setorigin(x, 0, 300);
          copyscreen(Vseg2, Vseg1);
          rz^.DrawFull(Vseg1, 47996, 50);
          solid^.draw(vseg1);
          copyscreen(vseg1, vga);
          setpalette(pal2);
          rz^.rotate(sint[i] div 16384);
          rz^.scale(65400);
          solid^.rotate(1, 1, 1);
          inc(x, 2);

          if i < 359 then inc(i) else i := 0;
          for l := 0 to 255 do
          begin
               if pal2[l][0] > pal1[l][0] then dec(pal2[l][0]);
               if pal2[l][1] > pal1[l][1] then dec(pal2[l][1]);
               if pal2[l][2] > pal1[l][2] then dec(pal2[l][2]);
          end;
          if keypressed then FreeAll;
     end;

     k := 0;
     while Sync(8, 0) do
     begin
          rz^.move(160 + cost[i] div 1024, 175 + sint[i] div 2048);
          solid^.setorigin(x, 0, 300);
          copyscreen(Vseg2, Vseg1);
          rz^.DrawFull(Vseg1, 47996, 50);
          solid^.draw(vseg1);
          copyscreen(vseg1, vga);
          setpalette(pal2);
          rz^.rotate(sint[i] div 16384);
          rz^.scale(65670);
          solid^.rotate(1, 1, 1);
          inc(x, 2);

          if i < 359 then inc(i) else i := 0;
          inc(k);
          if (k mod 2) = 0 then
          for l := 0 to 255 do
          begin
               if pal2[l][0] > 0 then dec(pal2[l][0]);
               if pal2[l][1] > 0 then dec(pal2[l][1]);
               if pal2[l][2] > 0 then dec(pal2[l][2]);
          end;
          if keypressed then FreeAll;
     end;

     Shutdownvirtual(vscr1);
     shutdownvirtual(vscr2);
     dispose(solid, done);
     dispose(rz);
     dispose(texture);
     dispose(rpic);
end;


{ TERCERA PARTE: (interrupcin) TUNELES + LETREROS }
procedure Part3;
var VirScr : PTVirtual;
    VirSeg : word;
    pal1, pal2 : TPalette;
    i, j, k : byte;
    pic : pointer;
begin
     getmem(pic, 2560);
     ClearScreen(0, VGA);
     SetupVirtual(VirScr, VirSeg);
     AngTab := new(PTTexture);
     RadTab := new(PTTexture);
     TunnelMap := new(PTTexture);
     AngSeg := seg(AngTab^);
     RadSeg := seg(RadTab^);
     TunnelSeg := seg(TunnelMap^);
     xms2base(HTunnel[2], TunnelMap, 65536);
     xms2base(HAngTab[0], AngTab, 65536);
     xms2base(HRadTab[0], RadTab, 65536);
     GetPaletteXMS(2, pal1);
     for i := 0 to 31 do
     begin
          pal1[i][0] := i shl 1;
          pal1[i][1] := 0;
          pal1[i][2] := 0;
     end;

     xms2base(HWordPic[0], pic, 2560);
     fillchar(pal2, 768, 63);
     ClearScreen(0, VirSeg);
     k := 0;
     while Sync(8, 10) do
     begin
          DrawTunnelFull(-3*k, k, VirSeg);
          i := 35 + random(10);
          j := 45 + random(10);
          DrawPicture(pic, 80, 32, YOffset[j] + i, 240, VirSeg);
          CopyScreen(VirSeg, VGA);
          setpalette(pal2);

          inc(k);
          for i := 0 to 255 do
          begin
               if pal2[i][0] > pal1[i][0] then dec(pal2[i][0]);
               if pal2[i][1] > pal1[i][1] then dec(pal2[i][1]);
               if pal2[i][2] > pal1[i][2] then dec(pal2[i][2]);
          end;
          if keypressed then FreeAll;
     end;

     xms2base(HRadTab[1], RadTab, 65536);
     xms2base(HAngTab[2], AngTab, 65536);
     xms2base(HWordPic[1], pic, 2560);
     fillchar(pal2, 768, 63);
     ClearScreen(0, VirSeg);
     k := 0;
     while Sync(8, 20) do
     begin
          DrawTunnelFull(-3*k, -k, VirSeg);
          i := 195 + random(10);
          j := 45 + random(10);
          DrawPicture(pic, 80, 32, YOffset[j] + i, 240, VirSeg);
          CopyScreen(VirSeg, VGA);
          setpalette(pal2);

          inc(k);
          for i := 0 to 255 do
          begin
               if pal2[i][0] > pal1[i][0] then dec(pal2[i][0]);
               if pal2[i][1] > pal1[i][1] then dec(pal2[i][1]);
               if pal2[i][2] > pal1[i][2] then dec(pal2[i][2]);
          end;
          if keypressed then FreeAll;
     end;

     xms2base(HRadTab[2], RadTab, 65536);
     xms2base(HAngTab[0], AngTab, 65536);
     xms2base(HWordPic[2], pic, 2560);
     fillchar(pal2, 768, 63);
     ClearScreen(0, VirSeg);
     k := 0;
     while Sync(8, 30) do
     begin
          DrawTunnelFull(2*k, 0, VirSeg);
          i := 35 + random(10);
          j := 125 + random(10);
          DrawPicture(pic, 80, 32, YOffset[j] + i, 240, VirSeg);
          CopyScreen(VirSeg, VGA);
          setpalette(pal2);

          inc(k);
          for i := 0 to 255 do
          begin
               if pal2[i][0] > pal1[i][0] then dec(pal2[i][0]);
               if pal2[i][1] > pal1[i][1] then dec(pal2[i][1]);
               if pal2[i][2] > pal1[i][2] then dec(pal2[i][2]);
          end;
          if keypressed then FreeAll;
     end;

     xms2base(HRadTab[0], RadTab, 65536);
     xms2base(HAngTab[1], AngTab, 65536);
     xms2base(HWordPic[3], pic, 2560);
     fillchar(pal2, 768, 63);
     ClearScreen(0, VirSeg);
     k := 0;
     while Sync(8, 36) do
     begin
          DrawTunnelFull(3*k, 0, VirSeg);
          i := 195 + random(10);
          j := 125 + random(10);
          DrawPicture(pic, 80, 32, YOffset[j] + i, 240, VirSeg);
          CopyScreen(VirSeg, VGA);
          setpalette(pal2);

          inc(k);
          for i := 0 to 255 do
          begin
               if pal2[i][0] > pal1[i][0] then dec(pal2[i][0]);
               if pal2[i][1] > pal1[i][1] then dec(pal2[i][1]);
               if pal2[i][2] > pal1[i][2] then dec(pal2[i][2]);
          end;
          if keypressed then FreeAll;
     end;

     while Sync(9, 0) do
     begin
          DrawTunnelFull(3*k, 0, VirSeg);
          i := 195 + random(10);
          j := 125 + random(10);
          DrawPicture(pic, 80, 32, YOffset[j] + i, 240, VirSeg);
          CopyScreen(VirSeg, VGA);
          setpalette(pal2);

          inc(k);
          for i := 0 to 255 do
          begin
               if pal2[i][0] > 0 then dec(pal2[i][0]);
               if pal2[i][1] > 0 then dec(pal2[i][1]);
               if pal2[i][2] > 0 then dec(pal2[i][2]);
               if pal2[i][0] > 0 then dec(pal2[i][0]);
               if pal2[i][1] > 0 then dec(pal2[i][1]);
               if pal2[i][2] > 0 then dec(pal2[i][2]);
          end;
          if keypressed then FreeAll;
     end;

     freemem(pic, 2560);
     ShutDownVirtual(VirScr);
     dispose(AngTab);
     dispose(RadTab);
     dispose(TunnelMap);
end;

{ CUARTA PARTE: LA VAMPIRESA }
procedure Part4;
var VScr1, VScr2, VScr3 : PTVirtual;
    VSeg1, VSeg2, VSeg3 : word;
    pal, pal2 : TPalette;
    x, y, t : longint;
    i1, i2, j1, j2 : integer;
    vp, vn : integer;


    procedure BPScroll(nx, ny : longint; sx, sy : integer; p, r : word);
    begin
         while Sync(p, r) do
         begin
              mapsection(x, y, VSeg1);
              copyscreen(vseg1, vseg2);
              scalescreen(VSeg2, vseg1);
              copyscreen(VSeg1, VGA);
              if abs(nx - x) > abs(sx) then inc(x, sx);
              if abs(ny - y) > abs(sy) then inc(y, sy);
              if keypressed then FreeAll;
         end;
         x := nx;
         y := ny;
    end;

begin
     vp := CPUvel;
     vn := -CPUvel;
     ClearScreen(0, VGA);
     SetupVirtual(VScr1, VSeg1);
     SetupVirtual(VScr2, VSeg2);
     SetupVirtual(VScr3, VSeg3);
     fillchar(pal2, 768, 0);
     setpalette(pal2);
     GetPaletteXMS(13, pal);
     x := 0;
     y := 0;
     mapsection(0, 0, VSeg1);
     copyscreen(vseg1, vseg2);
     ScaleScreen(VSeg2, vseg1);
     CopyScreen(VSeg1, VGA);
     fadeto(pal2, pal, 0);

     BPScroll(0, 1000, vp, vp, 10, 32);
     BPScroll(100, 1000, vp, vp, 10, 48);
     BPScroll(100, 900, vp, vn, 11, 0);

     mapsection(x, y, VSeg2);
     CopyScreen(VSeg2, VSeg1);
     Scalescreen(vseg2, VSeg1);
     copyscreen(VSeg1, VGA);
     i1 := 0; j1 := 0;
     i2 := 319; j2 := 199;
     t := 0;
     while Sync(11, 16) do
     begin
          Scale(i1, j1, i2, j2, VSeg2, 0, 0, 319, 199, VSeg1);
          CopyScreen(VSeg1, VSeg3);
          ScaleScreen(VSeg3, VSeg1);
          copyscreen(VSeg1, VGA);
          inc(t);
          if (t mod (4 - vp)) = 0 then
          begin
               if i1 < 100 then inc(i1, 4);
               if i2 > 160 then dec(i2, 4);
               if j1 < 100 then inc(j1, 3);
               if j2 > 145 then dec(j2, 3);
          end;
          if keypressed then FreeAll;
     end;

     while Sync(11, 32) do
     begin
          Scale(i1, j1, i2, j2, VSeg2, 0, 0, 319, 199, VSeg1);
          copyscreen(vseg1, vseg3);
          ScaleScreen(vseg3, VSeg1);
          copyscreen(VSeg1, VGA);
          inc(t);
          if (t mod (4 - vp)) = 0 then
          begin
               if i1 > 0 then dec(i1, 4);
               if i2 < 319 then inc(i2, 4);
               if j1 > 0 then dec(j1, 3);
               if j2 < 199 then inc(j2, 3);
          end;
          if keypressed then FreeAll;
     end;

     BPScroll(100, 1000, vp, vp, 11, 48);
     BPScroll(500, 1000, vp, vp, 12, 32);
     BPScroll(500, 0, vp, vn, 14, 0);

     mapsection(x, y, VSeg2);
     copyscreen(Vseg2, VSeg1);
     scalescreen(VSeg2, vseg1);
     copyscreen(VSeg1, VGA);
     i1 := 0; j1 := 0;
     i2 := 319; j2 := 199;
     while Sync(14, 16) do
     begin
          Scale(i1, j1, i2, j2, VSeg2, 0, 0, 319, 199, VSeg1);
          copyscreen(vseg1, vseg3);
          ScaleScreen(vseg3, VSeg1);
          copyscreen(VSeg1, VGA);
          inc(t);
          if (t mod (4 - vp)) = 0 then
          begin
               if i1 < 160 then inc(i1, 4);
               if i2 > 220 then dec(i2, 4);
               if j1 < 120 then inc(j1, 3);
               if j2 > 165 then dec(j2, 3);
          end;
          if keypressed then FreeAll;
     end;

     while Sync(14, 32) do
     begin
          Scale(i1, j1, i2, j2, VSeg2, 0, 0, 319, 199, VSeg1);
          copyscreen(vseg1, vseg3);
          ScaleScreen(vseg3, VSeg1);
          copyscreen(VSeg1, VGA);
          inc(t);
          if (t mod (4 - vp)) = 0 then
          begin
               if i1 > 0 then dec(i1, 4);
               if i2 < 319 then inc(i2, 4);
               if j1 > 0 then dec(j1, 3);
               if j2 < 199 then inc(j2, 3);
          end;
          if keypressed then FreeAll;
     end;

     BPScroll(460, 0, vn, vp, 14, 48);

     t := 0;
     while Sync(15, 48) do
     begin
          mapsection(x, y, VSeg1);
          copyscreen(vseg1, vseg2);
          ScaleScreen(vseg2, VSeg1);
          copyscreen(Vseg1, VGA);
          setpalette(pal);
          if y < 1000 then inc(y);
          inc(t);
          if (t mod 4) = 0 then
             for i1 := 0 to 255 do
             begin
                  if pal[i1][0] > 0 then dec(pal[i1][0]);
                  if pal[i1][1] > 0 then dec(pal[i1][1]);
                  if pal[i1][2] > 0 then dec(pal[i1][2]);
             end;
          if keypressed then FreeAll;
     end;

     ShutDownVirtual(VScr1);
     ShutDownVirtual(VScr2);
     ShutDownVirtual(VScr3);
end;

{ PART 5: GREETS }
procedure Part5;
var VirScr : PTVirtual;
    VirSeg : word;
    ax, ay, az, i, j : integer;
    solid : PTSolid;
    texture, rzpic : PTTexture;
    rz : PTRotoZoom;
    pal1, pal2 : TPalette;
    pic : pointer;
begin
     getmem(pic, 25600);
     solid := new(PTSolid, Init);
     SetupVirtual(VirScr, VirSeg);
     ClearScreen(0, VGA);
     texture := new(PTTexture);
     rzpic := new(PTTexture);
     rz := new(PTRotoZoom, Init(rzpic, pal1));

     GetPaletteXMS(14, pal1);
     xms2base(HStaticPic[6], VirScr, 64000);
     fillchar(pal2, 768, 0);
     setpalette(pal2);
     copyscreen(VirSeg, VGA);
     FadeTo(pal2, pal1, 0);
     while Sync(16, 48) do if keypressed then FreeAll;

     { Greets parte 1 }
     FadeOut(pal1, 1);
     ClearScreen(0, VGA);
     ClearScreen(0, VirSeg);
     solid^.Load('innadat.001', 25256);
     solid^.SetStyle(EnviromentMap);
     solid^.SetTexture(texture, 0);
     frame.reset;
     solid^.SetOrigin(-120, 0, 400);
     xms2base(HMap[2], texture, 65536);
     xms2base(HRotoPic[1], rzpic, 65536);
     rz^.ScaleUV(0.7, 1);
     rz^.Scale(32768);
     GetPaletteXMS(4, pal1);
     GetPaletteXMS(12, pal2);
     for i := 128 to 191 do pal1[i] := pal2[i];
     for i := 0 to 24 do
     begin
          pal1[i][0] := trunc(i * 2.56);
          pal1[i][1] := pal1[i][0];
          pal1[i][2] := pal1[i][0];
     end;
     GetPaletteXMS(5, pal2);
     for i := 192 to 255 do pal1[i] := pal2[i];
     fillchar(pal2, 768, 0);
     xms2base(HGreetPic[0], pic, 25600);
     while Sync(17, 0) do;

     ax := 0; ay := 25; az := 50;
     while Sync(18, 32) do
     begin
          rz^.move(160 + cost[i] div 1024, 100 + sint[i] div 1024);
          rz^.DrawFull(VirSeg, 316, 198);
          DrawPicture(pic, 128, 200, 192, 192, VirSeg);
          solid^.Draw(VirSeg);
          copyscreen(VirSeg, VGA);
          setpalette(pal2);

          rz^.Rotate(1);
          rz^.Scale(65536 - cost[i] div 128);
          if i < 359 then inc(i) else i := 0;
          solid^.Rotate(ax div 20, ay div 20, az div 20);
          if ax < 100 then inc(ax) else ax := 0;
          if ay < 100 then inc(ay) else ay := 0;
          if az < 100 then inc(az) else az := 0;

          for j := 0 to 191 do
          begin
               if pal2[j][0] < pal1[j][0] then inc(pal2[j][0]);
               if pal2[j][1] < pal1[j][1] then inc(pal2[j][1]);
               if pal2[j][2] < pal1[j][2] then inc(pal2[j][2]);
          end;
          if keypressed then FreeAll;
     end;

     while Sync(18, 52) do
     begin
          rz^.move(160 + cost[i] div 1024, 100 + sint[i] div 1024);
          rz^.DrawFull(VirSeg, 316, 198);
          DrawPicture(pic, 128, 200, 192, 192, VirSeg);
          solid^.Draw(VirSeg);
          copyscreen(VirSeg, VGA);
          setpalette(pal2);

          rz^.Rotate(1);
          rz^.Scale(65536 - cost[i] div 128);
          if i < 359 then inc(i) else i := 0;
          solid^.Rotate(ax div 20, ay div 20, az div 20);
          if ax < 100 then inc(ax) else ax := 0;
          if ay < 100 then inc(ay) else ay := 0;
          if az < 100 then inc(az) else az := 0;

          for j := 0 to 191 do
          begin
               if pal2[j][0] > 0 then dec(pal2[j][0]);
               if pal2[j][1] > 0 then dec(pal2[j][1]);
               if pal2[j][2] > 0 then dec(pal2[j][2]);
               if pal2[j][0] > 0 then dec(pal2[j][0]);
               if pal2[j][1] > 0 then dec(pal2[j][1]);
               if pal2[j][2] > 0 then dec(pal2[j][2]);
          end;
          if keypressed then FreeAll;
     end;
     dispose(solid, Done);

     { Greets parte 2 }
     ClearScreen(0, VirSeg);
     solid := new(PTSolid, Init);
     solid^.Load('innadat.001', 37808);
     solid^.SetStyle(EnviromentMap);
     solid^.SetTexture(texture, 0);
     frame.reset;
     solid^.SetOrigin(140, 0, 400);
     xms2base(HRotoPic[2], rzpic, 65536);
     rz^.ScaleUV(1.086, 1);
     fillchar(pal2, 768, 0);
     xms2base(HGreetPic[1], pic, 25600);
     while Sync(19, 0) do;

     ax := 0; ay := 25; az := 50;
     while Sync(20, 16) do
     begin
          rz^.move(160 + cost[i] div 1024, 100 + sint[i] div 1024);
          rz^.DrawFull(VirSeg, 316, 198);
          DrawPicture(pic, 128, 200, 0, 192, VirSeg);
          solid^.Draw(VirSeg);
          copyscreen(VirSeg, VGA);
          setpalette(pal2);

          rz^.Rotate(-1);
          rz^.Scale(65536 - cost[i] div 128);
          if i < 359 then inc(i) else i := 0;
          solid^.Rotate(ax div 20, ay div 20, az div 20);
          if ax < 100 then inc(ax) else ax := 0;
          if ay < 100 then inc(ay) else ay := 0;
          if az < 100 then inc(az) else az := 0;

          for j := 0 to 255 do
          begin
               if pal2[j][0] < pal1[j][0] then inc(pal2[j][0]);
               if pal2[j][1] < pal1[j][1] then inc(pal2[j][1]);
               if pal2[j][2] < pal1[j][2] then inc(pal2[j][2]);
          end;
          if keypressed then FreeAll;
     end;

     while Sync(20, 48) do
     begin
          rz^.move(160 + cost[i] div 1024, 100 + sint[i] div 1024);
          rz^.DrawFull(VirSeg, 316, 198);
          DrawPicture(pic, 128, 200, 0, 192, VirSeg);
          solid^.Draw(VirSeg);
          copyscreen(VirSeg, VGA);
          setpalette(pal2);

          rz^.Rotate(-1);
          rz^.Scale(65536 - cost[i] div 128);
          if i < 359 then inc(i) else i := 0;
          solid^.Rotate(ax div 20, ay div 20, az div 20);
          if ax < 100 then inc(ax) else ax := 0;
          if ay < 100 then inc(ay) else ay := 0;
          if az < 100 then inc(az) else az := 0;

          for j := 0 to 255 do
          begin
               if pal2[j][0] > 0 then dec(pal2[j][0]);
               if pal2[j][1] > 0 then dec(pal2[j][1]);
               if pal2[j][2] > 0 then dec(pal2[j][2]);
               if pal2[j][0] > 0 then dec(pal2[j][0]);
               if pal2[j][1] > 0 then dec(pal2[j][1]);
               if pal2[j][2] > 0 then dec(pal2[j][2]);
          end;
          if keypressed then FreeAll;
     end;

     dispose(solid, Done);
     freemem(pic, 25600);
     ShutDownVirtual(VirScr);
     dispose(texture);
     dispose(rzpic);
     dispose(rz);
end;


{ PARTE 6:  DE TODO }
procedure Part6;
var VirScr : PTVirtual;
    VirSeg : word;
    solid, sphere : PTSolid;
    texture : PTTexture;
    rz : PTRotoZoom;
    pic : array[0..3] of pointer;
    pal1, pal2, spal, spal2 : TPalette;
    i, j, k, z : integer;
begin
     SetupVirtual(VirScr, VirSeg);
     solid := new(PTSolid, init);
     sphere := new(PTSolid, init);
     solid^.Load('innadat.001', 37808);
     sphere^.Load('innadat.001', 77576);
     solid^.SetStyle(TextureMap);
     sphere^.SetStyle(TextureMap);
     pal2[0][0] := 0; pal2[0][1] := 0; pal2[0][2] := 0;
     pal2[1][0] := 63; pal2[1][1] := 32; pal2[1][2] := 8;
     MakeTexturePal(0, 160, 0, 200, 0, 280, 0.5, 120, spal, 0, 127, pal2, 2);
     MakeTexturePal(0, 160, 0, 200, 0, 280, 0.5, 120, spal2, 0, 111, pal2, 2);
     for i := 0 to 31 do
     begin
          spal2[i+224][0] := i shl 1;
          spal2[i+224][1] := i shl 1;
          spal2[i+224][2] := i shl 1;
     end;
     texture := new(PTTexture);
     solid^.SetTexture(texture, 2);
     solid^.SetColor(0, 127);
     sphere^.SetColor(0, 127);
     solid^.MakePhongTable;
     dispose(texture);
     solid^.SetOrigin(0, 0, 600);
     sphere^.SetOrigin(0, 0, 800);
     solid^.SetUV;
     solid^.ScaleUV(2.7 * 4, 6);
     solid^.SetUV;
     sphere^.ScaleUV(2.7, 4);
     frame.reset;
     MoveLight(0, -1, 2);
     ClearScreen(0, VGA);
     ClearScreen(0, VirSeg);

     { Tunnel }
     TunnelMap := new(PTTexture);
     AngTab := new(PTTexture);
     RadTab := new(PTTexture);
     TunnelSeg := seg(TunnelMap^);
     AngSeg := seg(AngTab^);
     RadSeg := seg(RadTab^);
     xms2base(HTunnel[0], TunnelMap, 65536);
     xms2base(HAngTab[2], AngTab, 65536);
     xms2base(HRadTab[0], RadTab, 65536);
     fillchar(pal1, 768, 0);
     fillchar(pal2, 768, 0);
     for i := 0 to 31 do pal1[i][0] := i shl 1;
     while Sync(21, 0) do;
     i := 0;
     setpalette(pal1);
     while Sync(21, 8) do
     begin
          DrawTunnelFull(i, i, VGA);
          inc(i);
          if keypressed then FreeAll;
     end;
     dispose(AngTab);
     dispose(RadTab);
     dispose(TunnelMap);


     { Solid }
     texture := new(PTTexture);
     xms2base(HMap[1], texture, 65536);
     solid^.SetTexture(texture, 2);
     clearscreen(0, vga);
     setpalette(spal);
     while Sync(21, 16) do
     begin
          fadeblurto0(1, VirSeg);
          solid^.draw(VirSeg);
          copyscreen(VirSeg, VGA);
          solid^.rotate(3, 3, 3);
          rotatelight(0, 0, -2);
          if keypressed then FreeAll;
     end;

     { Rotozoom }
     rz := new(PTRotoZoom, Init(texture, pal1));
     rz^.ScaleUV(0.8, 1);
     rz^.Rotate(45);
     xms2base(HRotoPic[4], texture, 65536);
     GetPaletteXMS(15, pal2);
     clearscreen(0, vga);
     setpalette(pal2);
     i := 0;
     while Sync(21, 32) do
     begin
          rz^.Move(160 + cost[i] div 1024, 100 + sint[i] div 1024);
          rz^.DrawFull(VGA, 316, 198);
          rz^.Rotate(-1);
          if i < 359 then inc(i) else i := 0;
          if keypressed then FreeAll;
     end;
     dispose(rz);
     dispose(texture);


     { Tunel + pics }
     TunnelMap := new(PTTexture);
     AngTab := new(PTTexture);
     RadTab := new(PTTexture);
     TunnelSeg := seg(TunnelMap^);
     AngSeg := seg(AngTab^);
     RadSeg := seg(RadTab^);
     for i := 0 to 3 do
     begin
          getmem(pic[i], 2560);
          xms2base(HWordPic[i], pic[i], 2560);
     end;

     xms2base(HTunnel[2], TunnelMap, 65536);
     GetPaletteXMS(2, pal1);
     for i := 0 to 31 do
     begin
          pal1[i][0] := i shl 1;
          pal1[i][1] := 0;
          pal1[i][2] := 0;
     end;
     pal2 := pal1;
     for i := 0 to 31 do
     begin
          pal1[i+128][0] := i shl 1;
          pal1[i+128][1] := 0;
          pal1[i+128][2] := 0;
     end;
     ClearScreen(0, VGA);
     ClearScreen(0, VirSeg);
     k := 0;
     SetPalette(pal2);

     xms2base(HAngTab[0], AngTab, 65536);
     xms2base(HRadTab[1], RadTab, 65536);
     setpal(0, 63, 63, 63);
     while Sync(21, 40) do
     begin
          DrawTunnelFull(-3*k, k, VirSeg);
          i := 35 + random(10); j := 45 + random(10);
          DrawPicture(pic[0], 80, 32, YOffset[j] + i, 240, VirSeg);
          i := 195 + random(10); j := 45 + random(10);
          DrawPicture(pic[1], 80, 32, YOffset[j] + i, 240, VirSeg);
          i := 35 + random(10); j := 125 + random(10);
          DrawPicture(pic[2], 80, 32, YOffset[j] + i, 240, VirSeg);
          i := 195 + random(10); j := 125 + random(10);
          DrawPicture(pic[3], 80, 32, YOffset[j] + i, 240, VirSeg);
          CopyScreen(VirSeg, VGA);
          Setpalette(pal2);
          inc(k);
          if (k mod 4) = 0 then
             for i := 128 to 159 do
             begin
                  if pal2[i][0] > pal1[i][0] then dec(pal2[i][0]);
                  if pal2[i][0] < pal1[i][0] then inc(pal2[i][0]);
                  if pal2[i][1] > pal1[i][1] then dec(pal2[i][1]);
                  if pal2[i][1] < pal1[i][1] then inc(pal2[i][1]);
                  if pal2[i][2] > pal1[i][2] then dec(pal2[i][2]);
                  if pal2[i][2] < pal1[i][2] then inc(pal2[i][2]);
             end;
          if keypressed then FreeAll;
     end;

     xms2base(HAngTab[2], AngTab, 65536);
     xms2base(HRadTab[0], RadTab, 65536);
     setpal(0, 63, 63, 63);
     while Sync(21, 48) do
     begin
          DrawTunnelFull(k, k, VirSeg);
          i := 35 + random(10); j := 45 + random(10);
          DrawPicture(pic[0], 80, 32, YOffset[j] + i, 240, VirSeg);
          i := 195 + random(10); j := 45 + random(10);
          DrawPicture(pic[1], 80, 32, YOffset[j] + i, 240, VirSeg);
          i := 35 + random(10); j := 125 + random(10);
          DrawPicture(pic[2], 80, 32, YOffset[j] + i, 240, VirSeg);
          i := 195 + random(10); j := 125 + random(10);
          DrawPicture(pic[3], 80, 32, YOffset[j] + i, 240, VirSeg);
          CopyScreen(VirSeg, VGA);
          Setpalette(pal2);
          inc(k);
          if (k mod 4) = 0 then
             for i := 128 to 159 do
             begin
                  if pal2[i][0] > pal1[i][0] then dec(pal2[i][0]);
                  if pal2[i][0] < pal1[i][0] then inc(pal2[i][0]);
                  if pal2[i][1] > pal1[i][1] then dec(pal2[i][1]);
                  if pal2[i][1] < pal1[i][1] then inc(pal2[i][1]);
                  if pal2[i][2] > pal1[i][2] then dec(pal2[i][2]);
                  if pal2[i][2] < pal1[i][2] then inc(pal2[i][2]);
             end;
          if keypressed then FreeAll;
     end;

     xms2base(HAngTab[0], AngTab, 65536);
     xms2base(HRadTab[2], RadTab, 65536);
     setpal(0, 63, 63, 63);
     while Sync(21, 56) do
     begin
          DrawTunnelFull(0, -2*k, VirSeg);
          i := 35 + random(10); j := 45 + random(10);
          DrawPicture(pic[0], 80, 32, YOffset[j] + i, 240, VirSeg);
          i := 195 + random(10); j := 45 + random(10);
          DrawPicture(pic[1], 80, 32, YOffset[j] + i, 240, VirSeg);
          i := 35 + random(10); j := 125 + random(10);
          DrawPicture(pic[2], 80, 32, YOffset[j] + i, 240, VirSeg);
          i := 195 + random(10); j := 125 + random(10);
          DrawPicture(pic[3], 80, 32, YOffset[j] + i, 240, VirSeg);
          CopyScreen(VirSeg, VGA);
          Setpalette(pal2);
          inc(k);
          if (k mod 4) = 0 then
             for i := 128 to 159 do
             begin
                  if pal2[i][0] > pal1[i][0] then dec(pal2[i][0]);
                  if pal2[i][0] < pal1[i][0] then inc(pal2[i][0]);
                  if pal2[i][1] > pal1[i][1] then dec(pal2[i][1]);
                  if pal2[i][1] < pal1[i][1] then inc(pal2[i][1]);
                  if pal2[i][2] > pal1[i][2] then dec(pal2[i][2]);
                  if pal2[i][2] < pal1[i][2] then inc(pal2[i][2]);
             end;
          if keypressed then FreeAll;
     end;

     xms2base(HAngTab[1], AngTab, 65536);
     xms2base(HRadTab[0], RadTab, 65536);
     setpal(0, 63, 63, 63);
     while Sync(22, 0) do
     begin
          DrawTunnelFull(k, k, VirSeg);
          i := 35 + random(10); j := 45 + random(10);
          DrawPicture(pic[0], 80, 32, YOffset[j] + i, 240, VirSeg);
          i := 195 + random(10); j := 45 + random(10);
          DrawPicture(pic[1], 80, 32, YOffset[j] + i, 240, VirSeg);
          i := 35 + random(10); j := 125 + random(10);
          DrawPicture(pic[2], 80, 32, YOffset[j] + i, 240, VirSeg);
          i := 195 + random(10); j := 125 + random(10);
          DrawPicture(pic[3], 80, 32, YOffset[j] + i, 240, VirSeg);
          CopyScreen(VirSeg, VGA);
          Setpalette(pal2);
          inc(k);
          if (k mod 4) = 0 then
             for i := 128 to 159 do
             begin
                  if pal2[i][0] > pal1[i][0] then dec(pal2[i][0]);
                  if pal2[i][0] < pal1[i][0] then inc(pal2[i][0]);
                  if pal2[i][1] > pal1[i][1] then dec(pal2[i][1]);
                  if pal2[i][1] < pal1[i][1] then inc(pal2[i][1]);
                  if pal2[i][2] > pal1[i][2] then dec(pal2[i][2]);
                  if pal2[i][2] < pal1[i][2] then inc(pal2[i][2]);
             end;
          if keypressed then FreeAll;
     end;
     dispose(AngTab);
     dispose(RadTab);
     dispose(TunnelMap);
     for i := 0 to 3 do freemem(pic[i], 2560);

     { Solid }
     texture := new(PTTexture);
     xms2base(HMap[1], texture, 65536);
     solid^.SetTexture(texture, 2);
     clearscreen(0, vga);
     setpalette(spal);
     while Sync(22, 8) do
     begin
          fadeblurto0(1, VirSeg);
          solid^.draw(VirSeg);
          copyscreen(VirSeg, VGA);
          solid^.rotate(3, -3, 3);
          rotatelight(0, 0, -2);
          if keypressed then FreeAll;
     end;

     { Rotozoom }
     rz := new(PTRotoZoom, Init(texture, pal1));
     rz^.ScaleUV(0.8, 1);
     rz^.Scale(78644);
     rz^.Rotate(-30);
     xms2base(HRotoPic[4], texture, 65536);
     GetPaletteXMS(15, pal2);
     clearscreen(0, vga);
     setpalette(pal2);
     i := 0;
     while Sync(22, 16) do
     begin
          rz^.Move(280 + cost[i] div 2048, 150 + sint[i] div 2048);
          rz^.DrawFull(VGA, 316, 198);
          rz^.Rotate(-1);
          if i < 359 then inc(i) else i := 0;
          if keypressed then FreeAll;
     end;
     dispose(rz);

     { Sphere }
     MoveLight(1, 0, 0);
     xms2base(HMap[1], texture, 65536);
     sphere^.SetTexture(texture, 2);
     clearscreen(0, vga);
     setpalette(spal);
     while Sync(22, 32) do
     begin
          fadeblurto0(1, VirSeg);
          sphere^.draw(VirSeg);
          copyscreen(VirSeg, VGA);
          sphere^.rotate(0, 0, 2);
          rotatelight(0, 4, 0);
          if keypressed then FreeAll;
     end;

     { pics + solid }
     solid^.SetColor(0, 111);
     solid^.MakePhongTable;
     solid^.SetOrigin(0, 0, 800);
     z := 800;
     for i := 0 to 3 do
     begin
          getmem(pic[i], 2560);
          xms2base(HWordPic[i], pic[i], 2560);
          AngSeg := seg(pic[i]^);
          RadSeg := ofs(pic[i]^);
          for j := 0 to 2559 do
          begin
               mem[AngSeg:RadSeg] := mem[AngSeg:RadSeg] + 224;
               inc(RadSeg);
          end;
     end;

     ClearScreen(0, VGA);
     ClearScreen(0, VirSeg);
     SetPalette(spal2);
     MoveLight(-1, 1, 2);

     setpal(0, 63, 63, 63);
     k := 0;
     while Sync(22, 48) do
     begin
          FadeBlurTo0(1, VirSeg);
          solid^.SetOrigin(0, 0, z);
          i := 35 + random(10); j := 45 + random(10);
          DrawPicture(pic[0], 80, 32, YOffset[j] + i, 240, VirSeg);
          i := 195 + random(10); j := 45 + random(10);
          DrawPicture(pic[1], 80, 32, YOffset[j] + i, 240, VirSeg);
          i := 35 + random(10); j := 125 + random(10);
          DrawPicture(pic[2], 80, 32, YOffset[j] + i, 240, VirSeg);
          i := 195 + random(10); j := 125 + random(10);
          DrawPicture(pic[3], 80, 32, YOffset[j] + i, 240, VirSeg);
          solid^.Draw(VirSeg);
          CopyScreen(VirSeg, VGA);
          Setpalette(spal2);
          inc(k);
          if z > -1000 then dec(z, 30);
          solid^.Rotate(1, -1, 5);
          RotateLight(0, 0, 2);
          if (k mod 3) = 0 then
             for i := 0 to 223 do
             begin
                  if spal2[i][0] > 0 then dec(spal2[i][0]);
                  if spal2[i][1] > 0 then dec(spal2[i][1]);
                  if spal2[i][2] > 0 then dec(spal2[i][2]);
             end;
          if keypressed then FreeAll;
     end;
     while Sync(23, 0) do
     begin
          FadeBlurTo0(2, VirSeg);
          solid^.SetOrigin(0, 0, z);
          i := 35 + random(10); j := 45 + random(10);
          DrawPicture(pic[0], 80, 32, YOffset[j] + i, 240, VirSeg);
          i := 195 + random(10); j := 45 + random(10);
          DrawPicture(pic[1], 80, 32, YOffset[j] + i, 240, VirSeg);
          i := 35 + random(10); j := 125 + random(10);
          DrawPicture(pic[2], 80, 32, YOffset[j] + i, 240, VirSeg);
          i := 195 + random(10); j := 125 + random(10);
          DrawPicture(pic[3], 80, 32, YOffset[j] + i, 240, VirSeg);
          solid^.Draw(VirSeg);
          CopyScreen(VirSeg, VGA);
          Setpalette(spal2);
          inc(k);
          if z > -1000 then dec(z, 30);
          solid^.Rotate(1, -1, 5);
          RotateLight(0, 0, 2);
          if (k mod 3) = 0 then
             for i := 0 to 255 do
             begin
                  if spal2[i][0] > 0 then dec(spal2[i][0]);
                  if spal2[i][1] > 0 then dec(spal2[i][1]);
                  if spal2[i][2] > 0 then dec(spal2[i][2]);
             end;
          if keypressed then FreeAll;
     end;
     dispose(texture);
     for i := 0 to 3 do freemem(pic[i], 2560);

     dispose(solid, Done);
     dispose(sphere, Done);
     ShutDownVirtual(VirScr);
end;


{ PARTE 7: Interrupcin }
procedure Part7;
var VirScr : PTVirtual;
    VirSeg, off : word;
    rz : PTRotoZoom;
    rzpic : PTTexture;
    pic : array[0..3] of pointer;
    ang : array[0..3] of integer;
    i, j : integer;
    pal1, pal2 : TPalette;
begin
     SetupVirtual(VirScr, VirSeg);
     rzpic := new(PTTexture);
     rz := new(PTRotoZoom, Init(rzpic, pal1));
     xms2base(HRotoPic[3], rzpic, 65536);
     rz^.ScaleUV(0.67, 1);
     rz^.Scale(32768);
     for i := 0 to 3 do
     begin
          getmem(pic[i], 2560);
          xms2base(HWordPic[i], pic[i], 2560);
          ang[i] := i * 90;
     end;
     GetPaletteXMS(6, pal1);
     for i := 0 to 31 do
     begin
          pal1[i][0] := i shl 1;
          pal1[i][1] := i shl 1;
          pal1[i][2] := i shl 1;
     end;
     fillchar(pal2, 768, 0);
     ClearScreen(0, VGA);
     SetPalette(pal2);
     i := 0;

     while Sync(23, 16) do
     begin
          rz^.Move(160 + cost[i] div 1024, 100 + sint[i] div 1024);
          rz^.DrawFull(VirSeg, 316, 198);
          off := YOffset[84 + sint[ang[0]] div 4096] +
                 120 + cost[ang[0]] div 4096;
          DrawPicture(pic[0], 80, 32, off, 240, VirSeg);
          off := YOffset[84 + sint[ang[1]] div 2048] +
                 120 + cost[ang[1]] div 2048;
          DrawPicture(pic[1], 80, 32, off, 240, VirSeg);
          off := YOffset[84 + sint[ang[2]] div 1024] +
                 120 + cost[ang[2]] div 1024;
          DrawPicture(pic[2], 80, 32, off, 240, VirSeg);
          off := YOffset[84 + sint[ang[3]] div 780] +
                 120 + cost[ang[3]] div 780;
          DrawPicture(pic[3], 80, 32, off, 240, VirSeg);
          CopyScreen(VirSeg, VGA);
          setpalette(pal2);

          rz^.Rotate(-1);
          rz^.Scale(65536 - cost[i] div 128);

          if i < 359 then inc(i) else i := 0;
          for j := 0 to 3 do
              if ang[j] < 359 then inc(ang[j]) else ang[j] := 0;

          for j := 0 to 255 do
          begin
               if pal2[j][0] < pal1[j][0] then inc(pal2[j][0]);
               if pal2[j][1] < pal1[j][1] then inc(pal2[j][1]);
               if pal2[j][2] < pal1[j][2] then inc(pal2[j][2]);
          end;
          if keypressed then FreeAll;
     end;

     while Sync(23, 32) do
     begin
          rz^.Move(160 + cost[i] div 1024, 100 + sint[i] div 1024);
          rz^.DrawFull(VirSeg, 316, 198);
          off := YOffset[84 + sint[ang[0]] div 4096] +
                 120 + cost[ang[0]] div 4096;
          DrawPicture(pic[0], 80, 32, off, 240, VirSeg);
          off := YOffset[84 + sint[ang[1]] div 2048] +
                 120 + cost[ang[1]] div 2048;
          DrawPicture(pic[1], 80, 32, off, 240, VirSeg);
          off := YOffset[84 + sint[ang[2]] div 1024] +
                 120 + cost[ang[2]] div 1024;
          DrawPicture(pic[2], 80, 32, off, 240, VirSeg);
          off := YOffset[84 + sint[ang[3]] div 780] +
                 120 + cost[ang[3]] div 780;
          DrawPicture(pic[3], 80, 32, off, 240, VirSeg);
          CopyScreen(VirSeg, VGA);
          setpalette(pal2);

          rz^.Rotate(-1);
          rz^.Scale(65536 - cost[i] div 128);

          if i < 359 then inc(i) else i := 0;
          for j := 0 to 3 do
              if ang[j] < 359 then inc(ang[j]) else ang[j] := 0;

          if (i mod 2) = 0 then
          for j := 0 to 31 do
          begin
               if pal2[j][1] > 0 then dec(pal2[j][1]);
               if pal2[j][2] > 0 then dec(pal2[j][2]);
          end;
          if keypressed then FreeAll;
     end;

     while Sync(23, 60) do
     begin
          rz^.Move(160 + cost[i] div 1024, 100 + sint[i] div 1024);
          rz^.DrawFull(VirSeg, 316, 198);
          off := YOffset[84 + sint[ang[0]] div 4096] +
                 120 + cost[ang[0]] div 4096;
          DrawPicture(pic[0], 80, 32, off, 240, VirSeg);
          off := YOffset[84 + sint[ang[1]] div 2048] +
                 120 + cost[ang[1]] div 2048;
          DrawPicture(pic[1], 80, 32, off, 240, VirSeg);
          off := YOffset[84 + sint[ang[2]] div 1024] +
                 120 + cost[ang[2]] div 1024;
          DrawPicture(pic[2], 80, 32, off, 240, VirSeg);
          off := YOffset[84 + sint[ang[3]] div 780] +
                 120 + cost[ang[3]] div 780;
          DrawPicture(pic[3], 80, 32, off, 240, VirSeg);
          CopyScreen(VirSeg, VGA);
          setpalette(pal2);

          rz^.Rotate(-1);
          rz^.Scale(65536 - cost[i] div 128);

          if i < 359 then inc(i) else i := 0;
          for j := 0 to 3 do
              if ang[j] < 359 then inc(ang[j]) else ang[j] := 0;

          if (i mod 2) = 0 then
          for j := 0 to 31 do
          begin
               if pal2[j][1] < (j shl 1) then inc(pal2[j][1]);
               if pal2[j][2] < (j shl 1) then inc(pal2[j][2]);
          end;
          if keypressed then FreeAll;
     end;

     while Sync(24, 0) do
     begin
          rz^.Move(160 + cost[i] div 1024, 100 + sint[i] div 1024);
          rz^.DrawFull(VirSeg, 316, 198);
          off := YOffset[84 + sint[ang[0]] div 4096] +
                 120 + cost[ang[0]] div 4096;
          DrawPicture(pic[0], 80, 32, off, 240, VirSeg);
          off := YOffset[84 + sint[ang[1]] div 2048] +
                 120 + cost[ang[1]] div 2048;
          DrawPicture(pic[1], 80, 32, off, 240, VirSeg);
          off := YOffset[84 + sint[ang[2]] div 1024] +
                 120 + cost[ang[2]] div 1024;
          DrawPicture(pic[2], 80, 32, off, 240, VirSeg);
          off := YOffset[84 + sint[ang[3]] div 780] +
                 120 + cost[ang[3]] div 780;
          DrawPicture(pic[3], 80, 32, off, 240, VirSeg);
          CopyScreen(VirSeg, VGA);
          setpalette(pal2);

          rz^.Rotate(-1);
          rz^.Scale(65536 - cost[i] div 128);

          if i < 359 then inc(i) else i := 0;
          for j := 0 to 3 do
              if ang[j] < 359 then inc(ang[j]) else ang[j] := 0;

          for j := 0 to 255 do
          begin
               if pal2[j][0] < 63 then inc(pal2[j][0]);
               if pal2[j][1] < 63 then inc(pal2[j][1]);
               if pal2[j][2] < 63 then inc(pal2[j][2]);
          end;
          if keypressed then FreeAll;
     end;

     ShutDownVirtual(VirScr);
     dispose(rzpic);
     dispose(rz);
     for i := 0 to 3 do freemem(pic[i], 2560);
end;


{ PART 8: Imgenes estticas }
procedure Part8;
var pal : array[1..5] of TPalette;
    temp : TPalette;
    VirScr : PTVirtual;
    VirSeg : word;
    p, r, x, y : word;
    i, j, k, l : integer;
begin
     SetupVirtual(VirScr, VirSeg);
     GetPaletteXMS(7, pal[2]);
     for i := 0 to 255 do
     begin
          pal[1][i][0] := 63 - pal[2][i][0];
          pal[1][i][1] := 63 - pal[2][i][1];
          pal[1][i][2] := 63 - pal[2][i][2];
     end;
     GetPaletteXMS(8, pal[3]);
     GetPaletteXMS(9, pal[4]);
     fillchar(pal[5], 768, 0);
     pal[5][128][0] := 63;
     pal[5][128][1] := 63;
     pal[5][128][2] := 63;

     p := 24;
     r := 2;

     i := 1;
     j := 5;
     while Sync(25, 48) do
     begin
          if ((r - 2) mod 8) = 0 then
          begin
               ClearScreen(0, VGA);
               SetPalette(pal[j]);
               xms2base(HStaticPic[j], ptr(VGA, 8), 64000);
               while Sync(p, r) do if keypressed then FreeAll;
               if j < 5 then inc(j) else j := 3;
               inc(r, 2);
               if r > 63 then
               begin
                    r := 0;
                    inc(p);
               end;
          end
          else
          begin
               ClearScreen(0, VGA);
               SetPalette(pal[i]);
               xms2base(HStaticPic[2], ptr(VGA, 8), 64000);
               while Sync(p, r) do if keypressed then FreeAll;
               i := 2 - (i - 1);
               inc(r, 2);
               if r > 63 then
               begin
                    r := 0;
                    inc(p);
               end;
          end;
     end;

     ClearScreen(0, VGA);
     SetPalette(pal[3]);
     xms2base(HStaticPic[3], VirScr, 64000);
     CopyScreen(VirSeg, VGA);
     temp := pal[3];
     k := 0;
     while Sync(26, 0) do
     begin
          SetPalette(temp);
          inc(k);
          if (k mod 4) = 0 then
          for l := 0 to 255 do
          begin
               if temp[l][0] > 0 then dec(temp[l][0]);
               if temp[l][1] > 0 then dec(temp[l][1]);
               if temp[l][2] > 0 then dec(temp[l][2]);
          end;
          if keypressed then FreeAll;
     end;

     k := 0;
     x := 0;
     y := 0;
     while Sync(26, 16) do
     begin
          Scale(x, y, 319, 199, VirSeg, 0, 0, 319, 199, VGA);
          SetPalette(temp);
          inc(k);
          if (((k mod 3) = 0) and (x < 160)) then inc(x, 4);
          if (((k mod 4) = 0) and (y < 100)) then inc(y, 4);
          if (k mod 2) = 0 then
          for l := 0 to 255 do
          begin
               if temp[l][0] < pal[3][l][0] then inc(temp[l][0]);
               if temp[l][1] < pal[3][l][1] then inc(temp[l][1]);
               if temp[l][2] < pal[3][l][2] then inc(temp[l][2]);
          end;
          if keypressed then FreeAll;
     end;

     while Sync(27, 0) do
     begin
          Scale(x, y, 319, 199, VirSeg, 0, 0, 319, 199, VGA);
          SetPalette(temp);
          inc(k);
          if (((k mod 3) = 0) and (x > 0)) then dec(x, 4);
          if (((k mod 4) = 0) and (y > 0)) then dec(y, 4);
          if (k mod 2) = 0 then
          for l := 0 to 255 do
          begin
               if temp[l][0] > 0 then dec(temp[l][0]);
               if temp[l][1] > 0 then dec(temp[l][1]);
               if temp[l][2] > 0 then dec(temp[l][2]);
          end;
          if keypressed then FreeAll;
     end;

     p := 27;
     r := 2;
     j := 5;
     while Sync(28, 48) do
     begin
          if ((r - 2) mod 8) = 0 then
          begin
               ClearScreen(0, VGA);
               SetPalette(pal[j]);
               xms2base(HStaticPic[j], ptr(VGA, 8), 64000);
               while Sync(p, r) do if keypressed then FreeAll;
               if j < 5 then inc(j) else j := 3;
               inc(r, 2);
               if r > 63 then
               begin
                    r := 0;
                    inc(p);
               end;
          end
          else
          begin
               ClearScreen(0, VGA);
               SetPalette(pal[i]);
               xms2base(HStaticPic[2], ptr(VGA, 8), 64000);
               while Sync(p, r) do if keypressed then FreeAll;
               i := 2 - (i - 1);
               inc(r, 2);
               if r > 63 then
               begin
                    r := 0;
                    inc(p);
               end;
          end;
     end;

     ClearScreen(0, VGA);
     SetPalette(pal[4]);
     xms2base(HStaticPic[4], VirScr, 64000);
     CopyScreen(VirSeg, VGA);
     temp := pal[4];
     k := 0;
     while Sync(29, 0) do
     begin
          SetPalette(temp);
          inc(k);
          if (k mod 4) = 0 then
          for l := 0 to 255 do
          begin
               if temp[l][0] > 0 then dec(temp[l][0]);
               if temp[l][1] > 0 then dec(temp[l][1]);
               if temp[l][2] > 0 then dec(temp[l][2]);
          end;
          if keypressed then FreeAll;
     end;

     ShutDownVirtual(VirScr);
end;


{ PARTE 9: Letrero con estela }
procedure Part9;
var VScr1, VScr2 : PTVirtual;
    VSeg1, VSeg2 : word;
    pal : TPalette;
    ix, iy : word;
    i : longint;
begin
     SetupVirtual(VScr1, VSeg1);
     SetupVirtual(VScr2, VSeg2);
     xms2base(HStaticPic[5], VScr2, 64000);
     for i := 0 to 127 do
     begin
          pal[i][0] := i shr 1;
          pal[i][1] := i shr 1;
          pal[i][2] := i shr 1;
     end;
     pal[128][0] := 63;
     pal[128][1] := 63;
     pal[128][2] := 63;
     ClearScreen(0, VGA);
     SetPalette(pal);
     i := 0;
     ix := 1;
     iy := 1;
     ClearScreen(0, VSeg1);

     while Sync(29, 32) do
     begin
          fadeblurto0(1, VSeg1);
          transscale(0, 0, 319, 199, VSeg2,
                     160 - ix, 100 - iy, 160 + ix, 100 + iy, VSeg1);
          CopyScreen(VSeg1, VGA);
          inc(i);
          if (i mod 5) = 0 then if ix < 159 then inc(ix);
          if (i mod 8) = 0 then if iy < 99 then inc(iy);
          if keypressed then FreeAll;
     end;

     while Sync(29, 60) do
     begin
          fadeblurto0(1, VSeg1);
          transscale(0, 0, 319, 199, VSeg2,
                     160 - ix, 100 - iy, 160 + ix, 100 + iy, VSeg1);
          CopyScreen(VSeg1, VGA);
          inc(i);
          if (i mod 5) = 0 then if ix > 1 then dec(ix);
          if (i mod 8) = 0 then if iy > 1 then dec(iy);
          if keypressed then FreeAll;
     end;

     while Sync(30, 0) do
     begin
          fadeblurto0(1, VSeg1);
          CopyScreen(VSeg1, VGA);
          if keypressed then FreeAll;
     end;

     ShutDownVirtual(VScr1);
     ShutDownVirtual(VScr2);
end;


{ MAIN PROGRAM }
begin
     InitAll;

     Part1;
     Part2;
     Part3;
     Part4;
     Part5;
     Part6;
     Part7;
     Part8;
     Part9;

     FreeAll;
end.
