//	plasmafx.cpp

#include "mymath.h"
#include "globals.h"
#include "plasmafx.h"


void GeneratePlasmaTable(byte *table, int type, double p1, double p2) {
	double a;
	for (int i = 0; i < 256; i++) {
                a = PI * i / 128.0;
		switch (type) {
                        case 1:  table[i] += p1 * fsin(a * p2); break;
                        case 2:  table[i] += p1 * fcos(a * p2); break;
                        case 3:  table[i] += p1 * fsin(a) * fsin(a * p2); break;
                        case 4:  table[i] += p1 * fcos(a) * fcos(a * p2); break;
                        case 5:  table[i] += p1 * fsin(a * p2) * fcos(a); break;
                        case 6:  table[i] += p1 * fsin(a) * fcos(a * p2); break;
                        case 7:  table[i] += p1 * fexp(-ffabs(p2 * (i - 128) / 128.0)); break;
                        case 8:  table[i] += p1 * flog(1 + ffabs(p2 * (i - 128) / 128.0)); break;
			case 9:  table[i] += p1; break;
			default: table[i] = 0;
		}
	}
}


void GeneratePlasma( TBitmap8bpp *dest, byte *table1, byte *table2,
                     byte t1, byte t2, byte t3, byte t4) {
	unsigned destofs = (unsigned)dest->datos;
	unsigned tbl1 = (unsigned)table1;
	unsigned tbl2 = (unsigned)table2;
	unsigned width = dest->ancho;
	unsigned height = dest->alto;
	byte p3, p4;
	_asm {
		mov edi, [destofs]
		mov esi, [tbl1]
		mov edx, [tbl2]
		xor ebx, ebx
		ylp:	mov ecx, [width]
				mov al, [t3]
				mov ah, [t4]
				mov [p3], al
				mov [p4], ah
		
		xlp:	mov bl, [t1]
				mov al, [esi + ebx]
				mov bl, [t2]
				add al, [esi + ebx]
				mov bl, [p3]
				add al, [esi + ebx]
				mov bl, [p4]
				add al, [esi + ebx]
				mov bl, cl
				add al, [edx + ebx]
				mov bl, byte ptr [height]
				add al, [edx + ebx]
				mov [edi], al
				inc edi
				
				add [p3], 2
				dec [p4]
				dec ecx
				jnz xlp
				
				inc [t1]
				sub [t2], 2
				dec [height]
				jnz ylp
	}
}
