//
//                       __      __      _  __ 
//                   .: (__ (__ (--) >-< ( (-_ :.
//
//
// (c) Copyright 1997 Mikko E. Mononen <memon@inside.org>
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <math.h>
#include <ctype.h>
#include "clax.h"
#include "ie.hh"
#include "globals.hh"
#include "material.hh"
#include "file_tga.hh"

c_SCENE*  world;

char*  tablePool;
char*  fadeTable;
char*  border;
char*  texts;
int    textHeight;  // text block height
int    textPos;     // text begins at line...


int
loadAnyTGA( char* file, char* buffer, char* palette )
{

  char       id[257];
  int        i;
  TGAheader  h;
  FILE       *fp;
  
  
  if ((fp = fopen( file, "rb" )) == 0 )
    return 0;
  
  if ( fread( &h, sizeof( TGAheader ), 1, fp ) == 0 )
    return 0;

  // skip over image identification field
  for ( i = 0; i < h.idSize; i++ )
    id[i] = (char)fgetc( fp );
  id[i] = 0;

  fseek( fp, (18 + h.idSize), SEEK_SET );
  if ( palette ) {
    for ( i = h.colorMapOrigin; i < (h.colorMapOrigin + h.colorMapLenght); i++ ) {
      palette[i * 3 + 2] = (char)(fgetc( fp ) >> 2);
      palette[i * 3 + 1] = (char)(fgetc( fp ) >> 2);
      palette[i * 3 + 0] = (char)(fgetc( fp ) >> 2);
    }
  }

  fseek( fp, (18 + h.idSize + (h.colorMapLenght) * 3), SEEK_SET );
  if ( buffer )
    for ( int y = h.height - 1; y >= 0; y-- )
      for ( int x = 0; x < h.width; x++ )
        buffer[x + y * h.width] = (char)fgetc( fp );
  
  fclose( fp );

  return 1;
}


inline
char*
align64k( char* buffer )
{
  return (char *)(((int)(buffer + 0xffff)) & ~0xffff);
}


void
calcFadeTable( char* palette)
{
  printf( " calculating fade table..." ); fflush( stdout );

  for ( int i = 0; i < 256; i++ ) {    // each color
    for ( int j = 0; j < 64; j++ ) {   // shades

      float  a = ((float)j / 63.0);

      int  r = (int)( (float)palette[i * 3] * (1.0 - a) );
      int  g = (int)( (float)palette[i * 3 + 1] * (1.0 - a) );
      int  b = (int)( (float)palette[i * 3 + 2] * (1.0 - a) );

      fadeTable[j * 256 + i] = bestMatch( r, g, b, palette );
    }
  }

  for ( i = 0; i < 256; i++ ) {    // each color
    for ( int j = 0; j < 64; j++ ) {   // shades

      float  a = ((float)j / 63.0);

      int  r = (int)( (float)palette[i * 3] * (1.0 - a)     + 63.0 * a );
      int  g = (int)( (float)palette[i * 3 + 1] * (1.0 - a) + 63.0 * a );
      int  b = (int)( (float)palette[i * 3 + 2] * (1.0 - a) + 63.0 * a );

      fadeTable[(j + 64) * 256 + i] = bestMatch( r, g, b, palette );
    }
  }

  printf( "done.\n" );  fflush( stdout );
}

int
saveFadeTable( char* filename )
{
  FILE*  fp;

  if ( (fp = fopen( filename, "wb" )) == 0 )
    return clax_err_badfile;

  fwrite( fadeTable, 256 * 128, 1, fp );
  fclose( fp );
  
  return clax_err_ok;
}

int
loadFadeTable( char* filename )
{
  FILE*  fp;

  if ( (fp = fopen( filename, "rb" )) == 0 )
    return clax_err_badfile;

  fread( fadeTable, 256 * 128, 1, fp );
  fclose( fp );

  return clax_err_ok;
}

int
initTables( int load, char* palette )
{
  border = new char [320 * 150];
  if ( border == 0 )
    return clax_err_nomem;

  texts = new char [320 * 480];
  if ( texts == 0 )
    return clax_err_nomem;

  tablePool = new char [2 * (256 * 256)];
  if ( tablePool == 0 )
    return clax_err_nomem;

  fadeTable = align64k( tablePool );

  if ( load != 0 ) {
    if ( loadFadeTable( "fade.tbl" ) != clax_err_ok )
      calcFadeTable( palette );
  } else {
    calcFadeTable( palette );
    saveFadeTable( "fade.tbl" );
  }
  
  return clax_err_ok;
}

void
closeTables()
{
  if ( tablePool )
    delete [] tablePool;

  if ( border )
    delete [] border;
 
  if ( texts )
    delete [] texts;
}


void
copyScreenShaded( char *dest, char *src, char* lut, long len );
#pragma aux copyScreenShaded = \
 "    push ebp            "\
 "    xor eax, eax        "\
 "    mov ebp, ebx        "\
 "    shr ecx, 2          "\
 " next:                  "\
 "    mov ebx, [esi]      "\
 "    mov edx, [edi]      "\
 "    mov ah, bl          "\
 "    mov al, dl          "\
 "    mov dl, [ebp+eax]   "\
 "    ror ebx, 8          "\
 "    ror edx, 8          "\
 "    mov ah, bl          "\
 "    mov al, dl          "\
 "    mov dl, [ebp+eax]   "\
 "    ror ebx, 8          "\
 "    ror edx, 8          "\
 "    mov ah, bl          "\
 "    mov al, dl          "\
 "    mov dl, [ebp+eax]   "\
 "    ror ebx, 8          "\
 "    ror edx, 8          "\
 "    mov ah, bl          "\
 "    mov al, dl          "\
 "    mov dl, [ebp+eax]   "\
 "    ror ebx, 8          "\
 "    ror edx, 8          "\
 "    mov [edi], edx      "\
 "    add esi, 4          "\
 "    add edi, 4          "\
 "    dec ecx             "\
 "    jnz next            "\
 "    pop ebp             "\
  parm [edi] [esi] [ebx] [ecx]  \
  modify exact [eax ecx esi ebx edi edx];


void
loadPalette( char* file, char* palette )
{
  // loads palette from pcx file

  FILE*  fp;
  if ( (fp = fopen( file, "rb" )) != 0 ) {
    fseek( fp, -(256 * 3), SEEK_END );
    fread( palette, 256 * 3, 1, fp );
    fclose( fp );
  }
  for ( int i = 0; i < 256; i++ ) {
    palette[i * 3] >>= 2;
    palette[i * 3 + 1] >>= 2;
    palette[i * 3 + 2] >>= 2;
  }
}


void
closeAction1()
{
  clax_free_world( world );
  clax_free_motion( world );
  closeIE();
}


int
openAction1( char** outBuffer, float* totalFrames, int* bgMask )
{
  // sets outBuffer, totalFrames, and bgMask

  c_OBJECT*  obj;
  w_NODE*    node;
  k_NODE*    kn;
  c_LIGHT*   lit;
  c_CAMERA*  cam;
  c_VECTOR   vec;
  c_OBJECT*  o1;
  int        err;
  int        i, j, x, y;
  float      frames, frame;
  

  IE_globals.fogColor.r = 0.5;
  IE_globals.fogColor.b = 1.0;
  IE_globals.fogColor.g = 0.5;
  IE_globals.fogEnabled = 0;    // fog not enabled
  IE_globals.maxZ = 20000.0;
  IE_globals.depthCue = (3.0 / 4.0) * IE_globals.maxZ;
  IE_globals.fogDepth = (1.0 / 2.0) * IE_globals.maxZ;

  // init clax
  clax_init( clax_hierarchy | clax_domorph | clax_calcnorm );
  clax_alloc_scene( &world );

  // load scene
  err = clax_load_world( "intro.3ds", world );
  if ( err != clax_err_ok )
    return err;
  err = clax_load_motion( "intro.3ds", world );
  if ( err != clax_err_ok )
    return err;
  clax_setactive_scene( world );

  // search and setup camera
  cam = 0;
  for ( node = world->world; node; node = node->next ) {
    if ( node->type == clax_obj_camera ) {
      cam = (c_CAMERA *)node->object;
      break;
    }
  }
  if ( cam == 0 )
    return clax_err_undefined;
//  printf( "Using camera: %s\n", cam->name );
  cam->sizeX = 320;
  cam->sizeY = 200;
  cam->aspectratio = 0.82;
  clax_setactive_camera( cam );

  // Initialise claxie
  err = initIE();
  if ( err != clax_err_ok )
    return err;

  if ( IE_globals.fogEnabled ) {
    char  c = bestMatch( IE_globals.fogColor.r * 62.5,
                         IE_globals.fogColor.g * 62.5,
                         IE_globals.fogColor.b * 62.5,
                         IE_globals.palette );
    *bgMask = (c << 24) | (c << 16) | (c << 8) | (c);
  } else
    *bgMask = 0;

  clax_getframes(&frame, &frames);
  *totalFrames = frames - frame;

  *outBuffer = IE_globals.outBuffer;

  // load faded border
  if ( !loadAnyTGA( "border.tga", border, 0 ) )
    return clax_err_badfile;
  for ( i = 0; i < (320 * 150); i++ ) {
    border[i] >>= 2;
    border[i] = 63 - border[i];
  }

  // load texts
  if ( !loadAnyTGA( "intro.tga", texts, 0 ) )
    return clax_err_badfile;
  for ( i = 0; i < (320 * 480); i++ ) {
    texts[i] >>= 2;
    texts[i] += 64;
  }
  textHeight = 68;
  textPos = 66;
  
  return clax_err_ok;
}


void
closeAction2()
{
  clax_free_world( world );
  clax_free_motion( world );
  closeIE();
}


int
openAction2( char** outBuffer, float* totalFrames, int* bgMask )
{
  // sets outBuffer, totalFrames, and bgMask

  c_OBJECT*  obj;
  w_NODE*    node;
  k_NODE*    kn;
  c_LIGHT*   lit;
  c_CAMERA*  cam;
  c_VECTOR   vec;
  c_OBJECT*  o1;
  int        err;
  int        i, j, x, y;
  float      frames, frame;
  

  IE_globals.fogColor.r = 0.5;
  IE_globals.fogColor.b = 1.0;
  IE_globals.fogColor.g = 0.5;
  IE_globals.fogEnabled = 0;    // fog not enabled
  IE_globals.maxZ = 1000.0;
  IE_globals.depthCue = (3.0 / 4.0) * IE_globals.maxZ;
  IE_globals.fogDepth = (1.0 / 2.0) * IE_globals.maxZ;

  // init clax
  clax_init( clax_hierarchy | clax_domorph | clax_calcnorm );
  clax_alloc_scene( &world );

  // load scene
  err = clax_load_world( "demo01.3ds", world );
  if ( err != clax_err_ok )
    return err;
  err = clax_load_motion( "demo01.3ds", world );
  if ( err != clax_err_ok )
    return err;
  clax_setactive_scene( world );

  // search and setup camera
  cam = 0;
  for ( node = world->world; node; node = node->next ) {
    if ( node->type == clax_obj_camera ) {
      cam = (c_CAMERA *)node->object;
      break;
    }
  }
  if ( cam == 0 )
    return clax_err_undefined;
//  printf( "Using camera: %s\n", cam->name );
  cam->sizeX = 320;
  cam->sizeY = 200;
  cam->aspectratio = 0.82;
  clax_setactive_camera( cam );

  // Initialise claxie
  err = initIE();
  if ( err != clax_err_ok )
    return err;

  if ( IE_globals.fogEnabled ) {
    char  c = bestMatch( IE_globals.fogColor.r * 62.5,
                         IE_globals.fogColor.g * 62.5,
                         IE_globals.fogColor.b * 62.5,
                         IE_globals.palette );
    *bgMask = (c << 24) | (c << 16) | (c << 8) | (c);
  } else
    *bgMask = 0;

  clax_getframes(&frame, &frames);
  *totalFrames = frames - frame;

  *outBuffer = IE_globals.outBuffer;

  // load faded border
  if ( !loadAnyTGA( "border.tga", border, 0 ) )
    return clax_err_badfile;
  for ( i = 0; i < (320 * 150); i++ ) {
    border[i] >>= 2;
    border[i] = 63 - border[i];
  }

  // load texts
  if ( !loadAnyTGA( "teksti.tga", texts, 0 ) )
    return clax_err_badfile;
  for ( i = 0; i < (320 * 480); i++ ) {
    texts[i] >>= 2;
    texts[i] += 64;
  }
  textHeight = 28;
  textPos = 168;
  
  return clax_err_ok;
}



void
renderFrame( float frame, int text )
{
    clax_setframe( frame );

    clax_update();
    transform();
    sort();
    processLights();
    drawPolys();

    // border fade
    char* borderPtr = border;
    char* outPtr = IE_globals.outBuffer + (15 * 320);
    copyScreenShaded( outPtr, borderPtr, fadeTable, 320 * 16 );
    outPtr += 320 * 16;
    borderPtr += 320 * 16;
    for ( int i = 0; i < 118; i++ ) {
      copyScreenShaded( outPtr, borderPtr, fadeTable, 16 );
      outPtr += 304;
      borderPtr += 304;
      copyScreenShaded( outPtr, borderPtr, fadeTable, 16 );
      outPtr += 16;
      borderPtr += 16;
    }
    copyScreenShaded( outPtr, borderPtr, fadeTable, 320 * 16 );
   
    // text
    outPtr = IE_globals.outBuffer + (textPos * 320);
    char*  textPtr = texts + (text * textHeight * 320);
    copyScreenShaded( outPtr, textPtr, fadeTable, 320 * textHeight );
}


void
putPic1()
{
  char*  out = (char *)0xa0000;
  loadAnyTGA( "vittupaa.tga", out, 0 );
}

void
putPic2()
{
  char*  out = (char *)0xa0000;
  loadAnyTGA( "vittupa2.tga", out, 0 );
}