//
//                       __      __      _  __ 
//                   .: (__ (__ (--) >-< ( (-_ :.
//
//
// (c) Copyright 1997 Mikko E. Mononen <memon@inside.org>
//

#ifndef __GLOBALS_HH__
#define __GLOBALS_HH__

#include "clax.h"

typedef struct {
  // shading tables
  char*   shadeTable;
  char*   fogTable;
  c_RGB   fogColor;

  // Palette
  char*   palette;

  // Double buffer
  char*   outBuffer;
  int     outBufferWidth;

  // All textures are here
  char*   texturePool;

  // Clipping window
  float   clipLeft, clipRight, clipTop, clipBottom;

  float   maxZ;
  float   depthCue;
  float   fogDepth;
  int     fogEnabled;

} Globals;

// Globals globals.. ;)
extern Globals  IE_globals;


int    initGlobals();
void   freeGlobals();

char*  initTexturePool( int poolSize );
char*  initOutBuffer( int width, int height );
void   setPalette( char* palette );

#endif