//
//                       __      __      _  __ 
//                   .: (__ (__ (--) >-< ( (-_ :.
//
//
// (c) Copyright 1997 Mikko E. Mononen <memon@inside.org>
//

#include <string.h>
#include "clax.h"
#include "globals.hh"

Globals   IE_globals;


int
initGlobals()
{
  IE_globals.palette = new char [256 * 3];
  if ( IE_globals.palette == 0 )
    return clax_err_nomem;

  IE_globals.shadeTable = new char [256 * 64];
  if ( IE_globals.shadeTable == 0 ) {
    freeGlobals();
    return clax_err_nomem;
  }

  IE_globals.fogTable = new char [256 * 64];
  if ( IE_globals.fogTable == 0 ) {
    freeGlobals();
    return clax_err_nomem;
  }

  return clax_err_ok;
}

char*
initOutBuffer( int width, int height )
{
  IE_globals.outBuffer = new char [width * height];
  IE_globals.outBufferWidth = width;
  return IE_globals.outBuffer;
}

char*
initTexturePool( int poolSize )
{
  IE_globals.texturePool = new char [poolSize];  
  return IE_globals.texturePool;
}

void
setGlobalPalette( char* palette )
{
  memcpy( IE_globals.palette, palette, 256 * 3 );
}

void
freeGlobals()
{
  if ( IE_globals.texturePool )
    delete [] IE_globals.texturePool;

  if ( IE_globals.shadeTable )
    delete [] IE_globals.shadeTable;

  if ( IE_globals.fogTable )
    delete [] IE_globals.fogTable;

  if ( IE_globals.palette )
    delete [] IE_globals.palette;
}