/* 256x256x32bits TEXTURE GENERATOR
 * filters routines - optimized for size
 * code by dake/calodox - July 99
 */

#define uchar unsigned char 

 #include "nmldec.h"
 #include "nmlflt.h"
#include "nmlgen.h"
 #include "savehead.h"

/*************************************************************************/
 void NML_FILTBLUR(uchar *source)
      {
       unsigned int c[3],u,i;

       for (i=0;i<256*256;i++)
           {
           for (u=0;u<3;u++)
               {
               int left, right, up, down;

               left=i-1;
               right=i+1;
               up=i-256;
               down=i+256;

               left&=65535;
               right&=65535;
               up&=65535;
               down&=65535;

               c[u]=source[(left<<2)+u];
               c[u]+=source[(right<<2)+u];
               c[u]+=source[(up<<2)+u];
               c[u]+=source[(down<<2)+u];
               c[u]>>=2;
               source[(i<<2)+u]=c[u];
               }
           }
        }
/***************************************************************************/

 void NML_FILTSHARPEN(uchar *source)
      {
       int c[3],u,i;

       for (i=0;i<256*256;i++)
           {
           for (u=0;u<3;u++)
               {
               int left, right, up, down;

               left=i-1;
               right=i+1;
               up=i-256;
               down=i+256;

               left&=65535;
               right&=65535;
               up&=65535;
               down&=65535;

                 c[u]=-source[(left<<2)+u];
                 c[u]-=source[(right<<2)+u];
                 c[u]-=source[(up<<2)+u];
                 c[u]-=source[(down<<2)+u];
                 c[u]+=(source[i<<2]<<3);
		 c[u]>>=2;
		 if (c[u]<0) c[u]=0;
		 if (c[u]>255) c[u]=255;

               source[(i<<2)+u]=c[u];
               }
           }
        }
/***************************************************************************/

 void NML_FILTSTRIPES(uchar *source, uchar *dest)
     {
     int i;
      for (i=0;i<256*256;i++)
          {
          int tempi, x,y;

          x=NMLRND_find(256)-128;
          x>>=4;
          y=NMLRND_find(256)-128;
          y>>=4;
          y<<=8;

          tempi=(x+i+y)&65535;
          tempi<<=2;

          dest[(i<<2)]=source[tempi];
          dest[(i<<2)+1]=source[tempi+1];
          dest[(i<<2)+2]=source[tempi+2];
	 }
     }

/***************************************************************************/

void NML_FILTCONTOUR(uchar *source, uchar *dest)
    {
    int c[3],u,i;

     for (i=0;i<256*256;i++)
         {
           for (u=0;u<3;u++)
               {
               int left, right, up, down;
               int p[10];

                left=i-1;
                right=i+1;
                up=i-256;
                down=i+256;

                p[0]=source[(((i-256-1)&65535)<<2)+u];
                p[1]=source[(((i-256)&65535)<<2)+u];
                p[2]=source[(((i-256+1)&65535)<<2)+u];
                p[3]=source[(((i-1)&65535)<<2)+u];
                p[4]=source[(((i)&65535)<<2)+u];
                p[5]=source[(((i+1)&65535)<<2)+u];
                p[6]=source[(((i+256-1)&65535)<<2)+u];
                p[7]=source[(((i+256)&65535)<<2)+u];
                p[8]=source[(((i+256+1)&65535)<<2)+u];

                c[u]=-p[1];
                c[u]-=p[3];
                c[u]-=p[5];
                c[u]-=p[7];
                c[u]+=(p[4]<<2);
		c[u]<<=4;
		 
                if (c[u]<0) c[u]=0;
                if (c[u]>255) c[u]=255;

                dest[(i<<2)+u]=c[u];
                }
            }
        }

/***************************************************************************/

   void NML_FILTEMBOSS(uchar *source, uchar *dest)
       {
       int c[3],u,i;

       for (i=0;i<256*256;i++)
           {
           for (u=0;u<3;u++)
               {
               int left, right, up, down;
               int p[10];

                left=i-1;
                right=i+1;
                up=i-256;
                down=i+256;

                p[0]=source[(((i-256-1)&65535)<<2)+u];
                p[1]=source[(((i-256)&65535)<<2)+u];
                p[2]=source[(((i-256+1)&65535)<<2)+u];
                p[3]=source[(((i-1)&65535)<<2)+u];
                p[4]=source[(((i)&65535)<<2)+u];
                p[5]=source[(((i+1)&65535)<<2)+u];
                p[6]=source[(((i+256-1)&65535)<<2)+u];
                p[7]=source[(((i+256)&65535)<<2)+u];
                p[8]=source[(((i+256+1)&65535)<<2)+u];

                c[u]=p[0]*3 + p[1]*2 + p[3]*2 +p[4];
                c[u]-=p[5]*2;
                c[u]-=p[7]*2;
                c[u]-=p[8]*3;
		 
                c[u]>>=2;
                if (c[u]<0) c[u]=0;
                if (c[u]>255) c[u]=255;

                dest[(i<<2)+u]=c[u];
               }
          }       
      }






