#ifndef	_D_REGISTRY_H
#define	_D_REGISTRY_H

typedef signed int SINT;
typedef unsigned int UINT;

//****************************************************************************************************
class	CRegistry
{
public:
	// Pass machine=TRUE for HKEY_LOCAL_MACHINE, otherwise get HKEY_CURRENT_USER
	 CRegistry( const char* product_name , BOOL machine = FALSE );
	 ~CRegistry();

	 SINT		GetInt( const char* name , SINT def = 0 );
	 void		SetInt( const char* name , SINT value );
	 void		GetString( const char* name , char* buffer , const char* def = "" , UINT buffer_len = 256 );
	 void		SetString( const char* name , char* value );
	 void		GetBinary( const char* name , char* buffer , const char* def , UINT );
	 void		SetBinary( const char* name , char* value , UINT );

	 GUID		GetGUID( const char* name , const GUID& def = GUID_NULL );
	 void		SetGUID( const char* name , const GUID& value );

protected:
	char	mKeyName[256];
	HKEY	mRootKey;

private:
	CRegistry( const CRegistry& );
	CRegistry	operator=( const CRegistry& );	
};

//****************************************************************************************************
#endif