#include "common.h"
#include "demo.h"

inline int CLIP(int i)
{
	return (i<0)?0:(i>255)?255:i;
}



inline int FADECOL(int c, float fc)
{	
	return (c&0xff000000)| (int((c&0xff)*fc)&0xff) | (int((c&0xff00)*fc)&0xff00) | (int((c&0xff0000)*fc)&0xff0000);
}


struct MatStub
{
	char name[32];
	char tex[64];
	float shiny,shinystrength;
	FVector amb,diff,spec;
	CTexture *tx;
};


struct LgtPos
{
	int flag;
	FMatrix axes;
	FVector posn;
	FVector col;
	float intens;
};

struct CamPos
{
	int flag;
	FMatrix axes;
	FVector posn;
	float fov,scf;
};

struct ObjPos
{
	int flag;
	FMatrix axes;
	FVector posn;
};



struct LgtStub
{
	char name[32];
	int type;

	LgtPos *pos,ipos;
	FVector rposn;	// temp space 

	void Draw(CamPos *c, BOOL flip=TRUE);	
	
};


struct CamStub
{
	char name[32];

	CamPos *pos,ipos;	

	
};

void LgtStub::Draw(CamPos *c, BOOL flip)
{
	/*
	FVector psn;
	if (flip)
	{		
		psn= c->axes.Transpose() * (ipos.posn-c->posn);
		psn.Z=-psn.Z;psn.Y=-psn.Y;
	}
	else
	{		
		psn= c->axes * (ipos.posn-c->posn);		
		
	}
	
	if (psn.Z>MINZ)
	{
		float fc=ipos.intens;if (fc>1) fc=1;
		int col=FADECOL(RGB_MAKE(int(ipos.col.R*255),int(ipos.col.G*255),int(ipos.col.B*255)),fc);

		float sz=25*ipos.intens;
		
		int a1=flare[0]->AddVertex(psn.X-sz,psn.Y-sz,psn.Z, 0,0, col);
		int a2=flare[0]->AddVertex(psn.X+sz,psn.Y-sz,psn.Z, 1,0, col);
		int a3=flare[0]->AddVertex(psn.X+sz,psn.Y+sz,psn.Z, 1,1, col);
		int a4=flare[0]->AddVertex(psn.X-sz,psn.Y+sz,psn.Z, 0,1, col);
		flare[0]->AddTri(a1,a2,a3);
		flare[0]->AddTri(a3,a4,a1);
		flare[0]->Draw();
	}
	*/
}

struct ObjV
{
	FVector p,op;
	FVector rp;	
};

struct ObjTV
{
	float u,v;
	int sm;
	FVector n;
	ObjV *vv;
	int idx,idx2;
	int col;
};

struct ObjF
{
	ObjV *a,*b,*c;
	ObjTV *ta,*tb,*tc;
	MatStub *m;
	CTexture *tx;
};

struct ObjStub
{
	char name[32];
	FVector min,max;
	ObjStub *parent,*child,*sibling;
	int hidden;

	int numv,numtv,numf;
	ObjV *v;
	ObjTV *tv;
	ObjF *f;

	ObjPos *pos,ipos;

	void Draw(CamPos *c, BOOL flip=TRUE);	
	void Drawflare(CamPos *c, FVector centre,float rad, BOOL flip=TRUE, BOOL flip2=FALSE);

	void Sub(ObjStub *b)
	{
		for (int c1=0;c1<numv;c1++) v[c1].op-=b->v[c1].op;
	}
	void Add1(ObjStub *b,float sc)
	{
		for (int c1=0;c1<numv;c1++) v[c1].p=v[c1].op+b->v[c1].op*sc;
	}
	void Add2(ObjStub *b,float sc)
	{
		for (int c1=0;c1<numv;c1++) v[c1].p=v[c1].p+b->v[c1].op*sc;
	}
};

void ObjStub::Draw(CamPos *c, BOOL flip)
{
	int c1;
	ObjV *vv=v;
	if (hidden) return;
	

	if (flip)
	{
		FMatrix axs=  c->axes.Transpose() * ipos.axes;
		FVector psn= c->axes.Transpose() * (ipos.posn-c->posn);
		for (c1=0;c1<numv;c1++) 
		{
			vv->rp= (axs*vv->p)+psn;			
			vv->rp.Z=-vv->rp.Z;	vv->rp.Y=-vv->rp.Y;
			vv->rp.X*=c->scf;
			vv->rp.Y*=c->scf;
			vv++;
		}
	}
	else
	{
		FMatrix axs=  c->axes * ipos.axes;
		FVector psn= c->axes * (ipos.posn-c->posn);
		for (c1=0;c1<numv;c1++) 
		{
			vv->rp= (axs*vv->p)+psn;
			vv->rp.X*=c->scf;
			vv->rp.Y*=c->scf;
			vv++;
		}
	}
	ObjTV *tvv=tv;
	for (c1=0;c1<numtv;c1++,tvv++) 
	{
		//FVector col=tvv->n*0.5+FVector(0.5,0.5,0.5);		
		tvv->idx=0x8000;
	}
	ObjF *ff=f;
	int aa,bb,cc;
	for (c1=0;c1<numf;c1++,ff++) 
	{
		if (ff->ta->idx!=0x8000) aa=ff->ta->idx; else aa=ff->ta->idx=ff->tx->AddVertex(ff->a->rp.X,ff->a->rp.Y,ff->a->rp.Z,ff->ta->u,ff->ta->v,ff->ta->col);
		if (ff->tb->idx!=0x8000) bb=ff->tb->idx; else bb=ff->tb->idx=ff->tx->AddVertex(ff->b->rp.X,ff->b->rp.Y,ff->b->rp.Z,ff->tb->u,ff->tb->v,ff->tb->col);
		if (ff->tc->idx!=0x8000) cc=ff->tc->idx; else cc=ff->tc->idx=ff->tx->AddVertex(ff->c->rp.X,ff->c->rp.Y,ff->c->rp.Z,ff->tc->u,ff->tc->v,ff->tc->col);
		ff->tx->AddTri(bb,aa,cc);
	}
	CTexture::DrawAll();

}


void ObjStub::Drawflare(CamPos *c, FVector centre,float rad, BOOL flip, BOOL flip2)
{
	float fc=(rad-1);
	if (fc<0) return;
	if (fc>1) fc=1;
	fc*=0.1;
	if (!flip2) rad=-rad*0.05;
	if (flip)
	{
		FMatrix axs=  c->axes.Transpose() * ipos.axes;
		FVector psn= c->axes.Transpose() * (ipos.posn-c->posn);
		centre= (axs*centre)+psn;			
		centre.Z=-centre.Z;
		centre.Y=-centre.Y;		
		centre.Z*=c->scf;
		centre.Y*=c->scf;
	}
	else
	{
		FMatrix axs=  c->axes * ipos.axes;
		FVector psn= c->axes * (ipos.posn-c->posn);
		centre= (axs*centre)+psn;			
		
	}
	ObjTV *tvv=tv;
	for (int c1=0;c1<numtv;c1++,tvv++) 
	{		
		tvv->idx=0x8000;
	}
	ObjF *ff=f;
	int aa,bb,cc,dd,ee,gg;	
	FVector pp;
	
	for (c1=0;c1<numf;c1++,ff++) 
	{
		
		if (ff->ta->idx!=0x8000) aa=ff->ta->idx; else aa=ff->ta->idx=ff->tx->AddVertex(ff->a->rp.X,ff->a->rp.Y,ff->a->rp.Z,ff->ta->u,ff->ta->v,FADECOL(ff->ta->col,fc));
		if (ff->tb->idx!=0x8000) bb=ff->tb->idx; else bb=ff->tb->idx=ff->tx->AddVertex(ff->b->rp.X,ff->b->rp.Y,ff->b->rp.Z,ff->tb->u,ff->tb->v,FADECOL(ff->tb->col,fc));
		if (ff->tc->idx!=0x8000) cc=ff->tc->idx; else cc=ff->tc->idx=ff->tx->AddVertex(ff->c->rp.X,ff->c->rp.Y,ff->c->rp.Z,ff->tc->u,ff->tc->v,FADECOL(ff->tc->col,fc));

		pp=centre+(ff->a->rp-centre)*rad;if (ff->ta->idx2!=0x8000) dd=ff->ta->idx2=ff->tx->AddVertex(pp.X,pp.Y,pp.Z,ff->ta->u,ff->ta->v,0);
		pp=centre+(ff->b->rp-centre)*rad;if (ff->tb->idx2!=0x8000) ee=ff->tb->idx2=ff->tx->AddVertex(pp.X,pp.Y,pp.Z,ff->tb->u,ff->tb->v,0);
		pp=centre+(ff->c->rp-centre)*rad;if (ff->tc->idx2!=0x8000) gg=ff->tc->idx2=ff->tx->AddVertex(pp.X,pp.Y,pp.Z,ff->tc->u,ff->tc->v,0);
		
		ff->tx->AddTri(bb,aa,dd);
		ff->tx->AddTri(dd,ee,bb);
		
		ff->tx->AddTri(aa,cc,gg);
		ff->tx->AddTri(gg,dd,aa);
		
		ff->tx->AddTri(cc,bb,ee);
		ff->tx->AddTri(ee,gg,cc);
		
		ff->tx->AddTri(bb,aa,cc);
			
	}
	CTexture::DrawAll();
}

struct Scn
{
	int nummat,numlgt,numcam,numobj;
	int tstart,tstop,tkeyfr;

	ObjStub *obj;
	CamStub *cam;
	MatStub *mat;
	LgtStub *lgt;

	void LoadScene(char *fname);
	void Interpolate(float t, int loop=1);
	LgtStub *Findlgt(char *name)
	{
		for (int c1=0;c1<numlgt;c1++) if (strnicmp(lgt[c1].name,name,strlen(name))==0) return lgt+c1;
		return NULL;
	}

	ObjStub *Findobj(char *name)
	{
		for (int c1=0;c1<numobj;c1++) if (strnicmp(obj[c1].name,name,strlen(name))==0) return obj+c1;
		return NULL;
	}

	void Draw(CamPos *c, BOOL flip=TRUE)
	{
		for (int c1=0;c1<numobj;c1++) obj[c1].Draw(c,flip);
	}
	void DrawL(CamPos *c, BOOL flip=TRUE)
	{
		for (int c1=0;c1<numlgt;c1++) lgt[c1].Draw(c,flip);
	}
	void Light(float shade=1);
};

void Scn::Light(float shade)
{
	int c1,c2,c3,alpha;
	for (c1=0;c1<numobj;c1++)
	{

		ObjStub *o=obj+c1;
		if (o->hidden) continue;
		ObjTV *tv=o->tv;
		LgtStub *l;
		for (l=lgt,c3=0;c3<numlgt;c3++,l++)
		{
			l->rposn= o->ipos.axes.Transpose() * (l->ipos.posn- o->ipos.posn);
		}
		alpha=255;
		if (o->f->tx==GOURAUD) alpha=128;
		for (c2=0;c2<o->numtv;c2++,tv++)
		{
			FVector col(0,0,0);
			

			for (l=lgt,c3=0;c3<numlgt;c3++,l++)			
			{
				FVector moo=(l->rposn-tv->vv->p);				
				float d= tv->n * moo / moo.MagnitudeSq();
				if (d<0) d=0;
				d*= (l->ipos.intens);				
				if (l->type==1)
				{
					FVector cow=o->ipos.axes.Transpose() * l->ipos.axes.Row[2] ;cow.Normalise();
					float sp=(moo * cow);
					//sp=fabs(sp);
					if (sp<=0) d=0; else
					{

						sp= (sp / moo.Magnitude());
						d*=sp*sp*sp*10;
					}
				}
				col+=l->ipos.col*d*10000.f*shade;
			}
			
			tv->col=(CLIP(col.R)<<16)|(CLIP(col.G)<<8)|(CLIP(col.B)<<0)|(CLIP(alpha)<<24);

		}
	}
}

void Scn::Interpolate(float t, int loop)
{
	if (t<0) t=0;
	if (loop==23)
	{
		if (t>tkeyfr-1) t=(tkeyfr-1)*2-t;
		if (t<0) t=0;
	} else
	if (!loop && t>tkeyfr-1) t=tkeyfr-1;
	
	int t1=int(t)%tkeyfr;
	int t2=(t1+1)%tkeyfr;
	t-=int(t);
	int c1;
	
	for (c1=0;c1<numcam;c1++)
	{
		CamStub *c=cam+c1;
		if (!(c->pos[t2].flag&4)) // interpolate position
		{
			c->ipos.axes= c->pos[t1].axes;
			c->ipos.posn= c->pos[t1].posn;
		} else {
			c->ipos.axes= c->pos[t1].axes*(1-t)+c->pos[t2].axes*(t);								
			c->ipos.posn= c->pos[t1].posn*(1-t)+c->pos[t2].posn*(t);
			//c->ipos.axes.Normalise();
		}
		if (!(c->pos[t2].flag&2)) // interpolate fov
		{
			c->ipos.fov= c->pos[t1].fov;			
			c->ipos.scf=1/tan(c->ipos.fov/2);
		} else {
			c->ipos.fov= c->pos[t1].fov * (1-t) + c->pos[t2].fov *t;
			c->ipos.scf=1/tan(c->ipos.fov/2);
		}
	}

	for (c1=0;c1<numlgt;c1++)
	{
		LgtStub *c=lgt+c1;
		if (!(c->pos[t2].flag&4)) // interpolate position
		{
			c->ipos.axes= c->pos[t1].axes;
			c->ipos.posn= c->pos[t1].posn;
		} else {
			c->ipos.axes= c->pos[t1].axes*(1-t)+c->pos[t2].axes*(t);								
			c->ipos.posn= c->pos[t1].posn*(1-t)+c->pos[t2].posn*(t);
			//c->ipos.axes.Normalise();
		}
		if (!(c->pos[t2].flag&2)) // interpolate col
		{
			c->ipos.col= c->pos[t1].col;			
		} else {
			c->ipos.col= c->pos[t1].col * (1-t) + c->pos[t2].col * t;
		}
		if (!(c->pos[t2].flag&2)) // interpolate intens
		{
			c->ipos.intens= c->pos[t1].intens;			
		} else {
			c->ipos.intens= c->pos[t1].intens * (1-t) + c->pos[t2].intens * t;
		}
	}

	for (c1=0;c1<numobj;c1++)
	{
		ObjStub *c=obj+c1;
		if (!(c->pos[t2].flag&4)) // interpolate position
		{
			t1=0;
			c->ipos.axes= c->pos[t1].axes;
			c->ipos.posn= c->pos[t1].posn;
		} else {
			c->ipos.axes= c->pos[t1].axes*(1-t)+c->pos[t2].axes*(t);								
			c->ipos.posn= c->pos[t1].posn*(1-t)+c->pos[t2].posn*(t);
			
			//c->ipos.axes.Normalise();
		}
	}

}


void Scn::LoadScene(char *fname)
{
	FILE_ f;
	f.open(fname);

	f.read(&nummat,4);
	f.read(&numlgt,4);
	f.read(&numcam,4);
	f.read(&numobj,4);
	f.read(&tstart,4);
	f.read(&tstop,4);
	f.read(&tkeyfr,4);

	
	

	int c1,c2,c3;

	mat=new MatStub[nummat];
	for (c1=0;c1<nummat;c1++)
	{
		f.read(&mat[c1].name,32);
		f.read(&mat[c1].tex,64);
		f.read(&mat[c1].shiny,4);
		f.read(&mat[c1].shinystrength,4);
		f.read(&mat[c1].amb,3*4);
		f.read(&mat[c1].diff,3*4);
		f.read(&mat[c1].spec,3*4);
	}
	
	lgt=new LgtStub[numlgt];
	for (c1=0;c1<numlgt;c1++)
	{
		f.read(&lgt[c1].name,32);
		f.read(&lgt[c1].type,4);
		lgt[c1].pos=new LgtPos[tkeyfr];
	}

	cam=new CamStub[numcam];
	for (c1=0;c1<numcam;c1++)
	{
		f.read(&cam[c1].name,32);
		cam[c1].pos=new CamPos[tkeyfr];
	}


	obj=new ObjStub[numobj];
	for (c1=0;c1<numobj;c1++)
	{
		obj[c1].hidden=0;
		f.read(&obj[c1].min,12);
		f.read(&obj[c1].max,12);
		f.read(&c2,4);obj[c1].parent=c2<0?NULL:obj+c2;
		f.read(&c2,4);obj[c1].child=c2<0?NULL:obj+c2;
		f.read(&c2,4);obj[c1].sibling=c2<0?NULL:obj+c2;
		f.read(&obj[c1].name,32);
		f.read(&obj[c1].numv,4);
		f.read(&obj[c1].numtv,4);
		f.read(&obj[c1].numf,4);

		obj[c1].v=new ObjV[obj[c1].numv];
		obj[c1].tv=new ObjTV[obj[c1].numtv];
		obj[c1].f=new ObjF[obj[c1].numf];
		obj[c1].pos=new ObjPos[tkeyfr];

		for (c2=0;c2<obj[c1].numv;c2++)
		{
			f.read(&obj[c1].v[c2].p,12);obj[c1].v[c2].op=obj[c1].v[c2].p;
		}
		for (c2=0;c2<obj[c1].numtv;c2++)
		{
			f.read(&obj[c1].tv[c2].u,4);
			f.read(&obj[c1].tv[c2].v,4);obj[c1].tv[c2].v=1-obj[c1].tv[c2].v;
			f.read(&obj[c1].tv[c2].sm,4);
			f.read(&obj[c1].tv[c2].n,12);
			obj[c1].tv[c2].col=0x20202020;
			f.read(&c3,4);
		}
		for (c2=0;c2<obj[c1].numf;c2++)
		{
			f.read(&c3,4);obj[c1].f[c2].a=obj[c1].v+c3;
			f.read(&c3,4);obj[c1].f[c2].b=obj[c1].v+c3;
			f.read(&c3,4);obj[c1].f[c2].c=obj[c1].v+c3;
			f.read(&c3,4);obj[c1].f[c2].ta=obj[c1].tv+c3;obj[c1].f[c2].ta->vv=obj[c1].f[c2].a;
			f.read(&c3,4);obj[c1].f[c2].tb=obj[c1].tv+c3;obj[c1].f[c2].tb->vv=obj[c1].f[c2].b;
			f.read(&c3,4);obj[c1].f[c2].tc=obj[c1].tv+c3;obj[c1].f[c2].tc->vv=obj[c1].f[c2].c;
			f.read(&c3,4);obj[c1].f[c2].m=mat+c3;			
			obj[c1].f[c2].tx=GOURAUD;
		}		
	}
	//{	char ss[24];	sprintf(ss,"%d %d\n",tkeyfr,numobj);	MessageBox(NULL,ss,ss,MB_OK);	}

	
	for (int t=0;t<tkeyfr;t++)
	{
		//{	char ss[24];	sprintf(ss,"%d %d\n",t,numobj);	MessageBox(NULL,ss,ss,MB_OK);	}
		// lights 
		if (t) 
		{
			for (int c3=0;c3<numlgt;c3++) 
			{
				LgtStub *o=lgt+c3;
				memcpy(&o->pos[t],&o->pos[t-1],sizeof(LgtPos));
			}
		}
		do
		{
			f.read(&c3,4);if (c3==-1) break;
			//if (c3>=numlgt) MessageBox(NULL,"error lgt","",MB_OK);

			LgtStub *o=lgt+c3;			
			f.read(&c3,4);
			o->pos[t].flag=c3;
			if (c3&1)
			{
				f.read(&o->pos[t].col,3*4);
			}
			if (c3&2)
			{
				f.read(&o->pos[t].intens,4);
			}
			if (c3&4)
			{
				f.read(&o->pos[t].axes,9*4);o->pos[t].axes.TransposeInPlace();
				f.read(&o->pos[t].posn,3*4);
			}			
		} while (1);

		// cameras

		if (t) 
		{
			for (int c3=0;c3<numcam;c3++) 
			{
				CamStub *o=cam+c3;
				memcpy(&o->pos[t],&o->pos[t-1],sizeof(CamPos));
			}
		}
		do
		{
			f.read(&c3,4);if (c3==-1) break;
			//if (c3>=numcam) MessageBox(NULL,"error cam","",MB_OK);
			CamStub *o=cam+c3;
			if (t) memcpy(&o->pos[t],&o->pos[t-1],sizeof(CamPos));
			f.read(&c3,4);	
			o->pos[t].flag=c3;
			if (c3&2)
			{
				f.read(&o->pos[t].fov,4);
			}
			if (c3&4)
			{
				f.read(&o->pos[t].axes,9*4);o->pos[t].axes.TransposeInPlace();
				f.read(&o->pos[t].posn,3*4);
			}			
		} while (1);

		// objects

		if (t) 
		{
			for (int c3=0;c3<numobj;c3++) 
			{
				ObjStub *o=obj+c3;
				memcpy(&o->pos[t],&o->pos[t-1],sizeof(ObjPos));
			}
		}
		do
		{
			f.read(&c3,4);if (c3==-1) break;
			//if (c3>=numobj) MessageBox(NULL,"error obj","",MB_OK);
			ObjStub *o=obj+c3;
			if (t) memcpy(&o->pos[t],&o->pos[t-1],sizeof(ObjPos));
			f.read(&c3,4);	
			o->pos[t].flag=c3;
			if (c3&4)
			{
				f.read(&o->pos[t].axes,9*4);o->pos[t].axes.TransposeInPlace();
				f.read(&o->pos[t].posn,3*4);
			}			
		} while (1);

	}
	
	//{	char ss[24];	sprintf(ss,"oh ! %d %d\n",tkeyfr,numobj);	MessageBox(NULL,ss,ss,MB_OK);	}

	f.close();
}

CTexture *LoadGreyAlphaTex(char *fname, int c=0)
{
	CTexture *mytex=new CTexture();
	DDPIXELFORMAT *pf;
	mytex->GetNicePixelFormat(16,4,&pf);
	if (!pf) mytex->GetNicePixelFormat(16,1,&pf);
	if (!pf) mytex->GetNicePixelFormat(16,0,&pf);
	mytex->Alloc(pf,256,256);
	int rb=countbits(pf->dwRBitMask),ro=countzeros(pf->dwRBitMask);
	int gb=countbits(pf->dwGBitMask),go=countzeros(pf->dwGBitMask);
	int bb=countbits(pf->dwBBitMask),bo=countzeros(pf->dwBBitMask);
	int ab=countbits(pf->dwRGBAlphaBitMask),ao=countzeros(pf->dwRGBAlphaBitMask);
	c=(( RGB_GETRED(c)<<rb)/256<<ro)|((RGB_GETGREEN(c)<<gb)/256<<go)|((RGB_GETBLUE(c)<<bb)/256<<bo);
	int pitch;
	UWORD *out;
	if ((out=mytex->Lock(&pitch))!=NULL)
	{
		TRACE("load bw locked texture %x %d\n%d %d\n",out,pitch,ab,ao);		
		FILE_ file;
		file.open(fname);
		unsigned char *temp=new unsigned char[65536];
		unsigned char *src=temp;
		file.read((char*)temp,65536);				
		int c2;
		for (int y=0;y<256;y++) 
		for (int x=0;x<256;x++) 
		{
			c2=*src++;						
			(out+pitch*y)[x]=c|((c2<<ab)/256<<ao);
		}
		delete [] temp;
		mytex->Unlock();
	}
	else TRACE("error locking texture");
	return mytex;

}



CTexture *LoadGreyTex(char *fname, int sz=256)
{
	
	CTexture *mytex=new CTexture();
	DDPIXELFORMAT *pf;
	mytex->GetNicePixelFormat(16,0,&pf);
	mytex->Alloc(pf,sz,sz);

	
	int rb=countbits(pf->dwRBitMask),ro=countzeros(pf->dwRBitMask);
	int gb=countbits(pf->dwGBitMask),go=countzeros(pf->dwGBitMask);
	int bb=countbits(pf->dwBBitMask),bo=countzeros(pf->dwBBitMask);
	int pitch;
	UWORD *out;
	
	if ((out=mytex->Lock(&pitch))!=NULL)
	{
		
		TRACE("load bw locked texture %x %d\n",out,pitch);		
		FILE_ file;
		file.open(fname);

		
		unsigned char *temp=new unsigned char[sz*sz];
		unsigned char *src=temp;
		file.read((char*)temp,sz*sz);

		
		int c;
		for (int y=0;y<sz;y++) 
		for (int x=0;x<sz;x++) 
		{
			c=*src++;
			(out+pitch*y)[x]=((c<<rb)/256<<ro)|((c<<gb)/256<<go)|((c<<bb)/256<<bo);
		}
		

		delete [] temp;
		
		file.close();
		mytex->Unlock();
	}
	else TRACE("error locking texture");
	
	return mytex;
}

CTexture *LoadRGBTex(char *fname, int sz)
{
	
	CTexture *mytex=new CTexture();
	DDPIXELFORMAT *pf;
	mytex->GetNicePixelFormat(16,0,&pf);
	mytex->Alloc(pf,sz,sz);

	
	int rb=countbits(pf->dwRBitMask),ro=countzeros(pf->dwRBitMask);
	int gb=countbits(pf->dwGBitMask),go=countzeros(pf->dwGBitMask);
	int bb=countbits(pf->dwBBitMask),bo=countzeros(pf->dwBBitMask);
	int pitch;
	UWORD *out;
	
	if ((out=mytex->Lock(&pitch))!=NULL)
	{
		
		TRACE("load rgb locked texture %x %d\n",out,pitch);		
		FILE_ file;
		file.open(fname);
	
		unsigned char *temp=new unsigned char[sz*sz*3];
		unsigned char *src=temp;
		file.read((char*)temp,sz*sz*3);

		int rc,gc,bc;
		for (int y=0;y<sz;y++) 
		for (int x=0;x<sz;x++) 
		{
			rc=*src++;
			gc=*src++;
			bc=*src++;
			(out+pitch*y)[x]=((rc<<rb)/256<<ro)|((gc<<gb)/256<<go)|((bc<<bb)/256<<bo);
		}
		

		delete [] temp;
		
		file.close();
		mytex->Unlock();
	}
	else TRACE("error locking texture");
	
	return mytex;
}

CTexture *LoadRGBTex3(char *fname, int sz)	// alpha!
{
	
	CTexture *mytex=new CTexture();
	DDPIXELFORMAT *pf;
	mytex->GetNicePixelFormat(16,1,&pf);
	if (!pf) mytex->GetNicePixelFormat(16,0,&pf);
	mytex->Alloc(pf,sz,sz);

	
	int rb=countbits(pf->dwRBitMask),ro=countzeros(pf->dwRBitMask);
	int gb=countbits(pf->dwGBitMask),go=countzeros(pf->dwGBitMask);
	int bb=countbits(pf->dwBBitMask),bo=countzeros(pf->dwBBitMask);
	int ab=countbits(pf->dwRGBAlphaBitMask),ao=countzeros(pf->dwRGBAlphaBitMask);
	int alpha=pf->dwRGBAlphaBitMask;
	int pitch;
	UWORD *out;
	
	
	if ((out=mytex->Lock(&pitch))!=NULL)
	{
		
		TRACE("load rgb locked texture %x %d\n",out,pitch);		
		FILE_ file;
		file.open(fname);
	
		unsigned char *temp=new unsigned char[sz*sz*3];
		unsigned char *src=temp;
		file.read((char*)temp,sz*sz*3);

		int rc,gc,bc;
		
		for (int y=0;y<sz;y++) 
		for (int x=0;x<sz;x++) 
		{
			rc=*src++;
			gc=*src++;
			bc=*src++;
			if (rc>=230 && bc<120 && gc<120)
			{
				(out+pitch*y)[x]=0;
			}
			else (out+pitch*y)[x]=((rc<<rb)/256<<ro)|((gc<<gb)/256<<go)|((bc<<bb)/256<<bo)|alpha;			
		}
		

		delete [] temp;
		
		file.close();
		mytex->Unlock();
	}
	else TRACE("error locking texture");
	
	return mytex;
}


CTexture *LoadRGBTex2(char *fname, int sz)	// red and blue swapped!
{
	
	CTexture *mytex=new CTexture();
	DDPIXELFORMAT *pf;
	mytex->GetNicePixelFormat(16,0,&pf);
	mytex->Alloc(pf,sz,sz);

	
	int rb=countbits(pf->dwRBitMask),ro=countzeros(pf->dwRBitMask);
	int gb=countbits(pf->dwGBitMask),go=countzeros(pf->dwGBitMask);
	int bb=countbits(pf->dwBBitMask),bo=countzeros(pf->dwBBitMask);
	int pitch;
	UWORD *out;
	
	if ((out=mytex->Lock(&pitch))!=NULL)
	{
		
		TRACE("load rgb locked texture %x %d\n",out,pitch);		
		FILE_ file;
		file.open(fname);
	
		unsigned char *temp=new unsigned char[sz*sz*3];
		unsigned char *src=temp;
		file.read((char*)temp,sz*sz*3);

		int rc,gc,bc;
		for (int y=0;y<sz;y++) 
		for (int x=0;x<sz;x++) 
		{
			bc=*src++;
			gc=*src++;			
			rc=*src++;
			(out+pitch*y)[x]=((rc<<rb)/256<<ro)|((gc<<gb)/256<<go)|((bc<<bb)/256<<bo);
		}
		

		delete [] temp;
		
		file.close();
		mytex->Unlock();
	}
	else TRACE("error locking texture");
	
	return mytex;
}


CTexture *LoadRGBATex(char *fname, int sz)
{
	
	CTexture *mytex=new CTexture();
	DDPIXELFORMAT *pf;
	mytex->GetNicePixelFormat(16,4,&pf);
	if (!pf) mytex->GetNicePixelFormat(16,1,&pf);
	if (!pf) mytex->GetNicePixelFormat(16,0,&pf);
	mytex->Alloc(pf,sz,sz);
	
	int rb=countbits(pf->dwRBitMask),ro=countzeros(pf->dwRBitMask);
	int gb=countbits(pf->dwGBitMask),go=countzeros(pf->dwGBitMask);
	int bb=countbits(pf->dwBBitMask),bo=countzeros(pf->dwBBitMask);
	int ab=countbits(pf->dwRGBAlphaBitMask),ao=countzeros(pf->dwRGBAlphaBitMask);
	int pitch;
	UWORD *out;
	
	if ((out=mytex->Lock(&pitch))!=NULL)
	{
		
		TRACE("load rgb locked texture %x %d\n",out,pitch);		
		FILE_ file;
		file.open(fname);
	
		unsigned char *temp=new unsigned char[sz*sz*3];
		unsigned char *src=temp;
		file.read((char*)temp,sz*sz*3);

		int rc,gc,bc,ac;
		for (int y=0;y<sz;y++) 
		for (int x=0;x<sz;x++) 
		{
			rc=*src++;
			gc=*src++;
			bc=*src++;
			ac=(rc+gc+bc-700)*100;
			if (ac>255) ac=255;
			if (ac<0) ac=0;			
			(out+pitch*y)[x]=((rc<<rb)/256<<ro)|((gc<<gb)/256<<go)|((bc<<bb)/256<<bo)|((ac<<ab)/256<<ao);
		}		

		delete [] temp;
		
		file.close();
		mytex->Unlock();
	}
	else TRACE("error locking texture");
	
	return mytex;
}

CTexture *texttex;
CTexture *texttex2;
CTexture *noisetex;
float texuv[26][4];

int blocked(int u, int v1, int v2, unsigned char *temp)
{	
	temp+=u;	
	for (;v1<v2;v1++) if (temp[v1*256]>10) return 1;
	return 0;
}

void inittext()
{
	texttex=LoadGreyTex("text.raw");
	texttex2=LoadGreyTex("textb.raw");
	FILE_ file;
	file.open("text.raw");
	unsigned char *temp=new unsigned char[65536];	
	file.read((char*)temp,65536);
	file.close();
	// analyse the text
	int u1=0,u2=0;
	for (int c1=0;c1<26;c1++)
	{
		// 58, 148, 240
		int v1=(c1<9)?1:(c1<17)?148-57:240-57;
		int v2=v1+72;
		if (c1==0 || c1==9 || c1==17) u2=0;

		
		u1=u2;
		while (!blocked(u1,v1,v2,temp)) u1++;
		u2=u1;
		while (blocked(u2,v1,v2,temp)) u2++;		
		texuv[c1][0]=(u1-1)/256.0f;
		texuv[c1][1]=v1/256.0f;
		texuv[c1][2]=(u2+1)/256.0f;
		texuv[c1][3]=v2/256.0f;
	}
}

void Filmtext(char *str, FVector p, int col, CTexture *tex, float TWID, float THGT, float TSPC, float TSCL, float uadj)
{	
	char *str2=str;
	float l=0,dl;
	while (*str2)
	{
		int c2=*str2-'a';
		if (c2<0 || c2>25)
		{
			dl=(texuv[2][2]-texuv[2][0])*TWID/2;
		}
		else
		{
			dl=(texuv[c2][2]-texuv[c2][0])*TWID;
		}
		l+=dl+TSPC;
		str2++;
	}
	p.X-=l/2;
	while (*str)
	{
		int c2=*str-'a';
		if (c2<0 || c2>25)
		{
			dl=(texuv[2][2]-texuv[2][0])*TWID/2;
		}
		else
		{
			dl=(texuv[c2][2]-texuv[c2][0])*TWID;
			float dl2=dl*TSCL;
			int a=tex->AddVertex(p.X+dl/2-dl2,p.Y-THGT,p.Z,texuv[c2][0]-uadj,texuv[c2][1],col);
			int b=tex->AddVertex(p.X+dl/2+dl2,p.Y-THGT,p.Z,texuv[c2][2]+uadj,texuv[c2][1],col);
			int c=tex->AddVertex(p.X+dl/2+dl2,p.Y+THGT,p.Z,texuv[c2][2]+uadj,texuv[c2][3],col);
			int d=tex->AddVertex(p.X+dl/2-dl2,p.Y+THGT,p.Z,texuv[c2][0]-uadj,texuv[c2][3],col);			
			tex->AddTri(a,b,c);
			tex->AddTri(c,d,a);
		}
		p.X+=dl+TSPC;
		str++;
	}
	tex->Draw();
}

float FADESPD =0.6;

void Filmtext2(char *str, FVector p, int col,float TWID, float THGT, float TSPC, float TSCL)
{	
	if (col>355) col=355-(col-356)*FADESPD;
	if (col<=0) return;
	int col2=RGB_MAKE(CLIP(col),CLIP(col),CLIP(col));
	Filmtext(str,p,col2, texttex, TWID,THGT,TSPC,0.5,0);	
	col2=RGB_MAKE(CLIP(col/4),CLIP(col/2),CLIP(col));
	Filmtext(str,p,col2, texttex2, TWID,THGT,TSPC,TSCL, 0.0031);
}

void Filmtext3(char *str, FVector p, float t)
{	
	float tsc=1+t*0.0061;
	Filmtext2(str,p,t*25,4*tsc,0.75*tsc,0.25+t*0.015,0.5+t*0.075);	
}

float wibbledata[64];

void initwibble()
{
	for (int c1=0;c1<64;c1++) wibbledata[c1]=((rand()/float(RAND_MAX))-0.5)+((rand()/float(RAND_MAX))-0.5)+((rand()/float(RAND_MAX))-0.5);
}


float getwibble(float t, int i=0, int num=3)
{
	float c2=1;
	float s=0;
	i&=31;
	for (int c1=0;c1<num;c1++,c2*=1.3)
	{
		s+=sin(wibbledata[i]*t*c2*0.4+wibbledata[i+1])*wibbledata[i+2]*0.4/c2;
		i+=3;
	}
	return s;
}

float getwibble2(float t, int i=0, int num=3)
{
	float c2=1;
	float s=0;
	i&=31;
	for (int c1=0;c1<num;c1++,c2*=1.3)
	{
		s+=sin(wibbledata[i]*t*c2+wibbledata[i+1])*wibbledata[i+2]/c2;
		i+=3;
	}
	return s;
}


float getwibble2d(float t, float t2=0, int num=3)
{
	float c2=1;
	float s=0,s2=0;
	int i=t2;
	int i2=i+1;
	i&=31;
	i2&=31;
	t2-=i;

	for (int c1=0;c1<num;c1++,c2*=1.3)
	{
		s+=sin(wibbledata[i]*t*c2+wibbledata[i+1])*wibbledata[i+2]/c2;
		s2+=sin(wibbledata[i2]*t*c2+wibbledata[i2+1])*wibbledata[i2+2]/c2;
		i+=3;
	}
	return s2*t2 + s*(1-t2);
}


float getdwibble(float t, int i=0, int num=3)	// derivative with respect to t.
{
	float c2=1;
	float s=0;
	i&=31;
	for (int c1=0;c1<num;c1++,c2*=1.3)
	{
		s+=cos(wibbledata[i]*t*c2+wibbledata[i+1])*wibbledata[i+2]/c2;
		i+=3;
	}
	return s;
}

float getjiggle(int i)
{
	i+=GetMusicPos();
	int j=i%31;
	int k=i&32;		
	return wibbledata[(j+k)&63];
}


void Degrade(CTexture *tex,float tofs)
{	
	
	float t=gTime/50000.f+tofs;
	float u=5*getwibble(t*0.011)+getjiggle(11)*3.1;
	float v=5*getwibble(t*0.013)+getjiggle(13)*3.1;
	
	float usc=0.4+0.15*getwibble(t, GetMusicPos()/SPEED, 2);
	float vsc=0.4+0.25*getwibble(t, GetMusicPos()/SPEED, 2);
	if (getjiggle(17)<0) usc*=2;
	if (getjiggle(19)<0) vsc*=2;
	
	int col=CLIP((getwibble(t,23)+1.1)*150)/2;			
	col=RGBA_MAKE(255,255,255,col);

	int a=tex->AddVertex(-4./3,-1,1,u-usc,v-vsc, col);
	int b=tex->AddVertex(+4./3,-1,1,u+usc,v-vsc, col);
	int c=tex->AddVertex(+4./3,+1,1,u+usc,v+vsc, col);
	int d=tex->AddVertex(-4./3,+1,1,u-usc,v+vsc, col);
	tex->AddTri(a,b,c);
	tex->AddTri(c,d,a);
	tex->Draw();
}

void BurnScreen(float t, float r,float g, float b, int wib)
{
	if (t<=0) return;
	float ot=t;
	t=t*6-2;
	if (t>1) t=1-(t-1)*0.1;
	if (t<=-1) return;

	WORD *vs=new WORD[17*17];
	WORD *vs2=vs;
	int ix,iy;
	int col;
	
	ot*=4;
	for (iy=0;iy<17;iy++)
	for (ix=0;ix<17;ix++)
	{

		
		float f=t*1.3+getwibble( ot+ix+wib , 45+wib) + getwibble( iy*2-ot+wib, 33+wib) + 0.03*getwibble (ot*7.34,11+wib);
		col=RGB_MAKE(CLIP(r*f),CLIP(g*f),CLIP(b*f));
		*vs2++=GOURAUD->AddVertex((ix-8)*4/3,(iy-8),8,col);
	}
	for (iy=0;iy<16;iy++)
	for (ix=0;ix<16;ix++)
	{
		GOURAUD->AddTri(vs[iy*17+ix],vs[iy*17+ix+1],vs[iy*17+ix+18]);
		GOURAUD->AddTri(vs[iy*17+ix+18],vs[iy*17+ix+17],vs[iy*17+ix]);
	}
	delete [] vs;

	GOURAUD->Draw();
}

void Bendtext(CTexture *tex, float x1, float y1, float x2, float y2, float z, float uu)
//void Bendtext(CTexture *tex, float x1, float y1, float x2, float y2, float z)
{	
	
	float t=gTime/50000.f;
	float x=0.4*getwibble(t*0.011)+getjiggle(11)*2.1;
	float y=0.4*getwibble(t*0.013)+getjiggle(13)*2.1;
	
	float usc=0.4+0.15*getwibble(t, GetMusicPos()/SPEED, 2);
	float vsc=0.4+0.25*getwibble(t, GetMusicPos()/SPEED, 2);
	static zsh=0;
	zsh*=0.93;
	if (getjiggle(17)<-0.4) usc*=2.5;
	if (getjiggle(19)<-0.4) vsc*=2.5;
	if (getjiggle(19)<-0.48) zsh=2;
	
	usc*=2+zsh;
	vsc*=2+zsh;
	
	t*=20;
	
	int col=RGB_MAKE(64,64,64);

	WORD *vs=new WORD[17*9];
	WORD *vs2=vs;
	int ix,iy;
	FVector cen((x1+x2)/2+getwibble(t/5,23)*12,(y1+y2)/2+getwibble(t/7,72)*7,z);
	FVector cen2((x1+x2)/2+getwibble(t/5,46)*12,(y1+y2)/2+getwibble(t/7,54)*7,z);

	for (iy=0;iy<9;iy++)
	for (ix=0;ix<17;ix++)
	{
		FVector p(x1+(x2-x1)/16.f*ix,y1+(y2-y1)/8.f*iy,z);
		p+=FVector(getwibble(t+ix*2.7+iy*1.3,1),getwibble(t-ix*1.357+iy*2.2734,11),getwibble(t+ix*2.1252-iy*1.864,7))*0.3;
		float sc;
		FVector d=p-cen;		
		sc=(p-cen).MagnitudeSq();
		sc=1.1+  2.5/(sc+1);
		p=cen+d*sc;
		
		d=p-cen2;		
		sc=(p-cen2).MagnitudeSq();
		sc=1.1-1.0/(sc*sc+1);
		p=cen2+d*sc;
		*vs2++=tex->AddVertex(p.X,p.Y,p.Z,ix/16.f,iy/16.f+uu,col);
	}
	for (iy=0;iy<8;iy++)
	for (ix=0;ix<16;ix++)
	{
		tex->AddTri(vs[iy*17+ix],vs[iy*17+ix+1],vs[iy*17+ix+18]);
		tex->AddTri(vs[iy*17+ix+18],vs[iy*17+ix+17],vs[iy*17+ix]);
	}

	col=RGB_MAKE(127,127,127);
	
	int a=tex->AddVertex(x1-usc,y1-vsc,z,0,0+uu, col);
	int b=tex->AddVertex(x2+usc,y1-vsc,z,1,0+uu, col);
	int c=tex->AddVertex(x2+usc,y2+vsc,z,1,0.5f+uu, col);
	int d=tex->AddVertex(x1-usc,y2+vsc,z,0,0.5f+uu, col);
	tex->AddTri(a,b,c);
	tex->AddTri(c,d,a);

	tex->Draw();
	delete vs;

}

/*
{	
	
	float t=gTime/50000.f;
	float x=0.4*getwibble(t*0.011)+getjiggle(11)*2.1;
	float y=0.4*getwibble(t*0.013)+getjiggle(13)*2.1;
	
	float usc=0.4+0.15*getwibble(t, GetMusicPos(), 2);
	float vsc=0.4+0.25*getwibble(t, GetMusicPos(), 2);
	static zsh=0;
	zsh*=0.93;
	if (getjiggle(17)<-0.4) usc*=2.5;
	if (getjiggle(19)<-0.4) vsc*=2.5;
	if (getjiggle(19)<-0.48) zsh=2;
	
	usc*=2+zsh;
	vsc*=2+zsh;
	
	t*=20;
	
	int col=RGB_MAKE(64,64,64);

	WORD *vs=new WORD[17*9];
	WORD *vs2=vs;
	int ix,iy;
	FVector cen((x1+x2)/2+getwibble(t/5,23)*12,(y1+y2)/2+getwibble(t/7,72)*7,z);
	FVector cen2((x1+x2)/2+getwibble(t/5,46)*12,(y1+y2)/2+getwibble(t/7,54)*7,z);

	for (iy=0;iy<9;iy++)
	for (ix=0;ix<17;ix++)
	{
		FVector p(x1+(x2-x1)/16.f*ix,y1+(y2-y1)/8.f*iy,z);
		p+=FVector(getwibble(t+ix*2.7+iy*1.3,1),getwibble(t-ix*1.357+iy*2.2734,11),getwibble(t+ix*2.1252-iy*1.864,7))*0.3;
		float sc;
		FVector d=p-cen;		
		sc=(p-cen).MagnitudeSq();
		sc=1.1+  2.5/(sc+1);
		p=cen+d*sc;
		
		d=p-cen2;		
		sc=(p-cen2).MagnitudeSq();
		sc=1.1-1.0/(sc*sc+1);
		p=cen2+d*sc;
		*vs2++=tex->AddVertex(p.X,p.Y,p.Z,ix/16.f,iy/16+uu,col);
	}
	for (iy=0;iy<8;iy++)
	for (ix=0;ix<16;ix++)
	{
		tex->AddTri(vs[iy*17+ix],vs[iy*17+ix+1],vs[iy*17+ix+18]);
		tex->AddTri(vs[iy*17+ix+18],vs[iy*17+ix+17],vs[iy*17+ix]);
	}

	col=RGB_MAKE(127,127,127);
	
	int a=tex->AddVertex(x1-usc,y1-vsc,z,0,0+uu, col);
	int b=tex->AddVertex(x2+usc,y1-vsc,z,1,0+uu, col);
	int c=tex->AddVertex(x2+usc,y2+vsc,z,1,0.5+uu, col);
	int d=tex->AddVertex(x1-usc,y2+vsc,z,0,0.5+uu, col);
	tex->AddTri(a,b,c);
	tex->AddTri(c,d,a);

	tex->Draw();
	delete vs;

}
*/

int xmap[256];
int ymap[128];
CTexture *zoomtex;

void initzoom()
{
	int c1;
	for (c1=0;c1<128;c1++) ymap[c1]=gD->mVM->mH*c1/128;
	for (c1=0;c1<256;c1++) xmap[c1]=gD->mVM->mW*c1/256;
	zoomtex=new CTexture();
	DDPIXELFORMAT *pf;
	pf=&gD->mPixelFormat;
	zoomtex->Alloc(pf,256,256);
};

void drawzoom(float z, int col)
{		
	if (col==0) return;
	int a=zoomtex->AddVertex(-5*CTexture::mXLens,-5/CTexture::mYLens,z,0,0, col);
	int b=zoomtex->AddVertex( 5*CTexture::mXLens,-5/CTexture::mYLens,z,1,0, col);
	int c=zoomtex->AddVertex(-5*CTexture::mXLens, 5/CTexture::mYLens,z,0,0.5, col);
	int d=zoomtex->AddVertex( 5*CTexture::mXLens, 5/CTexture::mYLens,z,1,0.5, col);
	zoomtex->AddTri(a,b,d);
	zoomtex->AddTri(d,c,a);
	zoomtex->Draw();		
};

void readzoom()
{
	int pitch;
	UWORD *out;
	
	if ((out=zoomtex->Lock(&pitch))!=NULL)
	{
		if (!gD->Lock())
		{
			UWORD *dst=out;
			for (int y=0;y<128;y++)
			{
				UWORD *src=(UWORD*) ( gD->mScreenMem+ymap[y]*gD->mPitch) ;
				for (int x=0;x<256;x++)
				{
					*dst++=src[xmap[x]];
				}
				dst+=pitch-256;
			}

			gD->Unlock();
		}
		zoomtex->Unlock();
	}
};

void killzoom()
{
	delete [] zoomtex;
};

extern float bt;

void lhlogo()
{

	v_skipto(vidtex, 876-5);
	v_setstop(3020);
	
	unsigned char *lhlogo=new unsigned char[128*128];
	FILE_ f;f.open("lh.raw");
	f.read(lhlogo,128*128);
	f.close();
	
	CamPos cam;
	cam.axes.MakeID();
	cam.posn=FVector(0,0,-20);
	FVector lookat=FVector(0,0,5);
	float dep=5;
	
	
	int dt=0;
	float z=0;
	int eb=0;
	do
	{
		CTexture::RestoreLostSurfaces();
		CTexture::UploadAll();
		CTexture::mLastSelected=NULL;		
		gD->mD3DD2->BeginScene();				

		static float t=0;
		t=t+(dt)*0.000031;
		z-=(dt)*0.000041;		
		if (z<-12) z=-12;
		cam.posn=FVector(getwibble(t,11)*7,getwibble(t,17)*7,getwibble(t,19)*3+z);
		cam.axes.Row[2]=lookat-cam.posn;
		cam.axes.Normalise();
		
		//gD->mD3DD2->SetRenderState( D3DRENDERSTATE_ZENABLE , TRUE );		
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_SRCBLEND , D3DBLEND_SRCALPHA);
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_DESTBLEND , D3DBLEND_INVSRCALPHA);
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_ZENABLE , FALSE );
		Degrade(noisetex);						
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_SRCBLEND , D3DBLEND_ONE);
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_DESTBLEND , D3DBLEND_ONE);

		
		float fres=-7+t*1.1;
		if (fres<0) fres=0; else fres=fres*fres;
		if (fres<5) fres=5;
		if (fres>40) fres=40;
		int y,x,coly;
		
		float sqs=10/float(fres);
		float sqs2=0.7;
		int res=fres+0.5;
		for (y=0;y<res;y++)
		{
			for (x=0;x<res;x++)
			{
				FVector p;
				coly=(lhlogo[int(128*x/fres)+128*int(128*y/fres)])/2;
				coly=RGBA_MAKE(coly,coly,coly,coly/2);

				p=cam.axes*(FVector(x*sqs-5,y*sqs-5,0)-cam.posn);
				int a1=GOURAUD->AddVertex(p.X,p.Y,p.Z,coly);
				p=cam.axes*(FVector((x+sqs2)*sqs-5,y*sqs-5,0)-cam.posn);
				int b1=GOURAUD->AddVertex(p.X,p.Y,p.Z,coly);
				p=cam.axes*(FVector((x+sqs2)*sqs-5,(y+sqs2)*sqs-5,0)-cam.posn);
				int c1=GOURAUD->AddVertex(p.X,p.Y,p.Z,coly);
				p=cam.axes*(FVector(x*sqs-5,(y+sqs2)*sqs-5,0)-cam.posn);
				int d1=GOURAUD->AddVertex(p.X,p.Y,p.Z,coly);

				
				coly=(lhlogo[(128*x/res)+128*(128*y/res)])/8;
				coly=RGBA_MAKE(coly,coly,coly,coly/2);

				p=cam.axes*(FVector(x*sqs-5,y*sqs-5,dep)-cam.posn);
				int a2=GOURAUD->AddVertex(p.X,p.Y,p.Z,coly);
				p=cam.axes*(FVector((x+sqs2)*sqs-5,y*sqs-5,dep)-cam.posn);
				int b2=GOURAUD->AddVertex(p.X,p.Y,p.Z,coly);
				p=cam.axes*(FVector((x+sqs2)*sqs-5,(y+sqs2)*sqs-5,dep)-cam.posn);
				int c2=GOURAUD->AddVertex(p.X,p.Y,p.Z,coly);
				p=cam.axes*(FVector(x*sqs-5,(y+sqs2)*sqs-5,dep)-cam.posn);
				int d2=GOURAUD->AddVertex(p.X,p.Y,p.Z,coly);


				//GOURAUD->AddTri(a1,b1,c1);GOURAUD->AddTri(c1,d1,a1);
				/*
				GOURAUD->AddTri(a1,a2,b2);GOURAUD->AddTri(b2,b1,a1);
				GOURAUD->AddTri(b1,b2,c2);GOURAUD->AddTri(c2,c1,b1);
				GOURAUD->AddTri(c1,c2,d2);GOURAUD->AddTri(d2,d1,c1);
				GOURAUD->AddTri(d1,d2,a2);GOURAUD->AddTri(a2,a1,d1);
				*/
				
				GOURAUD->DrawLine(a1,a2);GOURAUD->DrawLine(a1,b1);
				GOURAUD->DrawLine(b1,b2);GOURAUD->DrawLine(b1,c1);
				GOURAUD->DrawLine(c1,c2);GOURAUD->DrawLine(c1,d1);
				GOURAUD->DrawLine(d1,d2);GOURAUD->DrawLine(d1,a1);
				

			}
			GOURAUD->Draw();
		}

		static float filmt=0.f;
		filmt+=dt*0.00007;
		Filmtext3("lionhead",FVector(0,7,15),filmt);
		Filmtext3("studios",FVector(0,10,18),filmt);

		
		if (GetMusicPos()/SPEED>=87*4-2 && !eb)
		{
			eb=1;
			bt=-1.7;
		}

		dt=vidframeburn();
	} while (!gQuit && GetMusicPos()/SPEED < (87*4));	
	delete [] lhlogo;
	v_setstart(); // here we go
	static float filmt=-11.f;				
	do
	{		
		vidframepre();
		vidframemid();
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_ZENABLE , FALSE );
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_SRCBLEND , D3DBLEND_ONE);
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_DESTBLEND , D3DBLEND_ONE);
		Filmtext3("f i n",FVector(0,8*2,12*2),filmt);
		dt=vidframeburn();
		filmt+=dt*0.00017;
	} while (!gQuit && !v_stopped());



	
}

struct Part
{
	FVector p,v;
	FVector la;
	FVector p2,v2;
	ObjStub *obj;
};

float ease(float t,float tight=2)
{
	if (t<0) return 0;
	if (t>1) return 1;
	
	return sin(t*PI-PI/2)*0.5+0.5;
}

struct Pin
{
	float u,v;
	float z,p;
	int col;
	int idx;
} pin[32][42];

Pin pin2[32][42];

void BlendPin(float b1)
{
	float b2=1-b1;
	int x,y;
	Pin *p=&pin[0][0];
	Pin *p2=&pin2[0][0];
	for (y=0;y<31;y++,p++)
	for (x=0;x<41;x++)
	{		
		p->u=p->u*b1+p2->u*b2;
		p->v=p->v*b1+p2->v*b2;
		p->col=p->col*b1+p2->col*b2;
		if (p->col>300) p->col=300;
		if (p->col<100) p->col=100;
		p++;
	}
}


void DrawPin(CTexture *tex=GOURAUD)
{
	int x,y;
	Pin *p=&pin[0][0];
	for (y=0;y<31;y++,p++)
	for (x=0;x<41;x++)
	{
		p=&pin[y][x];
		int cc=p->col;if (cc>255) cc=255;if (cc<0) cc=0;
		p->idx=tex->AddVertex((x-20)*CTexture::mXLens*80,(y-15)*20/15/CTexture::mYLens*80,1600, p->u, p->v, RGB_MAKE(cc,cc,cc));
		p->col-=cc;if (p->col<0) p->col=0;
		p++;
	}
	p=&pin[0][0];
	for (y=0;y<30;y++,p+=2)
	for (x=0;x<40;x++)
	{
		p=&pin[y][x];
		tex->AddTri(p[0].idx,p[1].idx,p[43].idx);
		tex->AddTri(p[43].idx,p[42].idx,p[0].idx);	
	}
	tex->Draw();
}

void PinSphere(CamPos *c, FVector &posn, float r)
{
	FMatrix ca=c->axes.Transpose();
	int x,y;
	Pin *p=&pin2[0][0];
	for (y=0;y<32;y++)
	for (x=0;x<42;x++)
	{
		FVector ray=c->axes.Row[2] * (20.f / c->scf) + c->axes.Row[0] *(x-20.f) + c->axes.Row[1]*(y-15.f) ;
	
		FVector eye=c->posn - posn;

		

		float A=ray*ray;
		float B=ray*eye*2;
		float C=eye*eye;
		float D=fabs(B*B-4*A*C);
		if (D<0)
		{
			p->u=0;
			p->v=0;
			p->col=0;
		} else {		
			D=sqrt(D);
			float tt=(-B - D)/(2*A);
			if (tt<0) tt=(-B + D)/(2*A);
		
			FVector hit=ray*tt;
			hit= ca * (hit);		

			p->u=hit.X/3.f;
			p->v=hit.Y/3.f;
			tt=fabs(0.1/tt);			
			p->col=tt*tt*3;
		}			
		p++;
	}
}

void clouds()
{
	

	CTexture *flaretex=LoadGreyTex("flare.raw",32);
	CTexture *groundtex=LoadRGBTex("psych.raw",256);
	Scn myscn;	
	myscn.LoadScene("arse.ars");
	myscn.Interpolate(0);
	
	
	
	ObjStub *sphobj=myscn.Findobj("wheel");
	
	int c1;
	for (c1=0;c1<myscn.numobj;c1++) myscn.obj[c1].hidden=2;
	ObjStub *boxobj=myscn.Findobj("box01");
	
	boxobj->hidden=1;
	sphobj->hidden=0;
	for (c1=0;c1<sphobj->numf;c1++) sphobj->f[c1].tx=groundtex;
	for (c1=0;c1<boxobj->numf;c1++) boxobj->f[c1].tx=vidtex;
	for (c1=0;c1<boxobj->numtv;c1++) boxobj->tv[c1].v=0.5*int(boxobj->tv[c1].v+0.1);	// round!
	

#define NUMP 1000
	Part *part=new Part[NUMP];
	CamPos cam;
	cam.axes.MakeID();
	cam.posn=FVector(0,0,0);
	FVector lookat=FVector(0,0,0);

	
	float *dens=new float[myscn.numobj];		
	for (c1=0;c1<myscn.numobj;c1++) 
	{
		float f=c1?dens[c1-1]:0;
		FVector ar=(myscn.obj[c1].max-myscn.obj[c1].min);
		if (myscn.obj[c1].hidden!=2) ar=FVector(0,0,0);
		dens[c1]=f+ ar.X*ar.Y*ar.Z;
	}
	float mdens=dens[myscn.numobj-1];
	
		
	int bonei=0;
	
	for (c1=0;c1<NUMP;c1++)
	{
		part[c1].p2=(part[c1].p=FVector((rand()/float(RAND_MAX))*10.f-5.f,(rand()/float(RAND_MAX))*10.f-5.f,(rand()/float(RAND_MAX))*10.f-5.f))*10;
		part[c1].v2=part[c1].v=FVector(0,0,0);

		// allocate point to somewhere on body...
		
		float boned=(c1*mdens)/float(NUMP);		
		while (dens[bonei]<boned) bonei++;

		ObjStub *bone=myscn.obj+bonei;
		part[c1].obj=bone;
		part[c1].la=FVector(64*rand()/float(RAND_MAX),64*rand()/float(RAND_MAX),64*rand()/float(RAND_MAX));
		
		part[c1].p2= bone->ipos.posn + (bone->ipos.axes * part[c1].la);
		
	}
	delete [] dens;

	int dt=0;
	float z=0;
	float dsh=0.11;

	float interp=-1;


	v_skipto(vidtex, 725-5);
	v_setstop(726-3);
	v_setstart(); // here we go
	
	int trigvid=0;

	do
	{
		vidframepre();

		if (trigvid)
		{
			float v1=(curframe&1)?1:0;		
			
			for (c1=0;c1<boxobj->numtv;c1++) 
			{
				if (fabs(boxobj->tv[c1].v-0.5)>0.1) boxobj->tv[c1].v=v1;				
			}
			
		}
		
		
		static float t=0;
		t=t+(dt)*0.000031;
		interp+=dt*0.000004;

		cam.posn=FVector(getwibble2(t,11)*11,getwibble2(t,17)*11,getwibble2(t,19)*11);
		cam.posn.Normalise();cam.posn*=16;
		cam.axes.Row[2]=lookat-cam.posn;
		cam.axes.Normalise();

		
		float interp1=ease(interp)+0.02*(sin(t*4)+1);
		if (interp1<0) interp1=0;
		if (interp1>1) interp1=1;		
		interp1*=0.9;
		float interp2=1-interp1;

		
		myscn.Interpolate(fabs(interp*100),0);		
		myscn.lgt[1].ipos.intens*=(1+sin(t*3))*3;
		myscn.Light(interp1);
		for (c1=0;c1<boxobj->numtv;c1++) boxobj->tv[c1].col=0xa0a0a0a0;

		
		if (interp>1) boxobj->hidden=0;
		
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_ZENABLE , TRUE );		
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_SRCBLEND , D3DBLEND_SRCALPHA);
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_DESTBLEND , D3DBLEND_INVSRCALPHA);

		myscn.Draw(&myscn.cam[0].ipos);

		if (curframe>838-45)
		{			
			float pp=pow(0.9995,dt);
			for (c1=0;c1<sphobj->numv;c1++) sphobj->v[c1].p*=pp;
		}
		CamPos *c=&myscn.cam[0].ipos;
		

		
				
		if (dsh>0.015) dsh-=dt*0.0000001;
		if (dsh<0.015) dsh=0.015;
		
		
		Part *pr=part;

		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_ZENABLE , FALSE );
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_SRCBLEND , D3DBLEND_ONE);
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_DESTBLEND , D3DBLEND_ONE);

		
		

		


		for (c1=0;c1<NUMP;c1++,pr++)
		{
			float sh=c1*dsh;			
			pr->v=FVector(getwibble2(sh+t*0.5+pr->p.Y,1),getwibble2d(sh+t*0.5+pr->p.Z,7),getwibble2d(sh+t*0.5+pr->p.X,11));						
			pr->p-=pr->v* dt*0.00051;
			pr->p*=pow(0.96,dt*0.001);
			
			FVector p;
			
			// work out attached point's position (target position)

			
			if (interp1>0)
			{
				ObjStub *bone=pr->obj;
				FVector la= FVector(bone->min.X+(bone->max.X-bone->min.X)*(getwibble(pr->la.X+t*5,11)+0.5),
								bone->min.Y+(bone->max.Y-bone->min.Y)*(getwibble(pr->la.Y+t*5,13)+0.5),
									bone->min.Z+(bone->max.Z-bone->min.Z)*(getwibble(pr->la.Z+t*5,15)+0.5));

					
				FVector t= bone->ipos.posn + (bone->ipos.axes * la * 2);
				
		

				pr->v2+=(t-pr->p2)*dt*0.000451;
				
				pr->v2 *= pow(0.978,dt*0.0051);

				pr->p2+=pr->v2* dt*0.00051;

				if (interp<0) pr->p2=t;

				p=c->axes.Transpose() * (pr->p2 - c->posn);
				p.Z=-p.Z;
				p.Y=-p.Y;
				//p*=0.2;
			} 	 else p=FVector(0,0,0);		

			
			
			if (interp2>0)
			{
				FVector p1=cam.axes*(pr->p*1.5-cam.posn);	
				p=p*interp1+p1*interp2;
			};
			

			if (p.Z>MINZ)
			{
				float s=3.5/p.Z;
				if (s>0.6) s=0.6;
				s=2.8*interp1+s*interp2;
				int col=0xf080c0;
				int a=flaretex->AddVertex(p.X-s,p.Y-s,p.Z, 0,0, col);
				int b=flaretex->AddVertex(p.X+s,p.Y-s,p.Z, 1,0, col);
				int c=flaretex->AddVertex(p.X+s,p.Y+s,p.Z, 1,1, col);
				int d=flaretex->AddVertex(p.X-s,p.Y+s,p.Z, 0,1, col);
				flaretex->AddTri(a,b,c);flaretex->AddTri(c,d,a);
			}
		}
		flaretex->Draw();

		if (interp>1.85 && !trigvid)
		{
			trigvid=1;
			v_setstop(838-5);
			v_setstart(); // here we go
		}

		
  

		

		

		dt=vidframeburn(1,2.5*interp2+5*interp1,FADECOL(0xc0c0c0,0.5+0.5*interp2))/2 * 22.f/24.f;
	} while (!gQuit && (!(v_stopped()) || curframe < 833));	

	delete [] part;

	delete flaretex;
}

void volball()
{
	
	CTexture *flaretex=LoadRGBTex("psych.raw");
	
	Scn myscn;	
	myscn.LoadScene("sphr.ars");
	myscn.Interpolate(0);
	// set up the lighting and texture
	ObjStub *obj=myscn.obj;
	int c1;
	for (c1=0;c1<obj->numf;c1++) obj->f[c1].tx=flaretex;
	for (c1=0;c1<obj->numtv;c1++) obj->tv[c1].col=0xffffffff;

	CamPos cam;
	cam.axes.MakeID();
	cam.posn=FVector(0,0,0);
	FVector lookat=FVector(0,0,0);
	cam.scf=1;
	cam.fov=1;

	int dt=0;
	CamPos c;c.axes.MakeID();

	
	float flr=0;

	CTexture *bleamtex=LoadRGBTex3("bleam.raw",256);	

	int bar=0;
	do
	{
		CTexture::RestoreLostSurfaces();
		CTexture::UploadAll();
		CTexture::mLastSelected=NULL;		
		gD->mD3DD2->BeginScene();				

		static float t=0;
		t=t+(dt)*0.000031;

		cam.posn=FVector(getwibble(t,11)*11,getwibble(t,17)*11,getwibble(t,19)*11);
		cam.posn.Normalise();cam.posn*=400;
		cam.axes.Row[2]=lookat-cam.posn;
		cam.axes.Normalise();
		cam.posn+=cam.axes.Row[0]*90-cam.axes.Row[1]*100;

		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_ZENABLE , FALSE );
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_SRCBLEND , D3DBLEND_ONE);
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_DESTBLEND , D3DBLEND_ONE);

		{
				static float t=0;
				t=t+(dt)*0.000031;

				int x,y;
				Pin *p=&pin[0][0];
				for (y=0;y<32;y++)
				for (x=0;x<42;x++)
				{
					float sc=(1.5+sin(t+x*0.25))*(1.5+cos(-t+y*0.25));
					
					p->u= (x-20)*sc*0.00212;
					p->v= (y-15)*sc*0.00212;
					p++;
				}
				p=&pin[0][0];
				for (y=0;y<31;y++,p++)
				for (x=0;x<41;x++)
				{
					float f= ((SQR(p[0].u-p[1].u)+SQR(p[0].v-p[1].v)+SQR(p[0].u-p[42].u)+SQR(p[0].v-p[42].v)));
					f=pow(f,0.4);
					
					p->col=f*155;
					p++;
				}

						
				c.posn=FVector(getwibble(t,11)*7,getwibble(t,17)*7,getwibble(t,19)*7);
				c.axes.Row[2]=c.posn;c.axes.Normalise();
				c.fov=c.scf=1;
				PinSphere(&c,			FVector(0,0,0), 100);
				
				BlendPin(0.5+0.3*sin(t));
				
				gD->mD3DD2->SetRenderState( D3DRENDERSTATE_SRCBLEND , D3DBLEND_ONE);		
				gD->mD3DD2->SetRenderState( D3DRENDERSTATE_DESTBLEND , D3DBLEND_ONE);
				gD->mD3DD2->SetRenderState( D3DRENDERSTATE_ZENABLE , FALSE );		
				DrawPin(flaretex);
				//DrawPin(flaretex);		
		}



		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_SRCBLEND , D3DBLEND_SRCALPHA);
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_DESTBLEND , D3DBLEND_INVSRCALPHA);
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_ZENABLE , FALSE );

		flr=fabs(sin(t))*1.5f;
		
		ObjV *vv=obj->v;
		float dd;
		float scale=flr*0.4+0.6;
		for (c1=0;c1<obj->numv;c1++,vv++) 
		{
			vv->p= vv->op;
			dd=sqrt(SQR(vv->p.Y)+SQR(vv->p.Z));
			vv->p.X+=sin(dd/23.f+t*4)*1000/(10+dd);
			dd=sqrt(SQR(vv->p.X)+SQR(vv->p.Z));
			vv->p.Y+=sin(11+dd/23.f-t*4)*1000/(10+dd);
			vv->p*=scale;
		}
		gD->PollSound();		
		myscn.Draw(&cam,FALSE);
		

		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_ZENABLE , FALSE );
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_SRCBLEND , D3DBLEND_ONE);
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_DESTBLEND , D3DBLEND_ONE);

		
		
		
		
		
		if (flr>0.01) 
			obj->Drawflare(&cam,myscn.obj->ipos.posn,flr+1,FALSE,TRUE);

		
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_SRCBLEND , D3DBLEND_SRCALPHA);
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_DESTBLEND , D3DBLEND_INVSRCALPHA);

		{
			float z=5;
			int col=0xffffffff;			
			int a=bleamtex->AddVertex(-5*CTexture::mXLens,-5/CTexture::mYLens,z,0,0, col);
			int b=bleamtex->AddVertex( 5*CTexture::mXLens,-5/CTexture::mYLens,z,1,0, col);
			int c=bleamtex->AddVertex(-5*CTexture::mXLens, 5/CTexture::mYLens,z,0,1, col);
			int d=bleamtex->AddVertex( 5*CTexture::mXLens, 5/CTexture::mYLens,z,1,1, col);
			bleamtex->AddTri(a,b,d);
			bleamtex->AddTri(d,c,a);
			bleamtex->Draw();		
		}
	

		if (GetMusicPos()/16!=bar)
		{
			bar=GetMusicPos()/16;
			flr=2;
		}
		
		dt=vidframeburn();		
		gD->PollSound();
		static int brn=0;
		if (GetMusicPos()/SPEED>=50*4-2 && !brn)
		{
			brn=1;
			bt=-1.7;
		}
	} while (!gQuit && (GetMusicPos()/SPEED<50*4));	
	
	delete flaretex;
	delete bleamtex;

}

void silhou()
{
	CTexture *flaretex=LoadRGBTex("psych2.raw");
	CTexture *flaretex2=LoadRGBTex2("heart.raw",256);
	Scn myscn;	
	myscn.LoadScene("spin.ars");
	myscn.Interpolate(0);
	// set up the lighting and texture
	ObjStub *obj=myscn.Findobj("normal");
	for (int c0=0;c0<myscn.numobj;c0++)
	{
		ObjStub *obj=myscn.obj+c0;
		for (int c1=0;c1<obj->numf;c1++) obj->f[c1].tx=c0?flaretex:flaretex2;
	}
	
	int dt=0;

	v_skipto(vidtex, 488-5);
	v_setstop(724-4);
	v_setstart(); // here we go
	v_setfps(12);
	
	static int burn=0;
	do
	{
		vidframepre();

		static float t=0;
		t=t+(dt)*0.000036;

		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_ZENABLE , TRUE );		
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_SRCBLEND , D3DBLEND_SRCALPHA);
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_DESTBLEND , D3DBLEND_INVSRCALPHA);

		myscn.Interpolate(t*12.f/15);
		myscn.Light(0.1+0.3*(1+sin(t*4)));
		myscn.Draw(&myscn.cam[0].ipos);
		
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_SRCBLEND , D3DBLEND_SRCCOLOR);
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_DESTBLEND , D3DBLEND_DESTCOLOR);
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_ZENABLE , FALSE );


		float z=5;
		int col=0xffffffff;
		float v1=(curframe&1)?1:0;		
		int a=vidtex->AddVertex(-5*CTexture::mXLens,-5/CTexture::mYLens,z,0,v1, col);
		int b=vidtex->AddVertex( 5*CTexture::mXLens,-5/CTexture::mYLens,z,1,v1, col);
		int c=vidtex->AddVertex(-5*CTexture::mXLens, 5/CTexture::mYLens,z,0,0.5, col);
		int d=vidtex->AddVertex( 5*CTexture::mXLens, 5/CTexture::mYLens,z,1,0.5, col);
		vidtex->AddTri(a,b,d);
		vidtex->AddTri(d,c,a);
		vidtex->AddTri(a,b,d);
		vidtex->AddTri(d,c,a);
		vidtex->Draw();		

		if (GetMusicPos()/SPEED>=55*4-2 && !burn)
		{
			bt=-1.7;
			burn=1;
		}

		dt=vidframeburn();		
	} while (!gQuit && GetMusicPos()/SPEED<55*4);	
	v_setfps(15);
	
	delete flaretex;

}

void warpy()
{
	CTexture *flaretex=LoadRGBTex("psych.raw");	
	CTexture *bleamtex=LoadRGBTex3("bleam.raw",256);	
	int dt=0;
	CamPos c;c.axes.MakeID();
	do
	{
		CTexture::RestoreLostSurfaces();
		CTexture::UploadAll();
		CTexture::mLastSelected=NULL;		
		gD->mD3DD2->BeginScene();				

		static float t=0;
		t=t+(dt)*0.000031;

		int x,y;
		Pin *p=&pin[0][0];
		for (y=0;y<32;y++)
		for (x=0;x<42;x++)
		{
			float sc=(1.5+sin(t+x*0.25))*(1.5+cos(-t+y*0.25));
			
			p->u= (x-20)*sc*0.00212;
			p->v= (y-15)*sc*0.00212;
			p++;
		}
		p=&pin[0][0];
		for (y=0;y<31;y++,p++)
		for (x=0;x<41;x++)
		{
			float f= ((SQR(p[0].u-p[1].u)+SQR(p[0].v-p[1].v)+SQR(p[0].u-p[42].u)+SQR(p[0].v-p[42].v)));
			f=pow(f,0.4);
			
			p->col=f*155;
			p++;
		}

				
		c.posn=FVector(getwibble(t,11)*7,getwibble(t,17)*7,getwibble(t,19)*7);
		c.axes.Row[2]=c.posn;c.axes.Normalise();
		c.fov=c.scf=1;
		PinSphere(&c,			FVector(0,0,0), 100);
		
		BlendPin(0.5+0.3*sin(t));
		
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_SRCBLEND , D3DBLEND_ONE);		
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_DESTBLEND , D3DBLEND_ONE);
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_ZENABLE , FALSE );		
		DrawPin(flaretex);
		DrawPin(flaretex);		
		
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_SRCBLEND , D3DBLEND_SRCALPHA);
		gD->mD3DD2->SetRenderState( D3DRENDERSTATE_DESTBLEND , D3DBLEND_INVSRCALPHA);

		{
			float z=5;
			int col=0xffffffff;			
			int a=bleamtex->AddVertex(-5*CTexture::mXLens,-5/CTexture::mYLens,z,0,0, col);
			int b=bleamtex->AddVertex( 5*CTexture::mXLens,-5/CTexture::mYLens,z,1,0, col);
			int c=bleamtex->AddVertex(-5*CTexture::mXLens, 5/CTexture::mYLens,z,0,1, col);
			int d=bleamtex->AddVertex( 5*CTexture::mXLens, 5/CTexture::mYLens,z,1,1, col);
			bleamtex->AddTri(a,b,d);
			bleamtex->AddTri(d,c,a);
			bleamtex->Draw();		
		}
		
		gD->mD3DD2->EndScene();				
		dt=gD->DoTick(DT_FLIPCLEAR);
	} while (!gQuit);	
	delete bleamtex;
	delete flaretex;
}

void exitshit()
{
	FADESPD=1.2;
	int dt=0;
	float z=0;
	int eb=0;
	gD->DoTick(DT_FLIPCLEAR);
	gD->DoTick(DT_FLIPCLEAR);
	do
	{
		CTexture::RestoreLostSurfaces();
		CTexture::UploadAll();
		CTexture::mLastSelected=NULL;		
		gD->mD3DD2->BeginScene();				
	
		static float filmt=0.f;
		filmt+=dt*0.0000071;
		float filmt2=filmt;
		
		Filmtext3("b l e a m",FVector(0,(10-filmt2*6)*0.7,6),filmt2*7);		
		filmt2-=0.5;
		Filmtext3("demo",FVector(0,10-filmt2*6,10),filmt2*7);		
		filmt2-=1.5;		
		Filmtext3("copyright alex evans",FVector(0,10-filmt2*6,13),filmt2*7);		
		filmt2-=0.4;		
		Filmtext3("nineteen ninety eight",FVector(0,10-filmt2*6,15),filmt2*7);		
		filmt2-=0.9;		
		Filmtext3("art and acting by marcos",FVector(0,10-filmt2*6,13),filmt2*7);				
		filmt2-=0.4;		
		Filmtext3("music mixed by russ",FVector(0,10-filmt2*6,13),filmt2*7);		
		filmt2-=0.4;		
		Filmtext3("design by vic and statix",FVector(0,10-filmt2*6,13),filmt2*7);		

		filmt2-=0.8;		
		Filmtext3("hope you liked it",FVector(0,10-filmt2*6,13),filmt2*7);		
		//filmt2-=0.8;		
		//Filmtext3("stereo sound pack coming soon",FVector(0,10-filmt2*6,15),filmt2*7);		
		filmt2-=1.8;		
		Filmtext3("t h e   e n d",FVector(0,10-filmt2*6,15),filmt2*7);		
	
		dt=vidframeburn();
	} while (!gQuit);	

}

void herewego()
{

	

	//gD->mD3DD2->SetRenderState( D3DRENDERSTATE_WRAPU , TRUE);
	//gD->mD3DD2->SetRenderState( D3DRENDERSTATE_WRAPV , TRUE);
	//gD->mD3DD2->SetRenderState( D3DRENDERSTATE_TEXTUREADDRESS , D3DTADDRESS_WRAP);
	//gD->mD3DD2->SetRenderState( D3DRENDERSTATE_TEXTUREADDRESSU , D3DTADDRESS_WRAP);
	//gD->mD3DD2->SetRenderState( D3DRENDERSTATE_TEXTUREADDRESSV , D3DTADDRESS_WRAP);
	
	CTexture *hearttex[3];
	hearttex[0]=LoadRGBTex("heart.raw");
	hearttex[1]=LoadRGBTex("stw2.raw");
	hearttex[2]=LoadRGBTex("window.raw");
	//flare[0]=LoadGreyTex("flare1.raw",64);

	CTexture *victex=LoadGreyTex("vic.raw");

	noisetex=LoadGreyAlphaTex("noise.raw");
	v_init();	
	loadvid("fin.ctl");
	inittext();
	initwibble();
	initzoom();

	
	
	
	//
	
	//lhlogo();

		
	//	watchvid();	

	

	

	//Sleep(1000);
	
	if (gD->StartSound())
	{
		gD->CloseSound();
		gD->CloseScreen();		
		delete gD;
		return;		
	}

	if (0)
	{
		//gD->FastForward( (10.44+ ((31-7)*4*60/108.f + (40-31)*4*60/100.f))*TICKSPERSEC);
		gD->FastForward( (10.44+ ((17-7)*4*60/108.f + (31-31)*4*60/100.f))*TICKSPERSEC);
	}
	else
	{
		extern int firsttime;
		firsttime=GetTickCount();
		while (GetMusicPos()<0) {gD->GetTime();Sleep(0);}
	}
	//intro();
	//credits();	

	//clouds();


	
	//volball();
	//return;
	
	//lhlogo();
	//return;

	//exitshit();
	//warpy();
	//volball();
	//return;

	{
		Scn myscn;	
		myscn.LoadScene("h4.ars");
		myscn.Interpolate(0);


		intro();
		
		for (int c0=0;c0<myscn.numobj;c0++)
		{

			ObjStub *obj=myscn.obj+c0;		
			CTexture *tx=hearttex[1];		
			if (strnicmp(obj->name,"bass",strlen("bass"))==0) tx=hearttex[0];
			if (strnicmp(obj->name,"treble",strlen("treble"))==0) tx=hearttex[0];
			if (strnicmp(obj->name,"normal",strlen("normal"))==0) tx=hearttex[0];
			if (strnicmp(obj->name,"cylinder",strlen("cylinder"))==0) tx=hearttex[0];
			if (strnicmp(obj->name,"box02",strlen("box02"))==0) tx=hearttex[1];
			if (strnicmp(obj->name,"box03",strlen("box03"))==0) tx=hearttex[2];
			if (strnicmp(obj->name,"box01",strlen("box01"))==0) tx=hearttex[2];
			for (int c1=0;c1<obj->numf;c1++) obj->f[c1].tx=tx;
		}
		
		ObjStub *basso=myscn.Findobj("bass");
		ObjStub *trebleo=myscn.Findobj("treble");
		ObjStub *normalo=myscn.Findobj("normal");

		basso->hidden=1;
		trebleo->hidden=1;
		basso->Sub(normalo);
		trebleo->Sub(normalo);
		myscn.Light();
		
		float bass=0;
		float treble=0;
		float bassv=0;
		float treblev=0;
		float t=0;
		float dt=0;
		int bar=0;
		static basstrack[29][3]={0,10,10,
						  3,6,0,
						  4,6,7,
						  5,6,0,
						  9,8,0,
						  11,8,0,
						  13,0,7,
						  16,10,10,
						  17,10,10,
						  20,0,7,
						  21,8,0,
						  25,10,10,
						  27,10,10,
						  29,0,7,
						  32,10,10,
						  34,10,10,
						  35,7,0,
						  36,0,7,
						  37,7,0,
						  41,7,2,
						  43,7,2,
						  45,0,7,
						  48,7,0,
						  50,7,0,
						  52,0,7,
						  53,10,0,
						  57,7,7,
						  59,10,10,
						  61,0,5};

		do
		{
			CTexture::RestoreLostSurfaces();
			CTexture::UploadAll();
			CTexture::mLastSelected=NULL;		
			gD->mD3DD2->BeginScene();				
			
			
			gD->mD3DD2->SetRenderState( D3DRENDERSTATE_ZENABLE , TRUE );		
			gD->mD3DD2->SetRenderState( D3DRENDERSTATE_SRCBLEND , D3DBLEND_SRCALPHA);
			gD->mD3DD2->SetRenderState( D3DRENDERSTATE_DESTBLEND , D3DBLEND_INVSRCALPHA);

			#define SPRING1 0.1f		// k
			#define SPRING2 0.85f		// damp
			#define SPRING3 0.5f		// kick

			if (bar!=GetMusicPos()/2)
			{
				bar=GetMusicPos()/2;
				int b=bar&63;
				int bs=0;
				int tr=0;
				for (int c1=0;c1<29;c1++) if (basstrack[c1][0]==b)
				{
					bs=basstrack[c1][1];
					tr=basstrack[c1][2];
					break;
				}
				tr-=bs*0.3;
				if (tr<0) tr=0;

				if (tr)
				{
					treblev=SPRING3*tr/10.f;
				}
				if (bs)
				{
					bassv=SPRING3*bs/15.f;
				}
			}



			bass+=bassv*dt;
			treble+=treblev*dt;
			bassv-=SPRING1*bass*dt;
			treblev-=SPRING1*treble*dt;
			bassv*=pow(SPRING2,dt);
			treblev*=pow(SPRING2,dt);
							
			t=t+dt;
			myscn.Interpolate(t*0.3*0.5,23);
			myscn.Light(25);
			
			normalo->Add1(basso,bass);
			normalo->Add2(trebleo,treble);

			/*
			myscn.cam[0].ipos.posn.Z=0;
			myscn.cam[0].ipos.posn.X=sin(t*0.01)*100;
			myscn.cam[0].ipos.posn.Y=cos(t*0.01)*100;
			myscn.cam[0].ipos.axes.MakeZRot(t*0.01);
			*/

			myscn.Draw(&myscn.cam[0].ipos);

			gD->mD3DD2->SetRenderState( D3DRENDERSTATE_ZENABLE , FALSE );
			//Degrade(noisetex);						
			gD->mD3DD2->SetRenderState( D3DRENDERSTATE_SRCBLEND , D3DBLEND_ONE);
			gD->mD3DD2->SetRenderState( D3DRENDERSTATE_DESTBLEND , D3DBLEND_ONE);

			int br=GetMusicPos()/SPEED;
			static int moose=0;
			static int cr=0;
			static float fl=0;
			
			if ((br>=18*4 && br<32*4))
			{
				
				if (!moose)
				{
					moose=1;
					fl=1.f;
				}
				fl=1.2+0.7*sin(t*0.02);
				ObjStub *o=myscn.Findobj("box01");
				LgtStub *l=myscn.Findlgt("sun_1");
				if (o && l) o->Drawflare(&myscn.cam[0].ipos,l->ipos.posn,fl);

				o=myscn.Findobj("box03");
				l=myscn.Findlgt("sun_02");
				if (o && l) o->Drawflare(&myscn.cam[0].ipos,l->ipos.posn,fl);

				gD->PollSound();

			}
			fl*=pow(0.999,dt);

			if (br>=25*4-2 && cr==0)
			{
				bt=-1.7;
				cr=1;

			}
			if (br>=25*4 && cr==1)
			{
				cr=2;
				credits();
			}


			//gD->mD3DD2->SetRenderState( D3DRENDERSTATE_ZENABLE , TRUE );		
			
			
			//myscn.DrawL(&myscn.cam[0].ipos);


			//gD->mD3DD2->SetRenderState( D3DRENDERSTATE_ZENABLE , FALSE );

			// scroll the fucking texture
			ObjStub *obj=myscn.Findobj("normal");
			ObjTV *vv=normalo->tv;		
			for (int c1=0;c1<obj->numtv;c1++,vv++) 
			{
				vv->u-=dt*0.0031;		
			}
			
			
			if (cr==2)
				Bendtext(victex, -4 -5,-2 + 3,4 -5 ,2+ 3, 12, (br>39*4)?0:0.5);

			
			dt=vidframeburn() * 0.001;

			if (br<32*4) gD->PollSound();
			static int bbr=0;
			if (GetMusicPos()/SPEED>45*4-2 && !bbr)
			{
				bbr=1;
				bt=-1.7;
			}

		} while (!gQuit && GetMusicPos()/SPEED<45*4);
	}

	volball();	
	silhou();	
	clouds();
	bt=-0.2;
	outtro();
	bt=-0.2;
	lhlogo();
	exitshit();

	unloadvid();
	delete hearttex[0];
	delete hearttex[1];
	delete hearttex[2];
	delete noisetex;	

	killzoom();
	v_deinit();
}








/*
HANDLE garbagemutex=CreateMutex(NULL,FALSE,NULL);
HANDLE execmutex=CreateMutex(NULL,FALSE,NULL); 


WaitForSingleObject( hIOMutex, INFINITE );
fseek( fp, desired_position, 0L );
fwrite( data, sizeof( data ), 1, fp );
ReleaseMutex( hIOMutex);

struct garbageentry
{
	void (proc)();
	garbageentry *next;
};

void garbage(void proc())
{
	
}

void execute(void proc())
{
	
}

void mainproc()
{

}
*/