#include "common.h"
#include "mpeg.h"
#include <vfw.h>

HRESULT hr;
int blockalign;
int vfr,afr;
int wid,hgt;
int FRATE;
AVISTREAMINFO strhdr;
PAVIFILE pfile = NULL;
PAVISTREAM ps = NULL, psCompressed = NULL, psAudio=NULL;
AVICOMPRESSOPTIONS opts;
AVICOMPRESSOPTIONS FAR * aopts[1] = {&opts};
int inited=0;	

int initavi(int xwid, int xhgt, int fps, char *fname)
{
	if (inited) closeavi();
	wid=xwid;
	hgt=xhgt;
	FRATE=fps;

	int i;
	
	WORD wVer;

	BITMAPINFO format={{sizeof(BITMAPINFO),wid,hgt,1,24,BI_RGB,wid*hgt*3,0,0,0,0}};
	WAVEFORMATEX sformat={WAVE_FORMAT_PCM,MP3CHANS,MP3MIXRATE,MP3MIXRATE*2*MP3CHANS,2*MP3CHANS,16,0};

	/* first let's make sure we are running on 1.1 */
	wVer = HIWORD(VideoForWindowsVersion());
	if (wVer < 0x010a){
		 /* oops, we are too old, blow out of here */
		MessageBeep(MB_ICONHAND);
		MessageBox(NULL, "VideoForWindows too old", "error", MB_OK|MB_ICONSTOP);
		goto error;
	}

	AVIFileInit();

	
	//
	// Open the movie file for writing....
	//
	
	hr = AVIFileOpen(&pfile,		    // returned file pointer
		       fname,		            // file name
		       OF_WRITE | OF_CREATE,	    // mode to open file with
		       NULL);			    // use handler determined
						    // from file extension....
	if (hr != AVIERR_OK)
		goto error;

	// Fill in the header for the video stream....
	_fmemset(&strhdr, 0, sizeof(strhdr));
	strhdr.fccType                = streamtypeVIDEO;// stream type
	strhdr.fccHandler             = 0;
	strhdr.dwScale                = 1;
	strhdr.dwRate                 = FRATE;		    // 25 fps
	strhdr.dwSuggestedBufferSize  = 0;//format.bmiHeader.biSizeImage;
	strhdr.dwQuality= -1;
	SetRect(&strhdr.rcFrame, 0, 0,		    // rectangle for stream
	    (int) format.bmiHeader.biWidth,
	    (int) format.bmiHeader.biHeight);

	// And create the stream;
	hr = AVIFileCreateStream(pfile,		    // file pointer
			         &ps,		    // returned stream pointer
			         &strhdr);	    // stream header
	if (hr != AVIERR_OK) {
		goto error;
	}

	_fmemset(&opts, 0, sizeof(opts));
	
	if (!AVISaveOptions(NULL,ICMF_CHOOSE_KEYFRAME|ICMF_CHOOSE_DATARATE , 1, &ps, (LPAVICOMPRESSOPTIONS FAR *) &aopts))
	    goto error;

	hr = AVIMakeCompressedStream(&psCompressed, ps, &opts, NULL);
	if (hr != AVIERR_OK) {
		goto error;
	}
	
	hr = AVIStreamSetFormat(psCompressed, 0,
			       &format,	    // stream format
			       sizeof(format));
	if (hr != AVIERR_OK) {
	goto error;
	}
	
	
	// audio part

	_fmemset(&strhdr, 0, sizeof(strhdr));
	strhdr.fccType                = streamtypeAUDIO;// stream type
	strhdr.fccHandler             = 0;
	strhdr.dwScale                = blockalign=sformat.nBlockAlign;
	strhdr.dwRate                 = MP3MIXRATE*2*MP3CHANS;		    // 25 fps
	strhdr.dwSuggestedBufferSize  = MP3MIXRATE*2*MP3CHANS;//format.bmiHeader.biSizeImage;
	//strhdr.dwQuality= -1;
	strhdr.wPriority				= 7;
	
	strhdr.dwInitialFrames = 0.75 * MP3MIXRATE;
	strhdr.dwSampleSize = sformat.nBlockAlign;
	// And create the stream;
	hr = AVIFileCreateStream(pfile,		    // file pointer
			         &psAudio,		    // returned stream pointer
			         &strhdr);	    // stream header
	if (hr != AVIERR_OK) {
		goto error;
	}

	hr = AVIStreamSetFormat(psAudio, 0,
			       &sformat,	    // stream format
			       sizeof(sformat));
	if (hr != AVIERR_OK) {
	goto error;
	}

	// end of audio
	
	vfr=afr=0;
	inited=1;
	return 0;
error:
	closeavi(1);
	return -1;
}

void closeavi(int error)
{
	inited=0;
	if (psAudio)
		AVIStreamClose(psAudio);


	if (ps)
		AVIStreamClose(ps);

	if (psCompressed)
		AVIStreamClose(psCompressed);

	if (pfile)
		AVIFileClose(pfile);

	psAudio=ps=psCompressed=NULL;
	pfile=NULL;
	AVIFileExit();
	char str[128];
	sprintf(str,"error %08x (%d)",hr,hr);
	if (error) MessageBox(NULL, "VideoForWindows error", str, MB_OK|MB_ICONSTOP);	
}

int writeavivideo(void *data)
{
	if (!inited) return 0;
	hr = AVIStreamWrite(psCompressed,	// stream pointer
			vfr,				// time of this frame
			1,				// number to write
			data,wid*hgt*3,//data,size,
			0,//AVIIF_KEYFRAME,//key?AVIIF_KEYFRAME:0,			 // flags....
			NULL,
			NULL);
		if (hr != AVIERR_OK) closeavi(1);
		vfr++;
		return 0;
}

int writeaviaudio(void *data, CD3D *it)
{
	int len=((vfr+1)*MP3MIXRATE)/FRATE-afr;
	if (!inited) return 0;
	it->WriteSound((char*)data,len*blockalign);
	hr = AVIStreamWrite(psAudio,	// stream pointer
			afr,				// time of this frame
			len,				// number to write
			data,len*blockalign,//data,size,
			0,//key?AVIIF_KEYFRAME:0,			 // flags....
			NULL,
			NULL);
	if (hr != AVIERR_OK) closeavi(1);
	afr+=len;
	return 0;
}

