#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <time.h>
#include <math.h>
#include "vbe.h"
#include "fixed.h"

#define			PI		3.1415926535897932384626433832795

#define			WIDTH		320
#define			HEIGHT		200

LPVBECLS		lpVBE;
int			vbe_ver;
unsigned long		video_lfb;
int			video_page;
int			frame		= 0;
long *			back;
long *			texture;
float			TS		= 7.0f;

clock_t			full_time;

inline fixed bilinear( fixed v0, fixed v1, fixed v2, fixed v3, fixed fu, fixed fv )
{
	v0 += FixMul( v2 - v0, fv );
	v1 += FixMul( v3 - v1, fv );
	v0 += FixMul( v1 - v0, fu );
	return v0;
}

void rotate_texture( float angle )
{
	long *	p;
	int	x, y, i;
	fixed	c0, c1, c2, c3;
	fixed	inv_h, inv_w, fu, fv, u, v;
	fixed	du0, du1, dv0, dv1, du, dv;
	fixed	u0, v0, u1, v1, u2, v2, u3, v3;

	u0 = FLT_FIX( cos( angle - PI / 4 ) * TS + 127.5f );
	v0 = FLT_FIX( sin( angle - PI / 4 ) * TS + 127.5f );
	u1 = FLT_FIX( cos( angle + PI / 4 ) * TS + 127.5f );
	v1 = FLT_FIX( sin( angle + PI / 4 ) * TS + 127.5f );
	u2 = FLT_FIX( cos( angle - PI + PI / 4 ) * TS + 127.5f );
	v2 = FLT_FIX( sin( angle - PI + PI / 4 ) * TS + 127.5f );
	u3 = FLT_FIX( cos( angle - PI - PI / 4 ) * TS + 127.5f );
	v3 = FLT_FIX( sin( angle - PI - PI / 4 ) * TS + 127.5f );

	inv_h = FixDiv( INT_FIX( 1 ), HEIGHT << 16 );
	inv_w = FixDiv( INT_FIX( 1 ), WIDTH << 16 );
	du0 = FixMul( u2 - u0, inv_h );
	dv0 = FixMul( v2 - v0, inv_h );
	du1 = FixMul( u3 - u1, inv_h );
	dv1 = FixMul( v3 - v1, inv_h );
	du = FixMul( u1 - u0, inv_w );
	dv = FixMul( v1 - v0, inv_w );

	p = back;
	for ( y = 0; y < HEIGHT; y++ ) {
		u = u0;
		v = v0;
		for ( x = 0; x < WIDTH; x++ ) {
			fixed	r0, g0, b0;
			fixed	r1, g1, b1;
			fixed	r2, g2, b2;
			fixed	r3, g3, b3;

			// bicubic filter
			fu = FixBicubic( u & 0x0000ffff );
			fv = FixBicubic( v & 0x0000ffff );

			// bilinear filter
/*			fu = u & 0x0000ffff;
			fv = v & 0x0000ffff;*/

			i = ((v >> 8) & 0xff00) + (u >> 16);

			c0 = texture[i];
			c1 = texture[i + 1];
			c2 = texture[i + 256];
			c3 = texture[i + 257];

			r0 = c0 & 0xff0000;
			r1 = c1 & 0xff0000;
			r2 = c2 & 0xff0000;
			r3 = c3 & 0xff0000;
			r0 = bilinear( r0, r1, r2, r3, fu, fv );

			g0 = c0 & 0x00ff00;
			g1 = c1 & 0x00ff00;
			g2 = c2 & 0x00ff00;
			g3 = c3 & 0x00ff00;
			g0 = bilinear( g0, g1, g2, g3, fu, fv );

			b0 = c0 & 0x0000ff;
			b1 = c1 & 0x0000ff;
			b2 = c2 & 0x0000ff;
			b3 = c3 & 0x0000ff;
			b0 = bilinear( b0, b1, b2, b3, fu, fv );

/*			r0 &= 0xc00000;
			g0 &= 0x00c000;
			b0 &= 0x0000c0;*/

/*			__asm {
				mov	edi, [p]
				mov	eax, [r0]
				mov	ebx, [g0]
				mov	edx, [b0]
				mov	ah, bh
				mov	al, dl
				mov	[edi], eax
			}*/
			*p = (r0 & 0xff0000) | (g0 & 0xff00) | b0;

			u += du;
			v += dv;
			p++;
		}
		u0 += du0;
		v0 += dv0;
	}
}

void main( void )
{
	int	i, j;
	float	a = 0.0f;

	vbe_ver = CreateVBEClass( &lpVBE );

	texture = new long [256 * 256];
	for ( int vv = 0; vv < 256; vv++ )
	for ( int uu = 0; uu < 256; uu++ ) {
		texture[(vv << 8) + uu] = ((long)(rand() % 65000) << 16) | (long)(rand() % 65000);
	}

	lpVBE->InitMode( 0x410f, &video_lfb );

	full_time = clock();
	while ( !kbhit() )
	{
		video_page = (lpVBE->GetCurrentPage() ^ 1) * (WIDTH * HEIGHT * 4);
		back = (long *)(video_lfb + video_page);

		rotate_texture( a );

		lpVBE->SwapPages();
//		lpVBE->WaitVSync();

		frame++;
		a += 0.01f;
	}
	full_time = clock() - full_time;
	lpVBE->InitMode( 0, 0 );
	printf( "FPS: %f\n", (float)frame / ((float)full_time / (float)CLOCKS_PER_SEC) );
}
