#include <math.h>
#include "fixed.h"
#include "tri.h"

// for phong shading
#define	PI	3.1415926535897932384626433832795

#define	WIDTH	320
#define	HEIGHT	200

#define	sort_vertices( s0, s1, s2, d0, d1, d2 )			\
	fixed	ty0, ty1, ty2;					\
	ty0 = s0->y;						\
	ty1 = s1->y;						\
	ty2 = s2->y;						\
	if ( ty0 < ty1 ) {					\
		if ( ty0 < ty2 ) {				\
			d0 = s0;				\
			if ( ty1 < ty2 ) {			\
				d1 = s1;			\
				d2 = s2;			\
			} else {	/* ty1 > ty2 */		\
				d1 = s2;			\
				d2 = s1;			\
			}					\
		} else {		/* ty2 < ty0 */		\
			d0 = s2;				\
			d1 = s0;				\
			d2 = s1;				\
		}						\
	} else {			/* ty0 > ty1 */		\
		if ( ty1 < ty2 ) {				\
			d0 = s1;				\
			if ( ty2 < ty0 ) {			\
				d1 = s2;			\
				d2 = s0;			\
			} else {	/* ty2 > ty0 */		\
				d1 = s0;			\
				d2 = s2;			\
			}					\
		} else {		/* ty1 > ty2 */		\
			d0 = s2;				\
			d1 = s1;				\
			d2 = s0;				\
		}						\
	}

long *		tri_back;
fixed *		tri_zbuff;
long *		tri_texture;
fixed *		tri_phong_map;

int		tri_clip_x0	= 1;
int		tri_clip_y0	= 1;
int		tri_clip_x1	= 319;
int		tri_clip_y1	= 199;

void tri_init( void )
{
	int	i, j;
	float	amp = 0.8f;

	// generate phong map
	tri_phong_map = new fixed [256 * 256];
	for ( i = 0; i < 256; i++ )
	for ( j = 0; j < 256; j++ )
	tri_phong_map[(j << 8) + i] = FLT_FIX( amp * pow( sin( i * PI / 256 ) *
							  sin( j * PI / 256 ), 4 ) );
}

void tri_set_back( long *back )
{
	tri_back = back;
}

void tri_set_zbuff( fixed *zbuff )
{
	tri_zbuff = zbuff;
}

void tri_set_texture( long *texture )
{
	tri_texture = texture;
}

void tri_set_clip( int x0, int y0, int x1, int y1 )
{
	tri_clip_x0 = x0;
	tri_clip_y0 = y0;
	tri_clip_x1 = x1;
	tri_clip_y1 = y1;
}

long bilinear_phong( fixed pu, fixed pv, fixed tu, fixed tv )
{
	fixed	fu, fv, l, ll;
	long	c0, c1, c2, c3, i;
	fixed	rr0, rr1, rr2, rr3;
	fixed	gg0, gg1, gg2, gg3;
	fixed	bb0, bb1, bb2, bb3;
	fixed	rv0, rv1, ru;
	fixed	gv0, gv1, gu;
	fixed	bv0, bv1, bu;

	// texture map
	fu = tu & 0x0000ffff;
	fv = tv & 0x0000ffff;
	i = ((tv >> 8) & 0xff00) + (tu >> 16);
	c0 = tri_texture[i];
	c1 = tri_texture[i + 1];
	c2 = tri_texture[i + 256];
	c3 = tri_texture[i + 257];
	rr0 = c0 & 0xff0000;
	gg0 = c0 & 0x00ff00;
	bb0 = c0 & 0x0000ff;
	rr1 = c1 & 0xff0000;
	gg1 = c1 & 0x00ff00;
	bb1 = c1 & 0x0000ff;
	rr2 = c2 & 0xff0000;
	gg2 = c2 & 0x00ff00;
	bb2 = c2 & 0x0000ff;
	rr3 = c3 & 0xff0000;
	gg3 = c3 & 0x00ff00;
	bb3 = c3 & 0x0000ff;
	rv0 = rr0 + FixMul( rr2 - rr0, fv );
	rv1 = rr1 + FixMul( rr3 - rr1, fv );
	ru  = rv0 + FixMul( rv1 - rv0, fu );
	gv0 = gg0 + FixMul( gg2 - gg0, fv );
	gv1 = gg1 + FixMul( gg3 - gg1, fv );
	gu  = gv0 + FixMul( gv1 - gv0, fu );
	bv0 = bb0 + FixMul( bb2 - bb0, fv );
	bv1 = bb1 + FixMul( bb3 - bb1, fv );
	bu  = bv0 + FixMul( bv1 - bv0, fu );
	gu <<= 8;
	bu <<= 16;

	// phong map
	l = tri_phong_map[((pv >> 8) & 0xff00) + (pu >> 16)];
	ll = l << 8;

/*	ru = (ru >> 1) + (ll >> 1);
	gu = (gu >> 1) + (ll >> 1);
	bu = (bu >> 1) + (ll >> 1);
	ru = FixMul( ru, l );
	gu = FixMul( gu, l );
	bu = FixMul( bu, l );*/

	ru += ll;
	gu += ll;
	bu += ll;
	ru += INT_FIX( 100 );	// ambience
	gu += INT_FIX( 100 );
	bu += INT_FIX( 100 );
	ru = FixMul( ru, l );
	gu = FixMul( gu, l );
	bu = FixMul( bu, l );

	if ( ru > 0xff0000 ) ru = 0xff0000;
	if ( gu > 0xff0000 ) gu = 0xff0000;
	if ( bu > 0xff0000 ) bu = 0xff0000;
	return (FIX_INT( ru ) << 16) | (FIX_INT( gu ) << 8) | FIX_INT( bu );
}

inline void inner_z_texbl_phong( long *p, fixed *z,
	fixed x0, fixed x1, fixed z0, fixed z1,
	fixed pu0, fixed pu1, fixed pv0, fixed pv1,
	fixed tu0, fixed tu1, fixed tv0, fixed tv1 )
{
	fixed	length, clip_l;
	fixed	dx, dz, pdu, pdv, tdu, tdv, x0c, x1c, x0ic;

	x0c = FixCeil( x0 );
	x1c = FixCeil( x1 );

	// clip
	if ( FIX_INT( x1c ) < tri_clip_x0 ) return;
	if ( FIX_INT( x0c ) > tri_clip_x1 ) return;

	length = FixCeil( x1 ) - x0c;
	if ( !length ) return;

	x0ic = FIX_INT( x0c );
	p += x0ic;
	z += x0ic;

	dx = FixDiv( INT_FIX( 1 ), x1 - x0 );
	dz = FixMul( z1 - z0, dx );
	pdu = FixMul( pu1 - pu0, dx );
	pdv = FixMul( pv1 - pv0, dx );
	tdu = FixMul( tu1 - tu0, dx );
	tdv = FixMul( tv1 - tv0, dx );

	// sub-texel accuracy
	dx = x0c - x0;
	z0 += FixMul( dz, dx );
	pu0 += FixMul( pdu, dx );
	pv0 += FixMul( pdv, dx );
	tu0 += FixMul( tdu, dx );
	tv0 += FixMul( tdv, dx );

	length = FIX_INT( length );

	// clip
	if ( FIX_INT( x1c ) > tri_clip_x1 ) length -= FIX_INT( x1c ) - tri_clip_x1;
	if ( FIX_INT( x0c ) < tri_clip_x0 ) {
		clip_l = INT_FIX( tri_clip_x0 ) - x0c;
		z0 += FixMul( dz, clip_l );
		pu0 += FixMul( pdu, clip_l );
		pv0 += FixMul( pdv, clip_l );
		tu0 += FixMul( tdu, clip_l );
		tv0 += FixMul( tdv, clip_l );
		p += FIX_INT( clip_l );
		z += FIX_INT( clip_l );
		length -= FIX_INT( clip_l );
	}

	while ( length-- > 0 ) {
		if ( *z < z0 ) {
			*p = bilinear_phong( pu0, pv0, tu0, tv0 );
			*z = z0;
		}
		z0 += dz;
		pu0 += pdu;
		pv0 += pdv;
		tu0 += tdu;
		tv0 += tdv;
		z++;
		p++;
	}
}

void tri_z_texbl_phong( tri_vertex *sv0, tri_vertex *sv1, tri_vertex *sv2 )
{
#define	DO_INC()	xx0 += dx0;	\
			xx1 += dx1;	\
			zz0 += dz0;	\
			zz1 += dz1;	\
			puu0 += pdu0;	\
			puu1 += pdu1;	\
			pvv0 += pdv0;	\
			pvv1 += pdv1;	\
			tuu0 += tdu0;	\
			tuu1 += tdu1;	\
			tvv0 += tdv0;	\
			tvv1 += tdv1;	\
			p += WIDTH;	\
			z += WIDTH;	\
			y++;

	int		y, l;
	long *		p;
	fixed *		z;
	tri_vertex *	v0;
	tri_vertex *	v1;
	tri_vertex *	v2;
	int		clip_y;
	fixed		clip_h;
	fixed		y0c, y1c, y2c;
	fixed		y2_y0, y1_y0, y2_y1, y0c_y0, y1c_y1;
	fixed		xx0, xx1, zz0, zz1, ss0, ss1;
	fixed		dx0, dx1, dz0, dz1, ds0, ds1;
	fixed		puu0, puu1, pvv0, pvv1;
	fixed		pdu0, pdu1, pdv0, pdv1;
	fixed		tuu0, tuu1, tvv0, tvv1;
	fixed		tdu0, tdu1, tdv0, tdv1;

	sort_vertices( sv0, sv1, sv2, v0, v1, v2 );

	y0c = FixCeil( v0->y );
	y1c = FixCeil( v1->y );
	y2c = FixCeil( v2->y );

	// clip all
	if ( FIX_INT( y0c ) > tri_clip_y1 ) return;
	if ( FIX_INT( y2c ) < tri_clip_y0 ) return;
	if ( y2c <= y0c ) return;

	y = FIX_INT( y0c );
	l = y * WIDTH;
	p = tri_back + l;
	z = tri_zbuff + l;

	y2_y0 = FixDiv( INT_FIX( 1 ), v2->y - v0->y );
	dx0 = FixMul( v2->x - v0->x, y2_y0 );
	dz0 = FixMul( v2->z - v0->z, y2_y0 );
	pdu0 = FixMul( v2->pu - v0->pu, y2_y0 );
	pdv0 = FixMul( v2->pv - v0->pv, y2_y0 );
	tdu0 = FixMul( v2->tu - v0->tu, y2_y0 );
	tdv0 = FixMul( v2->tv - v0->tv, y2_y0 );

	// sub-pixel accuracy
	y0c_y0 = y0c - v0->y;
	xx0 = v0->x + FixMul( dx0, y0c_y0 );
	zz0 = v0->z + FixMul( dz0, y0c_y0 );
	puu0 = v0->pu + FixMul( pdu0, y0c_y0 );
	pvv0 = v0->pv + FixMul( pdv0, y0c_y0 );
	tuu0 = v0->tu + FixMul( tdu0, y0c_y0 );
	tvv0 = v0->tv + FixMul( tdv0, y0c_y0 );

	// clip y0
	if ( FIX_INT( y0c ) < tri_clip_y0 ) {
		clip_h = INT_FIX( tri_clip_y0 ) - y0c;
		xx0 += FixMul( dx0, clip_h );
		zz0 += FixMul( dz0, clip_h );
		puu0 += FixMul( pdu0, clip_h );
		pvv0 += FixMul( pdv0, clip_h );
		tuu0 += FixMul( tdu0, clip_h );
		tvv0 += FixMul( tdv0, clip_h );
		y += FIX_INT( clip_h );
		p += FIX_INT( clip_h ) * WIDTH;
		z += FIX_INT( clip_h ) * WIDTH;
	}

	if ( y0c < y1c ) {
		// clip y1
		clip_y = FIX_INT( y1c );
		if ( FIX_INT( y1c ) > tri_clip_y1 ) clip_y = tri_clip_y1;

		y1_y0 = FixDiv( INT_FIX( 1 ), v1->y - v0->y );
		dx1 = FixMul( v1->x - v0->x, y1_y0 );
		dz1 = FixMul( v1->z - v0->z, y1_y0 );
		pdu1 = FixMul( v1->pu - v0->pu, y1_y0 );
		pdv1 = FixMul( v1->pv - v0->pv, y1_y0 );
		tdu1 = FixMul( v1->tu - v0->tu, y1_y0 );
		tdv1 = FixMul( v1->tv - v0->tv, y1_y0 );

		// sub-pixel accuracy
		xx1 = v0->x + FixMul( dx1, y0c_y0 );
		zz1 = v0->z + FixMul( dz1, y0c_y0 );
		puu1 = v0->pu + FixMul( pdu1, y0c_y0 );
		pvv1 = v0->pv + FixMul( pdv1, y0c_y0 );
		tuu1 = v0->tu + FixMul( tdu1, y0c_y0 );
		tvv1 = v0->tv + FixMul( tdv1, y0c_y0 );

		// clip y0
		if ( FIX_INT( y0c ) < tri_clip_y0 ) {
			clip_h = INT_FIX( tri_clip_y0 ) - y0c;
			xx1 += FixMul( dx1, clip_h );
			zz1 += FixMul( dz1, clip_h );
			puu1 += FixMul( pdu1, clip_h );
			pvv1 += FixMul( pdv1, clip_h );
			tuu1 += FixMul( tdu1, clip_h );
			tvv1 += FixMul( tdv1, clip_h );
		}

		if ( dx0 < dx1 ) {
			while ( y < clip_y ) {
				inner_z_texbl_phong( p, z,
					xx0, xx1, zz0, zz1,
					puu0, puu1, pvv0, pvv1,
					tuu0, tuu1, tvv0, tvv1 );
				DO_INC();
			}
		} else {
			while ( y < clip_y ) {
				inner_z_texbl_phong( p, z,
					xx1, xx0, zz1, zz0,
					puu1, puu0, pvv1, pvv0,
					tuu1, tuu0, tvv1, tvv0 );
				DO_INC();
			}
		}
	}

	// clip bottom
	if ( FIX_INT( y1c ) > tri_clip_y1 ) return;
	if ( y2c <= y1c ) return;

	// clip y1
	clip_y = FIX_INT( y2c );
	if ( FIX_INT( y2c ) > tri_clip_y1 ) clip_y = tri_clip_y1;

	y2_y1 = FixDiv( INT_FIX( 1 ), v2->y - v1->y );
	dx1 = FixMul( v2->x - v1->x, y2_y1 );
	dz1 = FixMul( v2->z - v1->z, y2_y1 );
	pdu1 = FixMul( v2->pu - v1->pu, y2_y1 );
	pdv1 = FixMul( v2->pv - v1->pv, y2_y1 );
	tdu1 = FixMul( v2->tu - v1->tu, y2_y1 );
	tdv1 = FixMul( v2->tv - v1->tv, y2_y1 );

	// sub-pixel accuracy
	y1c_y1 = y1c - v1->y;
	xx1 = v1->x + FixMul( dx1, y1c_y1 );
	zz1 = v1->z + FixMul( dz1, y1c_y1 );
	puu1 = v1->pu + FixMul( pdu1, y1c_y1 );
	pvv1 = v1->pv + FixMul( pdv1, y1c_y1 );
	tuu1 = v1->tu + FixMul( tdu1, y1c_y1 );
	tvv1 = v1->tv + FixMul( tdv1, y1c_y1 );

	// clip y0
	if ( FIX_INT( y1c ) < tri_clip_y0 ) {
		clip_h = INT_FIX( tri_clip_y0 ) - y1c;
		xx1 += FixMul( dx1, clip_h );
		zz1 += FixMul( dz1, clip_h );
		puu1 += FixMul( pdu1, clip_h );
		pvv1 += FixMul( pdv1, clip_h );
		tuu1 += FixMul( tdu1, clip_h );
		tvv1 += FixMul( tdv1, clip_h );
	}

	if ( xx0 < xx1 ) {
		while ( y < clip_y ) {
			inner_z_texbl_phong( p, z,
				xx0, xx1, zz0, zz1,
				puu0, puu1, pvv0, pvv1,
				tuu0, tuu1, tvv0, tvv1 );
			DO_INC();
		}
	} else {
		while ( y < clip_y ) {
			inner_z_texbl_phong( p, z,
				xx1, xx0, zz1, zz0,
				puu1, puu0, pvv1, pvv0,
				tuu1, tuu0, tvv1, tvv0 );
			DO_INC();
		}
	}
#undef	DO_INC
}
