#include <string.h>

#define	WIDTH	320
#define	HEIGHT	200

// Proportional thick ~8x8 font

unsigned char font_Police[256][8] = {
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
  { 0x7E, 0x81, 0xA5, 0x81, 0xBD, 0x99, 0x81, 0x7E },
  { 0x7E, 0xFF, 0xDB, 0xFF, 0xC3, 0xE7, 0xFF, 0x7E },
  { 0x6C, 0xFE, 0xFE, 0xFE, 0x7C, 0x38, 0x10, 0x00 },
  { 0x10, 0x38, 0x7C, 0xFE, 0x7C, 0x38, 0x10, 0x00 },
  { 0x38, 0x7C, 0x38, 0xFE, 0xFE, 0x7C, 0x38, 0x7C },
  { 0x10, 0x10, 0x38, 0x7C, 0xFE, 0x7C, 0x38, 0x7C },
  { 0x00, 0x00, 0x18, 0x3C, 0x3C, 0x18, 0x00, 0x00 },
  { 0xFF, 0xFF, 0xE7, 0xC3, 0xC3, 0xE7, 0xFF, 0xFF },
  { 0x00, 0x3C, 0x66, 0x42, 0x42, 0x66, 0x3C, 0x00 },
  { 0xFF, 0xC3, 0x99, 0xBD, 0xBD, 0x99, 0xC3, 0xFF },
  { 0x0F, 0x07, 0x0F, 0x7D, 0xCC, 0xCC, 0xCC, 0x78 },
  { 0x3C, 0x66, 0x66, 0x66, 0x3C, 0x18, 0x7E, 0x18 },
  { 0x3F, 0x33, 0x3F, 0x30, 0x30, 0x70, 0xF0, 0xE0 },
  { 0x7F, 0x63, 0x7F, 0x63, 0x63, 0x67, 0xE6, 0xC0 },
  { 0x99, 0x5A, 0x3C, 0xE7, 0xE7, 0x3C, 0x5A, 0x99 },
  { 0x80, 0xE0, 0xF8, 0xFE, 0xF8, 0xE0, 0x80, 0x00 },
  { 0x02, 0x0E, 0x3E, 0xFE, 0x3E, 0x0E, 0x02, 0x00 },
  { 0x18, 0x3C, 0x7E, 0x18, 0x18, 0x7E, 0x3C, 0x18 },
  { 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x66, 0x00 },
  { 0x7F, 0xDB, 0xDB, 0x7B, 0x1B, 0x1B, 0x1B, 0x00 },
  { 0x3E, 0x63, 0x38, 0x6C, 0x6C, 0x38, 0xCC, 0x78 },
  { 0x00, 0x00, 0x00, 0x00, 0x7E, 0x7E, 0x7E, 0x00 },
  { 0x18, 0x3C, 0x7E, 0x18, 0x7E, 0x3C, 0x18, 0xFF },
  { 0x18, 0x3C, 0x7E, 0x18, 0x18, 0x18, 0x18, 0x00 },
  { 0x18, 0x18, 0x18, 0x18, 0x7E, 0x3C, 0x18, 0x00 },
  { 0x00, 0x18, 0x0C, 0xFE, 0x0C, 0x18, 0x00, 0x00 },
  { 0x00, 0x30, 0x60, 0xFE, 0x60, 0x30, 0x00, 0x00 },
  { 0x00, 0x00, 0xC0, 0xC0, 0xC0, 0xFE, 0x00, 0x00 },
  { 0x00, 0x24, 0x66, 0xFF, 0x66, 0x24, 0x00, 0x00 },
  { 0x00, 0x18, 0x3C, 0x7E, 0xFF, 0xFF, 0x00, 0x00 },
  { 0x00, 0xFF, 0xFF, 0x7E, 0x3C, 0x18, 0x00, 0x00 },
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
  { 0x60, 0xF0, 0xF0, 0xF0, 0x60, 0x00, 0x60, 0x00 },
  { 0xD8, 0xD8, 0xD8, 0x00, 0x00, 0x00, 0x00, 0x00 },
  { 0x6C, 0x6C, 0xFE, 0x6C, 0xFE, 0x6C, 0x6C, 0x00 },
  { 0x30, 0x7C, 0xC0, 0x78, 0x0C, 0xF8, 0x30, 0x00 },
  { 0x00, 0xC6, 0xCC, 0x18, 0x30, 0x66, 0xC6, 0x00 },
  { 0x38, 0x6C, 0x38, 0x76, 0xDC, 0xCC, 0x76, 0x00 },
  { 0x60, 0x60, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00 },
  { 0x30, 0x60, 0xC0, 0xC0, 0xC0, 0x60, 0x30, 0x00 },
  { 0xC0, 0x60, 0x30, 0x30, 0x30, 0x60, 0xC0, 0x00 },
  { 0x00, 0x66, 0x3C, 0xFF, 0x3C, 0x66, 0x00, 0x00 },
  { 0x00, 0x30, 0x30, 0xFC, 0x30, 0x30, 0x00, 0x00 },
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x60 },
  { 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00 },
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00 },
  { 0x06, 0x0C, 0x18, 0x30, 0x60, 0xC0, 0x80, 0x00 },
  { 0x7C, 0xC6, 0xCE, 0xDE, 0xF6, 0xE6, 0x7C, 0x00 },
  { 0x30, 0x70, 0x30, 0x30, 0x30, 0x30, 0xFC, 0x00 },
  { 0x78, 0xCC, 0x0C, 0x38, 0x60, 0xCC, 0xFC, 0x00 },
  { 0x78, 0xCC, 0x0C, 0x38, 0x0C, 0xCC, 0x78, 0x00 },
  { 0x1C, 0x3C, 0x6C, 0xCC, 0xFE, 0x0C, 0x1E, 0x00 },
  { 0xFC, 0xC0, 0xF8, 0x0C, 0x0C, 0xCC, 0x78, 0x00 },
  { 0x38, 0x60, 0xC0, 0xF8, 0xCC, 0xCC, 0x78, 0x00 },
  { 0xFC, 0xCC, 0x0C, 0x18, 0x30, 0x30, 0x30, 0x00 },
  { 0x78, 0xCC, 0xCC, 0x78, 0xCC, 0xCC, 0x78, 0x00 },
  { 0x78, 0xCC, 0xCC, 0x7C, 0x0C, 0x18, 0x70, 0x00 },
  { 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0x00 },
  { 0x00, 0x60, 0x60, 0x00, 0x00, 0x60, 0x60, 0xC0 },
  { 0x18, 0x30, 0x60, 0xC0, 0x60, 0x30, 0x18, 0x00 },
  { 0x00, 0x00, 0xFC, 0x00, 0x00, 0xFC, 0x00, 0x00 },
  { 0xC0, 0x60, 0x30, 0x18, 0x30, 0x60, 0xC0, 0x00 },
  { 0x78, 0xCC, 0x0C, 0x18, 0x30, 0x00, 0x30, 0x00 },
  { 0x7C, 0xC6, 0xDE, 0xDE, 0xDE, 0xC0, 0x78, 0x00 },
  { 0x30, 0x78, 0xCC, 0xCC, 0xFC, 0xCC, 0xCC, 0x00 },
  { 0xFC, 0x66, 0x66, 0x7C, 0x66, 0x66, 0xFC, 0x00 },
  { 0x3C, 0x66, 0xC0, 0xC0, 0xC0, 0x66, 0x3C, 0x00 },
  { 0xF0, 0xD8, 0xCC, 0xCC, 0xCC, 0xD8, 0xF0, 0x00 },
  { 0xFC, 0xC0, 0xC0, 0xF0, 0xC0, 0xC0, 0xFC, 0x00 },
  { 0xFC, 0xC0, 0xC0, 0xF0, 0xC0, 0xC0, 0xC0, 0x00 },
  { 0x3C, 0x66, 0xC0, 0xC0, 0xCE, 0x66, 0x3E, 0x00 },
  { 0xCC, 0xCC, 0xCC, 0xFC, 0xCC, 0xCC, 0xCC, 0x00 },
  { 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x00 },
  { 0x0C, 0x0C, 0x0C, 0x0C, 0xCC, 0xCC, 0x78, 0x00 },
  { 0xCC, 0xCC, 0xD8, 0xF0, 0xD8, 0xCC, 0xCC, 0x00 },
  { 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xFC, 0x00 },
  { 0xC6, 0xEE, 0xFE, 0xFE, 0xD6, 0xC6, 0xC6, 0x00 },
  { 0xC6, 0xE6, 0xF6, 0xDE, 0xCE, 0xC6, 0xC6, 0x00 },
  { 0x38, 0x6C, 0xC6, 0xC6, 0xC6, 0x6C, 0x38, 0x00 },
  { 0xF8, 0xCC, 0xCC, 0xF8, 0xC0, 0xC0, 0xC0, 0x00 },
  { 0x78, 0xCC, 0xCC, 0xCC, 0xDC, 0x78, 0x1C, 0x00 },
  { 0xF8, 0xCC, 0xCC, 0xF8, 0xD8, 0xCC, 0xCC, 0x00 },
  { 0x78, 0xCC, 0xE0, 0x70, 0x1C, 0xCC, 0x78, 0x00 },
  { 0xFC, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x00 },
  { 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xFC, 0x00 },
  { 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x78, 0x30, 0x00 },
  { 0xC6, 0xC6, 0xC6, 0xD6, 0xFE, 0xEE, 0xC6, 0x00 },
  { 0xC6, 0xC6, 0x6C, 0x38, 0x38, 0x6C, 0xC6, 0x00 },
  { 0xCC, 0xCC, 0xCC, 0x78, 0x30, 0x30, 0x30, 0x00 },
  { 0xFE, 0x06, 0x0C, 0x18, 0x30, 0x60, 0xFE, 0x00 },
  { 0xF0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xF0, 0x00 },
  { 0xC0, 0x60, 0x30, 0x18, 0x0C, 0x06, 0x02, 0x00 },
  { 0xF0, 0x30, 0x30, 0x30, 0x30, 0x30, 0xF0, 0x00 },
  { 0x10, 0x38, 0x6C, 0xC6, 0x00, 0x00, 0x00, 0x00 },
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF },
  { 0x60, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 },
  { 0x00, 0x00, 0x78, 0x0C, 0x7C, 0xCC, 0x76, 0x00 },
  { 0xE0, 0x60, 0x60, 0x7C, 0x66, 0x66, 0xDC, 0x00 },
  { 0x00, 0x00, 0x78, 0xCC, 0xC0, 0xCC, 0x78, 0x00 },
  { 0x1C, 0x0C, 0x0C, 0x7C, 0xCC, 0xCC, 0x76, 0x00 },
  { 0x00, 0x00, 0x78, 0xCC, 0xFC, 0xC0, 0x78, 0x00 },
  { 0x38, 0x6C, 0x60, 0xF0, 0x60, 0x60, 0xF0, 0x00 },
  { 0x00, 0x00, 0x76, 0xCC, 0xCC, 0x7C, 0x0C, 0xF8 },
  { 0xE0, 0x60, 0x6C, 0x76, 0x66, 0x66, 0xE6, 0x00 },
  { 0x30, 0x00, 0x70, 0x30, 0x30, 0x30, 0x78, 0x00 },
  { 0x0C, 0x00, 0x0C, 0x0C, 0x0C, 0xCC, 0xCC, 0x78 },
  { 0xE0, 0x60, 0x66, 0x6C, 0x78, 0x6C, 0xE6, 0x00 },
  { 0xE0, 0x60, 0x60, 0x60, 0x60, 0x60, 0xF0, 0x00 },
  { 0x00, 0x00, 0xCC, 0xFE, 0xFE, 0xD6, 0xC6, 0x00 },
  { 0x00, 0x00, 0xF8, 0xCC, 0xCC, 0xCC, 0xCC, 0x00 },
  { 0x00, 0x00, 0x78, 0xCC, 0xCC, 0xCC, 0x78, 0x00 },
  { 0x00, 0x00, 0xDC, 0x66, 0x66, 0x7C, 0x60, 0xF0 },
  { 0x00, 0x00, 0x76, 0xCC, 0xCC, 0x7C, 0x0C, 0x1E },
  { 0x00, 0x00, 0xDC, 0x76, 0x66, 0x60, 0xF0, 0x00 },
  { 0x00, 0x00, 0x7C, 0xC0, 0x78, 0x0C, 0xF8, 0x00 },
  { 0x20, 0x60, 0xF8, 0x60, 0x60, 0x68, 0x30, 0x00 },
  { 0x00, 0x00, 0xCC, 0xCC, 0xCC, 0xCC, 0x76, 0x00 },
  { 0x00, 0x00, 0xCC, 0xCC, 0xCC, 0x78, 0x30, 0x00 },
  { 0x00, 0x00, 0xC6, 0xD6, 0xFE, 0xFE, 0x6C, 0x00 },
  { 0x00, 0x00, 0xC6, 0x6C, 0x38, 0x6C, 0xC6, 0x00 },
  { 0x00, 0x00, 0xCC, 0xCC, 0xCC, 0x7C, 0x0C, 0xF8 },
  { 0x00, 0x00, 0xFC, 0x98, 0x30, 0x64, 0xFC, 0x00 },
  { 0x1C, 0x30, 0x30, 0xE0, 0x30, 0x30, 0x1C, 0x00 },
  { 0x60, 0x60, 0x60, 0x00, 0x60, 0x60, 0x60, 0x00 },
  { 0xE0, 0x30, 0x30, 0x1C, 0x30, 0x30, 0xE0, 0x00 },
  { 0x76, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
  { 0x00, 0x10, 0x38, 0x28, 0x6C, 0x44, 0xFE, 0x00 },
  { 0x30, 0x78, 0xCC, 0xCC, 0xFC, 0xCC, 0xCC, 0x00 },
  { 0xF8, 0xC0, 0xC0, 0xF8, 0xCC, 0xCC, 0xF8, 0x00 },
  { 0xF8, 0xCC, 0xCC, 0xF8, 0xCC, 0xCC, 0xF8, 0x00 },
  { 0xFC, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00 },
  { 0x38, 0x6C, 0x6C, 0x6C, 0x6C, 0x6C, 0xFE, 0xC6 },
  { 0xFC, 0xC0, 0xC0, 0xF8, 0xC0, 0xC0, 0xFC, 0x00 },
  { 0xDB, 0xDB, 0x7E, 0x3C, 0x7E, 0xDB, 0xDB, 0x00 },
  { 0x78, 0xCC, 0x0C, 0x38, 0x0C, 0xCC, 0x78, 0x00 },
  { 0xCC, 0xCC, 0xDC, 0xFC, 0xEC, 0xCC, 0xCC, 0x00 },
  { 0x78, 0xCC, 0xDC, 0xFC, 0xEC, 0xCC, 0xCC, 0x00 },
  { 0xCC, 0xD8, 0xF0, 0xE0, 0xF0, 0xD8, 0xCC, 0x00 },
  { 0x3C, 0x6C, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x00 },
  { 0xC6, 0xEE, 0xFE, 0xFE, 0xD6, 0xC6, 0xC6, 0x00 },
  { 0xCC, 0xCC, 0xCC, 0xFC, 0xCC, 0xCC, 0xCC, 0x00 },
  { 0x78, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x78, 0x00 },
  { 0xFC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x00 },
  { 0xF8, 0xCC, 0xCC, 0xCC, 0xF8, 0xC0, 0xC0, 0x00 },
  { 0x78, 0xCC, 0xC0, 0xC0, 0xC0, 0xCC, 0x78, 0x00 },
  { 0xFC, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x00 },
  { 0xCC, 0xCC, 0xCC, 0x7C, 0x0C, 0xCC, 0x78, 0x00 },
  { 0x7E, 0xDB, 0xDB, 0xDB, 0x7E, 0x18, 0x18, 0x00 },
  { 0xCC, 0xCC, 0x78, 0x30, 0x78, 0xCC, 0xCC, 0x00 },
  { 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xFE, 0x06 },
  { 0xCC, 0xCC, 0xCC, 0x7C, 0x0C, 0x0C, 0x0C, 0x00 },
  { 0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xFF, 0x00 },
  { 0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xFF, 0x03 },
  { 0xE0, 0x60, 0x60, 0x7C, 0x66, 0x66, 0x7C, 0x00 },
  { 0xC6, 0xC6, 0xC6, 0xF6, 0xDE, 0xDE, 0xF6, 0x00 },
  { 0xC0, 0xC0, 0xC0, 0xF8, 0xCC, 0xCC, 0xF8, 0x00 },
  { 0x78, 0x8C, 0x06, 0x3E, 0x06, 0x8C, 0x78, 0x00 },
  { 0xCE, 0xDB, 0xDB, 0xFB, 0xDB, 0xDB, 0xCE, 0x00 },
  { 0x7C, 0xCC, 0xCC, 0xCC, 0x7C, 0x6C, 0xCC, 0x00 },
  { 0x00, 0x00, 0x78, 0x0C, 0x7C, 0xCC, 0x76, 0x00 },
  { 0x00, 0x78, 0xC0, 0x78, 0xCC, 0xCC, 0x78, 0x00 },
  { 0x00, 0x00, 0xF8, 0xCC, 0xF8, 0xCC, 0xF8, 0x00 },
  { 0x00, 0x00, 0xFC, 0xC0, 0xC0, 0xC0, 0xC0, 0x00 },
  { 0x00, 0x00, 0x3C, 0x6C, 0x6C, 0x6C, 0xFE, 0xC6 },
  { 0x00, 0x00, 0x78, 0xCC, 0xFC, 0xC0, 0x78, 0x00 },
  { 0x00, 0x00, 0xDB, 0x7E, 0x3C, 0x7E, 0xDB, 0x00 },
  { 0x00, 0x00, 0x78, 0xCC, 0x18, 0xCC, 0x78, 0x00 },
  { 0x00, 0x00, 0xCC, 0xDC, 0xFC, 0xEC, 0xCC, 0x00 },
  { 0x00, 0x30, 0xCC, 0xDC, 0xFC, 0xEC, 0xCC, 0x00 },
  { 0x00, 0x00, 0xCC, 0xD8, 0xF0, 0xD8, 0xCC, 0x00 },
  { 0x00, 0x00, 0x3C, 0x6C, 0xCC, 0xCC, 0xCC, 0x00 },
  { 0x00, 0x00, 0xC6, 0xFE, 0xFE, 0xD6, 0xC6, 0x00 },
  { 0x00, 0x00, 0xCC, 0xCC, 0xFC, 0xCC, 0xCC, 0x00 },
  { 0x00, 0x00, 0x78, 0xCC, 0xCC, 0xCC, 0x78, 0x00 },
  { 0x00, 0x00, 0xFC, 0xCC, 0xCC, 0xCC, 0xCC, 0x00 },
  { 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88 },
  { 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA },
  { 0xDB, 0xF6, 0xDB, 0x6F, 0xDB, 0x7E, 0xD7, 0xED },
  { 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18 },
  { 0x18, 0x18, 0x18, 0x18, 0xF8, 0x18, 0x18, 0x18 },
  { 0x18, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x18, 0x18 },
  { 0x36, 0x36, 0x36, 0x36, 0xF6, 0x36, 0x36, 0x36 },
  { 0x00, 0x00, 0x00, 0x00, 0xFE, 0x36, 0x36, 0x36 },
  { 0x00, 0x00, 0xF8, 0x18, 0xF8, 0x18, 0x18, 0x18 },
  { 0x36, 0x36, 0xF6, 0x06, 0xF6, 0x36, 0x36, 0x36 },
  { 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36 },
  { 0x00, 0x00, 0xFE, 0x06, 0xF6, 0x36, 0x36, 0x36 },
  { 0x36, 0x36, 0xF6, 0x06, 0xFE, 0x00, 0x00, 0x00 },
  { 0x36, 0x36, 0x36, 0x36, 0xFE, 0x00, 0x00, 0x00 },
  { 0x18, 0x18, 0xF8, 0x18, 0xF8, 0x00, 0x00, 0x00 },
  { 0x00, 0x00, 0x00, 0x00, 0xF8, 0x18, 0x18, 0x18 },
  { 0x18, 0x18, 0x18, 0x18, 0x1F, 0x00, 0x00, 0x00 },
  { 0x18, 0x18, 0x18, 0x18, 0xFF, 0x00, 0x00, 0x00 },
  { 0x00, 0x00, 0x00, 0x00, 0xFF, 0x18, 0x18, 0x18 },
  { 0x18, 0x18, 0x18, 0x18, 0x1F, 0x18, 0x18, 0x18 },
  { 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00 },
  { 0x18, 0x18, 0x18, 0x18, 0xFF, 0x18, 0x18, 0x18 },
  { 0x18, 0x18, 0x1F, 0x18, 0x1F, 0x18, 0x18, 0x18 },
  { 0x36, 0x36, 0x36, 0x36, 0x37, 0x36, 0x36, 0x36 },
  { 0x36, 0x36, 0x37, 0x30, 0x3F, 0x00, 0x00, 0x00 },
  { 0x00, 0x00, 0x3F, 0x30, 0x37, 0x36, 0x36, 0x36 },
  { 0x36, 0x36, 0xF7, 0x00, 0xFF, 0x00, 0x00, 0x00 },
  { 0x00, 0x00, 0xFF, 0x00, 0xF7, 0x36, 0x36, 0x36 },
  { 0x36, 0x36, 0x37, 0x30, 0x37, 0x36, 0x36, 0x36 },
  { 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00 },
  { 0x36, 0x36, 0xF7, 0x00, 0xF7, 0x36, 0x36, 0x36 },
  { 0x18, 0x18, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00 },
  { 0x36, 0x36, 0x36, 0x36, 0xFF, 0x00, 0x00, 0x00 },
  { 0x00, 0x00, 0xFF, 0x00, 0xFF, 0x18, 0x18, 0x18 },
  { 0x00, 0x00, 0x00, 0x00, 0xFF, 0x36, 0x36, 0x36 },
  { 0x36, 0x36, 0x36, 0x36, 0x3F, 0x00, 0x00, 0x00 },
  { 0x18, 0x18, 0x1F, 0x18, 0x1F, 0x00, 0x00, 0x00 },
  { 0x00, 0x00, 0x1F, 0x18, 0x1F, 0x18, 0x18, 0x18 },
  { 0x00, 0x00, 0x00, 0x00, 0x3F, 0x36, 0x36, 0x36 },
  { 0x36, 0x36, 0x36, 0x36, 0xFF, 0x36, 0x36, 0x36 },
  { 0x18, 0x18, 0xFF, 0x18, 0xFF, 0x18, 0x18, 0x18 },
  { 0x18, 0x18, 0x18, 0x18, 0xF8, 0x00, 0x00, 0x00 },
  { 0x00, 0x00, 0x00, 0x00, 0x1F, 0x18, 0x18, 0x18 },
  { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },
  { 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF },
  { 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0 },
  { 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F },
  { 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00 },
  { 0x00, 0x00, 0xF8, 0xCC, 0xCC, 0xF8, 0xC0, 0x00 },
  { 0x00, 0x00, 0x78, 0xCC, 0xC0, 0xCC, 0x78, 0x00 },
  { 0x00, 0x00, 0xFC, 0x30, 0x30, 0x30, 0x30, 0x00 },
  { 0x00, 0x00, 0xCC, 0xCC, 0x7C, 0x0C, 0x78, 0x00 },
  { 0x00, 0x00, 0x7E, 0xDB, 0xDB, 0x7E, 0x18, 0x00 },
  { 0x00, 0x00, 0xCC, 0x78, 0x30, 0x78, 0xCC, 0x00 },
  { 0x00, 0x00, 0xCC, 0xCC, 0xCC, 0xCC, 0xFE, 0x06 },
  { 0x00, 0x00, 0xCC, 0xCC, 0x7C, 0x0C, 0x0C, 0x00 },
  { 0x00, 0x00, 0xDB, 0xDB, 0xDB, 0xDB, 0xFF, 0x00 },
  { 0x00, 0x00, 0xDB, 0xDB, 0xDB, 0xDB, 0xFF, 0x03 },
  { 0x00, 0x00, 0xE0, 0x60, 0x7C, 0x66, 0x7C, 0x00 },
  { 0x00, 0x00, 0xC6, 0xC6, 0xF6, 0xDE, 0xF6, 0x00 },
  { 0x00, 0x00, 0xC0, 0xC0, 0xF8, 0xCC, 0xF8, 0x00 },
  { 0x00, 0x00, 0xF8, 0x0C, 0x7C, 0x0C, 0xF8, 0x00 },
  { 0x00, 0x00, 0xCE, 0xDB, 0xFB, 0xDB, 0xCE, 0x00 },
  { 0x00, 0x00, 0x7C, 0xCC, 0x7C, 0x6C, 0xCC, 0x00 },
  { 0xD8, 0xFC, 0xC0, 0xF0, 0xC0, 0xC0, 0xFC, 0x00 },
  { 0x6C, 0x00, 0x78, 0xCC, 0xFC, 0xC0, 0x78, 0x00 },
  { 0x60, 0x30, 0x18, 0x30, 0x60, 0x00, 0xFC, 0x00 },
  { 0x18, 0x30, 0x60, 0x30, 0x18, 0x00, 0xFC, 0x00 },
  { 0x0E, 0x1B, 0x1B, 0x18, 0x18, 0x18, 0x18, 0x18 },
  { 0x18, 0x18, 0x18, 0x18, 0x18, 0xD8, 0xD8, 0x70 },
  { 0x18, 0x18, 0x00, 0x7E, 0x00, 0x18, 0x18, 0x00 },
  { 0x00, 0x76, 0xDC, 0x00, 0x76, 0xDC, 0x00, 0x00 },
  { 0x38, 0x6C, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00 },
  { 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00 },
  { 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00 },
  { 0x06, 0x0C, 0x08, 0x98, 0xD0, 0x70, 0x20, 0x20 },
  { 0x78, 0x6C, 0x6C, 0x6C, 0x00, 0x00, 0x00, 0x00 },
  { 0xE0, 0x30, 0x60, 0xF0, 0x00, 0x00, 0x00, 0x00 },
  { 0x00, 0x00, 0x3C, 0x3C, 0x3C, 0x3C, 0x00, 0x00 },
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
};

unsigned char width_Police[256] = {
  4,8,8,8,8,8,8,7,8,8,8,8,8,8,8,8,		// 00-0f
  8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,		// 10-1f
  4,5,6,8,7,8,8,4,5,5,8,7,5,7,5,8,		// 20-2f
  8,7,7,7,8,7,7,7,7,7,4,4,6,7,6,7,		// 30-3f
  8,7,8,8,7,7,7,8,7,4,7,7,7,8,8,8,		// 40-4f
  7,7,7,7,7,7,7,8,8,7,8,5,8,5,8,4,		// 50-5f
  5,8,8,7,8,7,7,8,8,6,7,8,5,8,7,7,		// 60-6f
  8,8,8,7,6,8,7,8,8,7,7,7,4,7,8,8,		// 70-7f
  7,7,7,7,8,7,8,7,7,7,7,7,8,7,7,7,		// 80-8f
  7,7,7,7,8,7,8,7,8,8,8,8,7,8,8,7,		// 90-9f
  8,7,7,7,8,7,8,7,7,7,7,7,8,7,7,7,		// a0-af
  8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,		// b0-bf
  8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,		// c0-cf
  8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,		// d0-df
  7,7,7,7,8,7,8,7,8,8,8,8,7,7,8,7,		// e0-ef
  7,7,7,7,8,6,8,8,7,6,6,8,7,5,7,4,		// f0-ff
};

long *	pv_back;

void print_v_set_back( long *back )
{
	pv_back = back;
}

void print_v_pixel( int x, int y, int color )
{
	if ( x < 0 || x >= WIDTH || y < 0 || y >= HEIGHT ) return;
	pv_back[WIDTH * y + x] = color;
}

void print_v_char( int x, int y, char c, int color )
{
	int	i, j, l;
	for ( i = 0; i < 8; i++ ) {
		l = font_Police[c][i];
		for ( j = 0; j < 8; j++ ) {
			if ( l & (0x80 >> j) ) print_v_pixel( x + j, y + i, color );
		}
	}
}

void print_v( int x, int y, char *str, int color, int x_alignment, int prop )
{
	char	a;
	int	i, xa = 0;
	if ( x_alignment == 1 ) {
		for ( i = 0; i < strlen( str ); i++ ) xa += width_Police[str[i]];
		xa = -(xa >> 1);
	}
	for ( i = 0; i < strlen( str ); i++ ) {
		a = str[i];
		print_v_char( x + xa, y, a, color );
		if ( prop ) x += width_Police[a];
		else x += 8;
	}
}
