#include <math.h>
#include "tri.h"
#include "vector.h"

#define	WIDTH	1024
#define	HEIGHT	768

void vector_project_2d( tri_vertex *p, vector *v, float fov_x, float fov_y )
{
	p->x = v->x * (fov_x / (1.0f - v->z / fov_x)) + (float)(WIDTH >> 1);
	p->y = v->y * (fov_y / (1.0f - v->z / fov_y)) + (float)(HEIGHT >> 1);
	p->z = (v->z / 1.5) - 10.0f;
}

void vector_normalize( vector *v )
{
	float	vl;
	vl = sqrt( v->x * v->x + v->y * v->y + v->z * v->z );
	v->x /= vl;
	v->y /= vl;
	v->z /= vl;
}

float vector_dot_product( vector *a, vector *b )
{
	return a->x * b->x + a->y * b->y + a->z * b->z;
}

void vector_cross_product( vector *d, vector *v0, vector *v1 )
{
	d->x = v0->y * v1->z - v0->z * v1->y;
	d->y = v0->z * v1->x - v0->x * v1->z;
	d->z = v0->x * v1->y - v0->y * v1->x;
}

void vector_rotate_x( vector *v, float angle )
{
	vector	d;
	float	_sin, _cos;
	_sin = sin( angle );
	_cos = cos( angle );
	d.x = v->x;
	d.y = v->y *  _cos + v->z * _sin;
	d.z = v->y * -_sin + v->z * _cos;
	*v = d;
}

void vector_rotate_y( vector *v, float angle )
{
	vector	d;
	float	_sin, _cos;
	_sin = sin( angle );
	_cos = cos( angle );
	d.x = v->x * _cos + v->z * -_sin;
	d.y = v->y;
	d.z = v->x * _sin + v->z *  _cos;
	*v = d;
}

void vector_rotate_z( vector *v, float angle )
{
	vector	d;
	float	_sin, _cos;
	_sin = sin( angle );
	_cos = cos( angle );
	d.x = v->x *  _cos + v->y * _sin;
	d.y = v->x * -_sin + v->y * _cos;
	d.z = v->z;
	*v = d;
}
