#ifndef	__MESH__
#define	__MESH__

typedef struct _tex_coord {
	float	pu, pv;		// Phong light-map coordinates
	float	tu, tv;		// Texture coordinates
} tex_coord;

typedef struct _mesh {
	int		n_verts;
	int		n_faces;
	vector *	verts;
	vector *	norms;
	int *		faces;
	tex_coord *	texuv;
	int *		texture;
} mesh;

int mesh_alloc( mesh *, int, int );
void mesh_free( mesh * );
void mesh_generate_normals( mesh *, int );
int mesh_generate_cube( mesh *, float );
int mesh_generate_torus( mesh *, int, int, float, float );
void mesh_rotate( mesh *, float, float, float );
void mesh_render( mesh * );
void mesh_scale( mesh *, float, float, float );
void mesh_generate_chrome_uv( mesh *, float, float );

#endif
