%out The Prophecy advertisement (c) Xaya Iccita/BloodBrothers 1995

;assembler directives

        jumps                   ;allow extending of conditional jumps
        locals lb               ;all labels beginning w/ lb considered local
        multerrs                ;allow multiple errors on one line
        smart                   ;smart code optimizations
        .386c                   ;allow 386-code
        pno87                   ;don't allow x87 code

perframe        equ     2       ;delay between worm frames
Wormbuffersize  equ     8192

Staramount      equ     512
Starspeed       equ     1

ScreenCenterY   equ     121     ;only values from 62 to 138 make sense
TextScreenDelay equ     3*72    ;72 = 1 second

notrainer       equ     1       ;1: wall checks, comment out for no checking
;debug          equ     1       ;1: vsync speed measure, commented out = no test

csg             segment byte public use16 'code'
                assume  cs:csg, ds:csg
                org     100h
advert          proc
                push    cs
                pop     es

                mov     ah,0fh
                int     10h
                cmp     al,3
                je      lbGetMemory
                mov     di,offset dosscreen
                mov     cx,9*160
                sub     al,al                   ;if nonstandard vmode
                rep     stosb                   ;store zero in buffer
                jmp     lbSetup
lbGetMemory:    push    0b800h
                pop     ds
                mov     si,15*160               ;otherwise take it from the
                mov     di,offset dosscreen     ;screen
                mov     cx,9*160
                rep     movsb

lbSetup:        push    cs
                pop     ds

                sub     ah,ah
                int     1ah
                mov     [rseed],dx              ;get random seed from clock

                call    starsetup               ;setup stars

                mov     ax,13h
                int     10h                     ;set video

                mov     dx,3c8h
                sub     al,al
                out     dx,al
                inc     dx
                mov     si,offset palette       ;set palette
                mov     cx,(64+8)*3             ;some crappy video cards can't
                outsb                           ;cope with rep outsb, this
                loop    $-1                     ;ought to work instead.
                mov     bx,7
lbPalette:      sub     si,24                   ;put rest of palette since
                mov     cx,24                   ;values are same.
                outsb
                loop    $-1
                dec     bx
                jnz     lbpalette

                mov     si,offset top
                mov     bp,7920/3
                call    decodebuffer            ;decode top buffer

                mov     cx,21120/2
                sub     di,di
                call    rawput                  ;put it on the screen

                mov     si,offset bottom
                mov     bp,2760/3
                call    decodebuffer            ;decode bottom buffer

                mov     cx,7360/2
                mov     di,(200-23)*320
                call    rawput                  ;put it on the screen

                mov     si,offset left
                mov     bp,333
                call    decodebuffer            ;decode left buffer

                mov     di,66*320
                call    sideput                 ;put it on the screen

                mov     si,offset right
                mov     bp,333
                call    decodebuffer            ;decode right buffer

                mov     di,66*320+296
                call    sideput                 ;put on the screen

                call    decodefont              ;decode font

                push    0a000h
                pop     es

lbLooper:       cmp     nibbles,1               ;if game active jump to that
                je      lbPlay                  ;routine
                call    vsync
                call    updatestars             ;otherwise handle the stars
                call    handletexts             ;and update texts
                cmp     textfunction,1
                jne     lbNotComing
                cmp     textline,0ffh
                jne     lbNotComing
                cmp     nibblequeued,1
                jne     lbNotComing
                mov     foodoffset,0            ;activate game
                call    makefood                ;select food position
                mov     nibbles,1               ;activate game
                mov     nibblescore,0           ;reset score
                mov     nibblequeued,0          ;remove request from queue
                mov     headoffset,32160        ;worm head at center of scrn
                mov     headdir,0               ;direction = right
                mov     insertp,0               ;buffer entry point
                mov     removep,0               ;buffer removal point
                mov     bufferdelay,16          ;initial length 16
lbNotComing:    mov     ah,1
                int     16h
                jz      lbLpNoKey
                sub     ah,ah
                int     16h
                cmp     al,32                   ;if space pressed the user wants
                jne     lbNotSpace              ;to play
                mov     nibblequeued,1          ;so, put the wish in the queue
                mov     textdelay,1             ;start removing the text
                jmp     lbLooper
lbNotSpace:     cmp     al,27                   ;if esc pressed quit the demo
                je      lbExit
lbLpNoKey:      jmp     lbLooper

lbPlay:         mov     cx,perframe             ;don't play at 'top speed'
lbDelay:        call    vsync                   ;delay
                call    updatestars             ;update stars
                loop    lbDelay
                mov     ah,1
                int     16h
                jz      lbNokey
                sub     ah,ah
                int     16h
                and     al,al
                jnz     lbNotarrow
                mov     al,ah
                sub     ah,ah
                mov     di,offset keys
                mov     cx,4
                push    es
                push    ds
                pop     es
lbTestkey:      scasb
                jne     lbNotthis
                pop     es
                mov     byte ptr headdir,ah     ;determine what key was pressed
                jmp     lbNokey
lbNotthis:      inc     ah
                inc     ah
                loop    lbTestkey
                pop     es
lbNotarrow:     cmp     al,27                   ;esc pressed -> exit
                je      lbExit
lbNokey:        mov     di,headoffset
                mov     bx,headdir
                add     di,[bx+offset dirsets]  ;move worm head
                mov     headoffset,di
                mov     al,byte ptr es:[di]
                and     al,7
                cmp     al,4                    ;is the pixel under it food?
                je      lbFood
                cmp     al,7                    ;is it a 'fake empty' slot?
                je      lbNoFood
ifdef notrainer
                cmp     al,0                    ;is it anything else?
                jne     lbRemoveWorm
endif
                jmp     lbNoFood
lbFood:         call    random                  ;worm hits food
                and     ax,3
                inc     ax
                inc     ax
                shl     ax,3
                mov     bufferdelay,ax          ;increase length
                shr     ax,1
                add     nibblescore,ax          ;increase score
                call    makefood                ;make more food
lbNoFood:       mov     al,5
                call    putpixel                ;put the pixel
                mov     si,insertp
                mov     [si+offset removebuffer],di     ;store addr
                inc     si
                inc     si
                and     si,(2*Wormbuffersize)-1
                mov     insertp,si
                mov     cx,bufferdelay
                and     cx,cx
                jz      lbRemove                ;if it isn't time to remove
                dec     cx                       ;then don't!
                mov     bufferdelay,cx
                jmp     lbPlay
lbRemove:       mov     si,removep
                mov     di,[si+offset removebuffer]
                sub     al,al
                call    putpixel                ;remove pixel
                inc     si
                inc     si
                and     si,(2*Wormbuffersize)-1
                mov     removep,si
                jmp     lbLooper

lbExit:         mov     ax,3
                int     10h
                push    0b800h
                pop     es
                sub     di,di                   ;restore partial screen
                mov     si,offset dosscreen
                mov     cx,160*9
                rep     movsb

                mov     di,7*2+9*160
                mov     si,offset prophecy
                mov     dx,13
lbAnsiY:        mov     cx,66
                rep     movsw                   ;put the 'ansi' on the screen
                add     di,28
                dec     dx
                jnz     lbAnsiY

                mov     ah,2
                sub     bh,bh
                mov     dx,1600h
                int     10h

                push    cs
                pop     es
                mov     ax,nibblebest
                and     ax,ax
                jnz     lbMakeScore
                mov     dx,offset noscore
                jmp     lbOutputStr
lbMakeScore:    mov     di,offset scoretext+12
                call    hexalize
                mov     di,offset scoretext+12
                sub     bh,bh
                mov     cx,4
lbAscii:        mov     bl,[di]
                mov     bl,[bx+offset hexes]
                mov     [di],bl
                inc     di
                loop    lbAscii
                mov     dx,offset scoretext
lbOutputStr:    mov     ah,9
                int     21h                     ;print best score
                ret

lbRemoveWorm:   mov     si,removep              ;remove worm
lbRemover:      mov     di,[si+offset removebuffer]
                sub     al,al
                call    putpixel
                inc     si
                inc     si
                and     si,(2*Wormbuffersize)-1
                cmp     si,insertp
                jne     lbRemover
                mov     di,foodoffset
                call    putfood                 ;remove food
                mov     nibbles,0

                mov     ax,nibblescore
                cmp     nibblebest,ax
                ja      lbNotBetter
                mov     nibblebest,ax
lbNotBetter:    push    es                      ;write scores on screen
                push    cs
                pop     es
                mov     di,offset gameover+20
                call    hexalize
                mov     ax,nibblebest
                mov     di,offset gameover+31
                call    hexalize
                pop     es

                mov     ax,textin               ;put game over screen
                cmp     textin,offset gameover+35
                je      lbNoRestore
                mov     textrestore,ax
lbNoRestore:    mov     ax,offset gameover
                mov     textin,ax
                mov     textout,ax

                jmp     lbLooper
advert          endp

rawput          proc                           ;put raw buffer on screen
                push    es
                push    0a000h
                pop     es
                mov     si,offset decbuffer
                rep     movsw                   ;put it on the screen
                pop     es
                ret
rawput          endp

sideput         proc                           ;put side buffer on screen
                push    es
                push    0a000h
                pop     es
                mov     si,offset decbuffer
                mov     dx,111
lbY:            mov     cx,24
                rep     movsb
                add     di,320-24
                dec     dx
                jnz     lbY
                pop     es
sideput         endp

hexalize        proc    ;es:di = dest, ax=value, bx eats dirt
                xchg    al,ah                  ;decode word into hex-number
                mov     bl,al
                shr     al,4
                stosb
                mov     al,bl
                and     al,15
                stosb
                mov     al,ah
                mov     bl,al
                shr     al,4
                stosb
                mov     al,bl
                and     al,15
                stosb
                ret
hexalize        endp

putpixel        proc    ;put pixel for the worm, modifies only 3 lowest bits
                        ;ax looses its life, al has color
                mov     ah,es:[di]
                and     ah,not 7
                or      ah,al
                mov     es:[di],ah
                ret
putpixel        endp

putfood         proc                    ;make 2x2 food, di contains addr
                call    putpixel        ;of first pixel. di lost
                inc     di
                call    putpixel
                add     di,319
                call    putpixel
                inc     di
                call    putpixel
                ret
putfood         endp

putfont         proc    ;di=dest, al=character (not multiplied), bl=clr on/off
                sub     ah,ah                   ;puts a character on screen
                imul    si,ax,192
                add     si,offset decbuffer
                and     bl,bl
                jnz     lbColor
                mov     bx,offset lbBlackPut
                jmp     lbStartFont
lbColor:        mov     bx,offset lbWhitePut
lbStartFont:    mov     ch,24
lbY:            mov     cl,8
lbX:            lodsb
                and     al,al
                jz      lbCPut
                jmp     bx
lbCPut:         inc     di
                dec     cl
                jnz     lbX
                add     di,320-8
                dec     ch
                jnz     lbY
                ret

lbWhitePut:     or      byte ptr es:[di],01000000b
                jmp     lbCPut
lbBlackPut:     and     byte ptr es:[di],00111111b
                jmp     lbCPut
putfont         endp

;wait for vertical sync, dx and ax destroyed
vsync           proc    near
ifdef debug                                     ;screen update debuggings
                mov     ah,0
                call    overscan
endif
		mov	dx,03dah
lb1:            in      al,dx
		test	al,8
                jnz     lb1
lb2:            in      al,dx
		test	al,8
                jz      lb2
ifdef debug
                mov     ah,1
                call    overscan
endif
		ret
endp

decodebuffer    proc    ;si=bit "packed" buffer addr, bp=size
                mov     di,offset decbuffer
                sub     al,al
                mov     cx,21120
                rep     stosb
                sub     cl,cl
lbkoira:        mov     di,offset decbuffer
                push    bp

                call    truedecode

                pop     bp
                inc     cl
                cmp     cl,3
                jne     lbkoira
                ret
decodebuffer    endp

decodefont      proc    ;no variables needed, ds=cs
                push    cs
                pop     es
                mov     bp,46*24        ;size of font
                mov     si,offset font
                mov     di,offset decbuffer
                push    di
                mov     cx,46*24*8
                sub     al,al
                rep     stosb
                pop     di
                call    truedecode
                ret
decodefont      endp

truedecode      proc    ;bp=size, cl=shift, es:di=dest, ds:si=src
lbperbyte:      lodsb                   ;load next byte
                mov     dl,al           ;move into dl for storage
                mov     bx,7            ;first bit
                mov     ch,8            ;run 8 times per byte
lbperbit:       bt      dx,bx           ;set cf if bit bx is set in dx
                setc    al              ;if cf, set al=1, else al=0
                shl     al,cl
                or      es:[di],al      ;stash that byte
                inc     di
                dec     bx              ;next bit
                dec     ch
                jnz     lbperbit        ;next bit
                dec     bp
                jnz     lbperbyte       ;next byte
                ret
truedecode      endp

;create pseudorandom value in range of 0..65535 which is returned in ax
random          proc                            ;linear random, theoretically
                mov     ax,[rseed]              ;returns each and every value
                mov     dx,36421                ;between min/max in a series
                mul     dx                      ;of max-min+1 calls
                inc     ax
                mov     [rseed],ax
                ret
random          endp

makefood        proc                            ;select new spot for food
                push    di
                mov     di,foodoffset
                and     di,di
                jz      lbFood1
                sub     ax,ax
                call    putfood
lbFood1:        call    random
                cmp     ax,63999
                ja      lbFood1
                mov     di,ax
                mov     ax,es:[di]
                and     ax,0707h
                jnz     lbFood1
                mov     ax,es:[di+320]
                and     ax,ax
                jnz     lbFood1
                mov     foodoffset,di
                mov     al,4
                call    putfood
                pop     di
                ret
makefood        endp

ifdef debug
overscan        proc    near
                mov     dx,3d4h
                in      al,dx
                mov     dx,3c0h
                mov     al,31h
                out     dx,al
                mov     al,ah
                out     dx,al
                ret
overscan        endp
endif

starsetup       proc    ;generate stars
                mov     di,offset stars
                mov     cx,Staramount
lbGen:          call    random
                stosw                           ;x is out
                call    random
                stosw                           ;y is out
                call    random
                shr     ax,9                    ;ax now in range 0..255
                mov     ax,255
                stosw                           ;z is out
                sub     ax,ax
                stosw                           ;removep. is out
                loop    lbGen
                ret
starsetup       endp


updatestars     proc    ;display stars
                pusha
                mov     si,offset stars
                mov     cx,Staramount
lbStars:        mov     bx,[si+6]               ;load removep. in bx
                mov     word ptr [si+6],0ffffh  ;clear the old
                cmp     bx,0ffffh
                je      lbNoremove              ;nothing to remove
                and     byte ptr es:[bx],11000111b
lbNoremove:     mov     bx,[si+4]               ;z in bx
                mov     ax,[si+2]               ;y in ax
                cwd                             ;convert ax to dword in dx:ax
                idiv    bx                      ;transformed y in ax now.
                add     ax,centery              ;y center
                cmp     ax,199                  ;is (unsigned)y > 199?
                ja      lbRecreate              ;yap, create new star in there
                mov     di,ax
                shl     di,8
                shl     ax,6
                add     di,ax                   ;y offset in di
                mov     ax,[si]                 ;x in ax
                cwd                             ;convert ax to dword in dx:ax
                idiv    bx                      ;transformed x in ax now
                add     ax,centerx              ;x center
                cmp     ax,319                  ;is (unsigned)x > 319?
                ja      lbRecreate              ;yap, create new star in there
                add     di,ax
                mov     [si+6],di               ;store remove-pointer
                mov     ax,bx
                shr     ax,5
                mov     ah,es:[di]
                shl     al,3
                and     ah,11000111b
                or      ah,al
                mov     byte ptr es:[di],ah     ;put pixel on screen
lbReloop:       sub     bx,Starspeed            ;decrease z
                cmp     bx,0
                jg      lbZok                   ;if z<=0 (divide by zero)
                jmp     lbRecreate              ;create new star
lbZok:          mov     [si+4],bx               ;update z in memory
                add     si,8                    ;next star
                loop    lbStars

                popa
                ret

lbRecreate:     call    random                  ;create new star
                mov     [si],ax                 ;new x
                call    random
                mov     [si+2],ax               ;new y
                mov     bx,255                  ;z is at end
                jmp     lbZok
updatestars     endp

handletexts     proc                            ;process texts
                cmp     textfunction,2
                jne     lbNotWait
                dec     textdelay               ;if delay function active
                jnz     lbNoWaitExit            ;well, delay.
                mov     textfunction,0
                mov     textdelay,TextScreenDelay
lbNoWaitExit:   ret
lbNotWait:      cmp     textfunction,1
                jne     lbOutGoing
                mov     si,textin
                jmp     lbSiSelected
lbOutGoing:     mov     si,textout              ;select buffer
lbSiSelected:   cmp     textchar,0ffh           ;end of line?
                jne     lbInLine
                cmp     textline,0ffh           ;end of screen?
                jne     lbInScreen
                lodsb                           ;screen size
                cmp     al,0ffh
                jne     lbNotAtScrEnd
                mov     si,textrestore
                cmp     textfunction,0
                jne     lbNext
                mov     textrestore,offset text
lbNext:         lodsb
lbNotAtScrEnd:  mov     textline,0              ;calculate first Y 'n stuff
                mov     textlinemax,al
                sub     ah,ah
                imul    ax,25
                shr     ax,1
                mov     bx,ScreenCenterY
                sub     bx,ax
                mov     textfirsty,bx
lbInScreen:     lodsb                           ;length of line
                and     al,al
                jnz     lbLengthNZ
                inc     textline
                jmp     lbInScreen
lbLengthNZ:     mov     textchar,0              ;calculate X and stuff
                mov     textcharmax,al
                shl     al,2
                mov     ah,160
                sub     ah,al
                mov     al,ah
                sub     ah,ah
                mov     textoutoffset,ax
                mov     al,textline
                imul    ax,25
                add     ax,textfirsty
                mov     dx,320
                mul     dx
                add     textoutoffset,ax
lbInLine:       sub     ah,ah                   ;load character
                lodsb
                cmp     textfunction,1
                jne     lbStoreOut
                mov     textin,si
                jmp     lbStored
lbStoreOut:     mov     textout,si              ;store changed buffer addr
lbStored:       mov     bl,textfunction
                mov     cl,textchar
                inc     cl
                cmp     cl,textcharmax
                jne     lbNotEol
                mov     cl,0ffh                 ;advance counters
                mov     ch,textline
                inc     ch
                cmp     ch,textlinemax
                jne     lbNotEos
                mov     ch,0ffh
                inc     textfunction
lbNotEos:       mov     textline,ch
lbNotEol:       mov     textchar,cl
                mov     di,textoutoffset
                add     textoutoffset,8
                call    putfont                 ;plot character
                ret
handletexts     endp

textfunction    db      1                       ;0=go out, 1=go in, 2=wait
textdelay       db      0                       ;delay in "wait"
textin          dw      offset text             ;offset of next incoming txt
textout         dw      offset text             ;offset of next out going txt
textline        db      0ffh                    ;current text line
textchar        db      0ffh                    ;current text character
textlinemax     db      0ffh                    ;max # lines on screen
textcharmax     db      0ffh                    ;max # chars on line
textfirsty      dw      0ffffh                  ;first y of text
textoutoffset   dw      0                       ;offset of next char
textrestore     dw      offset text             ;address of "first" page

nibblequeued    db      0                       ;1 = next time go out done,
                                                ;    start worming
nibbles         db      0                       ;1 = game active
keys            db      4Dh,50h,4Bh,48h         ;keys for lft/dwn/rght/up
dirsets         dw      1,320,-1,-320           ;offset modifications for dirs
centerx         dw      100                     ;center x for starfield
centery         dw      50                      ;center y for starfield
nibblescore     dw      0                       ;current score
nibblebest      dw      0                       ;best score

scoretext       db      "Best score: ???? (hex)",13,10,"$"
noscore         db      "Didn't you notice the integrated worm game?",13,10,"$"
hexes           db      "0123456789ABCDEF"

palette         label   byte                    ;adv. palette
        include palette.inc
top             label   byte                    ;bitmap: logo at top
        include top.inc
bottom          label   byte                    ;bitmap: tail at bottom
        include bottom.inc
left            label   byte                    ;bitmap: tail at left side
        include lside.inc
right           label   byte                    ;bitmap: tail at right side
        include rside.inc
font            label   byte                    ;bit packed font
        include font.inc
text            label   byte                    ;texts
        include text.inc
gameover        label   byte                    ;game over, man!
        include gover.inc
prophecy        label   byte                    ;ending ansi
        include prophecy.inc

rseed           dw      ?               ;random seed (get from sysclck)
foodoffset      dw      ?               ;worm:offset of food block
headoffset      dw      ?               ;worm:offset of head
headdir         dw      ?               ;worm:direction of head
insertp         dw      ?               ;worm:buffer FI-address
removep         dw      ?               ;worm:buffer FO-address
bufferdelay     dw      ?               ;worm:waiting time until next remove

stars           dw      4*Staramount dup (?)    ;x,y,z,removeaddr
removebuffer    dw      Wormbuffersize dup (?)  ;FIFO (first in, first out)
                                                ;buffer of worm body offsets
                                                ;in screen memory

dosscreen       db      160*9  dup (?)          ;the dos screen

decbuffer       label   byte            ;decode buffer
                db      21120 dup (?)   ;just to make sure this doesn't get
                                        ;too big, which would result in the
                                        ;code overwriting the PSP

csg             ends
                end     advert


         The Prophecy advertisement (c) Xaya Iccita/BloodBrothers 1995
                      All rights (what rights?) reserved.

License: If you break it, you own both pieces. If it formats your HD,
you own a formatted HD. I take no responsibility of it's (mis)functioning.

You are allowed to use this source as an example of (bad?) coding, but you
are definitely not allowed to use this as an ad for your board by just
changing some texts. There may be room for optimization in the code, but
hell, it worked on my crappy 386DX25 so it ought to work on your machine.

                      << Information wants to be free! >>

