/*
 *  Routine to grab Sauce from a file.  
 */
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "sauce.h"


Sauce *getSauce( FILE *fp) {
	Sauce s;
  long cur_pos;

  cur_pos = ftell( fp );  
  fseek( fp, -128, SEEK_END );

  /* 
   * can't count on Sauce structure to be char aligned, 
   * so this bit reads it piecemeal.  Hate to add all these 
   * numbers without #defines, but they're in sauce.h if it 
   * really is confusing.
   */ 
  fread( s.ID, 1, 5, fp );
  fread( s.Version, 1, 2, fp );
  fread( s.Title, 1, 35, fp );
  fread( s.Author, 1, 20, fp );
  fread( s.Group, 1, 20, fp );
  fread( s.Date, 1, 8, fp );

  // NOTE: not portable.  It'll be backwards on big-endian machines
  fread( &s.FileSize, sizeof( long ), 1, fp );

  fread( &s.DataType, 1, 1, fp );
  fread( &s.FileType, 1, 1, fp );

  // See above warning
  fread( &s.TInfo1, sizeof( short ), 1, fp );
  fread( &s.TInfo2, sizeof( short ), 1, fp );
  fread( &s.TInfo3, sizeof( short ), 1, fp );
  fread( &s.TInfo4, sizeof( short ), 1, fp );

  fread( &s.Comments, 1, 1, fp );
  fread( &s.Flags, 1, 1, fp );

  fseek( fp, cur_pos, SEEK_SET );

  if( strncmp( s.ID, "SAUCE", 5 ) == 0 ) {
		
		int i = sizeof(Sauce);
		Sauce *sauce;
		sauce = (Sauce *)malloc(sizeof(Sauce));
		memcpy(sauce, &s, sizeof(Sauce));
		return sauce;
  }

  return NULL;
}


Sauce *getSauceFromData(const char *data, int length) {
	Sauce s;
	long cur_pos;
	
	cur_pos = length-128;
	
	/* 
	* can't count on Sauce structure to be char aligned, 
	* so this bit reads it piecemeal.  Hate to add all these 
	* numbers without #defines, but they're in sauce.h if it 
	* really is confusing.
	*/ 
	memcpy( s.ID,		data+cur_pos, 5);		cur_pos += 5;
	memcpy( s.Version,	data+cur_pos, 2);		cur_pos += 2;
	memcpy( s.Title,	data+cur_pos, 35);		cur_pos += 35;
	memcpy( s.Author,	data+cur_pos, 20);		cur_pos += 20;
	memcpy( s.Group,	data+cur_pos, 20);		cur_pos += 20;
	memcpy( s.Date,		data+cur_pos, 8);		cur_pos += 8;
	
	// NOTE: not portable.  It'll be backwards on big-endian machines
	memcpy( &s.FileSize, data+cur_pos, sizeof(long));	cur_pos += sizeof(long);	
	memcpy( &s.DataType, data+cur_pos, 1);				cur_pos += 1;
	memcpy( &s.FileType, data+cur_pos, 1);				cur_pos += 1;
	
	// See above warning
	memcpy( &s.TInfo1, data+cur_pos, sizeof( short ));	cur_pos += sizeof(short);
	memcpy( &s.TInfo2, data+cur_pos, sizeof( short ));	cur_pos += sizeof(short);
	memcpy( &s.TInfo3, data+cur_pos, sizeof( short ));	cur_pos += sizeof(short);
	memcpy( &s.TInfo4, data+cur_pos, sizeof( short ));	cur_pos += sizeof(short);
	
	memcpy( &s.Comments, data+cur_pos, 1);	cur_pos += 1;
	memcpy( &s.Flags, data+cur_pos, 1);		cur_pos += 1;
	
	if( strncmp( s.ID, "SAUCE", 5 ) == 0 ) {
		
		int i = sizeof(Sauce);
		Sauce *sauce;
		sauce = (Sauce *)malloc(sizeof(Sauce));
		memcpy(sauce, &s, sizeof(Sauce));
		return sauce;
	}
	
	return NULL;
}
