// SaveAsAvi.cpp : implementation file
//

#include "stdafx.h"
#include "acidview.h"
#include "SaveAsAvi.h"
#include <avicomp.h>
#include <afxmt.h>
#include "ImageData.h"
#include "RipData.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

class CAviThreadData {

private:
	CSemaphore		*m_semaphore;
	bool			m_done;
	int				m_progress;

public:

	CString			m_filename;
	CImageContext   *m_context;
	CAcidImage		*m_image;

	CAviThreadData() :
		m_done(false),
		m_progress(0)
	{
		m_semaphore = new CSemaphore(2, 2); 
	}

	~CAviThreadData() {
		delete m_semaphore;
	}

	bool getThreadDone() const {
		return m_done;
	}

	void setThreadDone(bool b) {
	
		CSingleLock singleLock(m_semaphore);
	    singleLock.Lock();
		m_done = b;
		singleLock.Unlock();
		Sleep(1);
	}

	int  getProgress() const {
		return m_progress;
	}

	void setProgress(int i) {

		CSingleLock singleLock(m_semaphore);
	    singleLock.Lock();
		m_progress = i;
		singleLock.Unlock();
		Sleep(1);
	}
};


/////////////////////////////////////////////////////////////////////////////
// CSaveAsAvi dialog


CSaveAsAvi::CSaveAsAvi(CWnd* pParent /*=NULL*/)
	: CDialog(CSaveAsAvi::IDD, pParent),
	m_threadData(0),
	m_context(0),
	m_image(0)
{
	//{{AFX_DATA_INIT(CSaveAsAvi)
	//}}AFX_DATA_INIT
}




void CSaveAsAvi::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSaveAsAvi)
	DDX_Control(pDX, IDOK, m_ok);
	DDX_Control(pDX, IDC_AVI_OPEN_FILE, m_openFile);
	DDX_Control(pDX, IDC_AVI_FPS, m_fps);
	DDX_Control(pDX, IDC_AVI_FILENAME, m_filename);
	DDX_Control(pDX, IDC_AVI_PROGRESS, m_progress);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSaveAsAvi, CDialog)
	//{{AFX_MSG_MAP(CSaveAsAvi)
	ON_BN_CLICKED(IDC_AVI_OPEN_FILE, OnAviOpenFile)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSaveAsAvi message handlers

void CSaveAsAvi::OnOK() 
{
	//Get the vars 
	UpdateData();
	
	//Start the thread if data is valid
	m_threadData = new CAviThreadData();

	m_filename.GetWindowText(m_threadData->m_filename.GetBuffer(200), 200);
	m_threadData->m_context  = m_context;
	m_threadData->m_image	 = m_image;
	m_threadData->setThreadDone(false);
	
	m_oldAnimation = m_context->m_animation;
	m_context->m_animation = ON;
	m_context->m_recordMovie = true;
	char num[4];
	m_fps.GetLine(0, num, 3);
	int fps = atoi(num);
	m_context->m_fps = fps;
	int w = m_image->getWidth(m_context);
	int h = m_image->getHeight(m_context);
	avicompiler::startAVI((char *)(LPCTSTR)m_threadData->m_filename, m_context->m_fps, w, h);


	//Disable the controls
	m_ok.EnableWindow(FALSE);
	m_filename.EnableWindow(FALSE);
	m_fps.EnableWindow(FALSE);
	m_openFile.EnableWindow(FALSE);

	SetTimer(1, 10, NULL);
	AfxBeginThread((AFX_THREADPROC)saveAVI, (void *)m_threadData);
	//CDialog::OnOK();
}

void CSaveAsAvi::OnAviOpenFile() 
{
	CString filename;
	m_filename.GetWindowText(filename.GetBuffer(200), 200);
	CFileDialog dlg(FALSE, 
					"*.avi", 
					filename, 
					OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
					"Audio-Interleave Files (*.avi)|*.avi|All Files (*.*)|*.*||");
	if (dlg.DoModal()==IDOK) {
		m_filename.SetWindowText(dlg.GetPathName());
		UpdateData(FALSE);
	}	

}

void CSaveAsAvi::OnCancel() 
{
	//Terminate the thread
	if (m_threadData) {
		m_threadData->setThreadDone(true);
		m_ok.EnableWindow(TRUE);
		m_filename.EnableWindow(TRUE);
		m_fps.EnableWindow(TRUE);
		m_openFile.EnableWindow(TRUE);		
	}
		
	CDialog::OnCancel();	
}

void CSaveAsAvi::OnTimer(UINT nIDEvent) 
{
	
	int progress = m_threadData->getProgress();
	m_progress.SetPos(progress);
	if (progress>=100 || m_threadData==0 || m_threadData->getThreadDone()) {
		m_threadData->setThreadDone(true);
		KillTimer(1);
		EndDialog(IDOK);
	}
	
	UpdateData(FALSE);
	CDialog::OnTimer(nIDEvent);
}


BOOL CSaveAsAvi::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	int fps	   = AfxGetApp()->GetProfileInt("Settings", "recordFPS", 20);
	CString s;
	itoa(fps, s.GetBuffer(20), 10);
	m_fps.SetWindowText(s);
	m_filename.SetWindowText(CString(m_image->m_data->m_filename)+CString(".avi"));
	m_progress.SetRange(0, 100);
	m_progress.SetPos(0);
	UpdateData(FALSE);
	return TRUE;  	              
}



UINT CSaveAsAvi::saveAVI(LPVOID pParam) {

	CAviThreadData *threadData	= (CAviThreadData *)pParam;
	CAcidImage *image			= threadData->m_image;
	CImageContext *context		= threadData->m_context;	
	bool done					= false;
	bool imageDone				= false;
	
	CDC dc;
	context->m_pDC = &dc;
	context->m_pDC->CreateCompatibleDC(NULL);
	int w = image->getWidth(context);
	int h = image->getHeight(context);
 
	//Start the avi CString    

	//Setup the bitmap to draw to
	CBitmap *bitmap = new CBitmap();
	bitmap->CreateBitmap(w, h, 1, 32, NULL);
	context->m_pDC->SelectObject(bitmap);
	context->m_pDC->PatBlt(0, 0, w, h, BLACKNESS);

	unsigned int *pixels = new unsigned int[w*h];
	unsigned int *line   = new unsigned int[w];

	memset(pixels, 0, w*h*4);
	avicompiler::addFrame(pixels);

	image->startLoad(context);
	
	CDC *tempDC;
	if (image->getFileType()==RIP) {
		CRipData *ripData = (CRipData *)image->m_data;
		tempDC = ripData->m_pDC;
		ripData->m_pDC = context->m_pDC;
	}

	while(!imageDone && !done) {
		threadData->setProgress((image->m_data->m_filePos*100)/image->m_data->m_fileLength);
 
		imageDone = image->renderFrame(context);
		bitmap->GetBitmapBits(w*h*4, pixels);

		//flip the image
		int offset  = 0;
		int offset2 = (h-1)*w; 
		for (int i=0; i<h/2; i++) {
			memcpy(line,			pixels+offset,	w*4);
			memcpy(pixels+offset,	pixels+offset2, w*4);
			memcpy(pixels+offset2,	line,			w*4);
			offset  += w;
			offset2 -= w;
		}

		avicompiler::addFrame(pixels);
		if (image->getFileType()!=RIP)
			context->m_pDC->PatBlt(0, 0, w, h, BLACKNESS);
		done = threadData->getThreadDone();
	}

	avicompiler::endAVI();

	if (image->getFileType()==RIP) {
		CRipData *ripData = (CRipData *)image->m_data;
		ripData->m_pDC = tempDC;
	}

	bitmap->DeleteObject();
	delete bitmap;
	delete pixels;
	delete line;

	context->m_recordMovie = false;
	threadData->setThreadDone(true);
	delete threadData;
	threadData = 0;

	AfxEndThread(0);
	return 0;
}

BOOL CSaveAsAvi::DestroyWindow() 
{
	CString s;
	m_fps.GetWindowText(s.GetBuffer(4), 3);
	int fps = atoi(s);
	AfxGetApp()->WriteProfileInt(_T("Settings"), _T("recordFPS"), fps);
	m_context->m_animation = m_oldAnimation;
	
	return CDialog::DestroyWindow();
}
