#include "RipLoader.h"
#include "RipData.h"


//Used since only 1 param can be passed into the thread proc
struct RipThreadData {

	CRipData *ripData;
	CImageContext *context;
};

RipThreadData g_ripThreadData;


CRipLoader::CRipLoader(CImageRenderer *renderer) :
	CImageLoader(renderer) 
{


}


CRipLoader::~CRipLoader() {

}


bool CRipLoader::isFileType(const char *signature, const char *filename) {
	
	if (filename && strnicmp(filename,"rip",3)==0) {
		return true;
	}
	return false;
}


CImageData *CRipLoader::loadFile(const char *filename) {

	CRipData *ripData = new CRipData();
	ripData->copyFilename(filename);
	ripData->loadFileAsText(filename);

	loadFileFromDataImp(0,0,ripData);
	return ripData;
}


CImageData *CRipLoader::loadFileFromData(const char *data, const int length) {

	CRipData *ripData	  = new CRipData();
	ripData->m_fileData   = new char[length];
	ripData->m_fileLength = length;
	ripData->m_sauce      = getSauceFromData(data, length);
	memcpy(ripData->m_fileData, data, length);
	loadFileFromDataImp(0, 0, ripData);
	return ripData;
}


//done out of laziness for reads 
CRipData *g_ripData;
CImageContext *g_context;


void CRipLoader::loadFileFromDataImp(const char *, const int, CImageData *imageData) {
	
	CRipData *ripData		= (CRipData *)imageData;
	ripData->m_fileType		= RIP;
	ripData->m_animateable	= true;
	ripData->m_width		= 640;
	ripData->m_height		= 350;	
}


void CRipLoader::startLoad(CImageContext *context, CImageData *data) {

	CRipData *ripData = (CRipData *)data;
	m_renderer->setImage(context, data);

	ripData->init(context);

	if ( context->m_animation==ON) {

		if (context->m_recordMovie) {

		} else {
			g_ripThreadData.context = context;
			g_ripThreadData.ripData = ripData;
			ripData->setThreadDone(false);
			AfxBeginThread((AFX_THREADPROC)loadRip, (void *)&g_ripThreadData);
		}
	} else {

		CRipCommandData command;
		do {
			getNextRipCommand(context, ripData, &command);	
			ripData->executeCommand(&command);
		} while(command.m_command!=RIP_END);
	}	
}


UINT CRipLoader::loadRip(LPVOID pParam) {

	RipThreadData *data		= (RipThreadData *)pParam;
	CRipData *ripData		= data->ripData;
	CImageContext *context	= data->context;
	
	bool done				= false;
	CRipCommandData command;
	command.m_command = RIP_NONE;

	QueryPerformanceCounter((LARGE_INTEGER *)&ripData->m_lastTime);
	ripData->m_curTime = ripData->m_lastTime;
	do {

		getNextRipCommand(context, ripData, &command);	
		if (command.m_command!=RIP_END)
			ripData->addCommand(&command);

		done = ripData->getThreadDone();
	} while(command.m_command!=RIP_END && !done);

	ripData->setThreadDone(true);
	AfxEndThread(0);
	return 0;
}


bool CRipLoader::loadFrame(CImageContext *context, CImageData *data) {

	CRipData *ripData	= (CRipData *)data;

	int endPos = ripData->m_filePos + (context->m_speed/10)/context->m_fps;
	CRipCommandData command;
	do {
		getNextRipCommand(context, ripData, &command);	
		ripData->executeCommand(&command);
	} while(command.m_command!=RIP_END && ripData->m_filePos<endPos);

	return (command.m_command==RIP_END || ripData->m_filePos>=ripData->m_fileLength);
}

void CRipLoader::getNextRipCommand(CImageContext *context, CRipData *ripData, CRipCommandData *command) {


	command->m_command = RIP_NONE;
	command->m_data.clear();
	g_context		 = context;
	g_ripData		 = ripData;

	for(;;) {

		char ch = ripData->m_fileData[ripData->m_filePos++];
		CImageLoader::baudSimWait(context, ripData);
		if (ripData->m_filePos>=ripData->m_fileLength) {
			command->m_command = RIP_END; 
			return;
		}

		if (ch=='!') {
			
			//begin rip line
			while(	(ch!=CTRLZ) && 
					(ch!='\n')  && 
					(ch!='|')   &&
					(ripData->m_filePos<ripData->m_fileLength)) {
				
				//seek |
				do {
					ch = ripData->m_fileData[ripData->m_filePos++];
					CImageLoader::baudSimWait(context, ripData);
				} while(ch!='|' && ch!='\n' && (ripData->m_filePos<ripData->m_fileLength));
				
				if (ripData->m_filePos>=ripData->m_fileLength) {
					command->m_command = RIP_END; 
					return;
				}
			}
		}
		
		//found beginning of a command   
		if (ch=='|') {
			
			ch = ripData->m_fileData[ripData->m_filePos++];
			CImageLoader::baudSimWait(context, ripData);
			
			int level = -1;
			if (ch>='0' && ch<='9') 
				level = ch - '0';
			
			if (level==1) {
				
				ch = ripData->m_fileData[ripData->m_filePos++];
				CImageLoader::baudSimWait(context, ripData);
				
				switch(ch) {						
				case 'C':	command->m_command = RIP_GET_IMAGE;
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(readOne());
					return;
				case 'P':	command->m_command = RIP_PUT_IMAGE;
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(readOne());
					return;
				}
				
				//level 0 command
			} else {
				int i;
				switch(ch) {
				case 'T':	command->m_command = RIP_TEXT;
					command->m_text	 = readText();
					return;
				case '@':	command->m_command = RIP_TEXT_XY;
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->m_text	 = readText();
					return;
				case 'Y':	command->m_command = RIP_FONT_STYLE;
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					return;
				case 'c':	command->m_command = RIP_COLOR;
					command->addInt(megaRead());
					return;
				case 'X':	command->m_command = RIP_PIXEL;
					command->addInt(megaRead());
					command->addInt(megaRead());
					return;
				case 'L': 	command->m_command = RIP_LINE;
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					return;
				case 'R':	command->m_command = RIP_RECTANGLE;
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					return;
				case 'a':	command->m_command = RIP_ONE_PALETTE;
					command->addInt(megaRead());
					command->addInt(megaRead());
					return;
				case 'Q':	command->m_command = RIP_SET_PALETTE;
					for (i=0; i<16; i++) {
						command->addInt(megaRead());
					}
					return;
				case 'W':	command->m_command = RIP_WRITE_MODE;
					command->addInt(megaRead());	
					return;
				case 'm':	command->m_command = RIP_MOVE;
					command->addInt(megaRead());
					command->addInt(megaRead());
					return;
				case 'B':	command->m_command = RIP_BAR;
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					return;
				case 'C':	command->m_command = RIP_CIRCLE;
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					return;
				case 'i':	command->m_command = RIP_OVAL_PIE_SLICE;
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					return;
				case 'O':	command->m_command = RIP_OVAL;
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					return;
				case 'o':	command->m_command = RIP_FILLED_OVAL;
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					return;
				case 'P':	{
					command->m_command = RIP_POLYGON;
					command->addInt(megaRead());
					for(i=0; i<command->m_data[0]; i++) {
						command->addInt(megaRead());
						command->addInt(megaRead());
					}
							}
					return;
				case 'p':	{
					command->m_command = RIP_FILL_POLYGON;
					command->addInt(megaRead());
					for(i=0; i<command->m_data[0]; i++) {
						command->addInt(megaRead());
						command->addInt(megaRead());
					}
							}
					return;
				case 'l':	{
					command->m_command = RIP_POLYLINE;
					command->addInt(megaRead());
					for(i=0; i<command->m_data[0]; i++) {
						command->addInt(megaRead());
						command->addInt(megaRead());
					}
							}
					return;
				case 'F':	command->m_command = RIP_FILL;
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					return;
				case '=':	command->m_command = RIP_LINE_STYLE;
					command->addInt(megaRead());
					command->addInt(megaRead() + (megaRead()<<8));
					command->addInt(megaRead());	
					return;
				case 'S':	command->m_command = RIP_FILL_STYLE;
					command->addInt(megaRead());
					command->addInt(megaRead());
					return;
				case 'Z':	{
					command->m_command = RIP_BEZIER;
					for (int i=0; i<4; i++) {
						command->addInt(megaRead());
						command->addInt(megaRead());
					}
					command->addInt(megaRead());		
							}
					return;
				case 'A':	command->m_command = RIP_ARC;
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					return;
				case 'V':	command->m_command = RIP_OVAL_ARC;
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					return;
				case 'I':	command->m_command = RIP_PIE_SLICE;
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					command->addInt(megaRead());
					return;
				case 's':	command->m_command = RIP_FILL_PATTERN;
					for (i=0; i<8; i++)
						command->addInt(megaRead());
					command->addInt(megaRead());		
					return;
				case '#':	command->m_command = RIP_END;
					return;
						}
				}//else level 0
			}//beginning of command

		if (ripData->m_filePos>=ripData->m_fileLength) {
			command->m_command = RIP_END; 
			return;
		}
	}//for (;;)

}


int CRipLoader::megaRead() {

	int ret = 0;
	int i   = 0;
	do {

		char ch = g_ripData->m_fileData[g_ripData->m_filePos++];
		CImageLoader::baudSimWait(g_context, g_ripData);

		if (ch>='0' && ch<='9') {
			ret += (i==1)?(ch-'0'):(ch-'0')*36;
			i++;
		} else if (ch>='A' && ch<='Z') {
			ret += (i==1)?(ch-'A')+10:((ch-'A')+10)*36;
			i++;
		} else if (g_ripData->m_filePos>=g_ripData->m_fileLength || ch==CTRLZ) {
			/*! \note used to have some endOfRip = true here */
			return -1;
		}
	}while(i<2);

	return ret;
}


int CRipLoader::readOne() {

	for (;;) {

		char ch = g_ripData->m_fileData[g_ripData->m_filePos++];
		CImageLoader::baudSimWait(g_context, g_ripData);

		if (ch>='0' && ch<='9') {
			return (ch-'0');
		} else if (ch>='A' && ch<='Z') {
			return (ch-'A');
		} else if (ch==CTRLZ || g_ripData->m_filePos>=g_ripData->m_fileLength) {
			g_ripData->m_filePos--;
			return -1;
		}
	}
}


CString CRipLoader::readText() {

	CString ret = "";
	
	for(;;) {

		char ch = g_ripData->m_fileData[g_ripData->m_filePos++];
		CImageLoader::baudSimWait(g_context, g_ripData);

		if (ch=='|' || ch==CTRLZ || ch=='\n' || g_ripData->m_filePos>=g_ripData->m_fileLength || ch=='!') {
			if (ch=='|' || ch=='!')
				g_ripData->m_filePos--;
			return ret;
		} else if (ch=='\\') {
			do {
				char ch = g_ripData->m_fileData[g_ripData->m_filePos++];
				CImageLoader::baudSimWait(g_context, g_ripData);
			}while(ch=='\n' || ch==CTRLZ);
		} else {
			ret += ch;
		}
	}
	
}