#include "JpegLoader.h"

#include <jpgd/jpegdecoder.h>


CJpegLoader::CJpegLoader(CImageRenderer *renderer) :
	CBinaryLoader(renderer)
{
	
}

CJpegLoader::~CJpegLoader() {
	
}

bool CJpegLoader::isFileType(const char *signature, const char *) {
	
	char jpegsig[] = {(char)0xff, (char)0xd8};
	if (strncmp(signature,jpegsig,2)==0) {
		return true;
	}
	return false;
}


class CJpegBufferStream : public jpeg_decoder_stream
{
public:
	const char		*m_buffer;
	int				m_length;
	int				m_offs;
	
	CJpegBufferStream() : 
	m_offs(0)
	{
	}
	
	~CJpegBufferStream()
	{
	}
	
	// The read() method is called when the internal input buffer is empty.
	// Pbuf - input buffer
	// max_bytes_to_read - maximum bytes that can be written to Pbuf
	// Peof_flag - set this to true if at end of stream (no more bytes remaining)
	// Return -1 on error, otherwise return the number of bytes actually
	// written to the buffer (which may be 0).
	// Notes: This method will be called in a loop until you set *Peof_flag to
	// true or the internal buffer is full.
	// The MMX state will be automatically saved/restored before this method is
	// called, unlike previous versions.
	int read(uchar *Pbuf, int max_bytes_to_read, bool *Peof_flag){
		
		//test
		if ((m_offs+max_bytes_to_read)>m_length)
			max_bytes_to_read = m_length-m_offs;
		//end test
		
		memcpy(Pbuf, m_buffer+m_offs, max_bytes_to_read);
		m_offs += max_bytes_to_read;
		*Peof_flag = (m_offs>=m_length)?true:false;
		return max_bytes_to_read;
	}
};

void CJpegLoader::loadFileFromDataImp(const char *data, const int length, CImageData *imageData) {
	
	CBinaryData *binaryData = (CBinaryData *)imageData;
	binaryData->m_fileType = JPEG;

	CJpegBufferStream *Pinput_stream = new CJpegBufferStream();
	Pinput_stream->m_buffer = data;
	Pinput_stream->m_length = length;
	
	bool use_mmx = true;
	Pjpeg_decoder Pd = new jpeg_decoder((jpeg_decoder_stream *)Pinput_stream, use_mmx);		
	if (Pd->get_error_code() != 0)
	{
		printf("Error: Decoder failed! Error status: %i\n", Pd->get_error_code());
		
		// Always be sure to delete the input stream object _after_
		// the decoder is deleted. Reason: the decoder object calls the input
		// stream's detach() method.
		delete Pd;
		delete Pinput_stream;		
		return;
	}
	
	
	if (Pd->begin())
	{
		printf("Error: Decoder failed! Error status: %i\n", Pd->get_error_code());
		
		delete Pd;
		delete Pinput_stream;
		
		return;
	}
	
	uchar *Pbuf = NULL;
	if (Pd->get_num_components() == 3)
	{
		Pbuf = (uchar *)malloc(Pd->get_width() * 3);
		if (!Pbuf)
		{
			printf("Error: Out of memory!\n");
			
			delete Pd;
			delete Pinput_stream;
			
			return;
		}
	}
	
	int lines_decoded = 0;
	
	uchar *dst = (uchar *)malloc(Pd->get_width()*Pd->get_height()*4);
	
	for ( ; ; )
	{
		void *Pscan_line_ofs;
		uint scan_line_len;
		
		if (Pd->decode(&Pscan_line_ofs, &scan_line_len))
			break;
		
		lines_decoded++;
		
		if (Pd->get_num_components() == 3)
		{
			uchar *Psb = (uchar *)Pscan_line_ofs;
			uchar *Pdb = dst+(lines_decoded-1)*Pd->get_width()*4;
			int src_bpp = Pd->get_bytes_per_pixel();
			
			for (int x = Pd->get_width(); x > 0; x--, Psb += src_bpp, Pdb += 4)
			{
				Pdb[0] = Psb[2];
				Pdb[1] = Psb[1];
				Pdb[2] = Psb[0];
			}
			
		}
	}	
	
	binaryData->m_width  = Pd->get_width();
	binaryData->m_height = Pd->get_height();

	unsigned char *line = new unsigned char[binaryData->m_width*4];
	int offset  = 0;
	int offset2 = (binaryData->m_height-1)*binaryData->m_width*4; 
	for (int i=0; i<binaryData->m_height/2; i++) {
		memcpy(line,		dst+offset,		binaryData->m_width*4);
		memcpy(dst+offset,	dst+offset2,	binaryData->m_width*4);
		memcpy(dst+offset2,	line,			binaryData->m_width*4);
		offset  += binaryData->m_width*4;
		offset2 -= binaryData->m_width*4;
	}
	delete [] line;

	BITMAPINFO bi;
	bi.bmiHeader.biSize			= sizeof(BITMAPINFOHEADER);
	bi.bmiHeader.biPlanes		= 1;
	bi.bmiHeader.biBitCount		= 32;
	bi.bmiHeader.biCompression	= BI_RGB;
	bi.bmiHeader.biSizeImage	= 0;
	bi.bmiHeader.biXPelsPerMeter= 1;
	bi.bmiHeader.biXPelsPerMeter= 1;
	bi.bmiHeader.biClrUsed		= 0;
	bi.bmiHeader.biClrImportant	= 0;
	bi.bmiHeader.biWidth		= binaryData->m_width;
	bi.bmiHeader.biHeight		= binaryData->m_height;

	CDC dc;
	dc.CreateCompatibleDC(NULL); 
	binaryData->m_bitmap = new CBitmap();
	binaryData->m_bitmap->CreateBitmap(binaryData->m_width, binaryData->m_height, dc.GetDeviceCaps(PLANES), dc.GetDeviceCaps(BITSPIXEL), NULL);
	::SetDIBits(dc.GetSafeHdc(), *binaryData->m_bitmap, 0, binaryData->m_height, dst, &bi, DIB_RGB_COLORS);

	free(dst);
	free(Pbuf);
	
	if (Pd->get_error_code())
	{
		printf("Error: Decoder failed! Error status: %i\n", Pd->get_error_code());
		
		delete Pd;
		delete Pinput_stream;
		
		return;
	}
	
	delete Pd;
}