#pragma once


#include "CompressedFile.h"
#include <deque>

/*! Caches files and handles the trickanery or opening compressed files inside compressed files.
	\note You never have to delete a CCompresedFile since the factory will handle that. */
class CCompressedFileFactory {

private:
	static CCompressedFileFactory		*m_factory;
	std::deque<CCompressedFile *>		m_openedFiles;

	CCompressedFile						*loadFileImp(const char *);

public:

	CCompressedFileFactory();
	~CCompressedFileFactory();
	
	CCompressedFile *loadFile(const char *);
	int		getFile(void *, unsigned long *, const char *);
	/*! \return true if the last file in the path is a compressed file e.g. e:\test\blar.rar */
	static bool isCompressedFile(const char *);
	/*! \return true if the path contains a compressed filename e.g. e:\test\blar.rar\myimage.jpg
		Much slower than the above function */
	static bool containsCompressedFile(const char *);
	/*! \return The static instance of CCompressedFileFactory and will instantiate it if m_factory==0 */
	static CCompressedFileFactory *getFactory();

	/*! used to check for file_id.diz */
	bool fileExists(const char *);
};




