#include "AnsiLoader.h"
#include "ImageRenderer.h"
#include "Sauce.h"
#include "ansifont.h"


enum states {
	S_TXT,
	S_CHK_B,
	S_WAIT_LTR,
	S_END
};


/*! ugly, but the threads can only be passed one value and need
	both the context and textData */
struct AnsiThreadData {
		
	CImageContext *context;
	CTextData	  *textData;
};


AnsiThreadData g_threadData;


CAnsiLoader::CAnsiLoader(CImageRenderer *renderer) :
	CImageLoader(renderer)
{
}


CAnsiLoader::~CAnsiLoader() {
}


bool CAnsiLoader::isFileType(const char *, const char *) {
	return false;
}


CImageData *CAnsiLoader::loadFileFromData(const char *data, const int length) {

	CTextData *textData	   = new CTextData();
	textData->m_fileData   = new char[length];
	textData->m_fileLength = length;
	textData->m_sauce      = getSauceFromData(data, length);
	memcpy(textData->m_fileData, data, length);

	loadFileFromDataImp(data, length, textData);
	return textData;
}


CImageData *CAnsiLoader::loadFile(const char *filename) {

	//Load the file into memory
	CTextData *textData = new CTextData();
	textData->copyFilename(filename);
	textData->loadFileAsText(filename);
	loadFileFromDataImp(textData->m_fileData, textData->m_fileLength, textData);

	return textData;
}


void CAnsiLoader::loadFileFromDataImp(const char *data, const int length, CImageData *imageData) {

	CTextData *textData = (CTextData *)imageData;

	//Set the file type
	if (textData->m_sauce) {
		if (textData->m_sauce->DataType==1) {
	
			switch(textData->m_sauce->FileType) {
				case 0: textData->m_fileType	= ASCII;		
						break;
				case 2: textData->m_fileType	= ANSIMATION; 
						textData->m_animation	= true;	
						break;
				case 1: 
				default: textData->m_fileType	= ANSI;		
						break;
			}

			textData->m_iceColors = textData->m_sauce->Flags&1;
		}
	} else {
		//Do NOT want the default type to be ASCII since old ansi's do not have the sauce
		textData->m_fileType = ANSI;
	}

	//Ansi's and ansimations are animateable, may want ascii's to be like that too
	if (textData->m_fileType==ANSI || 
		textData->m_fileType==ANSIMATION)
		textData->m_animateable = true;
}


void CAnsiLoader::startLoad(CImageContext *context, CImageData *data) {

	m_renderer->setImage(context, data);

	CTextData *textData = (CTextData *)data;

	//initialize the loading vars
	textData->m_attribute = BIN_WHITE;
	textData->m_x = 0;
	textData->m_filePos = 0;
	textData->m_list->init(WRAP*2);
	textData->m_line = textData->m_list->forwardCat();
	textData->m_list->savePosition(textData->m_x);

	if ( context->m_animation==ON ||
		(context->m_animation==DEPENDENT && textData->m_animation)) {

		textData->m_list->m_maxLines = 26;
		for (int i=0; i<26; i++) 
			textData->m_list->forwardCat();
		textData->m_line = textData->m_list->top();

		if (context->m_recordMovie) {

		} else {
			
			g_threadData.context  = context;
			g_threadData.textData = textData;
			textData->setThreadDone(false);
			AfxBeginThread((AFX_THREADPROC)loadAnsimation, (void *)&g_threadData);
		}
	} else {

		/*! \note may want to remove */
		textData->m_list->m_maxLines = 0xFFFFFFFF;
		for (int i=0; i<25; i++) 
			textData->m_list->forwardCat();
		textData->m_line = textData->m_list->top();

		AnsiCommandData command;
		memset(command.argbuf, '\0', 256);
		do {			
			getNextAnsiCommand(context, textData, &command);	
			textData->executeCommand(&command);			
		} while(command.command!=ANSI_END_OF_FILE);
	}
}



UINT CAnsiLoader::loadAnsimation(LPVOID pParam) {

	AnsiThreadData *data	= (AnsiThreadData *)pParam;
	CTextData *textData		= data->textData;
	CImageContext *context	= data->context;
	
	AnsiCommandData currentCommand;
	currentCommand.command  = ANSI_STORE;
	memset(currentCommand.argbuf, '\0', sizeof(currentCommand.argbuf));
	bool done				= false;
	
	QueryPerformanceCounter((LARGE_INTEGER *)&textData->m_lastTime);
	textData->m_curTime = textData->m_lastTime;
	
	while(currentCommand.command!=ANSI_END_OF_FILE && !done) {

		getNextAnsiCommand(context, textData, &currentCommand);	
		if (currentCommand.command!=ANSI_END_OF_FILE) 
			textData->addCommand(&currentCommand);

		done = textData->getThreadDone();
	}

	textData->setThreadDone(true);
	AfxEndThread(0);
	return 0;
}

bool CAnsiLoader::loadFrame(CImageContext *context, CImageData *data) {

	CTextData *textData = (CTextData *)data;

	//int endPos = textData->m_filePos + (context->m_speed/10)/context->m_fps;
	/*! \todo get this right */
	int endPos = textData->m_filePos + (context->m_speed)/context->m_fps;
	AnsiCommandData command;
	memset(command.argbuf, '\0', 256);
	do {
		getNextAnsiCommand(context, textData, &command);	
		textData->executeCommand(&command);
	}while(textData->m_filePos<endPos && command.command!=ANSI_END_OF_FILE);

	return (command.command==ANSI_END_OF_FILE);
}

/*
 *			Command execution
 */

void CAnsiLoader::getNextAnsiCommand(CImageContext *context, CTextData *textData, AnsiCommandData *command) {
	
	char	ch;
	int		state = S_TXT;
	int		arg_index = 0;
	command->argbuf[0] = '\0';
	
	while (textData->m_filePos<textData->m_fileLength) {

		ch = textData->m_fileData[textData->m_filePos++];	
		CImageLoader::baudSimWait(context, textData);

		switch( state ) {

		case S_TXT:  
			switch( ch ) {				
				case CTRLZ:
					state = S_END;
					break;
				case ESC:
					state = S_CHK_B; 
					break;
				//NOTE: there used to be special case stores here
				default:
					command->argbuf[0] = ch;
					command->argbuf[1] = '\0';
					command->command = ANSI_STORE;
					return;					
			}
			break;
			
		case S_CHK_B:
			if ( ch != '[' ) {
				command->argbuf[0] = ESC;
				command->argbuf[1] = ch;
				command->argbuf[2] = '\0';
				command->command = ANSI_STORE;
				return;
			} else  {
				state = S_WAIT_LTR;
			}
			break;
				
		case S_WAIT_LTR:
			if ( isalpha( ch ) ) {
				//add end of line to the arguments string
				command->argbuf[ arg_index ] = '\0';
				// handle the ansi code
				switch( ch ) {
				case 'm':	command->command = ANSI_SET_ATTRIBUTES;		return;		// set attrs
				case 'H':															// set position
				case 'f':	command->command = ANSI_SET_POSITION;		return;
				case 'A':	command->command = ANSI_MOVE_UP;			return;		// move up
				case 'B':	command->command = ANSI_MOVE_DOWN;			return;		// down
				case 'C':	command->command = ANSI_MOVE_FORWARD;		return;		// right
				case 'D':   command->command = ANSI_MOVE_BACKWARD;		return;		// left
				case 's':	command->command = ANSI_SAVE_POSITION;		return;		// save
				case 'u':   command->command = ANSI_RESTORE_POSITION;	return;		// restore
				case 'J':	command->command = ANSI_CLEAR_SCREEN;		return;		// clear page
				case 'K':	command->command = ANSI_CLEAR_LINE;			return;		// clear line

				/*! \todo implement 
				Reverse Index
				Move the active position to the same horizontal position on the preceding line. 
				If the active position is at the top margin, a scroll down is performed. */
				case 'M':
					command->command = ANSI_NONE;
					return;

				/*! Enter Graphics Mode Causes the special graphics character set to be used.*/
				case 'F':
					command->command = ANSI_NONE;
					return;

				/*! Exit Graphics Mode This sequence causes the standard ASCII character set to be used.*/
				case 'G':
					command->command = ANSI_NONE;
					return;

				/*! ??? */
				case 'h':
				case 'T':
				case 'L':
				case 'O':
					command->command = ANSI_NONE;
					return;
				
				case '?':	
				case '=':	
					while(ch!='h') {
						ch = textData->m_fileData[textData->m_filePos++];	
						CImageLoader::baudSimWait(context, textData);
					}
					command->command = ANSI_NONE;
					break;
				default:

					command->command = ANSI_NONE;
#ifdef _DEBUG
					{
					char s[100];
					sprintf(s, "unsupported command %c", ch);
					::MessageBox(NULL, s, "blah", MB_OK);
					}
#endif

					break;
				}           
			} else {
				//add a character to the ';' delimited number argument list
				command->argbuf[ arg_index ] = ch; 
				if (arg_index != MAXCMDLEN-1)
					arg_index++;
/*
				else
#ifdef _DEBUG
					::MessageBox(NULL, "agrument buffer exceeded in CAnsiLoader", "arg buffer", MB_OK);
#endif
*/
			}
			break;
		case S_END:
			command->command = ANSI_END_OF_FILE;
			return;
		default:
			state = S_TXT; 
			break;
		}
	}
	command->command = ANSI_END_OF_FILE;	
}

