;
;
;    (CEVS) Cross-Eyed Viking Solutions 
;
;   Demo FX Unit 1.0 / 286 for real mode.
;   Lorne Kirkland Chartier (1996) - public domain.
;
;   * 286 version limitations *
;   - 16-bit math / processing of 32-bit counters, pointers, and timers
;   - source buffer -> destination buffer requires segment override
;
;

                .286p
                .model medium, pascal
                jumps

include         support.inc

                .code

;
;   fire1()     fire algorithm #1
;   author:     from PHRO demo by Phred/OTM
;   does:       averages frame 1 data + random line to create frame 2
;

                public fire1

fire1           proc pascal b1ptr:far ptr byte, b2ptr:far ptr byte, bufw:word, \
                            bufd:word
                uses ds, es, si, di

                mov ax,bufw
                mov cx,bufd
                dec cx
                mul cx
                lds si,b1ptr                    ; get buffer pointers
                les di,b2ptr
                add si,ax
                add di,ax                       ; start at buffer end

                ; generate random line for averaging
                push si
                mov cx,bufw
align 2
dofire1_rl:
                @rand
                and ax,1
                or al,al
                jz dofire1_r1
                mov al,255
dofire1_r1:
                mov byte ptr [si],al
                inc si
                loop dofire1_rl
                pop si

                ; start of main loop for averaging buffer
                mov bx,bufw
                dec si
                dec di

                mov dx,bufd
                dec dx
align 2
dofire1_1:
                push di si dx
                mov cx,0

align 2
dofire1_2:
                mov ax,0
                mov dx,0
                mov al,byte ptr [si+bx-1]
                mov dl,byte ptr [si+bx]
                add ax,dx
                mov dl,byte ptr [si+bx+1]
                add ax,dx
                mov dl,byte ptr [si]
                add ax,dx
                shr ax,2
                jz @skipdec
                dec ax
@skipdec:

                mov byte ptr es:[di],al
                dec di
                dec si

                ; loop for remaining cols
                inc cx
                cmp cx,bufw
                jl dofire1_2

                ; loop for remaining rows
                pop dx si di
                sub di,bx
                sub si,bx
                cmp dx,0
                je dofire1_d
                dec dx
                jmp dofire1_1

dofire1_d:
                ret
fire1           endp


;
;   plasma1()   plasma algorithm #1
;   author:     by Bas van Gaalen & Sven van Heel, Holland, PD
;               improved by GEM, Sweden, from SWAG pascal collection
;   does:       creates frame 2 from scratch via sine tables
;

pls1add1        db 50
pls1add2        db 90

                public plasma1

plasma1         proc pascal b1ptr:far ptr byte, b2ptr:far ptr byte, bufw:word, \
                            bufd:word
                uses ds, es, si, di
                cld

                les di,b2ptr                    ; es:di = destination

                mov ax,cs
                mov ds,ax

                inc [pls1add1]
                mov cl,[pls1add1]               ; cl = table 1 additive
                inc [pls1add2]
                mov ch,[pls1add2]               ; ch = table 2 additive

                mov dx,0
align 2
plasma1l1:
                push dx

                mov si,offset sintab
                mov bx,dx
                push bx
                add bl,cl
                mov dl,[si+bx]
                xor dh,dh
                mov bl,ch
                mov al,[si+bx]
                add si,dx
                pop bx
                add bl,al
                add bx,offset costab
                mov bl,[bx]
                mov bh,bl

                mov dx,bufw
                shr dx,1                        ; dx = words to write for row
align 2
plasma1l2:
                lodsw
                add ax,bx
                stosw
                dec dx
                jnz plasma1l2
                cmp si,offset sintab + 256
                jb plasma1l3
                sub si,256

align 2
plasma1l3:
                pop dx
                inc dx
                cmp dx,bufd
                jl plasma1l1

                ret
plasma1         endp


;
;
;   DATA (STORED IN CODE SEGMENT)
;
;

SINTAB LABEL BYTE
                DB 080H, 083H, 086H, 089H, 08DH, 090H, 093H, 096H
                DB 099H, 09CH, 09FH, 0A2H, 0A5H, 0A8H, 0ABH, 0AEH
                DB 0B1H, 0B4H, 0B7H, 0BAH, 0BDH, 0BFH, 0C2H, 0C5H
                DB 0C7H, 0CAH, 0CDH, 0CFH, 0D1H, 0D4H, 0D6H, 0D9H
                DB 0DBH, 0DDH, 0DFH, 0E1H, 0E3H, 0E5H, 0E7H, 0E9H
                DB 0EBH, 0ECH, 0EEH, 0F0H, 0F1H, 0F3H, 0F4H, 0F5H
                DB 0F6H, 0F8H, 0F9H, 0FAH, 0FBH, 0FCH, 0FCH, 0FDH
                DB 0FEH, 0FEH, 0FFH, 0FFH, 0FFH,  00H,  00H,  00H
COSTAB LABEL BYTE
                DB  00H,  00H,  00H,  00H, 0FFH, 0FFH, 0FEH, 0FEH
                DB 0FDH, 0FDH, 0FCH, 0FBH, 0FAH, 0F9H, 0F8H, 0F7H
                DB 0F6H, 0F5H, 0F3H, 0F2H, 0F0H, 0EFH, 0EDH, 0ECH
                DB 0EAH, 0E8H, 0E6H, 0E4H, 0E2H, 0E0H, 0DEH, 0DCH
                DB 0DAH, 0D7H, 0D5H, 0D3H, 0D0H, 0CEH, 0CBH, 0C9H
                DB 0C6H, 0C3H, 0C1H, 0BEH, 0BBH, 0B8H, 0B5H, 0B3H
                DB 0B0H, 0ADH, 0AAH, 0A7H, 0A4H, 0A1H, 09EH, 09BH
                DB 098H, 094H, 091H, 08EH, 08BH, 088H, 085H, 082H
                DB 07EH, 07BH, 078H, 075H, 072H, 06FH, 06CH, 068H
                DB 065H, 062H, 05FH, 05CH, 059H, 056H, 053H, 050H
                DB 04DH, 04BH, 048H, 045H, 042H, 03FH, 03DH, 03AH
                DB 037H, 035H, 032H, 030H, 02DH, 02BH, 029H, 026H
                DB 024H, 022H, 020H, 01EH, 01CH, 01AH, 018H, 016H
                DB 014H, 013H, 011H, 010H,  0EH,  0DH,  0BH,  0AH
                DB  09H,  08H,  07H,  06H,  05H,  04H,  03H,  03H
                DB  02H,  02H,  01H,  01H,  00H,  00H,  00H,  00H
                DB  00H,  00H,  00H,  01H,  01H,  01H,  02H,  02H
                DB  03H,  04H,  04H,  05H,  06H,  07H,  08H,  0AH
                DB  0BH,  0CH,  0DH,  0FH, 010H, 012H, 014H, 015H
                DB 017H, 019H, 01BH, 01DH, 01FH, 021H, 023H, 025H
                DB 027H, 02AH, 02CH, 02FH, 031H, 033H, 036H, 039H
                DB 03BH, 03EH, 041H, 043H, 046H, 049H, 04CH, 04FH
                DB 052H, 055H, 058H, 05BH, 05EH, 061H, 064H, 067H
                DB 06AH, 06DH, 070H, 073H, 077H, 07AH, 07DH, 080H
                DB 083H, 086H, 089H, 08DH, 090H, 093H, 096H, 099H
                DB 09CH, 09FH, 0A2H, 0A5H, 0A8H, 0ABH, 0AEH, 0B1H
                DB 0B4H, 0B7H, 0BAH, 0BDH, 0BFH, 0C2H, 0C5H, 0C7H
                DB 0CAH, 0CDH, 0CFH, 0D1H, 0D4H, 0D6H, 0D9H, 0DBH
                DB 0DDH, 0DFH, 0E1H, 0E3H, 0E5H, 0E7H, 0E9H, 0EBH
                DB 0ECH, 0EEH, 0F0H, 0F1H, 0F3H, 0F4H, 0F5H, 0F6H
                DB 0F8H, 0F9H, 0FAH, 0FBH, 0FCH, 0FCH, 0FDH, 0FEH
                DB 0FEH, 0FFH, 0FFH, 0FFH,  00H,  00H,  00H,  00H
                DB  00H,  00H,  00H, 0FFH, 0FFH, 0FEH, 0FEH, 0FDH
                DB 0FDH, 0FCH, 0FBH, 0FAH, 0F9H, 0F8H, 0F7H, 0F6H
                DB 0F5H, 0F3H, 0F2H, 0F0H, 0EFH, 0EDH, 0ECH, 0EAH
                DB 0E8H, 0E6H, 0E4H, 0E2H, 0E0H, 0DEH, 0DCH, 0DAH
                DB 0D7H, 0D5H, 0D3H, 0D0H, 0CEH, 0CBH, 0C9H, 0C6H
                DB 0C3H, 0C1H, 0BEH, 0BBH, 0B8H, 0B5H, 0B3H, 0B0H
                DB 0ADH, 0AAH, 0A7H, 0A4H, 0A1H, 09EH, 09BH, 098H
                DB 094H, 091H, 08EH, 08BH, 088H, 085H, 082H, 07EH
                DB 07BH, 078H, 075H, 072H, 06FH, 06CH, 068H, 065H
                DB 062H, 05FH, 05CH, 059H, 056H, 053H, 050H, 04DH
                DB 04BH, 048H, 045H, 042H, 03FH, 03DH, 03AH, 037H
                DB 035H, 032H, 030H, 02DH, 02BH, 029H, 026H, 024H
                DB 022H, 020H, 01EH, 01CH, 01AH, 018H, 016H, 014H
                DB 013H, 011H, 010H,  0EH,  0DH,  0BH,  0AH,  09H
                DB  08H,  07H,  06H,  05H,  04H,  03H,  03H,  02H
                DB  02H,  01H,  01H,  00H,  00H,  00H,  00H,  00H
                DB  00H,  00H,  01H,  01H,  01H,  02H,  02H,  03H
                DB  04H,  04H,  05H,  06H,  07H,  08H,  0AH,  0BH
                DB  0CH,  0DH,  0FH, 010H, 012H, 014H, 015H, 017H
                DB 019H, 01BH, 01DH, 01FH, 021H, 023H, 025H, 027H
                DB 02AH, 02CH, 02FH, 031H, 033H, 036H, 039H, 03BH
                DB 03EH, 041H, 043H, 046H, 049H, 04CH, 04FH, 052H
                DB 055H, 058H, 05BH, 05EH, 061H, 064H, 067H, 06AH
                DB 06DH, 070H, 073H, 077H, 07AH, 07DH, 080H, 083H
                DB 086H, 089H, 08DH, 090H, 093H, 096H, 099H, 09CH
                DB 09FH, 0A2H, 0A5H, 0A8H, 0ABH, 0AEH, 0B1H, 0B4H
                DB 0B7H, 0BAH, 0BDH, 0BFH, 0C2H, 0C5H, 0C7H, 0CAH
                DB 0CDH, 0CFH, 0D1H, 0D4H, 0D6H, 0D9H, 0DBH, 0DDH
                DB 0DFH, 0E1H, 0E3H, 0E5H, 0E7H, 0E9H, 0EBH, 0ECH
                DB 0EEH, 0F0H, 0F1H, 0F3H, 0F4H, 0F5H, 0F6H, 0F8H
                DB 0F9H, 0FAH, 0FBH, 0FCH, 0FCH, 0FDH, 0FEH, 0FEH
                DB 0FFH, 0FFH, 0FFH,  00H,  00H,  00H,  00H,  00H
                DB  00H,  00H, 0FFH, 0FFH, 0FEH, 0FEH, 0FDH, 0FDH
                DB 0FCH, 0FBH, 0FAH, 0F9H, 0F8H, 0F7H, 0F6H, 0F5H
                DB 0F3H, 0F2H, 0F0H, 0EFH, 0EDH, 0ECH, 0EAH, 0E8H
                DB 0E6H, 0E4H, 0E2H, 0E0H, 0DEH, 0DCH, 0DAH, 0D7H
                DB 0D5H, 0D3H, 0D0H, 0CEH, 0CBH, 0C9H, 0C6H, 0C3H
                DB 0C1H, 0BEH, 0BBH, 0B8H, 0B5H, 0B3H, 0B0H, 0ADH
                DB 0AAH, 0A7H, 0A4H, 0A1H, 09EH, 09BH, 098H, 094H
                DB 091H, 08EH, 08BH, 088H, 085H, 082H, 07EH, 07BH

                end

