;-----------------------------------
; dot.asm -  Maurice L. Marvin

DOSSEG
.model SMALL
.stack 100h
.code

   Color     EQU 100d        ; Color for pixel.
   Delay     EQU 2000d       ; # milliseconds to delay.
   Num_Times EQU 10d         ; Number of times to draw pixels across screen.

start:
   MOV  AX,0013h             ; Enter video mode 13h, 320x200x256 chained.
   INT  10h                  ; INT 10h, Function 00 (set mode).

   MOV  AH,Num_Times

   MOV  DX,0A000h            ; Setup ES:BX to address video memory.
   MOV  ES,DX
  @Next_Line:
   MOV  BX,7d00h

   MOV  CX,320d              ; Draw 320 pixels (width of display)
   MOV  AL,Color
  @Dot_Loop:
   PUSH AX             ; Save AX & CX
   PUSH CX
  @TR:
   ; Test for vertical retrace.
   MOV  DX,3C0h
   IN   AL,DX
   TEST AL,1000b
   JNZ  @TR

   MOV  ES:[BX],AL           ; Write pixel

   ; Do Delay
   MOV  AH,86h
   XOR  CX,CX
   MOV  DX,Delay
   INT  15h

   ; Test for vertical retrace.
  @AT:
   MOV  DX,3C0h
   IN   AL,DX
   TEST AL,1000b
   JNZ  @AT

   MOV  BYTE PTR ES:[BX],00h ; Erase pixel
   INC  BX
   POP  CX             ; Restore AX & CX
   POP  AX
   LOOP @Dot_Loop         ; Write dot in next position.
   DEC  AH
   JNZ  @Next_Line         ; Start over at left of screen.

   MOV  AX,0003h             ; Return to text mode.
   INT  10h

   MOV  AX,4C00h             ; Return to DOS.
   INT  21h
END start

