;  codebas.asm   converts a binary double word to an ASCII decimal string
;
;
;
.model       small
.386

public codebas

.code

codebas      proc
             push         edx                  ; save entry registers
             push         ecx
             push         eax
             or           eax,eax              ; check the sign
             jns          positive             ; if positive, no problem
             not          eax                  ; get the inverted number
             inc          eax                  ; plus one.
positive:
             std                               ; we create digits from right
             add          di,11                ; to left.
             mov          byte ptr es:1[di],0  ; set ASCII terminator
             mov          ecx,100              ; and the divisor.
             sub          edx,edx              ; prepare to do division
divdh:
             div          ecx                  ; divide by 100
             xchg         edx,eax              ; flip quotient and remainder
             aam                               ; we expand the two digits
             or           ax,'00'              ; put zeros on them,
             stosb
             mov          al,ah
             stosb                             ; and store the pair.
             sub          eax,eax              ; clear our working register
             xchg         eax,edx              ; get quotient for division
             or           eax,eax              ; is there more left ?
             jnz          divdh                ; yes, go do it.
             cmp          byte ptr es:1[di],'0'; leading zero ?
             jne          nolead0              ; no, don't.
             inc          di                   ; back up over it.
nolead0:
             pop          eax                  ; get number back.
             or           eax,eax              ; check it's sign, and
             jns          positive2            ; skip if positive
             mov          byte ptr es:[di],'-' ; set sign
             dec          di                   ; and make room for it
positive2:
             inc          di                   ; point to first digit
             pop          ecx
             pop          edx
             ret
codebas      endp
             end
