;  frespace.ASM   10/04/84  gwf
;
;
;
;	CALL FRESPACE(AH,AL,BH,BL,CH,CL). CL SHOULD BE 0 for default
;	  drive 1 for A, 2 for B, 3 for C, etc. The value of the
;	  other variables does not matter. They will come back
;	  with a meaningful value.
;
;		   AN EXAMPLE PROGRAM:
;
;      10 defint a-z
;      20 color 7,1:cls
;      30 test1=1:ah=0:al=0:bh=0:ch=0:cl=1:test2=2
;      35 INPUT"DRIVE 0=DEFAULT, 1=A, 2=B, 3=C";CL
;      37 PRINT"JUST BEFORE CALL"
;      40 CALL FRESPACE(AH,AL,BH,BL,CH,CL)
;      45 PRINT"JUST AFTER CALL"
;      50 PRINT" AH=";AH;" AL=";AL;" BH=";BH;" BL=";BL;" CH=";CH;" CL=";CL;
;      60 UFREE!=256*AH+AL
;      70 UBYTES!=256*BH+BL
;      80 USECTOR!=256*CH+CL
;      90 PRINT"UFREE!=";UFREE!;"  UBYTES!=";UBYTES!;"   USECTOR!=";USECTOR!
;      100 FRESPACE!=UFREE!*UBYTES!*USECTOR!
;      110 PRINT"FRESPACE!=";FRESPACE!
;      120 PRINT"THIS SHOULD BE 1",TEST1
;      130 PRINT"THIS SHOULD BE 2",TEST2
;

get_spa equ	36h	;Get disk free space function call
doscall equ	21h	;DOS interrupt number

dgroup	group	datarea
datarea segment para public 'DATA'

ah_ret	dw	?		;ah to be sent back
al_ret	dw	?		;al to be sent back
bh_ret	dw	?		;bh to be sent back
bl_ret	dw	?		;bl to be sent back
ch_ret	dw	?		;ch to be sent back
cl_ret	dw	?		;cl to be sent back

datarea ENDS
;
cseg	    segment 'CODE'
	    assume  cs:cseg
	    public frespace
frespace    proc    far
	push	bp		;BP from BASIC
	mov	bp,sp		;set base for parm list
	push	ds		;DS from basic work area
	push	es		;ES from basic work area
	mov	ax,datarea	;establish data addressability
	mov	ds,ax		;now DS is local data
	assume	ds:datarea
;
;
;
;
	push	bp
	sub	ax,ax
	mov	si,ss:[bp+6]	;get addr of parameter
	mov	al,es:[si]	;get value of parm
	mov	dx,ax		;dl contains the drive number on call
				;dh will be zero
	mov  ah,get_spa 	;get space function number
	int  doscall		;Call DOS

; Move the values into local work area to prepare to send back to basic
	xchg	dx,ax		;must have a word. Want to zero out DH.
	sub	ax,ax		; produce the zero
	xchg	dx,ax		; DX is now zero.
				;  DH is what we really want as zero.

	mov	dl,ah		;want to send back a byte
	mov	ah_ret,dx	;   prepare to return ah

	mov	dl,al		;want to send back a byte
	mov	al_ret,dx	;   prepare to return al

	mov	dl,bh		;want to send back a byte
	mov	bh_ret,dx	;   prepare to return bh

	mov	dl,bl		;want to send back a byte
	mov	bl_ret,dx	;   prepare to return bl

	mov	dl,ch		;want to send back a byte
	mov	ch_ret,dx	;   prepare to return ch

	mov	dl,cl		;want to send back a byte
	mov	cl_ret,dx	;   prepare to return cl


; Go back
	pop	bp		;get back Basic's workspace
	mov	ax,cl_ret
	mov	si,ss:[bp+6]
	mov	es:[si],ax	;return cl

	mov	ax,ch_ret
	mov	si,ss:[bp+8]
	mov	es:[si],ax	;return ch

	mov	ax,bl_ret
	mov	si,ss:[bp+10]
	mov	es:[si],ax	;return bl

	mov	ax,bh_ret
	mov	si,ss:[bp+12]
	mov	es:[si],ax	;return bh

	mov	ax,al_ret
	mov	si,ss:[bp+14]
	mov	es:[si],ax	;return al

	mov	ax,ah_ret
	mov	si,ss:[bp+16]
	mov	es:[si],ax	;return ah
;
	pop	es
	pop	ds
	pop	bp
	ret	12		;return to basic 6 parameters were sent
frespace    endp
;-----------------------------------------------------------------------
cseg	ends
	end			;end for assembler
