;             Ss.
; ----- SSS -----cp437-
;             ~S
;   .s'~ ^~s.           .s'~ ^~s.
;  .SS       'SS.        .SS       'SS.
;  SSS  --  :SS  --  SSS  ----  :SS
;  S".      .SSS        SSS.      ."S
;      s.   .sSS'        'SSs.   .s
;       "*sS*            *Ss*"  Ss.
; .sS.        .s~^    ^~s.       .SSS
;  SSs.    .s"  .   ^~s. "s.    .sSS'
;    '*Ss*"  sS       'SS. "*sS*'
;             SSS  ----  :SS
;             SSS.      .SSS
; --- SSS s.   .sSS' --rac^dug-
;             "S  "*sS*

      DOSSEG              ;assembler directives for .com linking
     .MODEL tiny
     .386
     .CODE
      ORG 100h

     INCLUDE mode13h.asm
     INCLUDE retrace.asm
     INCLUDE textmode.asm
     INCLUDE terminat.asm

     NumColors     = 12
     NumDots       = 100
     NumVgaColumns = 320
     NumVgaRows    = 200
     NumUpperRows  = 150
     CenterX       = 160
     CenterY       = 75
     ScreenCenter  = CenterY * NumVgaColumns + CenterX

     ;the cos table works as follows - the total range covered is
     ;2 * pi where 2 * pi corresponds to 1024 entries - CosTabOffset
     ;points after the first 90 degrees - SimdModMask is applied such that a
     ;dword-wise addressing of 1024 entries is done - SimdIncrement is for
     ;increasing both coordinates in parallel

     NumCosVals    = 0400h
     DWordSize     = 0004h
     WordSize      = 0002h
     CosTabSize    = NumCosVals * DWordSize
     CosTabOffset  = 00h * DWordSize
     CosTabPointer = Offset(AfterEnd)
     AfterCosTab   = CosTabPointer + CosTabSize

     ModMask       = 0FFCh
     SimdModMask   = (ModMask SHL 16) OR ModMask
     Increment     = 000Ch
     SimdIncrement = (Increment SHL 16) OR Increment

     SpriteUpper   = 0401h   ;2 * 2 compiled sprite
     SpriteLower   = 0203h

     VgaSeg        = 0a000h

Main:
     Mode13h 00h             ;destroys ax

     mov   ax,     cs
     add   BufSeg, ax

     mov   dx,     03C8h     ;vga register for palette change
     xor   ax,     ax
     out   dx,     al
     inc   dx                ;increment to next vga register to write rgb vals

     mov   si, Offset(Palette)
     mov   cx, NumColors * 3 ;12 colors with 3 components (rgb) each
PaletteLoop:
     xor   ah, 01            ;toggle ah, load next palette entry only on
     je    SkipRead          ;every second write
     lodsb
SkipRead:
     out   dx, al
     rol   al, 04h
     loop  PaletteLoop

     ;the next line is missing in the original
     ;it can cause the program to crash on an HP Mini 110-3100 under
     ;FreeDOS 1.3

     finit
     fldz                    ;cos tab generator, writes after program data
     mov   cx, NumCosVals
NextCosine:
     fld   st(0)             ;copy top of stack
     fcos
     fmul  Amplitude         ;scale cosine val (dword ptr)
     fistp dword ptr [si]    ;write next cosine table value
     fadd  AngleInc          ;add angle increment (dword ptr)
     add   si, DWordSize     ;address next entry
     loop  NextCosine
     ffree st(0)

     mov   ebp, SimdModMask  ;mask for application after addition

MainLoop:
     mov   es,  BufSeg
     xor   di,  di
     xor   ax,  ax
     dec   cx                ;as cx = 0, same effect as mov cx, 65536

     rep   stosb

     add   dword ptr ds:[AfterCosTab], SimdIncrement ;the blocks have been
     and   dword ptr ds:[AfterCosTab], ebp           ;swapped to clip the table
                                                     ;index into the proper
     mov   di,   word ptr ds:[AfterCosTab         ]  ;range
     mov   bx,   word ptr ds:[AfterCosTab+WordSize]

     mov   cx, NumDots

DotLoop:
     mov   si, [bx+CosTabPointer+CosTabOffset]                ;bx = row val
     imul  si, NumVgaColumns
     add   si, [di+CosTabPointer+CosTabOffset]                ;di = col val
     mov   es:word ptr [si+ScreenCenter              ], SpriteUpper
     mov   es:word ptr [si+ScreenCenter+NumVgaColumns], SpriteLower

     mov   si, SlowCount ;pseudo-random number generation - point somewhere
                         ;into memory, extract two bytes and use them as
                         ;increments for the indices to the cos tab

     lodsw                   ;lissajous figure routine
     xor   ax, [si]          ;di = row val
     xor   ah, ah
     sub   di, ax
     and   di, bp

     lodsw                   ;lissajous figure routine
     xor   ax, [si]          ;bx = col val
     xor   ah, ah
     sub   bx, ax
     and   bx, bp

     loop  DotLoop

     inc   word ptr FastCount

     WaitUntilRetrace

     push  ds
     push  es

     push VgaSeg             ;flip backbuffer to vga buffer
     pop  es

     pop   ds                ;first flip upper part (wordwise copy)
     xor   si, si
     xor   di, di
     mov   cx, NumUpperRows * NumVgaColumns / 2
     rep   movsw

     mov   dx, NumVgaRows - NumUpperRows
LowerRowsLoop:
     sub   si, 3 * NumVgaColumns

     mov   cx, NumVgaColumns ;flip row (bytewise copy and palette change)
RowLoop:
     lodsb
     add   al, 06h           ;shift color to higher palette position
     stosb
     loop  RowLoop 

     dec   dx
     jne   LowerRowsLoop   

     pop   ds

     mov   ah, 01h           ;check for keypress
     int   16h
     je    MainLoop

     Textmode
     TerminateClean

     BufSeg    dw 01000h ;stores a pointer to graphics backbuffer
     FastCount db 00000h ;partially accessed together wordwise
     SlowCount dw 00100h

     Amplitude dd 72.0                              ;hex 042900000h
     AngleInc  dd 0.0061359233222901821136474609375 ;hex 03BC90FDBh

     Palette db 000h, 04Bh, 0BBh, 0DDh, 05Ah, 026h, 0EEh, 06Bh, 037h
             db 0C0h, 04Fh, 0FFh, 09Eh, 066h, 0F2h, 0AFh, 077h, 000h 

AfterEnd:
     END Main                ;cos tab is written after the palette data
