
static float PI=3.1415926535897932384626433832795;

cbuffer CB : register(b0)
{
	uint	t0,t1,ai,ld;
	float2	CD;
};

Texture2D fsquad : register(t0);
sampler fssamp : register(s0);

/*float fake_noise(float2 co){
    return frac(sin(dot(co ,float2(12.9898,78.233))) * 43758.5453);
}*/

float4 permute(float4 x) {
	x+=34*x*x;
	return x-floor(x/289)*289;
}

float snoise(float3 v)
{ 
//	return 0;
  float2  C = {1./6,1./3};
  float4  D = {0,.5,1,2};

// First corner
  float3 i  = floor(v + dot(v, C.yyy) );
  float3 x0 =   v - i + dot(i, C.xxx) ;

// Other corners
  float3 g = step(x0.yzx, x0);
  float3 l = 1.0 - g;
  float3 i1 = min( g, l.zxy );
  float3 i2 = max( g, l.zxy );

  float3 x1 = x0 - i1 + C.xxx;
  float3 x2 = x0 - i2 + C.yyy; // 2.0*C.x = 1/3 = C.y
  float3 x3 = x0 - D.yyy;      // -1.0+3.0*C.x = -0.5 = -D.y

// Permutations
  i -= floor(i / 289) * 289; 
  float4 p = permute( permute( permute( 
             i.z + float4(0, i1.z, i2.z, 1 ))
           + i.y + float4(0, i1.y, i2.y, 1 )) 
           + i.x + float4(0, i1.x, i2.x, 1 ));

// Gradients: 7x7 points over a square, mapped onto an octahedron.
// The ring size 17*17 = 289 is close to a multiple of 49 (49*6 = 294)
  float3  ns = D.wyz/7 - D.xzx;

  float4 j = p - 49 * floor(p * ns.z * ns.z);  //  mod(p,7*7)

  float4 x_ = floor(j * ns.z);
  float4 y_ = floor(j - 7 * x_ );    // mod(j,N)

  float4 x = x_ *ns.x + ns.yyyy;
  float4 y = y_ *ns.x + ns.yyyy;
  float4 h = 1 - abs(x) - abs(y);

  float4 b0 = float4( x.xy, y.xy );
  float4 b1 = float4( x.zw, y.zw );

  //float4 s0 = float4(lessThan(b0,0.0))*2.0 - 1.0;
  //float4 s1 = float4(lessThan(b1,0.0))*2.0 - 1.0;
  float4 s0 = floor(b0)*2+1;
  float4 s1 = floor(b1)*2+1;
  float4 sh = -step(h, 0);

  float4 a0 = b0.xzyw + s0.xzyw*sh.xxyy ;
  float4 a1 = b1.xzyw + s1.xzyw*sh.zzww ;

// Mix final noise value
  float4 m = max(.6 - float4(dot(x0,x0), dot(x1,x1), dot(x2,x2), dot(x3,x3)), 0);
  return 42 * dot( m*m*m*m, float4( dot(normalize(float3(a0.xy,h.x)),x0), dot(normalize(float3(a0.zw,h.y)),x1), 
                                dot(normalize(float3(a1.xy,h.z)),x2), dot(normalize(float3(a1.zw,h.w)),x3) ) );
}

float4x4 wp(out float pattern, out float3 campos)
{
	pattern=t1/508032.;

	float pattern_emel=pow(max(pattern-3,0),2);
	campos=float3(0,16+pattern_emel*72,-16-pattern*16);

	float forog=max(pattern-4,0)*.1;
	float3 camto=float3(0,16+pattern_emel*50,0);
	float3 zaxis=normalize(camto-campos);
	float3 xaxis=normalize(cross(float3(sin(forog),1,cos(forog)), zaxis));
	float3 yaxis=cross(zaxis, xaxis);

	float4x4 view={	{xaxis, -dot(xaxis,campos)},
					{yaxis, -dot(yaxis,campos)},
					{zaxis, -dot(zaxis,campos)},
					{0,0,0,1}};
					
	return transpose(view);
}

#define B_V ((ld+2)*2)
float gt(float3 p) {return abs(snoise(float3(p.xz*.001,.653)))*-200;}

struct vsout
{
float4 spos:SV_POSITION;
float3 wp:TEXCOORD0;
float3 n:TEXCOORD1;
float3 l:TEXCOORD2;
float m:TEXCOORD3;
};



vsout vs(uint v:SV_VertexID, uint i:SV_InstanceID)
{
	vsout o;
	
	float3 campos;
	float pattern;
	float4x4 view=wp(pattern,campos);

	if (ld==2) // terrain
	{
		uint vv=clamp(v%2052, 1, 2050)-1;

		o.m=255;
		o.l=float3(v/2052+(vv&1)-512., 0, vv/2-512.)*6;
		o.l.y=o.n=gt(o.l);
		o.wp=o.l;
	} else { // tree
		i+=(ld<16)+(ld<8)*64;
		
		float3 tree_pos;
		sincos(i*PI*(3-sqrt(5))+4, tree_pos.x, tree_pos.z);
		tree_pos.xz*=sqrt(i)*35;
		tree_pos.y=gt(tree_pos);


		uint branch_num=v/B_V/ld;
		uint branch_depth=log2(branch_num+1);

		float jaj=max(pattern-7.5,0)*2.5+max(pattern-7.85,0)*20;
		float3 sc;
		float2 a={1,0};
		float4x4 branch_matrix={a.xyyy,a.yxyy,a.yyxy,{tree_pos,1}};

		for (uint i=0;i<branch_depth;i++,branch_num>>=1)
		{
			float branch_random=snoise((float3(tree_pos.xz,i*.9))*100);

			sincos(branch_random*PI/2, sc.x, sc.z);
			float4x4 branch_y={{sc.z,0,-sc.x,0},a.yxyy,{sc.x,0,sc.z,0},a.yyyx};
			
			float random_rot=abs(branch_random)*.2+PI/6;
			sincos((branch_num&1 ? random_rot : -random_rot)+snoise(float3(branch_matrix[3].xz/4, pattern*2))*.1, sc.x, sc.z); // branch rot
			sc.y=1;
			sc*=abs(branch_random)*.1+.66+jaj; // branch scale
			float4x4 branch_local={{sc.zx,0,0},
									{-sc.x,sc.z,0,0},
									{0,0,sc.y,0},
									{0,(branch_random>0)^(branch_num&1)?10:15.5,0,1}}; // side

			branch_matrix=mul(branch_local, mul(branch_y, branch_matrix));
		}

		uint vv=clamp(v%B_V, 1, B_V-2)-1;
		uint band_pos=(v/B_V%ld+(vv&1))*16/ld;

		sincos((vv/2)*PI*2/ld, sc.x, sc.z);
		sc*=pow(band_pos+.2, -.12);
		sc.y=band_pos;

		o.l=o.n=sc+snoise(sc*2)*.3;
		o.n.y-=band_pos;
		o.m=branch_depth*4+4;
		
		if (branch_depth==log2(ld)*2-1) // leaves override
		{
			o.l=o.n=float3(snoise(vv),snoise(vv*2),snoise(vv*3))*30;
			o.l/=jaj*20+1;
			o.m=-1;
		}

		o.wp=mul(float4(o.l,1), branch_matrix);
		o.n=mul(o.n, (float3x3)branch_matrix);
	}

	o.spos=mul(float4(o.wp,1), view);
	o.spos.yzw=float3(o.spos.y*CD.x/CD.y,1.0001*(o.spos.z-o.spos.w), o.spos.z);
	return o;
}

float4 ps(vsout i):SV_TARGET
{
	float3 campos;
	float pattern;
	wp(pattern,campos);
	float beat=pattern*48;

	float3 albedo_color;
	float glow=.01;
	if (i.m>254) // terrain
	{
		albedo_color=snoise(i.l*10)*.05+.1;
		i.n=normalize(cross(ddx(i.wp),ddy(i.wp)));
	} else
	if (i.m>0) // branch
	{
		i.n+=snoise(i.l*5)/i.m;
		albedo_color=float3(.5,.4,.3);
	} else { // leaf
		float leaf=snoise(i.l*.3);
		clip(leaf);
		albedo_color=float3(.56,.7,.5)*leaf;

		// gyors glow
		float gyors_glow=(pattern>=4?1-frac(beat)*.5:0)*saturate(snoise(i.wp/500+(int)beat))*4;
		albedo_color.r+=gyors_glow;
		glow+=gyors_glow;
		
		// masik gyors glow
		gyors_glow=(pattern>=6?1-frac(beat)*.5:0)*saturate(snoise(i.wp/250+(int)beat))*4;
		albedo_color.b+=gyors_glow;
		glow+=gyors_glow;
		
		if (pattern<7.5&&pattern>=2&&(beat%((pattern>=4)?12:24))<6)
		{
			albedo_color.g+=sin(t1)*.2+.8;
			glow=1;
		}
	}

	float robban=max(pattern-7.875,0)*20;
	albedo_color+=robban;
	glow+=robban;
	
	float fog_factor=max(glow,1-saturate(distance(campos, i.wp)*.00025));
	float intro_fog=1-pow(saturate(distance(i.wp,float3(0,16,0))/(max(pattern-4,0)*50000+26)), 64);
	fog_factor=min(fog_factor, intro_fog);

	//fog_factor=1;
	return float4((max(dot(normalize(i.n), float3(2/3.,2/3.,-1/3.)),0)+.2)*albedo_color*fog_factor, glow);
}


float4 v(uint v:SV_VertexID):SV_POSITION
{return float4((v&2)-.1,(v&1)-.1,0,.1);}

float3 p(float4 in_pos : SV_POSITION) : SV_TARGET
{
	float3 campos;
	float pattern;
	float4x4 view=wp(pattern,campos);

	float3 vray={(in_pos.xy-CD/2)/(CD.x/2),1};
	vray.y*=-1;
	vray=normalize(mul((float3x3)view, vray));
	
	float zsizsi=0;
	for (int i=0;i<12;i++)
		zsizsi+=snoise((campos+vray*(snoise(vray*100)+i*4))*2)/14;
		
//	return zsizsi*zsizsi;

	if (pattern<7.5||pattern>=7.875)
//		in_pos.x+=(fake_noise(in_pos.y+pattern)-.5)*pow(1-frac(pattern*4+.5),8)*pow(max(pattern-4,0),5);
		in_pos.x+=snoise(in_pos.y+pattern*1234)*pow(1-frac(pattern*4+.5),8)*pow(max(pattern-4,0),4);
		
	float4 wpos=fsquad.Load(in_pos);
	if (wpos.a)
	{
		float4 blurred=0;
		for (int i=0;i<25;i++)
			blurred+=fsquad.Sample(fssamp, (in_pos.xy+float2(i/5-2,i%5-2)*8)/CD)/20;

		wpos+=blurred*blurred.a;
	} else {
		wpos.xyz=	float3(1.2,2,4)*(pow(snoise(vray*150)/2+.5, 19)*.375+.0125)+
					float3(.4,.2,.12)*pow(snoise(vray+.2)/2+.5, 2);
	}

//	if (pattern>=8)
//	return 0;
	
	return (wpos+zsizsi*zsizsi)*saturate(pattern*4);
}

