#define WIN32_LEAN_AND_MEAN
#define WIN32_EXTRA_LEAN

#include <sapi.h>
#include <Windows.h>
#include <d3dx9.h>
#include <mmsystem.h>
#include <d3dcompiler.h>


#include "music\4klang.h"
#include "mmsystem.h"
#include "mmreg.h"
//#include <sal.h>
//#include <rpcsal.h>

SAMPLE_TYPE	lpSoundBuffer[MAX_SAMPLES*2];  
HWAVEOUT	hWaveOut;

#pragma data_seg(".wavefmt")
WAVEFORMATEX WaveFMT =
{
#ifdef FLOAT_32BIT	
	WAVE_FORMAT_IEEE_FLOAT,
#else
	WAVE_FORMAT_PCM,
#endif		
    2, // channels
    SAMPLE_RATE, // samples per sec
    SAMPLE_RATE*sizeof(SAMPLE_TYPE)*2, // bytes per sec
    sizeof(SAMPLE_TYPE)*2, // block alignment;
    sizeof(SAMPLE_TYPE)*8, // bits per sample
    0 // extension not needed
};

#pragma data_seg(".wavehdr")
WAVEHDR WaveHDR = 
{
	(LPSTR)lpSoundBuffer, 
	MAX_SAMPLES*sizeof(SAMPLE_TYPE)*2,			// MAX_SAMPLES*sizeof(float)*2(stereo)
	0, 
	0, 
	WHDR_PREPARED, 
	0, 
	0, 
	0
};


//#define SPEECH

#ifdef _DEBUG
#include <stdio.h>
#define D3DCHECK(x) if (FAILED((x))) ((char*)NULL)[0]=0;
//#define NOSOUND
//#define SAVESOUND "music-v2.raw"
//#define LOADSOUND
//#define SAVESOUNDPOST
//#define WIREFRAME 1

#else
#include "shader_code.h"
#define D3DCHECK(x) x;
#define FINAL 1
//#define NOSOUND
//#define DONTCRASH 1
//#define SHADERFILE 1
#endif


#define WINWIDTH 1280
#define WINHEIGHT 720

#ifndef FINAL
void compile_shader(IDirect3DDevice9 *device, const char* entry, IUnknown** shader)
{
	if (*shader)
	{
		(*shader)->lpVtbl->Release(*shader);
		(*shader)=NULL;
	}

	LPD3DXBUFFER shader_blob=NULL;
	LPD3DXBUFFER shader_error=NULL;
	if (entry[0]=='p')
	{

		if (D3D_OK==D3DXCompileShaderFromFileA("shader.hlsl", NULL, NULL, entry, "ps_3_0", 0, &shader_blob, &shader_error, NULL ))
			device->lpVtbl->CreatePixelShader(device, shader_blob->lpVtbl->GetBufferPointer(shader_blob), shader);
	} else {
		if (D3D_OK==D3DXCompileShaderFromFileA("shader.hlsl", NULL, NULL, entry, "vs_3_0", 0, &shader_blob, &shader_error, NULL ))
			device->lpVtbl->CreateVertexShader(device, shader_blob->lpVtbl->GetBufferPointer(shader_blob), shader);
	}

	if (shader_error)
	{
		OutputDebugStringA(shader_error->lpVtbl->GetBufferPointer(shader_error));
		shader_error->lpVtbl->Release(shader_error);
	}

	if (shader_blob)
		shader_blob->lpVtbl->Release(shader_blob);
}
#endif
#ifndef FINAL
	D3DPRESENT_PARAMETERS pp={0, 0, D3DFMT_UNKNOWN, 0, D3DMULTISAMPLE_4_SAMPLES, 0, D3DSWAPEFFECT_DISCARD, NULL, TRUE, TRUE, D3DFMT_D24S8, 0, 0, 0};
#else
	D3DPRESENT_PARAMETERS pp={WINWIDTH, WINHEIGHT, D3DFMT_A8R8G8B8, 0, D3DMULTISAMPLE_4_SAMPLES, 0, D3DSWAPEFFECT_DISCARD, NULL, FALSE, TRUE, D3DFMT_D24S8, 0, 0, D3DPRESENT_INTERVAL_ONE};
#endif
	int get_time[2]={TIME_SAMPLES,0};
	float params[8]={0, 0, WINWIDTH, WINHEIGHT, 0, 0.65f, 0.1f, 0 };

// Take away prolog and epilog, then put a minial prolog back manually with assembly below. The function never returns so no epilog is necessary.
__declspec( naked )  void __cdecl winmain()

{
	// Prolog
	__asm 
	{
		push ebp
        mov ebp,esp
        sub esp,__LOCAL_SIZE
	}
	
	{ // Extra scope to make compiler accept the __decalspec(naked) with local variables


	//Sleep(100000);

	// the most simple window
#ifdef FINAL
	HWND hWnd = CreateWindow(L"edit", 0, WS_POPUP | WS_VISIBLE, 0, 0, 0, 0, 0, 0, 0, 0);
#else
	HWND hWnd = CreateWindow(L"edit", 0, WS_POPUP | WS_VISIBLE, 0, 0, WINWIDTH, WINHEIGHT, 0, 0, 0, 0);
#endif

	// don't show the cursor
	ShowCursor(FALSE);

	IDirect3DPixelShader9* pixel_shader;
	IDirect3DVertexShader9* vertex_shader;
	IDirect3DTexture9* texture;
	IDirect3DSurface9* src_surface;
	IDirect3DSurface9* dst_surface;
	IDirect3DDevice9* device;
	IDirect3D9* d3d9=Direct3DCreate9(D3D_SDK_VERSION);
	D3DCHECK(d3d9->lpVtbl->CreateDevice(d3d9, D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hWnd, D3DCREATE_HARDWARE_VERTEXPROCESSING, &pp, &device));

	D3DCHECK(device->lpVtbl->CreateTexture(device, WINWIDTH, WINHEIGHT/2, 1, D3DUSAGE_RENDERTARGET, D3DFMT_A8R8G8B8, D3DPOOL_DEFAULT, &texture, NULL));
	D3DCHECK(device->lpVtbl->GetRenderTarget(device, 0, &src_surface));
	D3DCHECK(texture->lpVtbl->GetSurfaceLevel(texture, 0, &dst_surface));

	//D3DCHECK(device->lpVtbl->Present(device, NULL, NULL, NULL, NULL));
	D3DCHECK(device->lpVtbl->SetRenderState(device, D3DRS_ALPHABLENDENABLE, TRUE));
	D3DCHECK(device->lpVtbl->SetRenderState(device, D3DRS_SRCBLEND, D3DBLEND_SRCALPHA));
	D3DCHECK(device->lpVtbl->SetRenderState(device, D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA));
	D3DCHECK(device->lpVtbl->SetTexture(device, 0, texture));

	#define NUM_TEXT 26 // vigyazz, max 16 karakter lehet egy szoveg, vagy ird at ott lent a tombot!
	static const char* text_string[NUM_TEXT]={"\xf7","AstroideA","AstroideA","SELFMAPPING","code & music","reptile","for","Function'15",
		"Exceed", "United Force", "Shock!", "Byteam", "Exhumers", "Fresh", "Dilemma",
		"\xf7", "SKIP >|", "STOP", "\xf7", "\xf7", "\xf7", "\xf7", "\xf7", "\xf7", "\xf7", "\xf7"};
	LPD3DXMESH text_mesh[NUM_TEXT];
	float text_width[NUM_TEXT];

	HDC dc=CreateCompatibleDC(NULL);
	for (int i=0;i<NUM_TEXT;i++)
	{
		SelectObject(dc, CreateFontA(0,0,0,0,FW_DONTCARE,FALSE,FALSE,FALSE,DEFAULT_CHARSET,OUT_OUTLINE_PRECIS,
            CLIP_DEFAULT_PRECIS,CLEARTYPE_QUALITY, VARIABLE_PITCH,i>17?"Webdings":"Impact"));

		GLYPHMETRICSFLOAT glyph_metrics[16];	
		//memset(glyph_metrics,0,sizeof(GLYPHMETRICSFLOAT)*16);
		D3DCHECK(D3DXCreateTextA(device, dc, text_string[i], 0, .1f, &text_mesh[i], NULL, glyph_metrics ));
		text_width[i]=0;
		for (int j=0;text_string[i][j];j++)
			text_width[i]+=glyph_metrics[j].gmfCellIncX;
	}
	D3DCHECK(D3DXCreateCylinder(device, 1, 1, 64, 16, 64, &text_mesh[0], NULL));
	D3DCHECK(D3DXCreateSphere(device, 1, 64, 64, &text_mesh[15], NULL));

#ifdef FINAL
	ID3DXBuffer* blob;
	D3DXCompileShader(shader_hlsl, strlen(shader_hlsl), NULL, NULL, "ps_3_0", "ps_3_0", 0, &blob, NULL, NULL);
	device->lpVtbl->CreatePixelShader(device, blob->lpVtbl->GetBufferPointer(blob), &pixel_shader);
	D3DXCompileShader(shader_hlsl, strlen(shader_hlsl), NULL, NULL, "vs_3_0", "vs_3_0", 0, &blob, NULL, NULL);
	device->lpVtbl->CreateVertexShader(device, blob->lpVtbl->GetBufferPointer(blob), &vertex_shader);
#else
	pixel_shader=NULL;
	vertex_shader=NULL;
	compile_shader(device, "ps_3_0", &pixel_shader);
	compile_shader(device, "vs_3_0", &vertex_shader);
#endif

#ifdef SPEECH
	ISpVoice * pVoice = NULL;
	if (SUCCEEDED(CoInitialize(NULL)) && (SUCCEEDED(CoCreateInstance(&CLSID_SpVoice, NULL, CLSCTX_ALL, &IID_ISpVoice, (void **)&pVoice))))
		pVoice->lpVtbl->Speak(pVoice, L"Hello everyone at Function 2015. Astroidea would like to apologize for the lengthy precalculation of the music. While we're waiting for 4 clang to finish, let me thank you all for watching!", SPF_ASYNC|SPF_IS_NOT_XML, NULL);
#endif

#ifdef LOADSOUND
	FILE *f=fopen("music.raw", "rb");
	fread(lpSoundBuffer, sizeof(SAMPLE_TYPE)*MAX_SAMPLES*2, 1, f);
	fclose(f);
#else
#ifndef NOSOUND
	_4klang_render(lpSoundBuffer);
#ifdef SAVESOUND
	FILE *f=fopen(SAVESOUND, "wb");
	fwrite(lpSoundBuffer, sizeof(SAMPLE_TYPE)*MAX_SAMPLES*2, 1, f);
	fclose(f);
#endif
#else
	memset(&lpSoundBuffer[0], 0, sizeof(SAMPLE_TYPE)*MAX_SAMPLES*2);
#endif
#endif

//	for (int i=3344544*2;i<3344544*2+sizeof(SAMPLE_TYPE)*SAMPLES_PER_TICK*4;i++)
//		lpSoundBuffer[i]=0;

	for (int i=254016*2;i<338688*2;i++)
		lpSoundBuffer[i]=lpSoundBuffer[4402944*2-i];

#ifdef SAVESOUNDPOST
	{
	FILE *f=fopen("music_post.raw", "wb");
	fwrite(lpSoundBuffer, sizeof(SAMPLE_TYPE)*MAX_SAMPLES*2, 1, f);
	fclose(f);
	}
#endif

#ifdef SPEECH
	if (pVoice)
		pVoice->lpVtbl->WaitUntilDone(pVoice, INFINITE);
#endif

	waveOutOpen			( &hWaveOut, 0, &WaveFMT, NULL, 0, CALLBACK_NULL );
	waveOutWrite		( hWaveOut, &WaveHDR, sizeof(WaveHDR) );

	do
	{
#ifdef _DEBUG
		MSG msg;
		PeekMessage(&msg, hWnd, 0, 0, PM_REMOVE);
		if ((GetAsyncKeyState(VK_CONTROL) && GetAsyncKeyState('S')))
		{
			Sleep(100);
			compile_shader(device, "ps_3_0", &pixel_shader);
			compile_shader(device, "vs_3_0", &vertex_shader);

			waveOutReset(hWaveOut);
			waveOutClose(hWaveOut); hWaveOut=0; WaveHDR.dwFlags=2;
			waveOutOpen( &hWaveOut, 0, &WaveFMT, NULL, 0, CALLBACK_NULL );
			waveOutWrite( hWaveOut, &WaveHDR, sizeof(WaveHDR) );
		}

		if (!vertex_shader || !pixel_shader)
		{
			D3DCHECK(device->lpVtbl->Clear(device, 0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL, 0xff10c000, 1, 0));
			D3DCHECK(device->lpVtbl->Present(device, NULL, NULL, NULL, NULL));
			continue;
		}
#endif

		// calculate the current demo time
		D3DCHECK(device->lpVtbl->BeginScene(device));
		D3DCHECK(device->lpVtbl->Clear(device, 0, NULL, D3DCLEAR_TARGET, 0, 1, 0));
		D3DCHECK(device->lpVtbl->SetVertexShader(device, vertex_shader));
		D3DCHECK(device->lpVtbl->SetPixelShader(device, pixel_shader));

		waveOutGetPosition(hWaveOut, (LPMMTIME)&get_time, sizeof(MMTIME));
		params[0]=get_time[1];
		for (int i=0;i<NUM_TEXT;i++)
		{
			D3DCHECK(device->lpVtbl->Clear(device, 0, NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL, 0, 1, 0));
			params[1]=i;
			params[4]=text_width[i];
			D3DCHECK(device->lpVtbl->SetVertexShaderConstantF(device, 0, params, 2));
			D3DCHECK(device->lpVtbl->SetPixelShaderConstantF(device, 0, params, 2));
			D3DCHECK(text_mesh[i]->lpVtbl->DrawSubset(text_mesh[i], 0));
		}
		D3DCHECK(device->lpVtbl->StretchRect(device, src_surface, NULL, dst_surface, NULL, D3DTEXF_POINT));

		D3DCHECK(device->lpVtbl->EndScene(device));
		device->lpVtbl->Present(device, NULL, NULL, NULL, NULL);
	}
#ifdef _DEBUG
	while (1);
#else
	while ((!GetAsyncKeyState(VK_ESCAPE)) && (!(WaveHDR.dwFlags & WHDR_DONE)));//(get_time[1]<MAX_SAMPLES));
#endif
	}

	ExitProcess(0);
}
