/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef __USERSYS_H
#define __USERSYS_H

#include "..\com\system.h"

#ifdef __cplusplus
extern "C" {
#endif

	void userSys_make(char *app);
	void userSys_read(void);

  typedef struct {
    unsigned Version;           //PCBoard version number (i.e. 1500)
    long     RecNo;             //Record number from USER's file
    unsigned SizeOfRec;         //Size of "fixed" user record (current size)
    unsigned NumOfAreas;        //Number of conference areas (Main=1 thru 65535)
    unsigned NumOfBitFields;    //Number of Bit Map fields for conferences
    unsigned SizeOfBitFields;   //Size of each Bit Map field
    char     AppName[15];       //Name of the Third Party Application (if any)
    unsigned AppVersion;        //Version number for the application (if any)
    unsigned AppSizeOfRec;      //Size of a "fixed length" record (if any)
    unsigned AppSizeOfConfRec;  //Size of each conference record (if any)
    long     AppRecOffset;      //Offset of AppRec into USERS.INF record (if any)
    bool     Updated;           //TRUE if the USERS.SYS file has been updated
  } syshdrtype;


  typedef struct {              // Bit packed flags in the users file
    int Dirty        :1;        // Dirty Flag (meaning file has been updated)
    int MsgClear     :1;        // User's choice for screen clear after messages
    int HasMail      :1;        // Indicates if NEW mail has been left for user
    int DontAskFSE   :1;        // Don't ask for if FSE should be used
    int FSEDefault   :1;        // Default to FSE
    int ScrollMsgBody:1;        // Scroll message body when display messages
    int ShortHeader  :1;        // Display short message headers
    int WideEditor   :1;        // Use wide (79-column) message editor
  } packedbyte;

  typedef struct {              // Bit packed flags in the users file
    int UnAvailable:1;          // Chat Status (Unavailable if bit is set)
    int Reserved:7;             // RESERVED!  DO NO USE THESE BITS
  } packedbyte2;

  typedef struct {              // DOS format for bit packed date fields
    int Day   :5;               // 5 bit integer representing the Day
    int Month :4;               // 4 bit integer representing the Month
    int Year  :7;               // 7 bit integer representing the Year MINUS 80
  } datetype;

  typedef struct {
    char  Street[2][51];        // 2 NULL-terminated strings for street address
    char  City[26];             // A NULL-terminated string for city
    char  State[11];            // A NULL-terminated string for state
    char  Zip[11];              // A NULL-terminated string for zip
    char  Country[16];          // A NULL-terminated string for country
  } addresstypez;

  typedef struct {
    char     Previous[3][13];   // 3 NULL-terminated strings for last 3 passwords
    unsigned LastChange;        // Date of last password change
    unsigned TimesChanged;      // Number of times password has been changed
    unsigned ExpireDate;        // Expiration date of current password
  } passwordtypez;

  typedef struct {
    unsigned FirstDateOn;       // First date on, in julian date format
    unsigned NumSysopPages;     // Number of times caller paged the sysop
    unsigned NumGroupChats;     // Number of times caller entered group chat
    unsigned NumComments;       // Number of times caller left comment to sysop
    unsigned Num300;            // Number of times caller was on a 300 bps
    unsigned Num1200;           // Number of times caller was on a 1200 bps
    unsigned Num2400;           // Number of times caller was on a 2400 bps
    unsigned Num9600;           // Number of times caller was on a 9600 bps
    unsigned Num14400;          // Number of times caller was on a 14400+ bps
    unsigned NumSecViol;        // Number of security violations committed
    unsigned NumNotReg;         // Number of attempts to join un-reg conference
    unsigned NumReachDnldLim;   // Number of times download limit was reached
    unsigned NumFileNotFound;   // Number of times download file was not found
    unsigned NumPwrdErrors;     // Number of times entered password incorrectly
    unsigned NumVerifyErrors;   // Number of times upload verification failed
  } callerstattype;

  typedef struct {
    char  Line[5][61];          // 5 NULL-terminated strings for notes on caller
  } notestypez;

  typedef struct {
    double StartingBalance;      //Starting Balance
    double StartThisSession;     //Balance at login of current session
    double DebitCall;            //Charges for calls made to the system
    double DebitTime;            //Charges for time spent online
    double DebitMsgRead;         //Charges for messages read
    double DebitMsgReadCapture;  //Charges for messages captured
    double DebitMsgWrite;        //Charges for messages written
    double DebitMsgWriteEchoed;  //Charges for messages written (echoed)
    double DebitMsgWritePrivate; //Charges for messages written (private)
    double DebitDownloadFile;    //Charges for files downloaded
    double DebitDownloadBytes;   //Charges for bytes downloaded
    double DebitGroupChat;       //Charges for time spent in group chat
    double DebitTPU;             //Charges for third party utility usage
    double DebitSpecial;         //Charges made via PPEs
    double CreditUploadFile;     //Payback for files uploaded
    double CreditUploadBytes;    //Payback for bytes uploaded
    double CreditSpecial;        //Packback made via PPEs
    char DropSecLevel;           //Security level on empty/negative balance
  } accounttype;

  typedef struct {
    unsigned MaxMsgs;              //Maximum messages desired in QWK packet
    unsigned MaxMsgsPerConf;       //Maximum messages per conference
    long     PersonalAttachLimit;  //Attach limit on personal messages
    long     PublicAttachLimit;    //Attach limit on public (non-personal) msgs
    char     Reserved[18];
  } qwkconfigtype;

  typedef struct {
    char     Name[26];          // Name (NULL terminated)
    char     City[25];          // City (NULL terminated)
    char     Password[13];      // Password (NULL terminated)
    char     BusDataPhone[14];  // Business or Data Phone (NULL terminated)
    char     HomeVoicePhone[14];// Home or Voice Phone (NULL terminated)
    unsigned LastDateOn;        // Julian date for the Last Date On
    char     LastTimeOn[6];     // Last Time On (NULL Terminated)
    bool     ExpertMode;        // 1=Expert, 0=Novice
    char     Protocol;          // Protocol (A thru Z)
    packedbyte PackedFlags;     // Bit packed flags
    datetype DateLastDirRead;   // Date for Last DIR Scan (most recent file)
    int      SecurityLevel;     // Security Level
    unsigned NumTimesOn;        // Number of times the caller has connected
    char     PageLen;           // Page Length when display data on the screen
    unsigned NumUploads;        // Total number of FILES uploaded
    unsigned NumDownloads;      // Total number of FILES downloaded
    long     DailyDnldBytes;    // Number of BYTES downloaded so far today
    char     UserComment[31];   // Comment field #1 (NULL terminated)
    char     SysopComment[31];  // Comment field #1 (NULL terminated)
    int      ElapsedTimeOn;     // Number of minutes online
    unsigned RegExpDate;        // Julian date for Registration Expiration Date
    int      ExpSecurityLevel;  // Expired Security Level
    unsigned LastConference;    // Number of the conference the caller was in
    long     TotDnldBytes;      // Total number of BYTES downloaded
    long     TotUpldBytes;      // Total number of BYTES uploaded
    bool     DeleteFlag;        // 1=delete this record, 0=keep
    long     RecNum;            // Record Number in USERS.INF file
    packedbyte2  Flags;         // More bit packed flags
    char     Reserved[8];       // Bytes 390-397 from the USERS file
    long     MsgsRead;          // Number of messages the user has read in PCB
    long     MsgsLeft;          // Number of messages the user has left in PCB
    bool     AliasSupport;      // TRUE if Alias PSA installed
    char     Alias[26];         // Chosen Alias, if AliasSupport is TRUE
    bool     AddressSupport;    // TRUE if Address PSA installed
    addresstypez Address;       // Address information, if AddressSupport is TRUE
    bool     PasswordSupport;   // TRUE if Password PSA installed
    passwordtypez PwrdHistory;  // Password History, if PasswordSupport is TRUE
    bool     VerifySupport;     // TRUE if Verify PSA installed
    char     Verify[26];        // Verification Info, if VerifySupport is TRUE
    bool     StatsSupport;      // TRUE if Caller Stats PSA installed
    callerstattype Stats;       // Caller Stats, if StatsSupport is TRUE
    bool     NotesSupport;      // TRUE if Notes PSA installed
    notestypez Notes;           // Notes about caller, if NotesSupport is TRUE
    bool      AccountSupport;   // TRUE if Accounting PSA installed
    accounttype Account;        // Accounting values, if AccountSupport is TRUE
    bool      QwkSupport;       // TRUE if QWK/Net PSA installed
    qwkconfigtype QwkConfig;    // QWK/Net values, if QwkSupport is TRUE
  } userrectype;

#ifdef __cplusplus
}
#endif


#endif