/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*

TPA (Third Party Applications) functions

*/
#include <share.h>
#include <alloc.h>
#include <stdlib.h>
#include "..\lang\fortify.h"
#include "..\com\system.h"
#include "..\com\pcbdat.h"
#include "..\com\tpa.h"
#include "..\com\sharing.h"

TPArec *openTPA(char *base)
{
FILE *id;
IDrec i;
TPArec *tpa;

tpa = (TPArec *)malloc(sizeof(TPArec));
if (tpa == NULL)
	return NULL;

fnsplit(tpaPath, tmpDrive, tmpDir, tmpFile, NULL);
fnmerge(tmpStr, tmpDrive, tmpDir, base, ".ID");

if (access(tmpStr, 0) || (id = fopen_share(tmpStr, "rb", SH_DENYNO)) == NULL)
	{
    free(tpa);
	return NULL;
    }

fread(&i, sizeof(IDrec), 1, id);
tpa->staticSize = i.staticSize;
tpa->dynamicSize = i.dynamicSize;
tpa->version = atol(i.version);
fclose(id);

fnmerge(tmpStr, tmpDrive, tmpDir, base, ".TPA");

tpa->file = fopen_share(tmpStr, "r+b", SH_DENYNO);
if (tpa->file == NULL)
	{
    free(tpa);
	return NULL;
    }

return tpa;
}

void closeTPA(TPArec *tpa)
{
if (tpa == NULL)
	return;
fclose(tpa->file);
free(tpa);
}

void getTPA(TPArec *tpa, void *data, int size, int conf, int dynamic, long u)
{
int maxsize;

if (tpa->file == NULL || tpa == NULL)
	return;

if (u <= 0)
    if (userLoggedNum == -1)
    	u = 1;
    else
		u = userLoggedNum;

if (!dynamic)
	{
    maxsize = tpa->staticSize;
	fseek(tpa->file, (u - 1) * (tpa->staticSize + nConfs * tpa->dynamicSize), SEEK_SET);
    }
else
	{
    maxsize = tpa->dynamicSize;
	fseek(tpa->file, (u - 1) * (tpa->staticSize + nConfs * tpa->dynamicSize) + conf * tpa->dynamicSize, SEEK_SET);
    }

if (size > maxsize)
	size = maxsize;

fread(data, size, 1, tpa->file);
}

void putTPA(TPArec *tpa, void *data, int size, int conf, int dynamic, long u)
{
int maxsize;

if (tpa->file == NULL || tpa == NULL)
	return;

if (u <= 0)
	if (userLoggedNum == -1)
    	u = 1;
    else
    	u = userLoggedNum;

if (!dynamic)
	{
    maxsize = tpa->staticSize;
	fseek(tpa->file, (u - 1) * (tpa->staticSize + nConfs * tpa->dynamicSize), SEEK_SET);
    }
else
	{
    maxsize = tpa->dynamicSize;
	fseek(tpa->file, (u - 1) * (tpa->staticSize + nConfs * tpa->dynamicSize) + conf * tpa->dynamicSize, SEEK_SET);
    }

if (size > maxsize)
	size = maxsize;

fwrite(data, size, 1, tpa->file);
}

long getTPAlong(TPArec *tpa, int conf, int dynamic, long u)
{
long ret;

getTPA(tpa, &ret, 4, conf, dynamic, u);
return ret;
}

unsigned int getTPAint(TPArec *tpa, int conf, int dynamic, long u)
{
unsigned ret;

getTPA(tpa, &ret, 2, conf, dynamic, u);
return ret;
}

void createAllTPANewEntry(long userNumber)
{
FILE *in;
int nTPA;
int a;
char name[9];

fnsplit(tpaPath, tmpDrive, tmpDir, tmpFile, NULL);
fnmerge(tmpStr, tmpDrive, tmpDir, "TPA", ".IDX");

in = fopen_share(tmpStr, "r+b", SH_DENYRW);
if (in == NULL)
    return;

fread(&nTPA, 2, 1, in);

for (a=0;a<nTPA;a++)
	{
    fread(name, 8, 1, in);
    name[8]=0;
    createTPANewEntry(name, userNumber);
    }
fclose(in);

}

void createTPANewEntry(char *TPAname, long userNumber)
{
TPArec *tpa;
int maxsize;
char *buf;

tpa = openTPA(TPAname);
if (tpa->file == NULL || tpa == NULL)
	return;

fseek(tpa->file, (userNumber-1)*(tpa->staticSize + nConfs * tpa->dynamicSize), SEEK_SET);

if (tpa->staticSize + nConfs * tpa->dynamicSize > 0)
	{
	buf = (char*)malloc(tpa->staticSize + nConfs * tpa->dynamicSize); // no low memory check since we HAVE to write something anyway or we would end up with an invalid tpa...
	if (buf != NULL) memset(buf, 0, tpa->staticSize + nConfs * tpa->dynamicSize);
	fwrite(buf, tpa->staticSize + nConfs * tpa->dynamicSize, 1, tpa->file);
    if (buf != NULL) 
		free(buf);
    }

closeTPA(tpa);
}
