/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*

Manage Environment variables

*/

#include "..\com\system.h"
#include "..\com\pcbdat.h"
#include "..\com\env.h"
#include <string.h>
#include <stdlib.h>

int envTooSmall()
{
printf("\nEnvironment too small !!\n"
       "Increase SHELL /E:XXXX parameter in CONFIG.SYS\n");
return 0;
}

int setEnvironment(void)
{
sprintf(tmpStr, "FRTNODE=%d", node);
if (putenv(strdup(tmpStr))) return envTooSmall();
sprintf(tmpStr, "FRTINI=%s", iniFile);
if (putenv(strdup(tmpStr))) return envTooSmall();
getcwd(tmpDir, MAXPATH);
sprintf(tmpStr, "FRTDRIVE=%c:", *tmpDir);
if (putenv(strdup(tmpStr))) return envTooSmall();
strcpy(tmpDir, &tmpDir[2]);
sprintf(tmpStr, "FRTPATH=%s", tmpDir);
if (putenv(strdup(tmpStr))) return envTooSmall();
if (PCBcompat)
	{
	sprintf(tmpStr, "PCBNODE=%d", node);
	if (putenv(strdup(tmpStr))) return envTooSmall();
    strcpy(tmpDir, iniFile);
    while (tmpDir[strlen(tmpDir)-1] != '\\') tmpDir[strlen(tmpDir)-1] = 0;
	sprintf(tmpStr, "PCBDAT=%s%s", tmpDir, "PCBOARD.DAT");
	if (putenv(strdup(tmpStr))) return envTooSmall();
	getcwd(tmpDir, MAXPATH);
	sprintf(tmpStr, "PCBDRIVE=%c:", *tmpDir);
	if (putenv(strdup(tmpStr))) return envTooSmall();
	strcpy(tmpDir, &tmpDir[2]);
	sprintf(tmpStr, "PCBPATH=%s", tmpDir);
	if (putenv(strdup(tmpStr))) return envTooSmall();
    }
return 1;
}

void removeEnvironment(void)
{
putenv("FRTNODE=");
putenv("FRTINI=");
putenv("FRTPATH=");
putenv("FRTDRIVE=");
putenv("PCBNODE=");
putenv("PCBINI=");
putenv("PCBPATH=");
putenv("PCBDRIVE=");
}
