;From Hugh Noland - exhibits a small propeller rotating
 
cseg   segment   word
assume cs:cseg, ds:cseg
org 100h
 
begin: jmp main
 
xxx   db   "|/-\"
cur   dw   ?
 
main:
   call clr                ;clear screen
 
   mov ah,2                ;
   mov bh,0                ;position cursor
   mov dh,12               ;
   mov dl,35               ;
   int 10h                 ;
 
   mov ah,3                ;
   mov bh,0                ;save cursor size and shape
   int 10h                 ;
   mov cur,cx              ;
 
   mov ah,1                ;
   mov cx,1000h            ;hide cursor
   int 10h                 ;
 
   mov cx,30               ;propeller to go throught 30 rotations
m1:
   push cx
   mov cx,4
   mov si,offset xxx
m2:
   lodsb                   ;load char into AL and increment SI
   mov ah,9                ;
   mov bh,0                ;use int 10h, function 9 to print it
   mov bl,1eh              ;color attribute in BL (1eh = yellow on blue)
   push cx                 ;
   mov cx,1                ;
   int 10h                 ;
   pop cx
   call dlay               ;pause 1/10 second after printing character
   loop m2
   pop cx
   loop m1
 
   call clr
 
   mov ah,1                ;
   mov cx,cur              ;restore curser
   int 10h                 ;
 
   mov ax,4c00h            ;exit
   int 21h                 ;
 
;---------------------------------------------------------------------------
;generates a delay of approximately 1/10 second (number of microseconds,
;in hex, equals CX:DX)
;---------------------------------------------------------------------------
dlay   proc
   push ax
   push cx
   push dx
   mov ah,86h
   mov cx,0
   mov dx,0c350h
   int 15h
   pop dx
   pop cx
   pop ax
   ret
dlay   endp
 
;---------------------------------------------------------------------------
;clear screen and position cursor in upper left corner
;---------------------------------------------------------------------------
clr   proc
   push ax
   push bx
   push cx
   push dx
   mov ah,06               ;
   mov al,0                ;clear screen to white on blue
   mov bh,1fh              ;
   mov cx,0                ;
   mov dh,24               ;
   mov dl,79               ;
   int 10h                 ;
 
   xor dx,dx               ;
   mov ah,2                ;position cursor at 0,0
   mov bh,0                ;
   int 10h                 ;
 
   pop dx
   pop cx
   pop bx
   pop ax
   ret
clr   endp
 
 
cseg   ends
end   begin
