; From Jerry Coffin - Random #'s
;
COMMENT ^
If you have a 386, and don't mind a bit of extra time and code for a
good quality generator, here's some code.

Note that this _requires_ a 386, and that the numbers in the data
section are _not_ chosen arbitrarily - they're more or less critical to
the quality of the generator.  The period of this generator is
supposedly 2.3*10^18.  However, for serious use, the seeding code could
likely use some improvement.

 RH> I need random integers between 0 and 0FFFFh. It would be nice if I
 RH> could specify a range but I guess I can just div it by the num I
 RH> want and take DX...

Using the modulus _usually_ isn't a good way to go - it uses the least
significant bits, which are usually less random than the more signficant
bits.  It's better to divide the range of the generator by the range you
desire, then divide the returned number from the generator by that
result.

END COMMENT ^


.model small,c
.386

.data?
seed1   dd      ?
seed2   dd      ?
k       dd      ?

q1      dd      ?
r1      dd      ?
q2      dd      ?
r2      dd      ?


.data
m1      dd      214783563
a1      dd      40014

m2      dd     214783399
a2      dd      40692

.code
srand proc uses eax edx ecx
        mov     eax,m1
        xor     edx,edx
        div     a1
        mov     q1, eax
        mov     r1, edx

        mov     eax,m2
        xor     edx,edx
        div     a2
        mov     q2, eax
        mov     r2, edx

        xor     ah,ah
        int     1ah
        mov     word ptr seed1, dx
        mov     word ptr seed1+2, cx

        mov     word ptr seed2,cx
        mov     word ptr seed2+2, dx
        ret
srand endp

;
; long rand(void);
;
rand proc uses edx ebx ecx
        mov     eax,seed2
        mov     ebx,eax

        xor     edx,edx
        div     q2
        mov     ecx,eax

        mul     q2
        sub     ebx,eax
        mov     eax,a2
        mul     ebx

        mov     ebx,eax

        mov     eax,r2
        mul     ecx

        sub     ebx,eax

        test    ebx,ebx
        jge     @f

        add     ebx,m2
@@:
        mov     seed2, ebx

        mov     eax,seed1
        mov     ebx,eax

        xor     edx,edx
        div     q1
        mov     ecx,eax

        mul     q1
        sub     ebx,eax
        mov     eax,a1
        mul     ebx

        mov     ebx,eax

        mov     eax,r1
        mul     ecx

        sub     ebx,eax

        test    ebx,ebx
        jge     @f

        add     ebx,m1
@@:
        mov     seed1, ebx

        sub     ebx,seed2

        cmp     ebx,1
        jge     @f

        add     ebx,m1
        dec     ebx
@@:
        mov     eax,ebx

        ret
rand endp
        end

