;Here's some code for entering and leaving protected mode.
;
;Public domain code with no warranties, written by some Intel Corp. programmer
;and found at ftp.intel.com.

   page 66,132
   .386p

   stack segment stack use16
     dd 100 dup(0)
   stack ends

   data segment use16

   gdt  dd 0
     dd 0
   code_desc dd 0000ffffh
     dd 00cf9a00h
   data_desc dd 0000ffffh
     dd 00cf9200h
   ret_desc dd 0000ffffh
     dd 00cf9a00h

   gdt_label label fword
   gdt_limit dw 4*8-1
   gdt_base dd ?

   protected_code_address dd 0
      dw 08h
   data ends


   code segment para public use16 'code'
   assume cs:code,ds:data,ss:stack

 start:
   mov ax,data
   mov ds,ax

     ; setup gdt
   mov eax,0
   mov ax,data
   shl eax,4
   add eax,offset gdt
   mov gdt_base,eax

     ; runtime fixup of far jump into pmode
   mov eax,0
   mov ax,code32
   shl eax,4
   add eax,offset protected_code
   mov protected_code_address,eax

     ; runtime fixup for far jump back to rmode
   mov eax,0
   mov ax,code32
   mov es,ax
   mov word ptr es:[4],18h


   cli
   db 66h
   lgdt gdt_label
   smsw ax
   or ax,1
   lmsw ax
   jmp next
 next:  jmp fword ptr protected_code_address

 ret_real: smsw ax
   and ax,0fffeh
   lmsw ax
   jmp far ptr s16

 s16:
   mov ax,4c00h
   int 21h

 code  ends

 code32  segment use32
   assume cs:code32

 sto:
   jmp far ptr ret_real
 protected_code:
   mov ax,10h
   mov ds,ax
   mov ebx,0b8000h
   mov ax,0741h
   mov ecx,80*25
 st1:
   mov [ebx],ax
   add ebx,2
   loop st1

   jmp sto

 code32  ends

   end start
