; From Benjamin L Mcgee  - PRINTING NUMBERS
;
; itoa.asm 
; convert 16 bit integer to ascii string 
; accepts two parameters via the stack 
; thus the stack should appear as follows 
; sp + 6 offset of destination string 
; sp + 4 value of integer to convert to ascii string 
; sp + 2 near return address 
; sp + 0 bp pushed by this sub 
 
 
dataseg segment public 'data' 
 
        extrn _sbuff:byte 
        nflag db(0) 
dataseg ends 
 
codeseg segment byte public 'code' 
        assume cs:codeseg,es:dataseg,ds:dataseg 
        public itoa 
 
itoa  proc near 
        push bp                 ; 
        mov bp,sp               ; 
        mov ax, [bp] + 4        ; get number 
        mov nflag, 0            ; 
        cmp ax, 0               ; 
        jge positive            ; 
        mov nflag, 1            ; 
        neg ax                  ; 
positive: 
        mov di, offset _sbuff + 6 ; 
        xor cx, cx              ; store nul at end of string 
        mov byte ptr [di], cl   ; 
        dec di                  ; point to previous char 
        mov cx, 5               ; set count 
 
getchar: 
        mov bx, 10              ; 
        xor dx, dx              ; 
        div bx                  ; 
        add dl, '0'             ; convert number to ascii 
        mov byte ptr [di], dl   ; save character 
        dec di                  ; point to previous char 
        loop getchar            ; loop 5 times 
 
        cld                     ; strings move foreward 
        mov si, di              ; 
        inc si                  ; 
nextchar: 
        lods byte ptr [si]      ; skip leading zeros 
        cmp al, '0'             ; 
        jne notzero             ; 
        jmp nextchar            ; 
notzero:

        dec si                  ; adjust 
        cmp al, 0               ; check if ending nul 
        jne not0                ; nope? 
        dec si                  ; yup? make sure 0 is printed 
        jmp notneg              ; 0 is never negavive

not0: 
        cmp nflag, 0            ; check if negative 
        je notneg               ; nope? 
        dec si                  ; yup? prepend a '-' to the number 
        mov di, si              ; 
        mov byte ptr [di], '-'  ; 
notneg: 
        mov di, [bp + 6]        ; get pointer to destination 
 
storchar: 
        lods byte ptr [si]      ; move the number to it's final 
        stos byte ptr [di]      ; resting place 
        cmp al, 0               ; check for ending nul 
        je bye                  ; yup? bye bye 
        jmp storchar            ; nope? back fer more 
bye: 
        pop bp 
        ret 
itoa endp 
 
codeseg ends 
end
