;
; Project: EXESIZE.ASM
;
; Purpose: Demonstrate how to calculate the real EXE size from EXE header.
;
;  Author: Eddy L O Jansson / DFR Research & Engineering (saru@saru.ct.se)
;
;   Notes: Does not use 386 instructions, therefor this will only be accurate
;          on files where the exe (excluding overlays) is smaller than 65Kb.
;          Someone, please fix this.

.model tiny
.code
.radix 16

org   100h

main:
         mov ax,3D00h
         lea dx,filename
         int 21h                      ; Open file, readonly.
         jc  exit
         mov bx,ax                    ; move filehandle.

         mov ah,3Fh
         mov cx,2*3
         lea dx,EXEheader
         int 21h                      ; Read part of EXE header

         mov ah,3Eh                   ; Close file
         int 21h

         mov ax,exediv
         dec ax
         mov dx,512d
         mul dx
         add ax,exemod                ; Logic = ((EXE.DivLen-1)*512)+EXE.ModLen

 ; Here AX = Real EXE size.

exit:    ret

filename  db '1.EXE',0

exeheader dw ?       ; 'MZ'
exemod    dw ?       ; exesize+0 MOD 512
exediv    dw ?       ; exesize+1 DIV 512

end   main
