; bcd2.asm
comment ^
        This demonstration program is intended to show how unpacked
        binary coded decimal (BCD) numbers can be employed to do
        multiple precision math.

        written on Fri  08-02-1996  by Ed Beroset
        and released to the public domain
^
        IDEAL                   ; for use with Borland TASM's IDEAL mode
        P286
        MODEL small             ; DOS - small model
        STACK 1000h             ; allocate a bit of stack

        DATASEG

first   db  "923890789045616561123154503355430364461"
FIRST_LEN = $-first
second  db  "989656565656562332829776786441216415615"
SECOND_LEN = $-second

RESULT_LEN = FIRST_LEN + SECOND_LEN     ; allow room for multiplication
result  db  RESULT_LEN dup (0)          ;

newline db 0dh,0ah

        CODESEG
        STARTUPCODE                     ; set stack, DS
        mov     al,' '
        mov     cx,RESULT_LEN - SECOND_LEN
        call    PrintDupeChar

        mov     di,offset second        ;
        mov     cx,SECOND_LEN           ;
        call    PrintStringNewline      ;
        call    AsciiToBCD              ;

        mov     bx,di
        mov     dx,cx                   ; set up length of second number

        mov     al,' '
        mov     cx,RESULT_LEN - SECOND_LEN
        call    PrintDupeChar

        mov     di,offset first         ;
        mov     cx,FIRST_LEN            ;
        call    PrintStringNewline      ;
        call    AsciiToBCD              ;

        push    cx

        mov     al,'-'
        mov     cx,RESULT_LEN
        call    PrintDupeChar

        pop     cx

        mov     si,di
        mov     ax,cx

        call    PrintNewline            ;

        mov     cx,RESULT_LEN           ;
        mov     di,offset result        ;
        call    AddBCD                  ;

        call    BCDToAscii              ;
        call    PrintStringNewline      ;

        EXITCODE                        ; exit to DOS

;****************************************************************************
;                                                                AsciiToBCD
;
; convert an ASCII string of digits into an unpacked BCD number (in place)
;
; Entry:
;       DS:DI ==> ASCII string
;       CX    =   length of string in bytes
;
; Exit:
;       if CY set, error occurred
;       otherwise, result of addition is in result space
;
; Trashed:
;       none
;
;****************************************************************************
proc    AsciiToBCD
        push    cx                      ;
        push    di                      ;
@@next_digit:                           ;
        and     [byte ptr di],0fh       ; convert to BCD -- no error check!
        inc     di                      ; advance the pointer
        loop    @@next_digit            ; keep going
        pop     di                      ;
        pop     cx                      ;
        ret                             ;
endp    AsciiToBCD

;****************************************************************************
;                                                                BCDToAscii
;
; convert an unpacked BCD number into an ASCII string of digits (in place)
;
; Entry:
;       DS:DI ==> ASCII string
;       CX    =   length of string in bytes
;
; Exit:
;       if CY set, error occurred
;       otherwise, result of addition is in result space
;
; Trashed:
;       none
;
;****************************************************************************
proc    BCDToAscii
        push    cx                      ;
        push    di                      ;
@@next_digit:                           ;
        or      [byte ptr di],'0'       ; convert to ASCII - no error check!
        inc     di                      ; advance the pointer
        loop    @@next_digit            ; keep going
        pop     di                      ;
        pop     cx                      ;
        ret                             ;
endp    BCDToAscii

;****************************************************************************
;                                                                    AddBCD
;
; adds two unpacked BCD numbers and puts the result in result string
;
; Entry:
;       DS:SI ==> addend_1
;       AX    =   length of addend_1
;       DS:BX ==> addend_2
;       DX    =   length of addend_2
;       DS:DI ==> result buffer
;       CX    =   length of result buffer
;
; Exit:
;       if CY set, error occurred (result did not fit)
;       otherwise, result of addition is in result space
;
; Trashed:
;       none
;
;****************************************************************************
proc    AddBCD
        pusha                           ;
        add     si,ax                   ;
        add     bx,dx                   ;
        add     di,cx                   ;
        clc                             ;

@@add_em:
        dec     si                      ;
        dec     bx                      ;
        dec     di                      ;
        mov     al,[si]                 ;
        adc     al,[bx]                 ;
        aaa                             ;
        mov     [di],al                 ;
        dec     cx                      ;
        dec     dx                      ;
        jnz     @@add_em                ;

        mov     al,0                    ;
        adc     al,0                    ;
@@adjust_result:
        dec     di                      ;
        mov     [di],al                 ;
        mov     al,0                    ;
        loop    @@adjust_result

        popa                            ;
        ret                             ;
endp    AddBCD

;****************************************************************************
;                                                               PrintString
;
; prints an ASCII string to stdout using DOS services
;
; Entry:
;       DS:DI ==> ASCII string
;       CX    =   length of string in bytes
;
; Exit:
;       if CY set, error occurred
;       otherwise, result of addition is in result space
;
; Trashed:
;       none
;
;****************************************************************************
proc    PrintString
        push    ax bx cx dx di          ;
        mov     dx,di                   ;
        mov     bx,1                    ;
        mov     ah,40h                  ;
        int     21h                     ;
        pop     di dx cx bx ax          ;
        ret                             ;
endp    PrintString

proc    PrintStringNewline
        call    PrintString             ;
        call    PrintNewline
        ret
endp    PrintStringNewline

proc    PrintNewline
        push    cx                      ;
        push    di                      ;
        mov     di,offset newline       ;
        mov     cx,2                    ;
        call    PrintString             ;
        pop     di                      ;
        pop     cx                      ;
        ret
endp    PrintNewline

proc    PrintDupeChar
        pusha
        push    ds

        push    ss
        pop     ds
        push    ax
        mov     dx,sp
        mov     si,cx

        mov     bx,1
        mov     cx,1
@@more:
        mov     ah,40h
        int     21h
        dec     si
        jnz     @@more
        pop     ax

        pop     ds
        popa
        ret
endp    PrintDupeChar


        END
