#ifndef __TOOLWINDOW

#define __TOOLWINDOW

#include "SM_Window.h"


DEFINE_EVGUID(EV_TIMESCALE_UPDATE, 0x76696302, 0xC030, 0x47CB, 0xB0, 0x4B, 0xAE, 0x57, 0x4A, 0xEF, 0xD1, 0xCA);

class TimescaleUpdateEvent : public Event
{
public:
  TimescaleUpdateEvent()
  {
    m_pGUID = (EVGUID*) &EV_TIMESCALE_UPDATE;
  }

  int m_iScale;
};


DEFINE_EVGUID(EV_TOOLBUTTON_PRESSED, 0x25FC235E, 0x104A, 0x4204, 0x84, 0xF9, 0x6D, 0x49, 0x1F, 0xD9, 0x48, 0x36);

class ToolButtonPressedEvent : public Event
{
public:
  enum eButton
  {
    E_LOAD,
    E_SAVE,
    E_EXPORTTGAS,
    E_IMPORT,
    E_EXPORT,
    E_PLAY,
    E_PAUSE,
    E_STOP,
    E_NEWEFFECT,
    E_NEWMODIFIER,
  };

  ToolButtonPressedEvent(eButton Button)
  {
    m_pGUID = (EVGUID*) &EV_TOOLBUTTON_PRESSED;
    m_Button = Button;
  }

  eButton m_Button;
};

DEFINE_EVGUID(EV_DEBUGTEXT, 0x824A9E80, 0x968F, 0x4AC1, 0x8D, 0xFC, 0x32, 0x9F, 0xE8, 0xA7, 0x9C, 0x2C);
class DebugTextEvent : public Event
{
public:  
  DebugTextEvent(bool bDebugText)
  {
    m_pGUID      = (EVGUID*) &EV_DEBUGTEXT;
    m_bDebugText = bDebugText;
  }

  bool m_bDebugText;
};

DEFINE_EVGUID(EV_BPMGUIDE, 0xAC36B308, 0xAED9, 0x47B6, 0x91, 0x74, 0x92, 0xFF, 0x2B, 0x79, 0x97, 0x9F);
class BPMGuideEvent : public Event
{
public:  
  BPMGuideEvent(bool bBPMGuide)
  {
    m_pGUID      = (EVGUID*) &EV_BPMGUIDE;
    m_bBPMGuide = bBPMGuide;
  }

  bool m_bBPMGuide;
};

DEFINE_EVGUID(EV_NOMUSIC, 0x15A2C5AF, 0x5141, 0x4DDA, 0xB9, 0x12, 0xA1, 0x23, 0x66, 0x48, 0x30, 0x4D);
class NoMusicEvent : public Event
{
public:  
  NoMusicEvent(bool bNoMusic, bool bNoMusicOnStop)
  {
    m_pGUID      = (EVGUID*) &EV_NOMUSIC;
    m_bNoMusic = bNoMusic;
    m_bNoMusicOnStop = bNoMusicOnStop;
  }

  bool m_bNoMusic;
  bool m_bNoMusicOnStop;
};

class ToolWindow : public Window
{
  public:
    // TODO: rework events so that they use this enum and only one EVGUID
    enum eCheckBox
    {
      E_CHK_BPMGUIDE,
      E_CHK_NOMUSIC,
      E_CHK_NOMUSICONSTOP,
    };

    virtual int           Init                (Window* pParent = 0);  
    virtual int           ProcessMessage      (const UINT message, const WPARAM wParam, const LPARAM lParam);  
    virtual int           ProcessDialogMessage(const UINT message, const WPARAM wParam, const LPARAM lParam);    

    void                  SetCheckBox         (eCheckBox CheckBox, bool bState);
  protected:  
};


#endif