#ifndef __ML

#define __ML

#include <vector>


struct MetaFileToken
{
      MetaFileToken   ();
      ~MetaFileToken  ();
  int Init            ();
  int Shutdown        ();

  enum TokenType
  {
    E_ROOT,
    E_TAGBEGIN,
    E_TAGEND,
    E_INT,
    E_FLOAT,
    E_STRING
  };

  TokenType m_eType;
  union
  {
    char*     m_pszString;
    int       m_iValue;
    float     m_fValue;
  };
};

struct MetaFileNode
{
  MetaFileNode  ();
  ~MetaFileNode ();
  int Init      ();
  int Shutdown  ();
  
  MetaFileToken              m_Token;
  std::vector<MetaFileNode*> m_Sons;

  bool           IsTag ();
  bool           IsTag (const char* pcTag);
  bool           IsLeaf();
  MetaFileNode*  GetSon(const char* pcName);  
};

class MetaFile
{
public:
                MetaFile            ();
                ~MetaFile           ();

  int           Load                (const char* pszFilename);
  int           Parse               (const char* pszBuffer);
  int           Shutdown            ();

  MetaFileNode* Root                ();

  const char*   GetLatestError      ();

protected:  


  void        DumpTree            (MetaFileNode* pMetaFileNode);
  int         GetToken(const char** ppszBuffer, MetaFileToken* pToken);

  
  MetaFileNode* m_pRoot;
};

#endif
