#include "SM_CommonFXPCH.h"
#include "SM_Engine3DPCH.h"
#include "SM_DemoEffect.h"
#include "SM_Sound.h"


class MDMABordeFX : public SM_DemoEffect
{
public:              
  MDMABordeFX(char const* pcName) : SM_DemoEffect(pcName)
  {
  }

  virtual          ~MDMABordeFX()
  {
  }

  int      Init(const char* pcCommand)
  {
    return 0;        
  }

  int      Shutdown()
  {
    return (0);
  }

  int      Start(float fTime)
  {
    return (0);
  }

  int      Stop()
  {
    return (0);
  }

  int      Reset()
  {
    m_fBeatStartTime = -100.0f;
    return 0;
  }

  int      Run(float fTime)
  {
    #define BORDERHEIGHT 36

  Coordinates::UpdatePhysicalSize();


  FVF_PosRhwDiffuseTex1 pVertices[4];
  unsigned short        pIndices[6]={0,1,2,1,2,3};

  float fBorder = float(BORDERHEIGHT)/480.0f;


  pVertices[0].x=0.0f  ; pVertices[0].y=0.0f; pVertices[0].oow=pVertices[0].z=1.0f; pVertices[0].u=pVertices[0].v=0.0f; pVertices[0].diffuse=0xFFFFFFFF;
  pVertices[1].x=Coordinates::PhysicalWidth(); pVertices[1].y=0.0f; pVertices[1].oow=pVertices[1].z=1.0f; pVertices[1].u=pVertices[1].v=0.0f; pVertices[1].diffuse=0xFFFFFFFF;
  pVertices[2].x=0.0f; pVertices[2].y=fBorder*Coordinates::PhysicalHeight(); pVertices[2].oow=pVertices[2].z=1.0f; pVertices[2].u=pVertices[2].v=0.0f; pVertices[2].diffuse=0xFFFFFFFF;
  pVertices[3].x=Coordinates::PhysicalWidth(); pVertices[3].y=fBorder*Coordinates::PhysicalHeight(); pVertices[3].oow=pVertices[3].z=1.0f; pVertices[3].u=pVertices[3].v=0.0f; pVertices[3].diffuse=0xFFFFFFFF;


  SM_D3d::SetRenderState(D3DRS_LIGHTING, FALSE);    
  SM_D3d::SetRenderState(D3DRS_ZENABLE, D3DZB_FALSE);  
  SM_D3d::SetRenderState(D3DRS_ALPHABLENDENABLE, FALSE);
  SM_D3d::SetRenderState(D3DRS_FILLMODE, D3DFILL_SOLID);
  SM_D3d::SetRenderState(D3DRS_ZFUNC, D3DCMP_ALWAYS);
  SM_D3d::SetRenderState(D3DRS_ZWRITEENABLE, D3DZB_FALSE);
  SM_D3d::SetRenderState(D3DRS_COLORWRITEENABLE, 0xF);          
  SM_D3d::SetTextureStageState(0, D3DTSS_COLOROP   , D3DTOP_SELECTARG1);
  SM_D3d::SetTextureStageState(0, D3DTSS_COLORARG1 , D3DTA_TFACTOR);
  SM_D3d::SetTextureStageState(0, D3DTSS_ALPHAOP   , D3DTOP_SELECTARG1);
  SM_D3d::SetTextureStageState(0, D3DTSS_ALPHAARG1 , D3DTA_TFACTOR);
  SM_D3d::SetTextureStageState(1, D3DTSS_COLOROP   , D3DTOP_DISABLE);
  SM_D3d::SetTextureStageState(1, D3DTSS_ALPHAOP   , D3DTOP_DISABLE);
  
  SM_D3d::SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
  SM_D3d::SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
  

  SM_D3d::SetRenderState(D3DRS_COLORWRITEENABLE, 0xF);     


  SM_D3d::SetRenderState(D3DRS_CULLMODE,D3DCULL_NONE );    
  SM_D3d::Device()->SetVertexShader(FVF_POSRHWDIFFUSETEX1);

  pVertices[0].y=0; 
  pVertices[1].y=0; 
  pVertices[2].y=Coordinates::PhysicalHeight(); 
  pVertices[3].y=Coordinates::PhysicalHeight(); 
  SM_D3d::SetRenderState(D3DRS_TEXTUREFACTOR, 0xFFFFFFFF);  

  SM_D3d::SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
  SM_D3d::SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE);
  SM_D3d::SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE);
  SM_D3d::SetTextureStageState(0, D3DTSS_ALPHAOP   , D3DTOP_SELECTARG1);
  SM_D3d::SetTextureStageState(0, D3DTSS_ALPHAARG1 , D3DTA_TFACTOR);

  if (SM_Sound::IsBeat(fTime))
  {
    m_fBeatStartTime = fTime;
  }

  float fFade=(fTime-m_fBeatStartTime)/0.1f;

  fFade=min(1.0f, max(0.0f, fFade));
  
  float fAlpha=min(1.0f, max(0.0f, (1.0f-fFade)));
  
  unsigned uColor=int(255.0f*fAlpha);
  uColor=0x001C252D | (uColor<<24);

 
  if (fAlpha)
  {
    SM_D3d::SetRenderState(D3DRS_TEXTUREFACTOR, uColor);  

    SM_D3d::Device()->DrawIndexedPrimitiveUP(
        D3DPT_TRIANGLELIST, 
        0,
        6,
        2,
        pIndices,
        D3DFMT_INDEX16,
        pVertices, sizeof(FVF_PosRhwDiffuseTex1)); 
  }

  SM_D3d::SetRenderState(D3DRS_ALPHABLENDENABLE, FALSE);
  SM_D3d::SetRenderState(D3DRS_TEXTUREFACTOR, 0xFF000000);

  pVertices[0].y=0; 
  pVertices[1].y=0; 
  pVertices[2].y=fBorder*Coordinates::PhysicalHeight(); 
  pVertices[3].y=fBorder*Coordinates::PhysicalHeight(); 


  SM_D3d::Device()->DrawIndexedPrimitiveUP(
      D3DPT_TRIANGLELIST, 
      0,
      6,
      2,
      pIndices,
      D3DFMT_INDEX16,
      pVertices, sizeof(FVF_PosRhwDiffuseTex1)); 

  pVertices[0].y=Coordinates::PhysicalHeight()-fBorder*Coordinates::PhysicalHeight(); 
  pVertices[1].y=Coordinates::PhysicalHeight()-fBorder*Coordinates::PhysicalHeight(); 
  pVertices[2].y=Coordinates::PhysicalHeight(); 
  pVertices[3].y=Coordinates::PhysicalHeight(); 

  SM_D3d::Device()->DrawIndexedPrimitiveUP(
      D3DPT_TRIANGLELIST, 
      0,
      6,
      2,
      pIndices,
      D3DFMT_INDEX16,
      pVertices, sizeof(FVF_PosRhwDiffuseTex1)); 

    SM_D3d::SetRenderState(D3DRS_ZFUNC, D3DCMP_LESSEQUAL);
    SM_D3d::SetRenderState(D3DRS_ZENABLE, D3DZB_TRUE);
  
    return 1;
  }

  int      Command           (float fTime, const char* pcCommand)
  {    
    return 0;
  }  

  float m_fBeatStartTime;
};

MDMABordeFX Borde("BORDEMDMA");
DEFINE_EFFECT(MDMABordeFX)


