#include "SM_DemoEffect.h"
#include "SM_Slider.h"

class FilterFX : public SM_DemoEffect
{
public:              
  FilterFX(char const* pcName);
  virtual ~FilterFX();
  
  int      Init     (bool bRenderTarget=false);

  int      Shutdown ();  

  int      Start    (float fTime);
  
  int      Stop     ();
  
  int           Run               (float fTime);
  void          RunPreStartFrame  (float fTime);           
  void          RunPreRender      (float fTime);           
  void          RunPostRender     (float fTime);           
  void          RunPostEndFrame   (float fTime);           

  
  int           Command  (float fTime, const char* pcCommand);
  int           ParseShaderCommand(float fTime);


  int           SetRenderDepthTarget(int iRenderTarget, int iDepthBuffer);
  int           RestoreRenderDepthTarget();

  void          RenderNormal(float fTime);
  void          RenderHorizontalNoise(float fAmplitude);
  void          RenderLens(float fAmplitude);
  void          RenderWobble(float fTime);
  void          RenderUnderwater(float fTime, float fAmplitude);

  unsigned      GetBackColor();

  bool          m_bInterceptRender;

  bool          m_bHorizontalNoise;
  ExpSlider     m_HorizontalNoiseSlider;
  float         m_fHorizontalAmplitude;

  bool          m_bLens;
  bool          m_bFadeIn;
  LinearSlider  m_LensSlider;
  float         m_fLensStrength;
  float         m_fLensFrequency;


  bool          m_bBlur;
  LinearSlider  m_BlurSlider;
  bool          m_bBlurFadeIn;
  float         m_fBlurStrength;

  bool          m_bUnderwater;
  ExpSlider     m_UnderwaterSlider;
  bool          m_bUnderwaterFadeIn;
  float         m_fUnderwaterFrecuency;
  float         m_fUnderwaterAmplitude;


  bool          m_bWobble;

  bool          m_bTransition;


  unsigned      m_uBackGround;


  void          GetCurrent    (IDirect3DSurface8** ppDepthStencil, IDirect3DSurface8** ppBackBuffer, 
                               IDirect3DTexture8** ppTexture, int* piDepthID, int* piRenderTarget);

  void          GenerateMips();
  

  int           GetAuxDepthBufferID()
  {
    return m_iFakeDepthBufferID;
  }

protected:
  int           m_iFakeBufferID;
  int           m_iFakeDepthBufferID;  
};

extern FilterFX* g_SceneFilter;

extern int SIZEWIDTH;  
extern int SIZEHEIGHT; 

