;
;
; Filename     : sequence.inc
; Included from: Main.asm
; Description  : Object and Sequence for that cheezy animation
;
; Note: This animation is not done, I just wanted to get the source out so
; you could do something with it...
;
; Written by: John McCarthy
;             1316 Redwood Lane
;             Pickering, Ontario.
;             Canada, Earth, Milky Way (for those out-of-towners)
;             L1X 1C5
;
; Internet/Usenet:  BRIAN.MCCARTHY@CANREM.COM
;         Fidonet:  Brian McCarthy 1:229/15
;   RIME/Relaynet: ->CRS
;
; Home phone, (905) 831-1944, don't call at 2 am eh!
;
; John Mccarthy would really love to work for a company programming Robots
; or doing some high intensive CPU work.  Hint. Hint.
;
; Send me your protected mode source code!
; Send me your Objects!
; But most of all, Send me a postcard!!!!
;
;

;
; spaceship data
;

ship1      dd 8500
           dd offset hship1 - offset $ - 4
           dd -1
           dd offset lship1 - offset $ - 4

           sbc equ 0 ; ship body colour
           suc equ 1 ; ship underside colour
           swc equ 0 ; ship window colour
           sec equ 2 ; ship engine colour

;
; lo resolution spaceship
;

lship1     dw 10   ; lo resolution ship
           dw 6

           dw 25 dup (0)

           ;    x   y   z
           dw    0, 18,188  ; 0
           dw    0,-42,-68  ; 1
           dw  -48, 18,-82  ; 2
           dw   48, 18,-82  ; 3
           dw   34, 18,-14  ; 4
           dw  -34, 18,-14  ; 5
           dw -100, 18,-22  ; 6
           dw  -74, 18,130  ; 7
           dw  100, 18,-22  ; 8
           dw   74, 18,130  ; 9

           dw 0,0,0,16*sbc+12,0,3,4,2,3         ; engine
           dw 0,0,0,16*sbc+12,0,6,8,7,3,6       ; top
           dw 0,0,0,16*sbc+12,0,5,4,9,10,5
           dw 0,0,0,16*sbc+12,0,2,1,3,2
           dw 0,0,0,16*sbc+12,0,4,1,2,4

           dw iterate,0,0,16*suc+12,0,6,3,7,8,6   ; underside

                dw 0,2
                dw 25 dup (0)

                dw 0,0,0,16*suc+12,0,5,10,9,4,5
                dw 0,0,0,16*suc+12,0,1,4,3,1

;
; hi resolution spaceship
;

hship1     dw 18   ; hi resolution ship
           dw 16

           dw 25 dup (0)

           ;    x   y   z
           dw    0, 18,188  ; 0
           dw    0, -4, 94  ; 1
           dw  -20, -4,-16  ; 2
           dw    0,-30,-34  ; 3
           dw   20, -4,-16  ; 4
           dw    0,-42,-68  ; 5
           dw  -48, 18,-82  ; 6
           dw   48, 18,-82  ; 7
           dw   34, 18,-14  ; 8
           dw  -34, 18,-14  ; 9
           dw  -60, 18,  0  ;10
           dw  -80,-20, -6  ;11
           dw -100, 18,-22  ;12
           dw  -74, 18,130  ;13
           dw   80,-20, -6  ;14
           dw  100, 18,-22  ;15
           dw   74, 18,130  ;16
           dw   60, 18,  0  ;17

           dw 0,shade,0,16*sbc,0,10,3,2,1,10   ,0,0,0 ; front body
           dw 0,shade,0,16*sbc,0,6,4,3,10,6    ,0,0,0
           dw 0,shade,0,16*sbc,0,2,5,9,1,2     ,0,0,0
           dw 0,shade,0,16*sbc,0,4,6,9,5,4     ,0,0,0
           dw 0,wavey,0,16*sbc,0,2,4,5,2              ; cockpit
           dw 0,wavey,0,16*sbc,0,3,4,2,3

           dw 0,shade,0,16*sbc,0,18,15,17,18   ,0,0,0 ; right arm
           dw 0,shade,0,16*sbc,0,17,15,16,17   ,0,0,0
           dw 0,shade,0,16*sbc,0,15,6,8,16,15  ,0,0,0
           dw 0,shade,0,16*sbc,0,9,6,15,18,9   ,0,0,0

           dw 0,wavey,0,16*sec,0,8,6,7,8              ; engine

           dw 0,shade,0,16*sbc,0,11,12,6,10,11 ,0,0,0 ; left arm
           dw 0,shade,0,16*sbc,0,12,13,7,6,12  ,0,0,0
           dw 0,shade,0,16*sbc,0,13,12,14,13   ,0,0,0
           dw 0,shade,0,16*sbc,0,14,12,11,14   ,0,0,0

           dw iterate,shade,0,16*suc,0,7,13,11,10,7  ,0,0,0 ; underside

              dw 0
              dw 4
              dw 25 dup (0)

              dw both,last,0,16*suc,0,14,11,13,14
              dw both,last,0,16*suc,0,1,8,7,1
              dw both,last,0,16*suc,0,9,18,16,8,9
              dw both,last,0,16*suc,0,17,16,18,17

;
; these are cross referancing palettes for the spaceships - this way, the
; same shape data can be used for different colour spaceships
;

xrefgreen:
           c = 16*4
           rept 16
           db c
           c=c+1
           endm
           c = 16*1
           rept 16
           db c
           c=c+1
           endm
           c = 16*8
           rept 16
           db c
           c=c+1
           endm
xrefblue:
           c = 16*2
           rept 16
           db c
           c=c+1
           endm
           c = 16*1
           rept 16
           db c
           c=c+1
           endm
           c = 16*8
           rept 16
           db c
           c=c+1
           endm
xrefred:
           c = 16*3
           rept 16
           db c
           c=c+1
           endm
           c = 16*1
           rept 16
           db c
           c=c+1
           endm
           c = 16*8
           rept 16
           db c
           c=c+1
           endm

;
; the platform shape data
;

platform1  dd -1
           dd offset hplat1 - offset $ - 4

hplat1:
           dw 6,6
           dw 25 dup (0)

           dw -1120,-1600, 400 ; 1
           dw -1000,-1600,-960 ; 2
           dw   440,-1600,-720 ; 3
           dw  2200,-1600, 680 ; 4
           dw  -350,-1600,1000 ; 5
           dw     0, 1700,   0 ; 6

           dw 0,0,0,16*3+14,0,1,2,3,4,5,1
           dw 0,0,0,16*3+ 3,0,1,6,2,1
           dw 0,0,0,16*3+ 1,0,2,6,3,2
           dw 0,0,0,16*3+ 5,0,3,6,4,3
           dw 0,0,0,16*3+ 9,0,4,6,5,4
           dw 0,0,0,16*3+ 5,0,5,6,1,5

platform2  dd -1
           dd offset hplat2 - offset $ - 4

hplat2:
           dw 9,10
           dw 25 dup (0)

           dw -2925,-1800,-2160 ; 1
           dw -1215,-1800,-1575 ; 2
           dw  -540,-1800, -900 ; 3
           dw   135,-1800,-1665 ; 4
           dw  1215,-1800, -675 ; 5
           dw  1170,-1800,  900 ; 6
           dw -1440,-1800, 1125 ; 7
           dw   945,    0,    0 ; 8
           dw     0, 1800,    0 ; 9

           dw 0,0,0,16*2+15,0,1,2,3,7,1
           dw 0,0,0,16*2+15,0,4,5,6,7,3,4
           dw 0,0,0,16*2+9 ,0,6,8,9,6
           dw 0,0,0,16*2+12,0,8,6,5,8
           dw 0,0,0,16*2+8 ,0,7,6,9,7
           dw 0,0,0,16*2+5 ,0,1,7,9,1
           dw 0,0,0,16*2+7 ,0,2,1,9,2
           dw 0,0,0,16*2+9 ,0,3,2,9,3
           dw 0,0,0,16*2+3 ,0,4,3,9,4
           dw 0,0,0,16*2+10,0,5,4,9,8,5

platform3  dd -1
           dd offset hplat3 - offset $ - 4

hplat3:
           dw 17,21
           dw 25 dup (0)

           dw -2310,- 315,-300  ;1
           dw -2070,- 315,-930  ;2
           dw  -630,- 315,-360  ;3
           dw   690,-1085,-630  ;4
           dw  1350,-1085,-1200 ;5
           dw  2160,-1085,210   ;6
           dw  1230,-1085,1440  ;7
           dw   690,-1085,330   ;8
           dw  -570,- 315,360   ;9
           dw -1020,- 315,870   ;10
           dw -2070,- 315,1320  ;11
           dw -1680, 1885,0     ;12
           dw  1230, 1900,0     ;13
           dw  -540,    0,-240  ;14
           dw  -540,    0,210   ;15
           dw   690,-525 ,100   ;16
           dw   690,-525 ,-450  ;17

           dw 0,0,0,16*4+13,0,1,2,3,9,10,11,1
           dw 0,0,0,16*4+15,0,3,4,8,9,3
           dw 0,0,0,16*4+13,0,6,7,8,4,5,6

           dw 0,0,0,16*4+11,0,1,12,2,1
           dw 0,0,0,16*4+10,0,2,12,3,2
           dw 0,0,0,16*4+ 5,0,9,12,10,9
           dw 0,0,0,16*4+ 6,0,10,12,11,10
           dw 0,0,0,16*4+ 8,0,1,11,12,1

           dw 0,0,0,16*4+12,0,4,13,5,4
           dw 0,0,0,16*4+ 8,0,5,13,6,5
           dw 0,0,0,16*4+ 4,0,6,13,7,6
           dw 0,0,0,16*4+ 5,0,7,13,8,7

           dw 0,0,0,16*4+ 2,0,15,16,17,14,15
           dw 0,0,0,16*4+ 5,0,15,12,9,15
           dw 0,0,0,16*4+10,0,14,3,12,14
           dw 0,0,0,16*4+ 5,0,8,13,16,8
           dw 0,0,0,16*4+12,0,17,13,4,17

           dw 0,0,0,16*4+ 3,0,15,14,12,15
           dw 0,0,0,16*4+ 7,0,16,13,17,16

           dw 0,0,0,16*4+ 8,0,14,17,4,3,14
           dw 0,0,0,16*4+ 4,0,16,15,9,8,16

;
; diamond shape data
;

diamond1   dd -1
           dd offset dia1 - offset $ - 4

dia1       dw 8,12
           dw 25 dup (0)

           dw -100,-25,0   ; 1
           dw -100,+25,0   ; 2
           dw 0   ,-50,0   ; 3
           dw 0   ,0  ,+25 ; 4
           dw 0   ,0  ,-25 ; 5
           dw 0   ,+50,0   ; 6
           dw +100,-25,0   ; 7
           dw +100,+25,0   ; 8

           dw 0,shade,0,0*16+0,0,1,5,3,1       ,0,0,0
           dw 0,shade,0,0*16+0,0,2,5,1,2       ,0,0,0
           dw 0,shade,0,0*16+0,0,6,5,2,6       ,0,0,0
           dw 0,shade,0,0*16+0,0,8,5,6,8       ,0,0,0
           dw 0,shade,0,0*16+0,0,7,5,8,7       ,0,0,0
           dw 0,shade,0,0*16+0,0,3,5,7,3       ,0,0,0

           dw 0,shade,0,0*16+0,0,1,3,4,1       ,0,0,0
           dw 0,shade,0,0*16+0,0,2,1,4,2       ,0,0,0
           dw 0,shade,0,0*16+0,0,6,2,4,6       ,0,0,0
           dw 0,shade,0,0*16+0,0,8,6,4,8       ,0,0,0
           dw 0,shade,0,0*16+0,0,7,8,4,7       ,0,0,0
           dw 0,shade,0,0*16+0,0,3,7,4,3       ,0,0,0

;
; palette cross referancing for the diamonds
;

diagreen:
           c=16*4
           rept 16
           db c
           c=c+1
           endm
diablue:
           c=16*2
           rept 16
           db c
           c=c+1
           endm
diared:
           c=16*3
           rept 16
           db c
           c=c+1
           endm

;
; Animation sequence for those spaceships flying around.
;
; Note: all offsets are relative from original animation offset
; this way, animation sequences can be anywhere in memory and still run.
;

         align 4

animation1:

         j equ offset animation1
         o equ offset

         dw (o endlists - o lists ) / 2 ; number of headers
         dw o lists-j
         dw o sequences-j

;
; pointers to sequence headers
;

lists:
         dw o head0-j    ; platforms and camera
         dw o headbs0-j  ; blue ships
         dw o headbs1-j
         dw o headbs2-j
         dw o headgs0-j  ; green ships
        ;dw o headgs1-j
        ;dw o headgs2-j
        ;dw o headrs0-j  ; red ships
        ;dw o headrs1-j
        ;dw o headrs2-j
        ;dw o headbd0-j  ; blue diamonds
        ;dw o headbd1-j
        ;dw o headbd2-j
        ;dw o headgd0-j  ; green diamonds
        ;dw o headgd1-j
        ;dw o headgd2-j
        ;dw o headrd0-j  ; red diamonds
        ;dw o headrd1-j
        ;dw o headrd2-j
endlists:

;
; selectable sequences: eg "seq 1" goes to moveit1 and performs that sequence
;

sequences:
         dw o moveit0-j  ; fade off, initialize xmode, fade on
         dw o moveit1-j  ; initialize shapes
         dw o moveit2-j  ; platforms
         dw o moveit3-j  ; camera
         dw 0
         dw o moveit5-j  ; circle routine
         dw o moveit6-j  ; plot blue ship
         dw o moveit7-j  ; wait for 15 frames to pass
         dw 0
         dw 0
         dw 0
         dw 0
         dw 0
         dw 0
         dw 0
         dw o moveitf-j  ;
         dw o moveitg-j  ;

head0:
         seq 0        ; headers to sequences
         seq 1        ; eg do sequence 0, then 1, then 2...done
         seq 2
         seq 3
         done_all     ; when this happens, entire thing is done...

headbs0:
         seq 6
         seq 5
         done
headbs1:
         seq 7
         seq 6
         seq 5
         done
headbs2:
         seq 7
         seq 7
         seq 6
         seq 5
         done

headgs0:
         seq 15  ; green ship, moveit around and around....
         seq 16
         seq 16
         seq 16
         done

moveit0:
         fade_all 0,0,0,1,255,0
         set_mode xmode,xactual,yactual,pages
         initialize
         exit

moveit1:                                  ; initialize objects and bitmaps
         init_shape 0,platform1-j
         init_shape 1,platform2-j
         init_shape 2,platform3-j
         init_shape 3,ship1-j
         init_shape 4,diamond1-j

         init_bitmap 0,sphere,15,15
         init_bitmap 1,icon,15,15

         fade_to gamecolr-j,1,230,1
         exit

moveit2:
         new_object                       ; place platforms
         location 4250000,-750000,0
         full_rotation
         rotate_it 0,-20,0,65500
         shape 0
         on object

         new_object
         location -1000000,750000,3250000
         full_rotation
         rotate_it 0,40,0,65500
         shape 1
         on object

         new_object
         location -4250000,0,-3250000
         full_rotation
         rotate_it 0,-30,0,65500
         shape 2
         on object

         exit
moveit3:
         reset_irq
         camera

         location -5300000,-1933000,-3900000
         follow_obj 3,0
         wait_for ac,0

         move -5750000,-1800000,-3250000,180*2
         wait_for lc,0
         move -5300000,-1600000,-2350000,181*2
         wait_for lc,0
         move -4250000,-1400000,-2200000,190*2
         wait_for lc,0
         move -3350000,-1200000,-2800000,194*2
         wait_for lc,0
         move -3350000,-900000,-3700000,162*2
         wait_for lc,0
         move -4250000,-700000,-4150000,181*2
         wait_for lc,0
         move -5000000,-600000,-3850000,145*2
         wait_for lc,0
         move -5150000,-500000,-3150000,128*2
         wait_for lc,0
         move -4400000,-600000,-2650000,162*2
         wait_for lc,0
         move -3650000,-700000,-3150000,162*2
         wait_for lc,0
         move -4100000,-800000,-3700000,127*2
         wait_for lc,0
         move -4200000,-900000,-3550000,32*2
         wait_for lc,0
         move -4700000,-1100000,-3250000,104*2
         wait_for lc,0
         move -4860000,-1200000,-2950000,61*2
         wait_for lc,0
         move -4550000,-1300000,-3020000,57*2
         wait_for lc,0
         move -3650000,-700000,-3150000,163*2
         wait_for lc,0
         move -4100000,-800000,-3700000,127*2
         wait_for lc,0
         move -5550000,-600000,-4820000,329*2
         wait_for lc,0

         move -4500000,-800000,-3200000,270
         follow_obj 2,105                   ; look at blue platform
         wait_for lc,0
         move -1200000,-900000,4000000,400 ; go toward blue platform
         wait_for lc,0

         wait_for frame_r,545               ; wait until blue ships start their invasion

         follow_obj 4,65                    ; now start to follow the blue ships

         wait_for frame_r,70
         move 4200000,-900000,50000,400

         wait_for frame_r,300

         exit

moveit5:
         angle 0,5000,-10000        ; blue ships spinning above their home base
         wait_for ac,0
         twist_y 65536*128+23000,55*70*4
         align_d 16000
         wait_for frame_r 6525

         move 3900000,-600000,0,440 ; now blue ships take off for red invasion
         point_tm 10
         rotate_y 0,0
         twist_z 65536*3,170
         align_off
         wait_for frame_r 10000

         exit
moveit6:                            ; set original specs for blue ships
         new_object
         location -1300000,100000,3500000
         full_rotation
         rotate_it 0,40,0,65500
         shape 3
         xref_palette xrefblue
         on object
         exit
moveit7:
         wait_for frame_r 37        ; time delay between blue ships
         exit

moveitf:
         new_object
         location -4250000,-200000,-3250000
         full_rotation
         shape 3
         xref_palette xrefgreen
         on object
         exit
moveitg:
         location -4250000,-260000,-3244000 ; this section was made with the qbasic program, I just pointed the mouse and went for it!
         align_d 15000
         point_obj -4248000,-260000,-2898000,50
         wait_for frame_r,23
         point_obj -4890000,-260000,-2884000,50
         wait_for frame_r,42
         point_obj -4888000,-260000,-3652000,50
         wait_for frame_r,51
         point_obj -3656000,-260000,-3674000,50
         wait_for frame_r,82
         point_obj -3628000,-260000,-2774000,50
         wait_for frame_r,60
         point_obj -4802000,-260000,-2792000,50
         wait_for frame_r,78
         point_obj -4836000,-260000,-3598000,50
         wait_for frame_r,53
         point_obj -3692000,-260000,-3624000,50
         wait_for frame_r,76
         point_obj -3688000,-260000,-2816000,50
         wait_for frame_r,53
         point_obj -4698000,-260000,-2848000,50
         wait_for frame_r,67
         point_obj -4738000,-260000,-3556000,50
         wait_for frame_r,47
         point_obj -3780000,-260000,-3560000,50
         wait_for frame_r,63
         point_obj -3760000,-260000,-2874000,50
         wait_for frame_r,45
         point_obj -4666000,-260000,-3500000,50
         wait_for frame_r,73
         point_obj -3846000,-260000,-3522000,50
         wait_for frame_r,54
         point_obj -4616000,-260000,-2906000,50
         wait_for frame_r,65
         point_obj -3784000,-260000,-2872000,50
         wait_for frame_r,55
         point_obj -3842000,-260000,-3510000,50
         wait_for frame_r,42
         point_obj -4628000,-260000,-3496000,50
         wait_for frame_r,52
         point_obj -4622000,-260000,-2930000,50
         wait_for frame_r,37
         point_obj -3832000,-260000,-2902000,50
         wait_for frame_r,52
         point_obj -3852000,-260000,-3500000,50
         wait_for frame_r,39
         point_obj -4686000,-260000,-3516000,50
         wait_for frame_r,55
         point_obj -4666000,-260000,-2890000,50
         wait_for frame_r,41
         point_obj -3754000,-260000,-2876000,50
         wait_for frame_r,60
         point_obj -3802000,-260000,-3548000,50
         wait_for frame_r,44
         point_obj -4706000,-260000,-3580000,50
         wait_for frame_r,60
         point_obj -4734000,-260000,-2854000,50
         wait_for frame_r,48
         point_obj -3722000,-260000,-2846000,50
         wait_for frame_r,67
         point_obj -3766000,-260000,-3552000,50
         wait_for frame_r,47
         point_obj -4774000,-260000,-3580000,50
         wait_for frame_r,67
         point_obj -4750000,-260000,-2816000,50
         wait_for frame_r,50
         point_obj -3702000,-260000,-2808000,50
         wait_for frame_r,69
         point_obj -3754000,-260000,-3586000,50
         wait_for frame_r,51
         point_obj -4762000,-260000,-3582000,50
         wait_for frame_r,67
         point_obj -4754000,-260000,-2806000,50
         wait_for frame_r,51
         point_obj -3754000,-260000,-2846000,50
         wait_for frame_r,66
         point_obj -4084000,-260000,-3254000,50
         wait_for frame_r,34
         point_obj -4254000,-260000,-3290000,50
         wait_for frame_r,11
         point_obj -4290000,-260000,-3230000,50
         wait_for frame_r,4
         point_obj -4268000,-260000,-3160000,50
         wait_for frame_r,4
         point_obj -4242000,-260000,-3154000,50
         wait_for frame_r,1
         point_obj -4218000,-260000,-3154000,50
         wait_for frame_r,1
         point_obj -4194000,-260000,-3154000,50
         wait_for frame_r,1
         point_obj -4160000,-260000,-3156000,50
         wait_for frame_r,2
         point_obj -4136000,-260000,-3160000,50
         wait_for frame_r,1
         point_obj -4120000,-260000,-3180000,50
         wait_for frame_r,1
         point_obj -4112000,-260000,-3204000,50
         wait_for frame_r,1
         point_obj -4116000,-260000,-3228000,50
         wait_for frame_r,1
         point_obj -4136000,-260000,-3254000,50
         wait_for frame_r,2
         point_obj -4164000,-260000,-3270000,50
         wait_for frame_r,2
         point_obj -4184000,-260000,-3276000,50
         wait_for frame_r,1
         point_obj -4210000,-260000,-3284000,50
         wait_for frame_r,1
         point_obj -4242000,-260000,-3280000,50
         wait_for frame_r,2
         point_obj -4260000,-260000,-3256000,50
         wait_for frame_r,2
         point_obj -4262000,-260000,-3232000,50
         wait_for frame_r,1
         point_obj -4252000,-260000,-3208000,50
         wait_for frame_r,1
         point_obj -4232000,-260000,-3192000,50
         wait_for frame_r,1
         point_obj -4208000,-260000,-3188000,50
         wait_for frame_r,1
         point_obj -4190000,-260000,-3218000,50
         wait_for frame_r,2
         point_obj -4198000,-260000,-3240000,50
         wait_for frame_r,1
         point_obj -4224000,-260000,-3254000,50
         wait_for frame_r,1
         point_obj -4254000,-260000,-3258000,50
         wait_for frame_r,2
         point_obj -4280000,-260000,-3260000,50
         wait_for frame_r,1
         point_obj -4302000,-260000,-3244000,50
         wait_for frame_r,1
         point_obj -4306000,-260000,-3224000,50
         wait_for frame_r,1
         point_obj -4306000,-260000,-3200000,50
         wait_for frame_r,1
         point_obj -4284000,-260000,-3178000,50
         wait_for frame_r,2
         point_obj -4264000,-260000,-3172000,50
         wait_for frame_r,1
         point_obj -4230000,-260000,-3170000,50
         wait_for frame_r,2
         point_obj -4186000,-260000,-3170000,50
         wait_for frame_r,2
         point_obj -4166000,-260000,-3174000,50
         wait_for frame_r,1
         point_obj -4146000,-260000,-3178000,50
         wait_for frame_r,1
         point_obj -4128000,-260000,-3200000,50
         wait_for frame_r,1
         point_obj -4120000,-260000,-3234000,50
         wait_for frame_r,2
         point_obj -4124000,-260000,-3256000,50
         wait_for frame_r,1
         point_obj -4150000,-260000,-3278000,50
         wait_for frame_r,2
         point_obj -4174000,-260000,-3290000,50
         wait_for frame_r,1
         point_obj -4198000,-260000,-3294000,50
         wait_for frame_r,1
         point_obj -4226000,-260000,-3298000,50
         wait_for frame_r,1
         point_obj -4266000,-260000,-3286000,50
         wait_for frame_r,2
         point_obj -4290000,-260000,-3272000,50
         wait_for frame_r,1
         point_obj -4304000,-260000,-3248000,50
         wait_for frame_r,1
         point_obj -4308000,-260000,-3218000,50
         wait_for frame_r,2
         point_obj -4304000,-260000,-3194000,50
         wait_for frame_r,1
         point_obj -4260000,-260000,-3162000,50
         wait_for frame_r,3
         point_obj -4216000,-260000,-3150000,50
         wait_for frame_r,3
         point_obj -4182000,-260000,-3146000,50
         wait_for frame_r,2
         point_obj -4148000,-260000,-3142000,50
         wait_for frame_r,2
         point_obj -4128000,-260000,-3158000,50
         wait_for frame_r,1
         point_obj -4120000,-260000,-3186000,50
         wait_for frame_r,1
         point_obj -4120000,-260000,-3206000,50
         wait_for frame_r,1
         point_obj -4128000,-260000,-3232000,50
         wait_for frame_r,1
         point_obj -4150000,-260000,-3256000,50
         wait_for frame_r,2
         point_obj -4170000,-260000,-3264000,50
         wait_for frame_r,1
         point_obj -4200000,-260000,-3270000,50
         wait_for frame_r,2
         point_obj -4224000,-260000,-3274000,50
         wait_for frame_r,1
         point_obj -4248000,-260000,-3272000,50
         wait_for frame_r,1
         point_obj -4268000,-260000,-3260000,50
         wait_for frame_r,1
         point_obj -4278000,-260000,-3236000,50
         wait_for frame_r,1
         point_obj -4274000,-260000,-3214000,50
         wait_for frame_r,1
         point_obj -4242000,-260000,-3196000,50
         wait_for frame_r,2
         point_obj -4214000,-260000,-3200000,50
         wait_for frame_r,1
         point_obj -4202000,-260000,-3220000,50
         wait_for frame_r,1
         point_obj -4224000,-260000,-3232000,50
         wait_for frame_r,1
         point_obj -4244000,-260000,-3226000,50
         wait_for frame_r,1
         point_obj -4256000,-260000,-3204000,50
         wait_for frame_r,1
         point_obj -4236000,-260000,-3180000,50
         wait_for frame_r,2

         move -3600000,-140000,-3500000,10
         point_tm 10
         wait_for lc,0
         move -4900000,-240000,-3000000,10
         point_tm 10
         wait_for lc,0

         exit

