;
;
; Filename     : land.asm
; Included from: Main Assembley Module
; Description  : Draw Background Horizon
;
; Written by: John McCarthy
;             1316 Redwood Lane
;             Pickering, Ontario.
;             Canada, Earth, Milky Way (for those out-of-towners)
;             L1X 1C5
;
; Internet/Usenet:  BRIAN.MCCARTHY@CANREM.COM
;         Fidonet:  Brian McCarthy 1:229/15
;   RIME/Relaynet: ->CRS
;
; Home phone, (905) 831-1944, don't call at 2 am eh!
;
; Send me your protected mode source code!
; Send me your Objects!
; But most of all, Send me a postcard!!!!
;
; Simple non-rotatable background landscape.  Cannot be used with z rotations
; that is - it only draws a flat backgound landscape.  Use this  in  place of
; clear_fill routine.  This routine wipes all video memory within the current
; clipping parameters and puts the "landscape" in the background.
;
; This routine does not compensate for the height of the camera! the  scaling
; of the colours on the "ground" do not become tighter  as  the  camera  gets
; closer to the ground.  Someday, no today, I will make a routine which  does
; full flight simulator backgounds.
;
; NOTE: This routine sets the flag useclear=no and therefore  shuts  off  the
;       clear_fill routine in poly.inc.  This is done since  screen  clearing
;       is done at the same time as drawing the background landscape.
;
;

        .386p
        jumps

code32  segment para public use32
        assume cs:code32, ds:code32

        include pmode.ext       ; protected mode externals by TRAN
        include xmouse.ext      ; xmode mouse externals
        include xmode.ext       ; xmode externals by matt pritchard
        include irq.ext
        include 3d.ext
        include stars.ext
        include font.ext

        include macros.inc
        include equ.inc

        public draw_landscape

        sky equ 0      ; colours...
        ground equ 84

draw_landscape:
        out_8 sc_data, all_planes   ; write to all planes

        mov ax,eyeax            ; y = ratiox * (z * 20) / (z * 32) (horizon)
        or ax,ax
        jz doit_a

        call cosign             ; find horizon = tan(x xangle) * 1024
        push eax
        mov ax,eyeax
        call sign
        mov ebx,eax
        cmul eax,ebx,yactual
        pop ecx
        cdq
        idiv ecx
doit_a:
        mov si,ax
        add si,ymins
        sub si,8*yactual/400

        movzx edi,cliptp
        mov edi,fastimultable[edi*4]
        movzx ecx,cliplt
        shr ecx,2
        add edi,ecx
        add edi,current_page

        mov dx,ymaxs   ; dx = counter
        sub dx,ymins
        movzx edx,dx

        movzx ecx,xmaxs
        sub cx,xmins
        mov ebx,xactual
        sub bx,cx
        shr ebx,2
        shr cx,3        ; /4/2
        mov ebp,ecx
        mov ax,sky*256+sky  ; background sky colour

plot_loop1:
        cmp si,0       ; check for horizon
        jge here_s_johnny
        mov ecx,ebp
pl_1x:
        rep stosw
        add edi,ebx
        inc esi
        dec edx
        jnz plot_loop1

        ret

here_s_johnny:
        mov ax,ground*256+ground  ; background ground colour

plot_loop2:
        mov ecx,ebp
pl_2x:
        rep stosw
        add edi,ebx
        dec edx
        jnz plot_loop2

        ret

code32  ends
        end

