
; This is a hacked .NFF object from Toronto Virtual SIG.  Notice the  duplicate
; x,y,z points! Write me a program to convert between .NFF and dataword format.
; it must:
;
; a) check for duplicate points and simplify if any (modify connection data if
;    duplicate points)
; b) reverse the clockwise order to counter-clockwise.
; c) must also check  for  non-valid connection data. eg 3,2,1,3,3,4,6 (3's=err)
; d) provide the option to calculate surface colour  based  on  surface  normal,
;    this way, if an object has no rotation (option 1 in commands) then the colour
;    will already be set as if it had a light source. (saves 3 imuls/side)
; e) provide a scaling factor for the x,y,z points from fractional to mulpiple
;    eg 200 times bigger to 1/200'th smaller (or so).
;
; I could write a program to do this if only I had a routine to input a floating
; point number from the disk buffer... eg: 0.05412 to -1894.881 or whatever.
;
; I converted this file using a BASIC program (ug!,Hey it had  floating  point)
;
; the scaling for this file was 1/6 (.166666)
;
; make SURE you set maxpoints>214 and maxsurfaces>372

headerknight dd -1
             dd offset knight - offset $ -4

knight:
  dw 214
  dw 372
  dw 25 dup (0)

  dw -60,0,0     ; 1
  dw -54,11,0    ; 2
  dw -51,89,0    ; 3
  dw -45,73,0    ; 4
  dw -45,29,-45  ; 5
  dw -45,29,44   ; 6
  dw -42,0,-42   ; 7
  dw -42,0,41    ; 8
  dw -39,11,-39  ; 9
  dw -39,11,38   ; 10
  dw -36,89,-36  ; 11
  dw -36,89,35   ; 12
  dw -32,73,-32  ; 13
  dw -32,73,31   ; 14
  dw -31,0,0     ; 15
  dw -31,87,0    ; 16
  dw -30,133,12  ; 17
  dw -30,223,7   ; 18
  dw -30,226,28  ; 19
  dw -30,241,22  ; 20
  dw -29,262,10  ; 21
  dw -29,233,20  ; 22
  dw -29,215,5   ; 23
  dw -29,236,0   ; 24
  dw -28,128,33  ; 25
  dw -28,229,0   ; 26
  dw -28,95,21   ; 27
  dw -28,217,24  ; 28
  dw -28,107,-1  ; 29
  dw -27,139,-11 ; 30
  dw -26,270,30  ; 31
  dw -26,254,-11 ; 32
  dw -26,220,-13 ; 33
  dw -26,213,-14 ; 34
  dw -25,245,39  ; 35
  dw -24,236,36  ; 36
  dw -24,225,-19 ; 37
  dw -24,229,45  ; 38
  dw -23,232,-20 ; 39
  dw -23,199,-14 ; 40
  dw -22,118,-22 ; 41
  dw -22,0,-22   ; 42
  dw -22,0,21    ; 43
  dw -22,87,-22  ; 44
  dw -22,87,21   ; 45
  dw -21,195,-26 ; 46
  dw -21,203,-1  ; 47
  dw -20,219,39  ; 48
  dw -20,86,39   ; 49
  dw -20,143,-29 ; 50
  dw -19,248,-28 ; 51
  dw -19,211,-29 ; 52
  dw -18,218,-30 ; 53
  dw -18,275,-15 ; 54
  dw -17,280,0   ; 55
  dw -16,90,-10  ; 56
  dw -15,206,9   ; 57
  dw -15,192,-37 ; 58
  dw -14,223,-35 ; 59
  dw -14,99,-26  ; 60
  dw -14,124,50  ; 61
  dw -14,269,-30 ; 62
  dw -14,125,-35 ; 63
  dw -13,229,-36 ; 64
  dw -12,277,45  ; 65
  dw -12,83,4    ; 66
  dw -10,104,-37 ; 67
  dw -9,266,-38  ; 68
  dw -8,244,-39  ; 69
  dw -8,146,-39  ; 70
  dw -7,284,10   ; 71
  dw -6,106,-41  ; 72
  dw -5,298,-34  ; 73
  dw -4,239,48   ; 74
  dw -4,248,53   ; 75
  dw -4,264,-42  ; 76
  dw -4,127,-41  ; 77
  dw -3,290,-42  ; 78
  dw -2,107,-43  ; 79
  dw -2,288,-44  ; 80
  dw -2,230,54   ; 81
  dw -1,209,-41  ; 82
  dw -1,208,15   ; 83
  dw -1,287,-44  ; 84
  dw -1,29,-63   ; 85
  dw -1,0,-60    ; 86
  dw -1,11,-54   ; 87
  dw -1,89,-51   ; 88
  dw -1,73,-45   ; 89
  dw -1,0,-31    ; 90
  dw -1,87,-31   ; 91
  dw 0,-1,0      ; 92
  dw 0,87,0      ; 93
  dw 0,87,30     ; 94
  dw 0,0,30      ; 95
  dw 0,73,44     ; 96
  dw 0,89,50     ; 97
  dw 0,11,53     ; 98
  dw 0,0,59      ; 99
  dw 0,29,62     ; 100
  dw 0,287,-45   ; 101
  dw 0,216,-40   ; 102
  dw 0,305,-29   ; 103
  dw 0,190,-42   ; 104
  dw 1,295,-45   ; 105
  dw 1,80,-46    ; 106
  dw 1,287,-45   ; 107
  dw 1,219,47    ; 108
  dw 1,295,-46   ; 109
  dw 1,80,-46    ; 110
  dw 1,80,-46    ; 111
  dw 1,80,-46    ; 112
  dw 1,295,-46   ; 113
  dw 1,80,-46    ; 114     ; notice duplicate points!!, write me a program
  dw 1,80,-46    ; 115     ; to convert a .NFF file and elliminate this!
  dw 1,80,-46    ; 116
  dw 1,80,-46    ; 117
  dw 1,295,-46   ; 118
  dw 1,80,-46    ; 119     ; more dup's
  dw 1,80,-46    ; 120
  dw 1,80,-46    ; 121
  dw 1,80,-46    ; 122
  dw 1,264,-43   ; 123
  dw 1,295,-46   ; 124
  dw 1,295,-46   ; 125
  dw 1,295,-46   ; 126     ; more dup's!!! ahhhh!!!
  dw 2,295,-46   ; 127
  dw 2,295,-46   ; 128
  dw 2,295,-46   ; 129
  dw 2,295,-46   ; 130
  dw 2,295,-46   ; 131
  dw 2,287,-45   ; 132
  dw 2,221,-40   ; 133
  dw 2,107,-43   ; 134
  dw 3,287,-45   ; 135
  dw 3,228,-40   ; 136
  dw 4,288,-44   ; 137
  dw 4,289,-43   ; 138
  dw 5,298,-36   ; 139
  dw 5,243,-40   ; 140
  dw 6,146,-39   ; 141
  dw 6,83,45     ; 142
  dw 6,106,-41   ; 143
  dw 6,264,-41   ; 144
  dw 7,126,-39   ; 145
  dw 7,82,6      ; 146
  dw 10,104,-36  ; 147
  dw 11,266,-36  ; 148
  dw 11,281,5    ; 149
  dw 13,124,50   ; 150
  dw 14,279,44   ; 151
  dw 14,207,11   ; 152
  dw 15,97,-23   ; 153
  dw 15,192,-35  ; 154
  dw 16,270,-24  ; 155
  dw 16,89,-7    ; 156
  dw 16,122,-30  ; 157
  dw 17,276,-8   ; 158
  dw 17,248,-29  ; 159
  dw 17,224,-29  ; 160
  dw 17,210,-29  ; 161
  dw 18,143,-28  ; 162
  dw 18,217,-28  ; 163
  dw 18,230,-28  ; 164
  dw 18,238,42   ; 165
  dw 20,248,48   ; 166
  dw 20,204,1    ; 167
  dw 20,196,-24  ; 168
  dw 21,87,-22   ; 169
  dw 21,87,21    ; 170
  dw 21,0,-22    ; 171
  dw 21,0,21     ; 172
  dw 21,229,46   ; 173
  dw 21,218,39   ; 174
  dw 22,200,-12  ; 175
  dw 24,112,-11  ; 176
  dw 24,212,-14  ; 177
  dw 24,227,-13  ; 178
  dw 24,256,-12  ; 179
  dw 25,90,31    ; 180
  dw 25,220,-12  ; 181
  dw 25,235,-11  ; 182
  dw 25,139,-10  ; 183
  dw 26,273,28   ; 184
  dw 27,235,26   ; 185
  dw 27,101,11   ; 186
  dw 27,129,33   ; 187
  dw 28,216,24   ; 188
  dw 28,265,9    ; 189
  dw 28,214,5    ; 190
  dw 28,231,6    ; 191
  dw 29,227,29   ; 192
  dw 29,244,31   ; 193
  dw 29,223,9    ; 194
  dw 29,134,12   ; 195
  dw 29,240,10   ; 196
  dw 30,87,0     ; 197
  dw 30,0,0      ; 198
  dw 31,73,-32   ; 199
  dw 31,73,31    ; 200
  dw 35,89,-36   ; 201
  dw 35,89,35    ; 202
  dw 38,11,-39   ; 203
  dw 38,11,38    ; 204
  dw 41,0,-42    ; 205
  dw 41,0,41     ; 206
  dw 44,29,-45   ; 207
  dw 44,29,44    ; 208
  dw 44,73,0     ; 209
  dw 50,89,0     ; 210
  dw 53,11,0     ; 211
  dw 59,0,0      ; 212
  dw 62,29,0     ; 213
  dw -63,29,0    ; 214

  dw 0,shade,?,16*1+0,?,170,197,93,170         ,?,?,?  ;1
  dw 0,shade,?,16*1+0,?,94,170,93,94           ,?,?,?  ;2
  dw 0,shade,?,16*1+0,?,45,94,93,45            ,?,?,?  ;3
  dw 0,shade,?,16*1+0,?,16,45,93,16            ,?,?,?  ;4
  dw 0,shade,?,16*1+0,?,44,16,93,44            ,?,?,?  ;5
  dw 0,shade,?,16*1+0,?,91,44,93,91            ,?,?,?  ;6          0
  dw 0,shade,?,16*1+0,?,169,91,93,169          ,?,?,?  ;7
  dw 0,shade,?,16*1+0,?,197,169,93,197         ,?,?,?  ;8
  dw 0,shade,?,16*1+0,?,170,202,210,197,170    ,?,?,?  ;9
  dw 0,shade,?,16*1+0,?,94,97,202,170,94       ,?,?,?  ; 0
  dw 0,shade,?,16*1+0,?,45,12,97,94,45         ,?,?,?  ;;1
  dw 0,shade,?,16*1+0,?,16,3,12,45,16          ,?,?,?  ;;2
  dw 0,shade,?,16*1+0,?,44,11,3,16,44          ,?,?,?   ;3
  dw 0,shade,?,16*1+0,?,91,88,11,44,91         ,?,?,?   ;4
  dw 0,shade,?,16*1+0,?,169,201,88,91,169      ,?,?,?   ;5         1
  dw 0,shade,?,16*1+0,?,197,210,201,169,197    ,?,?,?   ;6
  dw 0,shade,?,16*1+0,?,202,200,209,210,202    ,?,?,?   ;7
  dw 0,shade,?,16*1+0,?,97,96,200,202,97       ,?,?,?   ;8
  dw 0,shade,?,16*1+0,?,12,14,96,97,12         ,?,?,?   ;9
  dw 0,shade,?,16*1+0,?,3,4,14,12,3            ,?,?,?   ; 0
  dw 0,shade,?,16*1+0,?,11,13,4,3,11           ,?,?,?   ;;1
  dw 0,shade,?,16*1+0,?,88,89,13,11,88         ,?,?,?   ;;2
  dw 0,shade,?,16*1+0,?,201,199,89,88,201      ,?,?,?    ;3
  dw 0,shade,?,16*1+0,?,210,209,199,201,210    ,?,?,?    ;4
  dw 0,shade,?,16*1+0,?,200,208,213,209,200    ,?,?,?    ;5
  dw 0,shade,?,16*1+0,?,96,100,208,200,96      ,?,?,?    ;6        2
  dw 0,shade,?,16*1+0,?,14,6,100,96,14         ,?,?,?    ;7
  dw 0,shade,?,16*1+0,?,4,214,6,14,4           ,?,?,?    ;8
  dw 0,shade,?,16*1+0,?,13,5,214,4,13          ,?,?,?    ;9
  dw 0,shade,?,16*1+0,?,89,85,5,13,89          ,?,?,?    ; 0
  dw 0,shade,?,16*1+0,?,199,207,85,89,199      ,?,?,?    ;;1
  dw 0,shade,?,16*1+0,?,209,213,207,199,209    ,?,?,?    ;;2
  dw 0,shade,?,16*1+0,?,208,204,211,213,208    ,?,?,?     ;3
  dw 0,shade,?,16*1+0,?,100,98,204,208,100     ,?,?,?     ;4
  dw 0,shade,?,16*1+0,?,6,10,98,100,6          ,?,?,?     ;5       3
  dw 0,shade,?,16*1+0,?,214,2,10,6,214         ,?,?,?     ;6
  dw 0,shade,?,16*1+0,?,5,9,2,214,5            ,?,?,?     ;7
  dw 0,shade,?,16*1+0,?,85,87,9,5,85           ,?,?,?     ;8
  dw 0,shade,?,16*1+0,?,207,203,87,85,207      ,?,?,?     ;9
  dw 0,shade,?,16*1+0,?,213,211,203,207,213    ,?,?,?     ; 0
  dw 0,shade,?,16*1+0,?,204,206,212,211,204    ,?,?,?     ;;1
  dw 0,shade,?,16*1+0,?,98,99,206,204,98       ,?,?,?     ;;2
  dw 0,shade,?,16*1+0,?,10,8,99,98,10          ,?,?,?      ;3
  dw 0,shade,?,16*1+0,?,2,1,8,10,2             ,?,?,?      ;4
  dw 0,shade,?,16*1+0,?,9,7,1,2,9              ,?,?,?      ;5
  dw 0,shade,?,16*1+0,?,87,86,7,9,87           ,?,?,?      ;6      4
  dw 0,shade,?,16*1+0,?,203,205,86,87,203      ,?,?,?      ;7
  dw 0,shade,?,16*1+0,?,211,212,205,203,211    ,?,?,?      ;8
  dw 0,shade,?,16*1+0,?,206,172,198,212,206    ,?,?,?      ;9
  dw 0,shade,?,16*1+0,?,99,95,172,206,99       ,?,?,?      ; 0
  dw 0,shade,?,16*1+0,?,8,43,95,99,8           ,?,?,?      ;;1
  dw 0,shade,?,16*1+0,?,1,15,43,8,1            ,?,?,?      ;;2
  dw 0,shade,?,16*1+0,?,7,42,15,1,7            ,?,?,?       ;3
  dw 0,shade,?,16*1+0,?,86,90,42,7,86          ,?,?,?       ;4
  dw 0,shade,?,16*1+0,?,205,171,90,86,205      ,?,?,?       ;5
  dw 0,shade,?,16*1+0,?,212,198,171,205,212    ,?,?,?       ;6
  dw 0,shade,?,16*1+0,?,172,92,198,172         ,?,?,?       ;7      5
  dw 0,shade,?,16*1+0,?,95,92,172,95           ,?,?,?       ;8
  dw 0,shade,?,16*1+0,?,43,92,95,43            ,?,?,?       ;9
  dw 0,shade,?,16*1+0,?,15,92,43,15            ,?,?,?       ; 0
  dw 0,shade,?,16*1+0,?,42,92,15,42            ,?,?,?       ;;1
  dw 0,shade,?,16*1+0,?,90,92,42,90            ,?,?,?       ;;2
  dw 0,shade,?,16*1+0,?,171,92,90,171          ,?,?,?        ;3
  dw 0,shade,?,16*1+0,?,198,92,171,198         ,?,?,?        ;4
  dw 0,shade,?,16*1+0,?,128,127,126,128        ,?,?,?        ;5
  dw 0,shade,?,16*1+0,?,130,128,126,130        ,?,?,?        ;6
  dw 0,shade,?,16*1+0,?,131,130,126,131        ,?,?,?        ;7      6
  dw 0,shade,?,16*1+0,?,129,131,126,129        ,?,?,?        ;8
  dw 0,shade,?,16*1+0,?,105,129,126,105        ,?,?,?        ;9
  dw 0,shade,?,16*1+0,?,109,105,126,109        ,?,?,?        ; 0
  dw 0,shade,?,16*1+0,?,113,109,126,113        ,?,?,?        ;;1
  dw 0,shade,?,16*1+0,?,118,113,126,118        ,?,?,?        ;;2
  dw 0,shade,?,16*1+0,?,124,118,126,124        ,?,?,?         ;3
  dw 0,shade,?,16*1+0,?,125,124,126,125        ,?,?,?         ;4
  dw 0,shade,?,16*1+0,?,138,129,105,138        ,?,?,?         ;5
  dw 0,shade,?,16*1+0,?,139,138,105,139        ,?,?,?         ;6
  dw 0,shade,?,16*1+0,?,105,109,103,105        ,?,?,?         ;7     7
  dw 0,shade,?,16*1+0,?,139,105,103,139        ,?,?,?         ;8
  dw 0,shade,?,16*1+0,?,109,113,73,109         ,?,?,?         ;9
  dw 0,shade,?,16*1+0,?,103,109,73,103         ,?,?,?         ; 0
  dw 0,shade,?,16*1+0,?,113,118,78,113         ,?,?,?         ;;1
  dw 0,shade,?,16*1+0,?,73,113,78,73           ,?,?,?         ;;2
  dw 0,shade,?,16*1+0,?,118,124,80,118         ,?,?,?          ;3
  dw 0,shade,?,16*1+0,?,78,118,80,78           ,?,?,?          ;4
  dw 0,shade,?,16*1+0,?,124,125,84,124         ,?,?,?          ;5
  dw 0,shade,?,16*1+0,?,80,124,84,80           ,?,?,?          ;6
  dw 0,shade,?,16*1+0,?,126,101,84,126         ,?,?,?          ;7     8
  dw 0,shade,?,16*1+0,?,125,126,84,125         ,?,?,?          ;8
  dw 0,shade,?,16*1+0,?,127,107,101,127        ,?,?,?          ;9
  dw 0,shade,?,16*1+0,?,126,127,101,126        ,?,?,?          ; 0
  dw 0,shade,?,16*1+0,?,132,107,127,132        ,?,?,?          ;;1
  dw 0,shade,?,16*1+0,?,128,132,127,128        ,?,?,?          ;;2
  dw 0,shade,?,16*1+0,?,135,132,128,135        ,?,?,?           ;3
  dw 0,shade,?,16*1+0,?,130,135,128,130        ,?,?,?           ;4
  dw 0,shade,?,16*1+0,?,135,130,131,135        ,?,?,?           ;5
  dw 0,shade,?,16*1+0,?,137,135,131,137        ,?,?,?           ;6     9
  dw 0,shade,?,16*1+0,?,137,131,129,137        ,?,?,?           ;7
  dw 0,shade,?,16*1+0,?,138,137,129,138        ,?,?,?           ;8
  dw 0,shade,?,16*1+0,?,148,138,139,148        ,?,?,?           ;9
  dw 0,shade,?,16*1+0,?,155,148,139,155        ,?,?,?           ; 0
  dw 0,shade,?,16*1+0,?,155,139,103,155        ,?,?,?           ;;1
  dw 0,shade,?,16*1+0,?,158,155,103,158        ,?,?,?           ;;2
  dw 0,shade,?,16*1+0,?,103,73,149,103         ,?,?,?            ;3
  dw 0,shade,?,16*1+0,?,158,103,149,158        ,?,?,?            ;4
  dw 0,shade,?,16*1+0,?,73,78,71,73            ,?,?,?            ;5
  dw 0,shade,?,16*1+0,?,149,73,71,149          ,?,?,?            ;6     10
  dw 0,shade,?,16*1+0,?,78,80,55,78            ,?,?,?            ;7
  dw 0,shade,?,16*1+0,?,71,78,55,71            ,?,?,?            ;8
  dw 0,shade,?,16*1+0,?,80,84,54,80            ,?,?,?            ;9
  dw 0,shade,?,16*1+0,?,55,80,54,55            ,?,?,?            ; 0
  dw 0,shade,?,16*1+0,?,84,101,62,84           ,?,?,?            ;;1
  dw 0,shade,?,16*1+0,?,54,84,62,54            ,?,?,?            ;;2
  dw 0,shade,?,16*1+0,?,101,107,68,101         ,?,?,?             ;3
  dw 0,shade,?,16*1+0,?,62,101,68,62           ,?,?,?             ;4
  dw 0,shade,?,16*1+0,?,68,107,132,68          ,?,?,?             ;5
  dw 0,shade,?,16*1+0,?,76,68,132,76           ,?,?,?             ;6      11
  dw 0,shade,?,16*1+0,?,135,123,76,135         ,?,?,?             ;7
  dw 0,shade,?,16*1+0,?,132,135,76,132         ,?,?,?             ;8
  dw 0,shade,?,16*1+0,?,144,123,135,144        ,?,?,?             ;9
  dw 0,shade,?,16*1+0,?,137,144,135,137        ,?,?,?             ; 0
  dw 0,shade,?,16*1+0,?,144,137,138,144        ,?,?,?             ;;1
  dw 0,shade,?,16*1+0,?,148,144,138,148        ,?,?,?             ;;2
  dw 0,shade,?,16*1+0,?,159,148,155,159        ,?,?,?              ;3
  dw 0,shade,?,16*1+0,?,179,159,155,179        ,?,?,?              ;4
  dw 0,shade,?,16*1+0,?,179,155,158,179        ,?,?,?              ;5
  dw 0,shade,?,16*1+0,?,189,179,158,189        ,?,?,?              ;6
  dw 0,shade,?,16*1+0,?,189,158,149,189        ,?,?,?              ;7
  dw 0,shade,?,16*1+0,?,184,189,149,184        ,?,?,?              ;8
  dw 0,shade,?,16*1+0,?,184,149,71,184         ,?,?,?              ;9
  dw 0,shade,?,16*1+0,?,151,184,71,151         ,?,?,?              ; 0
  dw 0,shade,?,16*1+0,?,71,55,65,71            ,?,?,?              ;;1    12
  dw 0,shade,?,16*1+0,?,151,71,65,151          ,?,?,?              ;;2
  dw 0,shade,?,16*1+0,?,55,54,31,55            ,?,?,?               ;3
  dw 0,shade,?,16*1+0,?,65,55,31,65            ,?,?,?               ;4
  dw 0,shade,?,16*1+0,?,54,62,21,54            ,?,?,?               ;5
  dw 0,shade,?,16*1+0,?,31,54,21,31            ,?,?,?               ;6
  dw 0,shade,?,16*1+0,?,62,68,32,62            ,?,?,?               ;7
  dw 0,shade,?,16*1+0,?,21,62,32,21            ,?,?,?               ;8
  dw 0,shade,?,16*1+0,?,68,76,51,68            ,?,?,?               ;9
  dw 0,shade,?,16*1+0,?,32,68,51,32            ,?,?,?               ; 0
  dw 0,shade,?,16*1+0,?,76,123,69,76           ,?,?,?               ;;1
  dw 0,shade,?,16*1+0,?,51,76,69,51            ,?,?,?               ;;2     13
  dw 0,shade,?,16*1+0,?,144,140,69,144         ,?,?,?                ;3
  dw 0,shade,?,16*1+0,?,123,144,69,123         ,?,?,?                ;4
  dw 0,shade,?,16*1+0,?,140,144,148,140        ,?,?,?                ;5
  dw 0,shade,?,16*1+0,?,159,140,148,159        ,?,?,?                ;6
  dw 0,shade,?,16*1+0,?,164,159,179,164        ,?,?,?                ;7
  dw 0,shade,?,16*1+0,?,182,164,179,182        ,?,?,?                ;8
  dw 0,shade,?,16*1+0,?,182,179,189,182        ,?,?,?                ;9
  dw 0,shade,?,16*1+0,?,196,182,189,196        ,?,?,?                ; 0
  dw 0,shade,?,16*1+0,?,196,189,184,196        ,?,?,?                ;;1
  dw 0,shade,?,16*1+0,?,193,196,184,193        ,?,?,?                ;;2    14
  dw 0,shade,?,16*1+0,?,193,184,151,193        ,?,?,?                 ;3
  dw 0,shade,?,16*1+0,?,166,193,151,166        ,?,?,?                 ;4
  dw 0,shade,?,16*1+0,?,75,166,151,75          ,?,?,?                 ;5
  dw 0,shade,?,16*1+0,?,65,75,151,65           ,?,?,?                 ;6
  dw 0,shade,?,16*1+0,?,31,35,75,31            ,?,?,?                 ;7
  dw 0,shade,?,16*1+0,?,65,31,75,65            ,?,?,?                 ;8
  dw 0,shade,?,16*1+0,?,31,21,20,31            ,?,?,?                 ;9
  dw 0,shade,?,16*1+0,?,35,31,20,35            ,?,?,?                 ;0
  dw 0,shade,?,16*1+0,?,21,32,24,21            ,?,?,?                 ;
  dw 0,shade,?,16*1+0,?,20,21,24,20            ,?,?,?                 ;
  dw 0,shade,?,16*1+0,?,32,51,39,32            ,?,?,?
  dw 0,shade,?,16*1+0,?,24,32,39,24            ,?,?,?
  dw 0,shade,?,16*1+0,?,51,69,64,51            ,?,?,?
  dw 0,shade,?,16*1+0,?,39,51,64,39            ,?,?,?
  dw 0,shade,?,16*1+0,?,140,136,64,140         ,?,?,?
  dw 0,shade,?,16*1+0,?,69,140,64,69           ,?,?,?
  dw 0,shade,?,16*1+0,?,164,136,140,164        ,?,?,?
  dw 0,shade,?,16*1+0,?,159,164,140,159        ,?,?,?
  dw 0,shade,?,16*1+0,?,178,160,164,178        ,?,?,?
  dw 0,shade,?,16*1+0,?,182,178,164,182        ,?,?,?
  dw 0,shade,?,16*1+0,?,191,178,182,191        ,?,?,?
  dw 0,shade,?,16*1+0,?,196,191,182,196        ,?,?,?
  dw 0,shade,?,16*1+0,?,185,191,196,185        ,?,?,?
  dw 0,shade,?,16*1+0,?,193,185,196,193        ,?,?,?
  dw 0,shade,?,16*1+0,?,165,185,193,165        ,?,?,?
  dw 0,shade,?,16*1+0,?,166,165,193,166        ,?,?,?
  dw 0,shade,?,16*1+0,?,74,165,166,74          ,?,?,?
  dw 0,shade,?,16*1+0,?,75,74,166,75           ,?,?,?
  dw 0,shade,?,16*1+0,?,35,36,74,35            ,?,?,?
  dw 0,shade,?,16*1+0,?,75,35,74,75            ,?,?,?
  dw 0,shade,?,16*1+0,?,20,22,36,20            ,?,?,?
  dw 0,shade,?,16*1+0,?,35,20,36,35            ,?,?,?
  dw 0,shade,?,16*1+0,?,20,24,26,20            ,?,?,?
  dw 0,shade,?,16*1+0,?,22,20,26,22            ,?,?,?
  dw 0,shade,?,16*1+0,?,24,39,37,24            ,?,?,?
  dw 0,shade,?,16*1+0,?,26,24,37,26            ,?,?,?
  dw 0,shade,?,16*1+0,?,39,64,59,39            ,?,?,?
  dw 0,shade,?,16*1+0,?,37,39,59,37            ,?,?,?
  dw 0,shade,?,16*1+0,?,136,133,59,136         ,?,?,?
  dw 0,shade,?,16*1+0,?,64,136,59,64           ,?,?,?
  dw 0,shade,?,16*1+0,?,160,133,136,160        ,?,?,?
  dw 0,shade,?,16*1+0,?,164,160,136,164        ,?,?,?
  dw 0,shade,?,16*1+0,?,163,160,178,163        ,?,?,?
  dw 0,shade,?,16*1+0,?,181,163,178,181        ,?,?,?
  dw 0,shade,?,16*1+0,?,181,178,191,181        ,?,?,?
  dw 0,shade,?,16*1+0,?,194,181,191,194        ,?,?,?
  dw 0,shade,?,16*1+0,?,194,191,185,194        ,?,?,?
  dw 0,shade,?,16*1+0,?,192,194,185,192        ,?,?,?
  dw 0,shade,?,16*1+0,?,192,185,165,192        ,?,?,?
  dw 0,shade,?,16*1+0,?,173,192,165,173        ,?,?,?
  dw 0,shade,?,16*1+0,?,81,173,165,81          ,?,?,?
  dw 0,shade,?,16*1+0,?,74,81,165,74           ,?,?,?
  dw 0,shade,?,16*1+0,?,36,38,81,36            ,?,?,?
  dw 0,shade,?,16*1+0,?,74,36,81,74            ,?,?,?
  dw 0,shade,?,16*1+0,?,36,22,19,36            ,?,?,?
  dw 0,shade,?,16*1+0,?,38,36,19,38            ,?,?,?
  dw 0,shade,?,16*1+0,?,22,26,18,22            ,?,?,?
  dw 0,shade,?,16*1+0,?,19,22,18,19            ,?,?,?
  dw 0,shade,?,16*1+0,?,26,37,33,26            ,?,?,?
  dw 0,shade,?,16*1+0,?,18,26,33,18            ,?,?,?
  dw 0,shade,?,16*1+0,?,37,59,53,37            ,?,?,?
  dw 0,shade,?,16*1+0,?,33,37,53,33            ,?,?,?
  dw 0,shade,?,16*1+0,?,133,102,53,133         ,?,?,?
  dw 0,shade,?,16*1+0,?,59,133,53,59           ,?,?,?
  dw 0,shade,?,16*1+0,?,102,133,160,102        ,?,?,?
  dw 0,shade,?,16*1+0,?,163,102,160,163        ,?,?,?
  dw 0,shade,?,16*1+0,?,177,161,163,177        ,?,?,?
  dw 0,shade,?,16*1+0,?,181,177,163,181        ,?,?,?
  dw 0,shade,?,16*1+0,?,190,177,181,190        ,?,?,?
  dw 0,shade,?,16*1+0,?,194,190,181,194        ,?,?,?
  dw 0,shade,?,16*1+0,?,188,190,194,188        ,?,?,?
  dw 0,shade,?,16*1+0,?,192,188,194,192        ,?,?,?
  dw 0,shade,?,16*1+0,?,174,188,192,174        ,?,?,?
  dw 0,shade,?,16*1+0,?,173,174,192,173        ,?,?,?
  dw 0,shade,?,16*1+0,?,108,174,173,108        ,?,?,?
  dw 0,shade,?,16*1+0,?,81,108,173,81          ,?,?,?
  dw 0,shade,?,16*1+0,?,38,48,108,38           ,?,?,?
  dw 0,shade,?,16*1+0,?,81,38,108,81           ,?,?,?
  dw 0,shade,?,16*1+0,?,19,28,48,19            ,?,?,?
  dw 0,shade,?,16*1+0,?,38,19,48,38            ,?,?,?
  dw 0,shade,?,16*1+0,?,18,23,28,18            ,?,?,?
  dw 0,shade,?,16*1+0,?,19,18,28,19            ,?,?,?
  dw 0,shade,?,16*1+0,?,33,34,23,33            ,?,?,?
  dw 0,shade,?,16*1+0,?,18,33,23,18            ,?,?,?
  dw 0,shade,?,16*1+0,?,33,53,52,33            ,?,?,?
  dw 0,shade,?,16*1+0,?,34,33,52,34            ,?,?,?
  dw 0,shade,?,16*1+0,?,102,82,52,102          ,?,?,?
  dw 0,shade,?,16*1+0,?,53,102,52,53           ,?,?,?
  dw 0,shade,?,16*1+0,?,161,82,102,161         ,?,?,?
  dw 0,shade,?,16*1+0,?,163,161,102,163        ,?,?,?
  dw 0,shade,?,16*1+0,?,168,154,161,168        ,?,?,?
  dw 0,shade,?,16*1+0,?,177,168,161,177        ,?,?,?
  dw 0,shade,?,16*1+0,?,175,168,177,175        ,?,?,?
  dw 0,shade,?,16*1+0,?,190,175,177,190        ,?,?,?
  dw 0,shade,?,16*1+0,?,167,175,190,167        ,?,?,?
  dw 0,shade,?,16*1+0,?,188,167,190,188        ,?,?,?
  dw 0,shade,?,16*1+0,?,152,167,188,152        ,?,?,?
  dw 0,shade,?,16*1+0,?,174,152,188,174        ,?,?,?
  dw 0,shade,?,16*1+0,?,83,152,174,83          ,?,?,?
  dw 0,shade,?,16*1+0,?,108,83,174,108         ,?,?,?
  dw 0,shade,?,16*1+0,?,48,57,83,48            ,?,?,?
  dw 0,shade,?,16*1+0,?,108,48,83,108          ,?,?,?
  dw 0,shade,?,16*1+0,?,28,47,57,28            ,?,?,?
  dw 0,shade,?,16*1+0,?,48,28,57,48            ,?,?,?
  dw 0,shade,?,16*1+0,?,23,40,47,23            ,?,?,?
  dw 0,shade,?,16*1+0,?,28,23,47,28            ,?,?,?
  dw 0,shade,?,16*1+0,?,34,46,40,34            ,?,?,?
  dw 0,shade,?,16*1+0,?,23,34,40,23            ,?,?,?
  dw 0,shade,?,16*1+0,?,52,58,46,52            ,?,?,?
  dw 0,shade,?,16*1+0,?,34,52,46,34            ,?,?,?
  dw 0,shade,?,16*1+0,?,82,104,58,82           ,?,?,?
  dw 0,shade,?,16*1+0,?,52,82,58,52            ,?,?,?
  dw 0,shade,?,16*1+0,?,154,104,82,154         ,?,?,?
  dw 0,shade,?,16*1+0,?,161,154,82,161         ,?,?,?
  dw 0,shade,?,16*1+0,?,162,154,168,162        ,?,?,?
  dw 0,shade,?,16*1+0,?,183,162,168,183        ,?,?,?
  dw 0,shade,?,16*1+0,?,183,168,175,183        ,?,?,?
  dw 0,shade,?,16*1+0,?,195,183,175,195        ,?,?,?
  dw 0,shade,?,16*1+0,?,195,175,167,195        ,?,?,?
  dw 0,shade,?,16*1+0,?,187,195,167,187        ,?,?,?
  dw 0,shade,?,16*1+0,?,187,167,152,187        ,?,?,?
  dw 0,shade,?,16*1+0,?,150,187,152,150        ,?,?,?
  dw 0,shade,?,16*1+0,?,83,61,150,83           ,?,?,?
  dw 0,shade,?,16*1+0,?,152,83,150,152         ,?,?,?
  dw 0,shade,?,16*1+0,?,83,57,25,83            ,?,?,?
  dw 0,shade,?,16*1+0,?,61,83,25,61            ,?,?,?
  dw 0,shade,?,16*1+0,?,57,47,17,57            ,?,?,?
  dw 0,shade,?,16*1+0,?,25,57,17,25            ,?,?,?
  dw 0,shade,?,16*1+0,?,47,40,30,47            ,?,?,?
  dw 0,shade,?,16*1+0,?,17,47,30,17            ,?,?,?
  dw 0,shade,?,16*1+0,?,46,50,30,46            ,?,?,?
  dw 0,shade,?,16*1+0,?,40,46,30,40            ,?,?,?
  dw 0,shade,?,16*1+0,?,58,70,50,58            ,?,?,?
  dw 0,shade,?,16*1+0,?,46,58,50,46            ,?,?,?
  dw 0,shade,?,16*1+0,?,104,141,70,104         ,?,?,?
  dw 0,shade,?,16*1+0,?,58,104,70,58           ,?,?,?
  dw 0,shade,?,16*1+0,?,141,104,154,141        ,?,?,?
  dw 0,shade,?,16*1+0,?,162,141,154,162        ,?,?,?
  dw 0,shade,?,16*1+0,?,176,157,162,176        ,?,?,?
  dw 0,shade,?,16*1+0,?,183,176,162,183        ,?,?,?
  dw 0,shade,?,16*1+0,?,186,176,183,186        ,?,?,?
  dw 0,shade,?,16*1+0,?,195,186,183,195        ,?,?,?
  dw 0,shade,?,16*1+0,?,180,186,195,180        ,?,?,?
  dw 0,shade,?,16*1+0,?,187,180,195,187        ,?,?,?
  dw 0,shade,?,16*1+0,?,142,180,187,142        ,?,?,?
  dw 0,shade,?,16*1+0,?,150,142,187,150        ,?,?,?
  dw 0,shade,?,16*1+0,?,49,142,150,49          ,?,?,?
  dw 0,shade,?,16*1+0,?,61,49,150,61           ,?,?,?
  dw 0,shade,?,16*1+0,?,25,27,49,25            ,?,?,?
  dw 0,shade,?,16*1+0,?,61,25,49,61            ,?,?,?
  dw 0,shade,?,16*1+0,?,17,29,27,17            ,?,?,?
  dw 0,shade,?,16*1+0,?,25,17,27,25            ,?,?,?
  dw 0,shade,?,16*1+0,?,30,41,29,30            ,?,?,?
  dw 0,shade,?,16*1+0,?,17,30,29,17            ,?,?,?
  dw 0,shade,?,16*1+0,?,50,63,41,50            ,?,?,?
  dw 0,shade,?,16*1+0,?,30,50,41,30            ,?,?,?
  dw 0,shade,?,16*1+0,?,77,63,50,77            ,?,?,?
  dw 0,shade,?,16*1+0,?,70,77,50,70            ,?,?,?
  dw 0,shade,?,16*1+0,?,141,145,77,141         ,?,?,?
  dw 0,shade,?,16*1+0,?,70,141,77,70           ,?,?,?
  dw 0,shade,?,16*1+0,?,145,141,162,145        ,?,?,?
  dw 0,shade,?,16*1+0,?,157,145,162,157        ,?,?,?
  dw 0,shade,?,16*1+0,?,153,147,157,153        ,?,?,?
  dw 0,shade,?,16*1+0,?,176,153,157,176        ,?,?,?
  dw 0,shade,?,16*1+0,?,156,153,176,156        ,?,?,?
  dw 0,shade,?,16*1+0,?,186,156,176,186        ,?,?,?
  dw 0,shade,?,16*1+0,?,146,156,186,146        ,?,?,?
  dw 0,shade,?,16*1+0,?,180,146,186,180        ,?,?,?
  dw 0,shade,?,16*1+0,?,142,66,146,142         ,?,?,?
  dw 0,shade,?,16*1+0,?,180,142,146,180        ,?,?,?
  dw 0,shade,?,16*1+0,?,49,56,66,49            ,?,?,?
  dw 0,shade,?,16*1+0,?,142,49,66,142          ,?,?,?
  dw 0,shade,?,16*1+0,?,27,60,56,27            ,?,?,?
  dw 0,shade,?,16*1+0,?,49,27,56,49            ,?,?,?
  dw 0,shade,?,16*1+0,?,29,67,60,29            ,?,?,?
  dw 0,shade,?,16*1+0,?,27,29,60,27            ,?,?,?
  dw 0,shade,?,16*1+0,?,41,72,67,41            ,?,?,?
  dw 0,shade,?,16*1+0,?,29,41,67,29            ,?,?,?
  dw 0,shade,?,16*1+0,?,63,79,72,63            ,?,?,?
  dw 0,shade,?,16*1+0,?,41,63,72,41            ,?,?,?
  dw 0,shade,?,16*1+0,?,77,134,79,77           ,?,?,?
  dw 0,shade,?,16*1+0,?,63,77,79,63            ,?,?,?
  dw 0,shade,?,16*1+0,?,145,143,134,145        ,?,?,?
  dw 0,shade,?,16*1+0,?,77,145,134,77          ,?,?,?
  dw 0,shade,?,16*1+0,?,147,143,145,147        ,?,?,?
  dw 0,shade,?,16*1+0,?,157,147,145,157        ,?,?,?
  dw 0,shade,?,16*1+0,?,153,116,106,153        ,?,?,?
  dw 0,shade,?,16*1+0,?,147,153,106,147        ,?,?,?
  dw 0,shade,?,16*1+0,?,156,119,116,156        ,?,?,?
  dw 0,shade,?,16*1+0,?,153,156,116,153        ,?,?,?
  dw 0,shade,?,16*1+0,?,146,121,119,146        ,?,?,?
  dw 0,shade,?,16*1+0,?,156,146,119,156        ,?,?,?
  dw 0,shade,?,16*1+0,?,66,122,121,66          ,?,?,?
  dw 0,shade,?,16*1+0,?,146,66,121,146         ,?,?,?
  dw 0,shade,?,16*1+0,?,56,120,122,56          ,?,?,?
  dw 0,shade,?,16*1+0,?,66,56,122,66           ,?,?,?
  dw 0,shade,?,16*1+0,?,117,120,56,117         ,?,?,?
  dw 0,shade,?,16*1+0,?,60,117,56,60           ,?,?,?
  dw 0,shade,?,16*1+0,?,67,115,117,67          ,?,?,?
  dw 0,shade,?,16*1+0,?,60,67,117,60           ,?,?,?
  dw 0,shade,?,16*1+0,?,72,114,115,72          ,?,?,?
  dw 0,shade,?,16*1+0,?,67,72,115,67           ,?,?,?
  dw 0,shade,?,16*1+0,?,79,112,114,79          ,?,?,?
  dw 0,shade,?,16*1+0,?,72,79,114,72           ,?,?,?
  dw 0,shade,?,16*1+0,?,111,112,79,111         ,?,?,?
  dw 0,shade,?,16*1+0,?,134,111,79,134         ,?,?,?
  dw 0,shade,?,16*1+0,?,110,111,134,110        ,?,?,?
  dw 0,shade,?,16*1+0,?,143,110,134,143        ,?,?,?
  dw 0,shade,?,16*1+0,?,106,110,143,106        ,?,?,?
  dw 0,shade,?,16*1+0,?,147,106,143,147        ,?,?,?
  dw 0,shade,?,16*1+0,?,114,112,111,114        ,?,?,?
  dw 0,shade,?,16*1+0,?,115,114,111,115        ,?,?,?
  dw 0,shade,?,16*1+0,?,117,115,111,117        ,?,?,?
  dw 0,shade,?,16*1+0,?,120,117,111,120        ,?,?,?
  dw 0,shade,?,16*1+0,?,122,120,111,122        ,?,?,?
  dw 0,shade,?,16*1+0,?,119,121,122,119        ,?,?,?
  dw 0,shade,?,16*1+0,?,116,119,122,116        ,?,?,?
  dw 0,shade,?,16*1+0,?,110,106,116,110        ,?,?,?
  dw 0,shade,?,16*1+0,?,111,110,116,111        ,?,?,?
  dw 0,shade,?,16*1+0,?,122,111,116,122        ,?,?,?

