
// g3dmatrl.cpp
//
// Copyright (c) 1996 by Toshiaki Tsuji, all rights reserved.

#include "stdgfx.h"
#include "g3dmatrl.h"

//******************************************
//
// G3DMATERIAL Class
//
//******************************************

G3DMATERIAL::G3DMATERIAL ()
  {
    Texture = NULL;
    Ambient = 0;
    Transparency = 0;
    Attributes = 0;
    Name[0] = 0;
    ID = 0;
  } // End of Constructor for G3DMATERIAL 

G3DMATERIAL::~G3DMATERIAL ()
  {
  } // End of Destructor for G3DMATERIAL 
  
VOID G3DMATERIAL::SetTexture ( ANIMIMAGE *Image )
  {
    Texture = Image;
  } // End of SetTexture for G3DMATERIAL 

VOID G3DMATERIAL::SetName ( STRING NewName )
  {
    strcpy ( Name, NewName );  
  } // End of SetName for G3DMATERIAL
  
VOID G3DMATERIAL::SetID ( LONG NewID )
  {
    ID = NewID;  
  } // End of SetID for G3DMATERIAL
  

//******************************************
//
// G3DMATERIAL Class
//
//******************************************

G3DMATERIALLIB::G3DMATERIALLIB ()
  {
    Materials = NULL;
    NumMaterials = 0;
    Textures = NULL;
    NumTextures = 0;
  } // End of Constructor for G3DMATERIALLIB

G3DMATERIALLIB::~G3DMATERIALLIB ()
  {
    DestroyMaterials ();
    DestroyTextures ();
  } // End of Destructor for G3DMATERIALLIB
      
VOID G3DMATERIALLIB::CreateMaterials ( LONG Num )
  {
    DestroyMaterials ();
    
    Materials = new G3DMATERIAL* [Num];
    if (Materials==NULL)
      return;
      
    LONG i;
    
    NumMaterials = Num;
    for (i=0;i<NumMaterials;i++)
      {
        Materials[i] = new G3DMATERIAL ();
      } // End for  
  } // End of CreateMaterials for G3DMATERIALLIB

VOID G3DMATERIALLIB::DestroyMaterials ()
  {
    LONG i;
    if (Materials!=NULL)
      {
        for (i=0;i<NumMaterials;i++)
          {
            if (Materials[i]!=NULL)
              delete Materials[i];
          } // End for
        delete Materials;
      } // End if    
    NumMaterials = 0;
    Materials = NULL;        
  } // End of DestroyMaterials for G3DMATERIALLIB

VOID G3DMATERIALLIB::CreateTextures ( LONG Num )
  {
    DestroyTextures ();
    
    Textures = new ANIMIMAGE* [Num];
    if (Textures==NULL)
      return;
      
    LONG i;
    
    NumTextures = Num;
    for (i=0;i<NumTextures;i++)
      {
        Textures[i] = new ANIMIMAGE ();
      } // End for  
  } // End of CreateTextures for G3DMATERIALLIB

VOID G3DMATERIALLIB::DestroyTextures ()
  {
    LONG i;
    if (Textures!=NULL)
      {
        for (i=0;i<NumTextures;i++)
          {
            if (Textures[i]!=NULL)
              delete Textures[i];
          } // End for
        delete Textures;
      } // End if    
    NumTextures = 0;
    Textures = NULL;        
  } // End of DestroyTextures for G3DMATERIALLIB

G3DMATERIAL* G3DMATERIALLIB::FindMaterialByName ( STRING SearchName )
  {
    LONG i;
    
    for (i=0;i<NumMaterials;i++)
      {
        if (strcmp(SearchName,Materials[i]->GetName())==0)
          return Materials[i];           
      } // End for
    return NULL;  
  } // End of FindMaterialByName for G3DMATERIALLIB

G3DMATERIAL* G3DMATERIALLIB::FindMaterialByID ( LONG SearchID )
  {
    LONG i;
    
    for (i=0;i<NumMaterials;i++)
      {
        if (SearchID==Materials[i]->GetID())
          return Materials[i];           
      } // End for
    return NULL;  
  } // End of FindMaterialByID for G3DMATERIALLIB

BOOLEAN G3DMATERIALLIB::LoadTexture ( LONG Index, STRING FileName, BOOLEAN FileType,
                                      RGBPALETTE *Pal )
  {
    if ((Index<0)||(Index>=NumTextures))
      return FAILURE;

    BOOLEAN Result = FAILURE;

    ANIMIMAGE *Texture = GetTexture ( Index );
    Texture->Create ( IMAGE_8BIT, 256, 256 );
    
    RGBPALETTE *LoadedPal = NULL;
    COLORTABLE *MatchTable = NULL;
    FLICFILE *Flic = NULL;
    
    switch (FileType)
      {
        case TEXTURE_STATIC :
          LoadedPal = new RGBPALETTE ();
          Result = Grafix.LoadImage ( FileName, Texture, LoadedPal );
          break;  
        case TEXTURE_FLIC :
          Flic = new FLICFILE ();
          Result = Flic->Load ( FileName );
          Flic->GetFirstPalette ();
          LoadedPal = Flic->GetPalette ();
          break;  
        case TEXTURE_ANIM :
          break;  
      } // End switch

    LONG i;
    if (Result==SUCCESS)
      {
        if (Pal!=NULL)
          {
            if (Pal->IsIdentical(LoadedPal)==FALSE)
              {
                if (FileType==TEXTURE_STATIC)
                  {
                    MatchTable= new COLORTABLE ();  
                    MatchTable->CopyPalette ( Pal );  
                    MatchTable->CreateMatchTable ( LoadedPal );
                    Grafix.AdjustImageSize ( Texture, 256, 256 );
                    Grafix.ConvertImage ( Texture, MatchTable );
                  } // End if
                else if (FileType==TEXTURE_FLIC)
                  {
                    Flic->Convert ( Pal );  
                    Flic->SetFrame ( 0 );
                    Texture->CreateBaseImage ();
                    Texture->CreateFrames ( Flic->GetNumFrames() );
                    Grafix.SetScaleFactor ( 256, Flic->GetImageWidth(),
                                            256, Flic->GetImageHeight() );                                            
                    for (i=0;i<Flic->GetNumFrames();i++)
                      {
                        Flic->PlayFrame ( TRUE );
                        Grafix.ScaleImage  ( Flic->GetImage (), 0, 0,                        
                                             Flic->GetImageWidth(), Flic->GetImageHeight(),
                                             Texture, 0, 0 );
                        Texture->RecordFrame ( i, Texture, 0, 0 );
                      } // End for
                    Grafix.SetScaleFactor ( 1, 1, 1, 1 );
                  } // End else if  
              } // End if  
          } // End if  
      } // End if

    if (Flic!=NULL)
      {
        delete Flic;
        LoadedPal = NULL;
      } // End if  

    if (LoadedPal!=NULL)  
      delete LoadedPal;

    if (MatchTable!=NULL)        
      delete MatchTable;

    return Result;  
  } // End of LoadTaexture for G3DMATERIALLIB  
