; _GetCHR      campiona da schermo una matrice 8x8 per il carattere n
; _PutString   stampa una stringa asciiz
; _PutHex      stampa un hex a 32bit (8 cifre)
;              n.b. con questo e' possibile anche stampare un numero BCD
; _CHRFNT indirizzo base del font di caratteri installato

; WARNING! This assembler code is highly interleaved to get the max
; from 486 and Pentium processors while running quite fast on good ol' 386
; to better understand this code
; remember: REGISTERS are used as variables, so follow what happens to every
;           register.
;           Usually i interleave TWO sequences into one, skip one instruction
;           and you get the usual sequence everyone can understand.
;           I not optimized sequences that clashes with bottlenecks OUTSIDE
;           the processor (i.e. memory access), my main target is keep the most
;           accessed stuff into registers and process things at 32bit.

       .386P
       
code32 segment para public use32
       assume cs:code32,ds:code32
       
include 386video.inc

; MODULO Per I/O Character oriented
;
        align dword
_CHRFNT dd 0 
        dd (16*256) dup(0)
        align byte
       
CHIN macro n
        mov cx,[esi+(PXWIDTH+(n*2*PXWIDTH))]
        shl ecx,16
        mov cx,[esi+(n*2*PXWIDTH)]
        mov [edi+ebp+(n*4)],ecx
     endm

CHOU macro n
        mov ecx,[esi+ebp+(n*4)]
        mov [edi+(n*2*PXWIDTH)],cx
        shr ecx,16
        mov [edi+(PXWIDTH+(n*2*PXWIDTH))],cx
     endm     
        
         public _GetCHR
_GetCHR:
         ; copia da RAM VIDEO sul BUFFER dei caratteri
         ; una matrice 
         ; esi = screen base offset
         ; edi = character bitmap index
         ; eax = x position in nudgets
         ; edx = y position in pixels
        pushad
        add esi,eax
        shl edi,CHARSHIFT
        add esi,[edx*4+_RowStart]
        add edi,offset _CHRFNT
        BLITMODE BLITPLANE

        mov dx,GRAPHICS
        mov ax,RP0
        mov ebp,0
chanplane:        
        out dx,ax
        push esi
        CHIN 0
        CHIN 1
        CHIN 2
        CHIN 3
        pop esi
        add ebp,16
        inc ah
        cmp ah,4
        jne chanplane
        popad
	ret


        public _PutString

_PutString:
         ; edi = screen base
         ; eax = x in nudgets
         ; edx = y in pixels
         ; ebx = string
         
         pushad
         add edi,eax
         add edi,[edx*4+_RowStart]
         BLITMODE BLITPLANE
         jmp @czero
@bliit:  inc ebx
         shl esi,CHARSHIFT
         mov dx,SEQUENCER
         add esi,offset _CHRFNT
         mov ax,WP0
         mov ebp,0
LUPPALO:         
         out dx,ax
         mov ecx,[esi+ebp]    ; CHOU 0
         mov [edi],cx         ;
         shr ecx,16           ;
         mov [edi+PXWIDTH],cx ;
         CHOU 1
         CHOU 2
         CHOU 3
         add ebp,16
         rol ah,1
         jnc LUPPALO
         add edi,2
@czero:         
         movsx esi,byte ptr [ebx]
         cmp esi,0
         jne @bliit
         
         popad
	 ret



        public _PutHex

_PutHex: ; scrive il numero BCD a 32 bit
         ; contenuto in ebx
         ; edi = screen dest
         ; eax = x in nudgets
         ; edx = y in pixels
         ; ebx = number to write
         pushad
         add edi,eax
         add edi,[edx*4+_RowStart]
         BLITMODE BLITPLANE
         mov ecx,8
         mov dx,SEQUENCER
         add edi,16
         mov esi,ebx
@ngnchar:
         and esi,0Fh
         shr ebx,4
         cmp esi,10
         jb  @isdec
         add esi,(65-48-10) ; 'A' - '0' - 10
@isdec:   
         push ecx
         add esi,48 ; '0' == 48
         mov ax,WP0
         shl esi,CHARSHIFT
         mov ebp,0
         add esi,offset _CHRFNT
SLUPPALO:         
         out dx,ax
         mov ecx,[esi+ebp]    ; CHOU 0
         mov [edi],cx         ;
         shr ecx,16           ;
         mov [edi+PXWIDTH],cx ;
         CHOU 1
         CHOU 2
         CHOU 3
         add ebp,16
         rol ah,1
         jnc SLUPPALO         
         pop ecx
         sub edi,2
         mov esi,ebx
         dec ecx
         jnz @ngnchar
         popad
	 ret
         
code32 ends

 END

