void bend_points (int a, int b, double ampli)
{
	double tmp,c,s;
	for (int i=a; i<=b; i++) {
		tmp=PI*ampli*points[i].z;
		c=cos(tmp);
		s=sin(tmp);
		tmp=points[i].x;
		points[i].x=c*tmp-s*points[i].y;
		points[i].y=s*tmp+c*points[i].y;
	}
}

void pinch_points (int a, int b, double ampli)
{
	for (int i=a; i<=b; i++)
		points[i].x*=1.0-ampli*points[i].z;
}

void taper_points (int a, int b, double ampli)
{
	double tmp;
	//swap z-y
	for (int i=a; i<=b; i++) {
		tmp = 1.0-ampli * points[i].y;
		points[i].x*=tmp;
		points[i].z*=tmp;
	}
}

void taper_points2 (int a, int b, double ampli)
{
	double tmp;
	//swap z-y
	for (int i=a; i<=b; i++) {
		tmp = 1.0-ampli * points[i].z;
		points[i].x*=tmp;
		points[i].y*=tmp;
	}
}

void mould_points (int a, int b, double ampli)
{
	double tmp;
	
	for (int i=a; i<=b; i++) {
		tmp=atan2(points[i].y, points[i].x) / PI;
		tmp = 1.0-ampli*tmp*points[i].z;
		points[i].x*=tmp;
		points[i].y*=tmp;
	}
}

void extrude_points (int a, int b, double d)
{
	for (int i=a; i<=b; i++) points[i]+=(pNormals[i]*d);
}

void calc_face_normals ()
{
	for (int i=0; i<TORUS_QUADS; i++) {
		fNormals[i]=normalize(
  			cross(points[torus_quads[i*4+0]]-points[torus_quads[i*4+1]],
            points[torus_quads[i*4+1]]-points[torus_quads[i*4+2]]));
	}
}

void prepare_points_and_normals ()
{
	int j=0,k=0;
	for (int i=0; i<TORUS_POINTS; i++) {
		points[i].x=torus_points[j++];
		points[i].y=torus_points[j++];
		points[i].z=torus_points[j++];
		
		pNormals[i].x=torus_normals[k++];
		pNormals[i].y=torus_normals[k++];
		pNormals[i].z=torus_normals[k++];
	}
}

void draw_torus ()
{
	vec3 *n;
	int i,k;
	calc_face_normals();
	
 	glBegin(GL_QUADS);
	for (i=0; i<TORUS_QUADS; i++) {
		n=&fNormals[i];
 		glNormal3f(n->x,n->y,n->z);
 		for (k=i*4; k<i*4+4; k++) {
 			n=&points[torus_quads[k]];
 			glVertex3f(n->x,n->y,n->z);
		}
	}
	glEnd();
}

void do_fx5 ()
{
	GLfloat t = 1.0-(SDL_GetTicks()-fx[5])/fxLength[5];
	extrude_points(48,79, t/1.2);
	extrude_points(255-31-16,255-16,t/1.4);
	if (!camera_change) {
		camera.x=rnd()*6.0-3.0;
		camera.y=rnd()*4.0-2.0;
		camera.z=rnd()*6.0-3.0;
		camera=normalize(camera)*3.0;
		camera_change=TRUE;
	}
}

void do_fx6 ()
{
	GLfloat t = 1.0-(SDL_GetTicks()-fx[6])/fxLength[6];
	pinch_points(0,255, -t);
}
	
void do_fx7 ()
{
	glDisable(GL_LIGHTING);
	//glLineWidth(2.0);
	double t=SDL_GetTicks()-fx[7];
	glColor4f(1,1,0.3,1);
	if (t<500) glColor4f(1,1,0.3,t/500.0);
	if (fxLength[7]-t<1500) glColor4f(1,1,0.3,(fxLength[7]-t)/1500.0);
	for (int j=0; j<NUM_CIRCLE; j++) {
		glPushMatrix();
		glRotatef((SDL_GetTicks()+fx[7]*j)*0.05,circle_rotate[j].x,circle_rotate[j].y,circle_rotate[j].z);
		glBegin(GL_LINE_LOOP);
		for (int i=0; i<42; i++) glVertex3f(sin(2*PI/42*i)*circle_radius[j],cos(2*PI/42*i)*circle_radius[j],0);
		glEnd();
		glPopMatrix();
	}
	glEnable(GL_LIGHTING);
	//glLineWidth(1.0);
}

void do_fx8 ()
{
	GLfloat t = 1.0-(SDL_GetTicks()-fx[8])/fxLength[8];
	extrude_points(0,15,t/3);
	//mould_points(0,255, -t*2.3);
}

void do_fx11 ()
{
	GLfloat t = 1.0-(SDL_GetTicks()-fx[11])/fxLength[11];
	if (fx11_volume>0.5) taper_points(0,255,-t*fx11_volume*1.5);
}

void do_fx12 ()
{
	GLfloat t = 1.0-(SDL_GetTicks()-fx[12])/fxLength[12];
	taper_points2(0,255, -t*1.4);
}

void do_fx15 ()
{
	GLfloat t=2.0-(SDL_GetTicks()-fx[15])/fxLength[15];
	glScalef(t,1,1);
	//mould_points(0,255,-t*1.3);
	bend_points(0,255,(t-1.0)*0.5);
}

void do_fx17 ()
{
	GLfloat t=1.0-(SDL_GetTicks()-fx[17])/fxLength[17];
	//pinch_points(0,255, -t*0.6);
}


