/*
ͻ
                     WordUp Graphics Toolkit Version 4.5                    
                            Demonstration Program 44                        
                                                                            
 Displays the status of the keyboard flags.  Try pressing the numlock,      
 scrlock, capslock, shift, ctrl and alt keys.                               
                                                                            
 Once a key other than those listed above is hit, it then flashes the       
 keyboard LEDS in sequence.                                                 
                                                                            
  PROJECT                                                             
 This program requires the WGT45.LIB file to be linked.                     
                                                                            
  DATA FILES                                                          
 None.                                                                      
                                                                            
ͼ
*/

#include <wgt45.h>

void main(void)
{
  printf ("WGT Example #44\n\n");
  printf ("Control of the keyboard status keys is demonstrated.\n");
  printf ("Press a key to abort key detection and force keys to be lighted.\n");
  printf ("Another keypress will end the program.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();
  clrscr ();

  do {
    if (wget_numlock ())  printf ("NUMLOCK  ");
    if (wget_capslock ()) printf ("CAPSLOCK  ");
    if (wget_scrlock ())  printf ("SCRLOCK  ");
    if (wget_lshift ())   printf ("LSHIFT  ");
    if (wget_rshift ())   printf ("RSHIFT  ");
    if (wget_lalt ())     printf ("LALT  ");
    if (wget_ralt ())     printf ("RALT  ");
    if (wget_lctrl ())     printf ("LCTRL  ");
    if (wget_rctrl ())     printf ("RCTRL  ");
    printf("\n");
   } while (!kbhit ());

   getch ();
   printf ("Look at your LEDS!\n");

   wset_numlock (0);
   wset_capslock (0);
   wset_scrlock (0);
   do {
     wset_numlock (1); delay (50); wset_numlock (0);
     wset_capslock (1); delay (50); wset_capslock (0);
     wset_scrlock (1); delay (50); wset_scrlock (0);
    } while (!kbhit ());

   getch ();

   wset_numlock (1);
   wset_capslock (0);
   wset_scrlock (0);
}